// colourspace.h
// LiVES
// (c) G. Finch 2004 <salsaman@xs4all.nl>
// Released under the GPL 2.0 or higher
// see file ../COPYING for licensing details

// headers for palette conversions

typedef struct {
  guchar u0;
  guchar y0;
  guchar v0;
  guchar y1;
} uyvy_frame;


void convert_rgb_to_uyvy_frame(guchar *bgrdata, gint hsize, gint vsize, gint rowstride);
void convert_rgb_to_yuv420_frame(guchar *bgrdata, gint hsize, gint vsize, gint rowstride);
void convert_yuv422p_to_rgb_frame(uint8_t *src, gint hsize, gint vsize, gint orowstride, guchar *dest);

guchar calc_luma (guchar *pixel);


///////////////////////////////////////
gboolean convert_layer_palette(weed_plant_t *layer, int outpl);
void resize_layer (weed_plant_t *layer, int width, int height, int interp);
void create_empty_pixel_data(weed_plant_t *layer);
GdkPixbuf *layer_to_pixbuf (weed_plant_t *layer);
gboolean pixbuf_to_layer(weed_plant_t *layer, GdkPixbuf *pixbuf);
