// effects.h
// LiVES (lives-exe)
// (c) G. Finch 2003
// Released under the GPL 2.0 or higher
// see file ../COPYING for licensing details

#include "effects-weed.h"

gboolean do_effect(lives_rfx_t *rfx, gboolean is_preview); // defined as extern in paramwindow.c

void on_render_fx_activate (GtkMenuItem *menuitem, lives_rfx_t *rfx);


///////////////// real time effects

// render
void
on_realfx_activate                   (GtkMenuItem     *menuitem,
				      gpointer         user_data);

gint 
realfx_progress (gboolean reset);


gint guess_rowstride (gint idx);



// key callbacks

gboolean grabkeys_callback (GtkAccelGroup *, GObject *, guint, GdkModifierType, gpointer user_data); // for accel groups
gboolean grabkeys_callback_hook (GtkToggleButton *button, gpointer user_data); // for widgets

gboolean rte_on_off_callback (GtkAccelGroup *, GObject *, guint, GdkModifierType, gpointer user_data); // for accel groups
gboolean rte_on_off_callback_hook (GtkToggleButton *, gpointer user_data); // for widgets

gboolean rtemode_callback (GtkAccelGroup *, GObject *, guint, GdkModifierType, gpointer user_data); // for accel groups
gboolean rtemode_callback_hook (GtkToggleButton *, gpointer user_data); // for widgets

gboolean swap_fg_bg_callback (GtkAccelGroup *, GObject *, guint, GdkModifierType, gpointer user_data);

GdkPixbuf *get_blend_frame(weed_timecode_t tc);

void nine_fill (guchar *new_data, gint i, gint j, guchar *old_data, gint x, gint y, gint rowstride);

GdkPixbuf *on_rte_apply (GdkPixbuf *pixbuf, weed_plant_t *effect_map, int opwidth, int opheight, weed_timecode_t tc);








