// keyboard.c
// LiVES
// (c) G. Finch 2004 <salsaman@xs4all.nl>
// released under the GNU GPL 2.0 or higher
// see file ../COPYING for licensing details


#include <gdk/gdkkeysyms.h>

#include "main.h"
#include "effects.h"
#include "callbacks.h"


// TODO ** - check all of this - are we polling twice ??

gboolean 
key_snooper (GtkWidget *widget, GdkEventKey *event, gpointer data) {
  // this gets called for every keypress - check for cached keys
  pl_key_function ((event->type==GDK_KEY_PRESS),event->keyval,event->state);
  return FALSE;
}


gboolean 
plugin_poll_keyboard (gpointer data) {
  // this is a function which should be called periodically during playback.
  // If a video playback plugin has control of the keyboard 
  // (e.g fullscreen video playback plugins)
  // it will be asked to send keycodes via pl_key_function

  // TODO ** - check all of this

  if (mainw->ext_keyboard) {
    //let plugin call pl_key_function itself, with any keycodes it has received
    (*vid_playback_plugin->send_keycodes)();
  }

  // we also auto-repeat our cached keys
  if (cached_key) gtk_accel_groups_activate (G_OBJECT (mainw->LiVES),(guint)cached_key,cached_mod);

  // if we have OSC we will poll it here, as we seem to only be able to run 1 gtk_timeout at a time
#ifdef ENABLE_OSC
  if (prefs->osc_udp_started) lives_osc_poll(NULL);
#endif

#ifdef ENABLE_JACK
  lives_jack_poll(NULL);
#endif

  return TRUE;
}



void 
pl_key_function (gboolean down, guint16 unicode, guint16 keymod) {
  // translate key events
  // plugins can call this with a unicode key to pass key events to LiVES


#define NEEDS_TRANSLATION 1<<15

  // mask for ctrl and alt
  GdkModifierType state=(keymod&(GDK_CONTROL_MASK|GDK_MOD1_MASK));

  if (down==FALSE) {
    // up...
    if (keymod&NEEDS_TRANSLATION) {
      switch (unicode) {
	// some keys need translating when a modifier is held down
      case(key_left) :if (cached_key==GDK_Left) cached_key=0;return;
      case(key_right) :if (cached_key==GDK_Right) cached_key=0;return;
      case(key_up)  :if (cached_key==GDK_Up) cached_key=0;return;
      case(key_down) :if (cached_key==GDK_Down) cached_key=0;return;
      }
    }
    else if (cached_key==unicode) cached_key=0;
    return;
  }

  // translate hardware code into gdk keyval, and call any accelerators
  if (keymod&NEEDS_TRANSLATION) {
    switch (unicode) {
      // some keys need translating when a modifier is held down
    case (65) :unicode=GDK_space;break;
    case (22) :unicode=GDK_BackSpace;break;
    case (36) :unicode=GDK_Return;break;
    case (24) :unicode=GDK_q;break;
    case (10) :unicode=GDK_1;break;
    case (11) :unicode=GDK_2;break;
    case (12) :unicode=GDK_3;break;
    case (13) :unicode=GDK_4;break;
    case (14) :unicode=GDK_5;break;
    case (15) :unicode=GDK_6;break;
    case (16) :unicode=GDK_7;break;
    case (17) :unicode=GDK_8;break;
    case (18) :unicode=GDK_9;break;
    case (19) :unicode=GDK_0;break;
    case (67) :unicode=GDK_F1;break;
    case (68) :unicode=GDK_F2;break;
    case (69) :unicode=GDK_F3;break;
    case (70) :unicode=GDK_F4;break;
    case (71) :unicode=GDK_F5;break;
    case (72) :unicode=GDK_F6;break;
    case (73) :unicode=GDK_F7;break;
    case (74) :unicode=GDK_F8;break;
    case (75) :unicode=GDK_F9;break;
    case (76) :unicode=GDK_F10;break;
    case (95) :unicode=GDK_F11;break;
    case (96) :unicode=GDK_F12;break;
    case (99) :unicode=GDK_Page_Up;break;
    case(105) :unicode=GDK_Page_Down;break;

      // auto repeat keys
    case(key_left) :unicode=GDK_Left;break;
    case(key_right) :unicode=GDK_Right;break;
    case(key_up)  :unicode=GDK_Up;break;
    case(key_down) :unicode=GDK_Down;break;

    default:return;
    }
  }

  if ((unicode==GDK_Left||unicode==GDK_Right||unicode==GDK_Up||unicode==GDK_Down)&&(keymod&GDK_CONTROL_MASK)) {
    cached_key=unicode;
    cached_mod=GDK_CONTROL_MASK;
  }

  if (mainw->ext_keyboard) {
    if (cached_key) return;
    if (mainw->multitrack==NULL) gtk_accel_groups_activate (G_OBJECT (mainw->LiVES),(guint)unicode,state);
    else gtk_accel_groups_activate (G_OBJECT (mainw->multitrack->window),(guint)unicode,state);
  }
}


// key callback functions - ones which have keys and need wrappers


gboolean slower_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  
  on_slower_pressed (NULL,user_data);
  return TRUE;
}

gboolean faster_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  
  on_faster_pressed (NULL,user_data);
  return TRUE;
}

gboolean skip_back_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  
  on_back_pressed (NULL,user_data);
  return TRUE;
}

gboolean skip_forward_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  
  on_forward_pressed (NULL,user_data);
  return TRUE;
}

gboolean stop_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  on_stop_activate (NULL,NULL);
  return TRUE;
}

gboolean fullscreen_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  on_full_screen_pressed (NULL,NULL);
  return TRUE;
}

gboolean sepwin_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  on_sepwin_pressed (NULL,NULL);
  return TRUE;
}

gboolean loop_cont_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  on_loop_button_activate (NULL,NULL);
  return TRUE;
}

gboolean ping_pong_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  on_ping_pong_activate (NULL,NULL);
  return TRUE;
}

gboolean fade_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  on_fade_pressed (NULL,NULL);
  return TRUE;
}

gboolean showfct_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mainw->showfct),!prefs->show_framecount);
  return TRUE;
}

gboolean loop_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mainw->loop_video),!mainw->loop);
  return TRUE;
}

gboolean dblsize_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  on_double_size_pressed (NULL,NULL);
  return TRUE;
}

gboolean rec_callback (GtkAccelGroup *group, GObject *obj, guint keyval, GdkModifierType mod, gpointer user_data) {
  gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(mainw->record_perf),!gtk_check_menu_item_get_active (GTK_CHECK_MENU_ITEM (mainw->record_perf)));
  return TRUE;
}






