// mainwindow.h
// LiVES (lives-exe)
// (c) G. Finch <salsaman@xs4all.nl> 2003
// Released under the GPL 2.0 or higher
// see file ../COPYING for licensing details


#ifndef _HAS_MAINWINDOW_H_
#define _HAS_MAINWINDOW_H_

#include <pthread.h>

// hardware related prefs

// fraction of a second quantisation for event timing; these two must match, and must be multiples of 10>=1000000 !
// >10**8 is not recommended, since we sometimes store seconds in a gdouble
#define U_SEC 100000000.
#define U_SECL (gint64)100000000

// key rpt (millisecs) for kb rpt, should be << FPS_MAX
// TODO - make pref
#define KEY_RPT_INTERVAL 40

// parameters for resizing the image frames, and for capture
// TODO - make prefs
#define V_RESIZE_ADJUST 36
#define H_RESIZE_ADJUST 22

// number of function keys
#define FN_KEYS 12

// FX keys, 1 - 9 normally
#define FX_KEYS_PHYSICAL 9

// must be > FX_KEYS_PHYSICAL, and <=64 (number of bits in a 64bit int mask)
// (max number of keys accesible through rte window or via OSC)
#define FX_KEYS_MAX_VIRTUAL 64

// the rest of the keys are accessible through the multitrack renderer
#define FX_KEYS_MAX 65536


typedef struct {
  // set in set_palette_colours()
  gint style;
#define STYLE_PLAIN 0 // no theme (theme 'none')
#define STYLE_1 1<<0 // turn on theming if set
#define STYLE_2 1<<1 // colour the spinbuttons on the front page if set
#define STYLE_3 1<<2 // style is lightish - allow themeing of widgets with dark text, otherwise use menu bg

  GdkColor white;
  GdkColor black;
  GdkColor light_blue;
  GdkColor light_yellow;
  GdkColor pink;
  GdkColor light_red;
  GdkColor grey20;
  GdkColor grey25;
  GdkColor grey50;
  GdkColor dark_orange;
  GdkColor fade_colour;
  GdkColor normal_back;
  GdkColor normal_fore;

  GdkColor menu_and_bars;
  GdkColor banner_fade_text;
  GdkColor info_text;
  GdkColor info_base;

  GdkColor bm_opaque;
  GdkColor bm_trans;

} _palette;




// mainw->
typedef struct {
  gchar msg[512];

  // files
  gint current_file;
  gint first_free_file;
  file *files[MAX_FILES+1]; // +1 for the clipboard
  gchar vid_load_dir[256];
  gchar vid_save_dir[256];
  gchar audio_dir[256];
  gchar image_dir[256];
  gchar proj_load_dir[256];
  gchar proj_save_dir[256];
  gchar xmms_dir[256];
  gint untitled_number;
  gint cap_number;
  gint clips_available;

  // hash table of clips in menu order
  GList *cliplist;

  // sets
  gchar set_name[256];

  // playback
  gboolean faded;
  gboolean double_size;
  gboolean sep_win;
  gboolean fs;
  gboolean loop;
  gboolean loop_cont;
  gboolean ping_pong;
  gboolean mute;
  gboolean must_resize;
  gint audio_start;
  gint audio_end;

  gboolean ext_playback;
  gboolean ext_keyboard;
  guint ext_palette;

  // TODO - use Weed palettes ?
#define EXTP_UNDEFINED 0
#define EXTP_RGB24 1
#define EXTP_UYVY 2
#define EXTP_YUV420 3
#define EXTP_RGBA32 4
  gint ptr_x;
  gint ptr_y;

  gdouble fps_measure;


  // flags
  gboolean save_with_sound;
  gboolean ccpd_with_sound;
  gboolean selwidth_locked;
  gboolean is_ready;
  gboolean opening_loc;  // opening location (streaming)
  gboolean dvgrab_preview;
  gboolean switch_during_pb;
  gboolean clip_switched; // for recording - did we switch clips ?
  gboolean record;

  gboolean in_fs_preview;
  gint cancelled;

  // no cancel
#define CANCEL_NONE 0

  // user pressed stop
#define CANCEL_USER 1

  // cancel but keep opening
#define CANCEL_NO_PROPOGATE 2

  // effect processing finished during preview
#define CANCEL_PREVIEW_FINISHED 3

  // application quit
#define CANCEL_APP_QUIT 4

  // ran out of preview frames
#define CANCEL_NO_MORE_PREVIEW 5

  // image could not be captured
#define CANCEL_CAPTURE_ERROR 6

  // event_list completed
#define CANCEL_EVENT_LIST_END 7

  // video playback completed
#define CANCEL_VID_END 8

  // generator was stopped
#define CANCEL_GENERATOR_END 9

  // user pressed 'Keep'
#define CANCEL_KEEP 10

  // video playback completed
#define CANCEL_AUD_END 11

  // cancelled because of error
#define CANCEL_ERROR 12

  // special cancel for TV toy
#define CANCEL_KEEP_LOOPING 100

  gboolean error;

  guint cancel_type;
#define CANCEL_KILL 0
#define CANCEL_HUP 1
#define CANCEL_SOFT 2

  weed_plant_t *event_list;

  gshort endian;

  gint pwidth;
  gint pheight;

  gshort whentostop;
  // which stream end should cause playback to finish ?
#define NEVER_STOP 0
#define STOP_ON_VID_END 1
#define STOP_ON_AUD_END 2

  gboolean noframedrop;

  gint play_start;
  gint play_end;
  gboolean playing_sel;
  gboolean preview;

  gboolean is_processing;
  gboolean is_rendering;
  gboolean resizing;

  gboolean foreign;  // for external window capture
  gboolean record_foreign;
  gboolean t_hidden;

  // recording from an external window
  guint foreign_key;
  unsigned int foreign_id;
  GdkColormap *foreign_cmap;
  GdkPixmap *foreign_map;
  gint foreign_width;
  gint foreign_height;
  gint foreign_bpp;

  // some VJ effects
  gboolean nervous;

  lives_rfx_t *rendered_fx; // external rendered effects plugins
  gint num_rendered_effects_builtin;
  gint num_rendered_effects_custom;
  gint num_rendered_effects_test;

  // for the merge dialog
  gint last_transition_idx;
  gint last_transition_loops;
  gboolean last_transition_loop_to_fit;
  gboolean last_transition_align_start;
  gboolean last_transition_ins_frames;

#define GU641 ((guint64)1)
  guint64 rte; // current max for VJ mode == 64 effects on fg clip

#define EFFECT_NONE 0

  guint last_grabable_effect;
  guint rte_keys; // which effect is bound to keyboard
  gint num_tr_applied; // number of transitions active
  gdouble blend_factor; // keyboard control parameter
  
  gint blend_file;
  gint blend_file_step;

  uyvy_frame *uyvy_frame;
  guchar *yuv_frame;
  int uyvy_width;
  int uyvy_height;

  gint scrap_file;

  // which number file we are playing
  gint playing_file;

  gint pre_src_file; // file we were editing before any ext input started

  gint scr_width;
  gint scr_height;
  gint toy_type;
#define TOY_NONE 0
#define TOY_RANDOM_FRAMES 1
#define TOY_TV 1
  gboolean toy_go_wild;

  // copy/paste
  gboolean insert_after;
  gboolean with_sound;

  // selection
  gint sel_start;
  gshort sel_move;

  // which bar should we move ?
#define SEL_MOVE_START 1
#define SEL_MOVE_END 2
#define SEL_MOVE_AUTO 3
#define SEL_MOVE_SINGLE 4

  // prefs (Save on exit)
  gint prefs_changed;
#define PREFS_THEME_CHANGED (1<<0)
#define PREFS_JACK_CHANGED (1<<1)
#define PREFS_TEMPDIR_CHANGED (1<<2)

  // default sizes for when no file is loaded
  gint def_width;
  gint def_height;

  // for the framedraw preview - TODO use lives_framedraw_t array
  gint framedraw_frame;


  /////////////////////////////////////////////////

  // end of static-ish info
  gboolean save_all;
  gchar first_info_file[256];
  gboolean leave_files;
  gboolean was_set;

  // extra parameters for opening special files
  gchar *file_open_params;

  gint last_dprint_file;

  // actual frame being displayed
  gint actual_frame;

  // and the audio 'frame' for when we are looping
  gdouble aframeno;

  // for the internal player
  gdouble period;
  gint64 startticks;
  gint64 timeout_ticks;
  gint64 startsecs;
  gint64 currticks;
  gint64 deltaticks;
  gint64 firstticks;
  gint64 origticks;
  gboolean size_warn;
  gboolean noswitch;
  gint new_clip;
  gboolean reinit_effects; // TODO - remove
  gboolean osc_block;
  gdouble fixed_fps;

  gshort scratch;
#define SCRATCH_NONE 0
#define SCRATCH_BACK -1
#define SCRATCH_FWD 1

  // internal fx
  gboolean internal_messaging;
  gint (*progress_fn) (gboolean reset);

  gboolean threaded_dialog;

  // fx controls
  gdouble fx1_val;
  gdouble fx2_val;
  gdouble fx3_val;
  gdouble fx4_val;
  gdouble fx5_val;
  gdouble fx6_val;

  gint fx1_start;
  gint fx2_start;
  gint fx3_start;
  gint fx4_start;

  gint fx1_step;
  gint fx2_step;
  gint fx3_step;
  gint fx4_step;

  gint fx1_end;
  gint fx2_end;
  gint fx3_end;
  gint fx4_end;

  gboolean fx1_bool;
  gboolean fx2_bool;
  gboolean fx3_bool;
  gboolean fx4_bool;
  gboolean fx5_bool;
  gboolean fx6_bool;

  gboolean effects_paused;
  gboolean did_rfx_preview;

  //function pointers
  guint kb_timer;
  gulong config_func;
  gulong pb_fps_func;
  gulong spin_start_func;
  gulong spin_end_func;
  gulong record_perf_func;
  gulong vidbar_func;
  gulong laudbar_func;
  gulong raudbar_func;
  gulong hrule_func;
  gulong toy_func_none;
  gulong toy_func_random_frames;
  gulong hnd_id;

  // for jack transport
  gboolean jack_can_stop;
  gboolean jack_can_start;

  gboolean video_seek_ready;

  // selection pointers
  gulong mouse_fn1;
  gboolean mouse_blocked;
  gboolean hrule_blocked;

  // stored clips
  gint clipstore[FN_KEYS-1];

  // GdkGC (graphics context)
  GdkGC *gc;

  // key function for autorepeat ctrl-arrows
  guint ksnoop;

  lives_mt *multitrack;

  gint new_blend_file;

  // Widgets  -- TODO - move into sub struct mainw->widgets->*
  GdkNativeWindow xwin;
  GtkTooltips *tooltips;
  GtkWidget *frame1;
  GtkWidget *frame2;
  GtkWidget *playframe;
  GdkPixbuf *imframe;
  GdkPixbuf *imsep;
  GtkWidget *LiVES;
  GtkWidget *save;
  GtkWidget *open;
  GtkWidget *open_sel;
  GtkWidget *open_vcd_menu;
  GtkWidget *open_vcd_submenu;
  GtkWidget *open_vcd;
  GtkWidget *open_dvd;
  GtkWidget *open_loc;
  GtkWidget *open_yuv4m;
  GtkWidget *open_device_menu;
  GtkWidget *open_device_submenu;
  GtkWidget *open_firewire;
  GtkWidget *open_hfirewire;
  GtkWidget *recent_menu;
  GtkWidget *recent_submenu;
  GtkWidget *recent1;
  GtkWidget *recent2;
  GtkWidget *recent3;
  GtkWidget *recent4;
  GtkWidget *save_as;
  GtkWidget *backup;
  GtkWidget *restore;
  GtkWidget *save_selection;
  GtkWidget *close;
  GtkWidget *import_proj;
  GtkWidget *export_proj;
  GtkWidget *sw_sound;
  GtkWidget *clear_ds;
  GtkWidget *ccpd_sound;
  GtkWidget *quit;
  GtkWidget *undo;
  GtkWidget *redo;
  GtkWidget *copy;
  GtkWidget *cut;
  GtkWidget *insert;
  GtkWidget *paste_as_new;
  GtkWidget *merge;
  GtkWidget *delete;
  GtkWidget *select_submenu;
  GtkWidget *select_all;
  GtkWidget *select_new;
  GtkWidget *select_to_end;
  GtkWidget *select_from_start;
  GtkWidget *select_start_only;
  GtkWidget *select_end_only;
  GtkWidget *select_last;
  GtkWidget *select_invert;
  GtkWidget *lock_selwidth;
  GtkWidget *record_perf;
  GtkWidget *playall;
  GtkWidget *playsel;
  GtkWidget *playclip;
  GtkWidget *rev_clipboard;
  GtkWidget *stop;
  GtkWidget *rewind;
  GtkWidget *full_screen;
  GtkWidget *loop_video;
  GtkWidget *loop_continue;
  GtkWidget *loop_ping_pong;
  GtkWidget *sepwin;
  GtkWidget *mute_audio;
  GtkWidget *sticky;
  GtkWidget *showfct;
  GtkWidget *fade;
  GtkWidget *dsize;

  GtkWidget *change_speed;
  GtkWidget *capture;
  GtkWidget *reorder;
  GtkWidget *load_audio;
  GtkWidget *load_cdtrack;
  GtkWidget *eject_cd;
  GtkWidget *recaudio_submenu;
  GtkWidget *recaudio_clip;
  GtkWidget *recaudio_sel;
  GtkWidget *export_submenu;
  GtkWidget *export_allaudio;
  GtkWidget *export_selaudio;
  GtkWidget *append_audio;
  GtkWidget *trim_submenu;
  GtkWidget *trim_audio;
  GtkWidget *trim_to_pstart;
  GtkWidget *delaudio_submenu;
  GtkWidget *delsel_audio;
  GtkWidget *delall_audio;
  GtkWidget *ins_silence;
  GtkWidget *fade_aud_in;
  GtkWidget *fade_aud_out;
  GtkWidget *resample_audio;
  GtkWidget *resample_video;
  GtkWidget *preferences;
  GtkWidget *xmms_play_audio;
  GtkWidget *xmms_random_audio;
  GtkWidget *xmms_stop_audio;
  GtkWidget *rename;
  GtkWidget *toys;
  GtkWidget *toy_none;
  GtkWidget *toy_random_frames;
  GtkWidget *toy_tv;
  GtkWidget *show_file_info;
  GtkWidget *show_file_comments;
  GtkWidget *show_clipboard_info;
  GtkWidget *show_messages;
  GtkWidget *show_layout_errors;
  GtkWidget *sel_label;
  GtkAccelGroup *accel_group;
  GtkWidget *sep_image;
  GtkWidget *hruler;
  GtkWidget *vj_menu;
  GtkWidget *vj_save_set;
  GtkWidget *vj_load_set;
  GtkWidget *vj_show_keys;
  GtkWidget *rte_defs_menu;
  GtkWidget *rte_defs;
  GtkWidget *save_rte_defs;
  GtkWidget *vj_reset;
  GtkWidget *mt_menu;

  // for the fileselection preview
  GtkWidget *fs_playarea;
  GtkWidget *fs_playframe;

  // for the framedraw special widget - TODO - use a sub-struct
  GtkWidget *framedraw; // the eventbox
  GtkWidget *framedraw_reset; // the 'redraw' button
  GtkWidget *framedraw_preview; // the 'redraw' button
  GtkWidget *framedraw_spinbutton; // the frame number button
  GtkWidget *framedraw_scale; // the slider
  GtkWidget *framedraw_image; // the image
  GtkWidget *fd_frame; // surrounding frame widget

  GdkPixmap *framedraw_orig_pixmap; // the original frame pixmap
  GdkPixmap *framedraw_copy_pixmap; // the altered frame pixmap
  GdkBitmap *framedraw_bitmap; // and its mask
  GdkGC *framedraw_bitmapgc;  // the GC for the bitmap
  GdkGC *framedraw_colourgc;  // the GC for the pixmap, we can draw in colours !

  // bars here -> actually text above bars
  GtkWidget *vidbar;
  GtkWidget *laudbar;
  GtkWidget *raudbar;

#define MAIN_SPIN_SPACER 76 // pixel spacing for start/end spins for clip and multitrack editors
  GtkWidget *spinbutton_end;
  GtkWidget *spinbutton_start;

  GtkWidget *arrow1;
  GtkWidget *arrow2;

  weed_plant_t *filter_map;
  void ***pchains;

  // for the internal player
  gint fixed_height;
  GtkWidget *image274;
  GtkWidget *play_window;
  GdkPixbuf *frame_image;
  GdkPixbuf *dbl_size;
  GtkWidget *plug1;
  gulong pw_exp_func;

  // frame preview in the separate window
  GtkWidget *preview_box;
  GtkWidget *preview_image;
  GtkWidget *preview_spinbutton;
  GtkWidget *preview_scale;
  gint preview_frame;
  gulong preview_spin_func;
  gint prv_link;
#define PRV_FREE 0
#define PRV_START 1
#define PRV_END 2
#define PRV_PTR 3

  GtkWidget *image272;
  GtkWidget *image273;
  GtkWidget *playarea;
  GtkWidget *hseparator;
  GtkWidget *scrolledwindow;
  GtkWidget *message_box;
  GtkWidget *warning_label;

  GtkWidget *textview1;
  GtkWidget *winmenu;
  GtkWidget *eventbox;
  GtkWidget *eventbox2;
  GtkWidget *eventbox3;
  GtkWidget *eventbox4;
  GtkWidget *eventbox5;

  // toolbar buttons
  GtkWidget *t_stopbutton;
  GtkWidget *t_bckground;
  GtkWidget *t_fullscreen;
  GtkWidget *t_sepwin;
  GtkWidget *t_double;
  GtkWidget *t_infobutton;

  GtkWidget *t_slower;
  GtkWidget *t_faster;
  GtkWidget *t_forward;
  GtkWidget *t_back;

  GtkWidget *t_hide;

  GtkWidget *toolbar;
  GtkWidget *tb_hbox;
  GtkWidget *fs1;
  GtkWidget *vbox1;

  GtkWidget *volume_scale;
  GtkWidget *vol_toolitem;
  GtkWidget *vol_label;

  // menubar buttons
  GtkWidget *btoolbar; // button toolbar - clip editor
  GtkWidget *m_sepwinbutton;
  GtkWidget *m_playbutton;
  GtkWidget *m_stopbutton;
  GtkWidget *m_playselbutton;
  GtkWidget *m_rewindbutton;
  GtkWidget *m_loopbutton;
  GtkWidget *m_mutebutton;
  GtkWidget *menu_hbox;
  GtkWidget *menubar;

  // separate window
  gint opwx;
  gint opwy;

  // sepwin buttons
  GtkWidget *p_playbutton;
  GtkWidget *p_playselbutton;
  GtkWidget *p_rewindbutton;
  GtkWidget *p_loopbutton;
  GtkWidget *p_mutebutton;
  GtkWidget *p_mute_img;

  // timer bars
  GtkWidget *video_draw;
  GdkPixmap *video_drawable;
  GtkWidget *laudio_draw;
  GdkPixmap *laudio_drawable;
  GtkWidget *raudio_draw;
  GdkPixmap *raudio_drawable;

  // framecounter
  GtkWidget *framebar;
  GtkWidget *framecounter;
  GtkWidget *spinbutton_pb_fps;
  GtkWidget *vps_label;
  GtkWidget *curf_label;
  GtkWidget *banner;

  // rendered effects
  GtkWidget *effects_menu;
  GtkWidget *tools_menu;
  GtkWidget *utilities_menu;
  GtkWidget *utilities_submenu;
  GtkWidget *run_test_rfx_submenu;
  GtkWidget *run_test_rfx_menu;
  GtkWidget *custom_effects_menu;
  GtkWidget *custom_effects_submenu;
  GtkWidget *custom_effects_separator;
  GtkWidget *custom_tools_menu;
  GtkWidget *custom_tools_submenu;
  GtkWidget *custom_tools_separator;
  GtkWidget *custom_utilities_menu;
  GtkWidget *custom_utilities_submenu;
  GtkWidget *custom_utilities_separator;
  GtkWidget *rte_separator;
  GtkWidget *invis;

  gint num_tracks;
  gint *clip_index;
  gint *frame_index;


  gboolean only_close;

#ifdef ENABLE_JACK
  jack_driver_t *jackd; // jack audio playback device
  jack_driver_t *jackd_read; // jack audio recorder device
#endif


  // layouts
  GtkTextBuffer *layout_textbuffer; // stores layout errors
  GList *affected_layouts_map; // map of layouts with errors
  GList *current_layouts_map; // map of all layouts for set

  gchar *recovery_file;
  gboolean leave_recovery;

  gboolean unordered_blocks;

  gboolean no_exit; // if TRUE, do not exit after saving set

  mt_opts multi_opts;

  gint rec_aclip;
  gdouble rec_avel;
  gdouble rec_aseek;

  gpointer do_not_free;
  GMemVTable alt_vtable;
  void (*free_fn)(gpointer);

  pthread_mutex_t gtk_mutex;
  pthread_mutex_t interp_mutex;

  lives_fx_candidate_t fx_candidates[MAX_FX_CANDIDATE_TYPES];

  GList *cached_list;
  FILE *clip_header;

  gfloat volume; // audio volume level (for jack)

  int aud_rec_fd; // fd of file we are recording audio to
  gdouble rec_end_time;
  long rec_samples;
  gdouble rec_fps;
  gint rec_vid_frames;
  gint rec_arate;
  gint rec_achans;
  gint rec_asamps;
  gint rec_signed_endian;

  gboolean no_switchclose_dprint;
  gchar *any_string;  // text saying "Any", for encoder and output format

  gint opening_frames; // count of frames so far opened, updated after preview (currently)

  gboolean show_procd;

  gboolean block_param_updates; // block visual param changes from updating real values
  gboolean no_interp; // block interpolation (for single frame previews)

  gdouble fd_scale;

  weed_timecode_t cevent_tc;

  GdkGC *general_gc;

} mainwindow;



_palette *palette;


typedef struct {
  gulong ins_frame_function;

  GtkWidget *merge_dialog;
  GtkWidget *ins_frame_button;
  GtkWidget *drop_frame_button;
  GtkWidget *param_vbox;
  GtkWidget *spinbutton_loops;
  GtkWidget *trans_entry;

  gboolean loop_to_fit;
  gboolean align_start;
  gboolean ins_frames;
  int *list_to_rfx_index;
  GList *trans_list;

} _merge_opts;






_merge_opts* merge_opts;

// note, we can only have two of these currently, one for rendered effects, one for real time effects
GtkWidget *fx_dialog[2];


#endif // HAS_MAINWINDOW_H
