// plugins.h
// LiVES
// (c) G. Finch 2003-2006 <salsaman@xs4all.nl>
// released under the GNU GPL 2.0 or higher
// see file ../COPYING or www.gnu.org for licensing details

#ifndef _HAS_PLUGINS_H
#define _HAS_PLUGINS_H

#include <gmodule.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <stdlib.h>
#include "main.h"


GList *
get_plugin_list (gchar *plugin_type, gboolean allow_nonex, gchar *plugdir);
#define PLUGIN_ENCODERS "encoders"
#define PLUGIN_VID_PLAYBACK "playback/video"


// smogrify handles the directory differently for themes
#define PLUGIN_THEMES "themes"

// uses WEED_PLUGIN_PATH
#define PLUGIN_EFFECTS_WEED "weed"
#define PLUGIN_WEED_FX_BUILTIN "effects/realtime/weed"


GList *
plugin_request (const gchar *plugin_type, const gchar *plugin_name, const gchar *request);

GList *
plugin_request_with_blanks (const gchar *plugin_type, const gchar *plugin_name, const gchar *request);

GList *
plugin_request_by_line (const gchar *plugin_type, const gchar *plugin_name, const gchar *request);

GList *
plugin_request_by_space (const gchar *plugin_type, const gchar *plugin_name, const gchar *request);

// TODO - make 1 function
GList *
plugin_request_common (const gchar *plugin_type, const gchar *plugin_name, const gchar *request, gchar *delim, gboolean allow_blanks);

GList *
get_plugin_result (gchar *, gchar *, gboolean); /* private function */


void 
do_plugin_error(const gchar *plugin_type, const gchar *plugin_name_or_null);


typedef struct {
  // playback
  gchar name[64];
  GModule *gmodule;

  const gchar * (*version) (void);
  void (*set_keyfun)(void (*fn)(gboolean, guint16, guint16));
  guint (*set_palette)(const gchar *p_name);
  guint (*get_capabilities)(void);
  gboolean (*init_screen)(int width, int height, gboolean fullscreen);
  gboolean (*render_frame)(int hsize, int vsize, void *pixel_data, void *return_data);
  void (*free_frame)(void);
  gboolean (*send_keycodes)(void);
  void (*exit_screen)(gint16 mouse_x, gint16 mouse_y);

  gint fwidth,fheight;

  //capabilities
  gboolean can_resize;
  gboolean can_return;
  gboolean local_display;
  gchar *fps_list;
} _vid_playback_plugin;


_vid_playback_plugin *vid_playback_plugin;


gboolean open_vid_playback_plugin (const gchar *name);
void vid_playback_plugin_exit (void);


// external rendered fx plugins (RFX plugins)
#define PLUGIN_RENDERED_EFFECTS_BUILTIN "effects/rendered"

// in the home directory
#define PLUGIN_RENDERED_EFFECTS_CUSTOM ".lives-dir/plugins/effects/rendered/custom"
#define PLUGIN_RENDERED_EFFECTS_TEST ".lives-dir/plugins/effects/rendered/test"

// rfx scripts for the SDK
#define PLUGIN_RENDERED_EFFECTS_BUILTIN_SCRIPTS "effects/RFXscripts"

// in the home directory
#define PLUGIN_RENDERED_EFFECTS_CUSTOM_SCRIPTS ".lives-dir/plugins/effects/RFXscripts/custom"
#define PLUGIN_RENDERED_EFFECTS_TEST_SCRIPTS ".lives-dir/plugins/effects/RFXscripts/test"


// max number of display widgets per parameter (currently 5 for RGBA spinbuttons + colorbutton)
#define MAX_PARAM_WIDGETS 5

// length of max string (not including terminating NULL) for LiVES-perl
#define RFX_MAXSTRINGLEN 1024


typedef struct {
  // weed style part
  gchar *name;
  gchar *desc;

  gchar *label;
  gint flags;
  gboolean use_mnemonic;
  gpointer interp_func;
  gpointer display_func;
  gint hidden;

  // reason(s) for hiding [bitmap]
#define HIDDEN_GUI (1<<0)
#define HIDDEN_MULTI (1<<1)
#define HIDDEN_NEEDS_REINIT (1<<2)

  gdouble step_size;
  gint copy_to;
  gboolean transition;
  gboolean reinit;

  gboolean wrap;
  gint group;
  gint type;

#define LIVES_PARAM_UNKNOWN 0
#define LIVES_PARAM_NUM 1
#define LIVES_PARAM_BOOL 2
#define LIVES_PARAM_COLRGB24 3
#define LIVES_PARAM_STRING 4
#define LIVES_PARAM_STRING_LIST 5
#define LIVES_PARAM_COLRGBA32 6


#define LIVES_PARAM_UNDISPLAYABLE 65536
  
  gint dp;  //decimals, 0 for int and bool
  void *value;  // current value(s)

  gdouble min;
  gdouble max;

  void *def; // default values
  GList *list; // for string list (choices)

  // multivalue type - for future use
  gshort multi;
#define PVAL_MULTI_NONE 0
#define PVAL_MULTI_ANY 1
#define PVAL_MULTI_PER_CHANNEL 2

  //--------------------------------------------------
  // extras for LiVES

  // TODO - change to GtkWidget **widgets, terminated with a NULL
  GtkWidget *widgets[MAX_PARAM_WIDGETS]; // widgets which hold value/RGBA settings
  gboolean onchange; // is there a trigger ?

  gboolean changed;

} lives_param_t;


typedef struct {
  gchar *name;  // the name of the executable (so we can run it !)
  gchar *menu_text; // for Weed, this is the filter_class "name"
  gchar *action_desc; // for Weed "Applying $s"
  gint min_frames; // for Weed, 1
  gint num_in_channels;
  gshort status;
#define RFX_STATUS_BUILTIN 0 // factory presets
#define RFX_STATUS_CUSTOM 1 // custom effects in the custom menu
#define RFX_STATUS_TEST 2 // test effects in the advanced menu
#define RFX_STATUS_ANY 3 // indicates free choice of statuses
#define RFX_STATUS_WEED 4 // indicates an internal RFX, created from a weed instance

  // these are only used when prompting for a name
#define RFX_STATUS_COPY 128 // indicates a copy operation to test
#define RFX_STATUS_RENAME 129 // indicates a copy operation to test

  guint32 props;
#define RFX_PROPS_SLOW        0x0001  // hint to GUI
#define RFX_PROPS_MAY_RESIZE  0x0002 // is a tool


#define RFX_PROPS_RESERVED1   0x1000
#define RFX_PROPS_RESERVED2   0x2000
#define RFX_PROPS_RESERVED3   0x4000
#define RFX_PROPS_AUTO_BUILT  0x8000

  GtkWidget *menuitem;  // the menu item which activates this effect
  gint num_params;
  lives_param_t *params;
  void *source;  // points to the source (e.g. a weed_plant_t)
  void *extra;  // for future use */
  gchar delim[2];
  gboolean is_template;

} lives_rfx_t;

gboolean check_rfx_for_lives (lives_rfx_t *);

void render_fx_get_params (lives_rfx_t *, const gchar *plugin_name, gshort status);

void sort_rfx_array (lives_rfx_t *in_array, gint num_elements);

gint find_rfx_plugin_by_name (gchar *name, gshort status);

void rfx_copy (lives_rfx_t *src, lives_rfx_t *dest, gboolean full);

void rfx_free(lives_rfx_t *rfx);

void rfx_free_all (void);

void param_copy (lives_param_t *src, lives_param_t *dest, gboolean full);


typedef struct {
  gshort red;
  gshort green;
  gshort blue;
} lives_colRGB24_t;

typedef struct {
  gshort red;
  gshort green;
  gshort blue;
  gshort alpha;
} lives_colRGBA32_t;


typedef struct {
  GList *list; // list of filter_idx from which user can delegate
  gint delegate; // offset in list of delegate
} lives_fx_candidate_t;

// filter types which can have candidates
#define FX_CANDIDATE_AUDIO_VOL 0
#define FX_CANDIDATE_RESIZER 1

#define MAX_FX_CANDIDATE_TYPES 2



gboolean get_bool_param(void *value);
gint get_int_param(void *value);
gdouble get_double_param(void *value);
void get_colRGB24_param(void *value, lives_colRGB24_t *rgb);
void get_colRGBA32_param(void *value, lives_colRGBA32_t *rgba);

void set_bool_param(void *value, const gboolean _const);
void set_int_param(void *value, const gint _const);
void set_double_param(void *value, const gdouble _const);
void set_colRGB24_param(void *value, gshort red, gshort green, gshort blue);
void set_colRGBA32_param(void *value, gshort red, gshort green, gshort blue, gshort alpha);

// return an array of parameter values
void **store_rfx_params (lives_rfx_t *);
void set_rfx_params_from_store (lives_rfx_t *rfx, void **store);
void rfx_params_store_free (lives_rfx_t *, void **store);

// 
GList *array_to_string_list (gchar **array, gint offset, gint len);

lives_rfx_t *weed_to_rfx (weed_plant_t *plant, gboolean show_reinits);


#endif
