/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#ifndef __BASEVIEW_H__
#define __BASEVIEW_H__
//-----------------------------------------------------------------------------------------------------------------------
#include <klistview.h>
#include <kconfig.h>
#include "programmaster.h"
#include "programitem.h"
#include "program.h"
//-----------------------------------------------------------------------------------------------------------------------
class MainWidget;
//-----------------------------------------------------------------------------------------------------------------------
class BaseView : public QObject
{
	Q_OBJECT
public:
	BaseView(MainWidget *parent, ProgramMaster *programMaster, KListView *lv, QPtrList<Program> *programs, QWidget *frame);

	virtual void loadSettings(KConfig *cfg);
	virtual void saveSettings(KConfig *cfg);

	virtual void filter(ProgramItem *pi);
	virtual void newDay() = 0;
	virtual void aboutToShow() = 0;
	virtual void preParse() = 0;
	virtual void postParse() = 0;

	bool refresh();
	void saveSelection();
	void restoreSelection();
	void hideChannel(ProgramItem *item);
	void hideBlacklist(ProgramItem *pi);
	void hideCategories(ProgramItem *pi);

	void hidePast(ProgramItem *item);
//	bool pastHidden() { return(m_hidePast); }
//	void setPastHidden(bool hidePast) { m_hidePast = hidePast; }

	void hideNonFavs(ProgramItem *item);
//	bool favsOnly() { return(m_favsOnly); }
//	void setFavsOnly(bool favsOnly) { m_favsOnly = favsOnly; }

	KListView* listView() { return(m_lv); }
	int showColWidth() { return(m_showColWidth); }

public slots:
	virtual void showPopupMenu(KListView*, QListViewItem *item, const QPoint&) = 0;
	virtual bool rebuild() = 0;
	void aboutToShowCheck(QWidget *wid);
	void updateDesc();
	void toggleHidePast() { m_hidePast = !m_hidePast; refresh(); }
	void toggleFavsOnly() { m_favsOnly = !m_favsOnly; refresh(); }

protected:
	MainWidget *m_parent;
	ProgramMaster *m_programMaster;
	QPtrList<Program> *m_programs;
	KListView *m_lv;
	QWidget *m_frame;
	QString m_selection;
	bool m_favsOnly;
	bool m_hidePast;
	int m_showColWidth;

};
//-----------------------------------------------------------------------------------------------------------------------
#endif
//-----------------------------------------------------------------------------------------------------------------------
