/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kiconloader.h>
#include <kconfig.h>
#include <kglobal.h>
#include <qspinbox.h>
#include <qimage.h>
#include <qhttp.h>
#include <qdir.h>
//-----------------------------------------------------------------------------------------------------------------------
#include "channelitem.h"
#include "mainwidget.h"
//-----------------------------------------------------------------------------------------------------------------------
ChannelItem::ChannelItem(MainWidget *parent, QListView *lv, Channel *channel) : QListViewItem(lv)
{
	m_parent = parent;
	m_channel = channel;
	m_uop = NULL;
	
//	KConfig *cfg = KGlobal::config();
//	if(cfg->hasGroup(m_channel->id())) {
//		cfg->setGroup(m_channel->id());
//		channel->setPrio(cfg->readNumEntry("prio", 0));
//	}
	m_uop = new QUrlOperator;
	connect(m_uop, SIGNAL(finished(QNetworkOperation*)), this, SLOT(updateIcon(QNetworkOperation*)));

	if(m_parent->prefs()->cb_chanicons->isChecked()) {
		loadChannelLogo();
		setText(0, " "+m_channel->customName());
	} else
		setText(0, m_channel->customName());
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelItem::updateIcon(QNetworkOperation *nop)
{
	if(nop->state() != QNetworkProtocol::StDone) return;

	QString imagePath(QDir::home().path() + "/.maxemumtvguide/icons/");
	QString imageLocation = m_channel->imageLocation();
	int iconSize = m_parent->prefs()->sb_chaniconsize->value();
	QImage image;

	if(!image.load(imagePath + imageLocation.right(imageLocation.length()-imageLocation.findRev('/')-1))) {
		setEmptyIcon();
		return;
	}

	m_channel->setImage(image);
	m_icon.convertFromImage(image.smoothScale(iconSize, iconSize));
	setPixmap(0, m_icon);
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelItem::loadChannelLogo()
{
	int iconSize = m_parent->prefs()->sb_chaniconsize->value();
	QImage image;

	if(m_channel->hasCustomImage()) {
		if(image.load(m_channel->customImage())) {
			m_channel->setImage(image);
			m_icon.convertFromImage(image.smoothScale(iconSize, iconSize));
			setPixmap(0, m_icon);
			return;
		}
	}

	if(m_channel->imageLocation().isEmpty()) {
		setEmptyIcon();
		return;
	}
	if(!m_channel) return;
	if(m_channel->hasImage()) {
		m_icon.convertFromImage(m_channel->image().smoothScale(iconSize, iconSize));
		setPixmap(0, m_icon);
		return;
	}

	QString imagePath(QDir::home().path() + "/.maxemumtvguide/icons/");
	QNetworkProtocol::registerNetworkProtocol("http", new QNetworkProtocolFactory<QHttp>);
	QString imageLocation = m_channel->imageLocation();
	QDir loc(imagePath);

	if(!loc.exists() && !loc.mkdir(QDir::home().path() + "/.maxemumtvguide") && !loc.mkdir(QDir::home().path() + "/.maxemumtvguide/icons"))
		return;

	if(!image.load(imagePath + imageLocation.right(imageLocation.length()-imageLocation.findRev('/')-1))) {
		m_uop->copy(imageLocation, "file:"+imagePath);
		setEmptyIcon();
	} else {
		m_channel->setImage(image);
		m_icon.convertFromImage(image.smoothScale(iconSize, iconSize));
		setPixmap(0, m_icon);
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void ChannelItem::setEmptyIcon()
{
	int iconSize = m_parent->prefs()->sb_chaniconsize->value();
	QImage temp((KGlobal::instance()->iconLoader()->loadIcon("maxemumtvguide", KIcon::NoGroup)).convertToImage());
	m_icon.convertFromImage(temp.smoothScale(iconSize, iconSize));
	setPixmap(0, m_icon);
}
//-----------------------------------------------------------------------------------------------------------------------
int ChannelItem::compare(QListViewItem* i, int /*col*/, bool /*ascending*/) const
{
	ChannelItem *ci = (ChannelItem*)i;

	if(channel()->prio() == ci->channel()->prio())
		return(0);
	if(channel()->prio() < ci->channel()->prio())
		return(1);
	return(-1);
}
//-----------------------------------------------------------------------------------------------------------------------
