/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kcolorbutton.h>
#include <kkeybutton.h>
#include <qspinbox.h>
#include <qlistbox.h>
#include "mainwidget.h"
#include "prefsdialog.h"
//-----------------------------------------------------------------------------------------------------------------------
PrefsDialog::PrefsDialog(MainWidget *parent)
{
	m_parent = parent;
	lb_type->setCurrentItem(0);

	connect(kkb_toggle, SIGNAL(capturedShortcut(const KShortcut&)), m_parent, SLOT(capturedShortcut(const KShortcut&)));
	connect(kcb_favourite, SIGNAL(changed(const QColor&)), m_parent, SLOT(favColChanged(const QColor&)));
}
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::loadSettings()
{
	KConfig *cfg = KGlobal::config();

	cfg->setGroup("MTVG");
	// General
	cb_daystart->setCurrentItem(cfg->readNumEntry("daystart", 5));
	cb_manualwidth->setChecked(cfg->readBoolEntry("manualColWidth", false));
	cb_chanicons->setChecked(cfg->readBoolEntry("chanIcons", true));
	sb_chaniconsize->setValue(cfg->readNumEntry("chanIconSize", 16));
	sb_timeoffset->setValue(cfg->readNumEntry("timeOffset", 0));
	KShortcut sc(cfg->readEntry("toggleShortcut", ""));
	kkb_toggle->setShortcut(sc, true);
	// Reminders
	sb_minbefore->setValue(cfg->readNumEntry("minbefore", 1));
	cb_showpopup->setChecked(cfg->readBoolEntry("showpopup", true));
	cb_executecmd->setChecked(cfg->readBoolEntry("executecmd", false));
	le_command->setText(cfg->readEntry("command", ""));
	// Tags
	cb_directortag->setChecked(cfg->readBoolEntry("directorTag", true));
	cb_actorstag->setChecked(cfg->readBoolEntry("actorsTag", true));
	cb_episodetag->setChecked(cfg->readBoolEntry("episodeTag", true));
	cb_categorytag->setChecked(cfg->readBoolEntry("categoryTag", true));
	cb_datetag->setChecked(cfg->readBoolEntry("dateTag", true));
	cb_aspecttag->setChecked(cfg->readBoolEntry("aspectTag", true));
	// Colours
	cb_past->setChecked(cfg->readBoolEntry("pastCol", true));
	kcb_past->setColor(cfg->readColorEntry("kPastCol", new QColor(255, 240, 240)));
	cb_present->setChecked(cfg->readBoolEntry("presentCol", true));
	kcb_present->setColor(cfg->readColorEntry("kPresentCol", new QColor(255, 255, 240)));
	cb_progress->setChecked(cfg->readBoolEntry("progressCol", true));
	kcb_progress->setColor(cfg->readColorEntry("kProgressCol", new QColor(246, 238, 150)));
	cb_future->setChecked(cfg->readBoolEntry("futureCol", true));
	kcb_future->setColor(cfg->readColorEntry("kFutureCol", new QColor(240, 255, 240)));
	cb_favourite->setChecked(cfg->readBoolEntry("favouriteCol", true));
	kcb_favourite->setColor(cfg->readColorEntry("kFavouriteCol", new QColor(240, 240, 255)));
	m_parent->lv_favourite->setPaletteBackgroundColor(kcb_favourite->color());
	cb_timesep->setChecked(cfg->readBoolEntry("timeSep", true));
	kcb_timesep->setColor(cfg->readColorEntry("kTimeSep", new QColor(140, 140, 140)));
	cb_colsep->setChecked(cfg->readBoolEntry("colSep", true));
	kcb_colsep->setColor(cfg->readColorEntry("kColSep", new QColor(200, 200, 200)));
	// Forum
	le_name->setText(cfg->readEntry("userName", ""));
	le_location->setText(cfg->readEntry("userLocation", ""));
	// Updates
	le_tvfile->setText(cfg->readEntry("tvfile", ""));
	le_updatecmd->setText(cfg->readEntry("updatecmd", ""));
	cb_autoupdate->setChecked(cfg->readBoolEntry("autoupdate", false));
}
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::saveSettings()
{
	KConfig *cfg = KGlobal::config();

	cfg->setGroup("MTVG");
	// General
	cfg->writeEntry("daystart", cb_daystart->currentItem());
	cfg->writeEntry("manualColWidth", cb_manualwidth->isChecked());
	cfg->writeEntry("chanIcons", cb_chanicons->isChecked());
	cfg->writeEntry("chanIconSize", sb_chaniconsize->value());
	cfg->writeEntry("timeOffset", sb_timeoffset->value());
	cfg->writeEntry("toggleShortcut", kkb_toggle->shortcut().toString());
	// Reminders
	cfg->writeEntry("minbefore", sb_minbefore->value());
	cfg->writeEntry("showpopup", cb_showpopup->isChecked());
	cfg->writeEntry("executecmd", cb_executecmd->isChecked());
	cfg->writeEntry("command", le_command->text());
	// Tags
	cfg->writeEntry("directorTag", cb_directortag->isChecked());
	cfg->writeEntry("actorsTag", cb_actorstag->isChecked());
	cfg->writeEntry("episodeTag", cb_episodetag->isChecked());
	cfg->writeEntry("categoryTag", cb_categorytag->isChecked());
	cfg->writeEntry("dateTag", cb_datetag->isChecked());
	cfg->writeEntry("aspectTag", cb_aspecttag->isChecked());
	// Colours
	cfg->writeEntry("pastCol", cb_past->isChecked());
	cfg->writeEntry("kPastCol", kcb_past->color());
	cfg->writeEntry("presentCol", cb_present->isChecked());
	cfg->writeEntry("kPresentCol", kcb_present->color());
	cfg->writeEntry("progressCol", cb_progress->isChecked());
	cfg->writeEntry("kProgressCol", kcb_progress->color());
	cfg->writeEntry("futureCol", cb_future->isChecked());
	cfg->writeEntry("kFutureCol", kcb_future->color());
	cfg->writeEntry("favouriteCol", cb_favourite->isChecked());
	cfg->writeEntry("kFavouriteCol", kcb_favourite->color());
	cfg->writeEntry("timeSep", cb_timesep->isChecked());
	cfg->writeEntry("kTimeSep", kcb_timesep->color());
	cfg->writeEntry("colSep", cb_colsep->isChecked());
	cfg->writeEntry("kColSep", kcb_colsep->color());
	// Forum
	cfg->writeEntry("userName", le_name->text());
	cfg->writeEntry("userLocation", le_location->text());
	// Updates
	cfg->writeEntry("tvfile", le_tvfile->text());
	cfg->writeEntry("updatecmd", le_updatecmd->text());
	cfg->writeEntry("autoupdate", cb_autoupdate->isChecked());

	cfg->sync();
}
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::browseUpdateCmdClicked() { m_parent->browseUpdateCmdClicked(); }
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::refresh() { m_parent->refresh(); }
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::rebuildView() { m_parent->rebuildView(); }
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::browseCommandClicked() { m_parent->browseCommandClicked(); }
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::defaultColoursClicked() { m_parent->defaultColoursClicked(); }
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::detailTagsChanged() { m_parent->detailTagsChanged(); }
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::updateChannels() { m_parent->updateChannels(); }
//-----------------------------------------------------------------------------------------------------------------------
void PrefsDialog::manualColWidth(bool manual) { m_parent->manualColWidth(manual); }
//-----------------------------------------------------------------------------------------------------------------------
