/***************************************************************************
 *   Copyright (C) 2005 by Robert Maxe                                     *
 *   mutex@spray.se                                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
//-----------------------------------------------------------------------------------------------------------------------
#include <kwin.h>
#include <klocale.h>
#include <qpushbutton.h>
#include <qsizepolicy.h>
#include <qtextbrowser.h>
#include <qprogressbar.h>
#include <qdatetime.h>
#include <qspinbox.h>
#include <qlabel.h>
#include "remindwindow.h"
#include "programmaster.h"
#include "mainwidget.h"
//-----------------------------------------------------------------------------------------------------------------------
RemindWindow::RemindWindow(MainWidget *parent, Program *program)
{
	m_dialog = new ReminderDialog(this);
	setCentralWidget(m_dialog);
	setCaption(i18n("Reminder"));
	setMaximumHeight(113);
	m_dialog->tl_show->setText(program->title());
	m_dialog->tl_time->setText((program->startDT()).toString("hh:mm") + " - " + (program->stopDT()).toString("hh:mm") + "  (" + program->duration().toString("h:mm") + ")");
	m_dialog->tl_channel->setText(program->channel()->customName());

	m_parent = parent;
	m_dialog->tb_details->setMinimumHeight(130);
	m_dialog->tb_details->hide();

	QString descr;
	bool air = false;

	if(!program->subtitle().isEmpty())
		descr += "<b>" + i18n("Title") + ":</b> " + program->subtitle();
	if(!program->desc().isEmpty()) {
		if(!descr.isEmpty()) descr += "<br>";
		descr += "<b>" + i18n("Info") + ":</b> " + program->desc();
	} else
		air = true;
	if(m_parent->prefs()->cb_directortag->isChecked() && !program->director().isEmpty()) {
		if(!descr.isEmpty()) descr += "<br>";
		descr += "<br><b>" + i18n("Director") + ":</b> " + program->director();
		air = true;
	}
	if(m_parent->prefs()->cb_actorstag->isChecked() && !program->actors().isEmpty()) {
		if(!air) descr += "<br>";
		if(!descr.isEmpty()) descr += "<br>";
		descr += "<b>" + i18n("Actors") + ":</b> " + program->actors();
		air = true;
	}
	if(m_parent->prefs()->cb_episodetag->isChecked() && !program->episode().isEmpty()) {
		if(!air) descr += "<br>";
		if(!descr.isEmpty()) descr += "<br>";
		descr += "<b>" + i18n("Episode") + ":</b> " + program->episode();
		air = true;
	}
	if(m_parent->prefs()->cb_categorytag->isChecked() && !program->category().isEmpty()) {
		if(!air) descr += "<br>";
		if(!descr.isEmpty()) descr += "<br>";
		descr += "<b>" + i18n("Category") + ":</b> " + program->category();
		air = true;
	}
	if(m_parent->prefs()->cb_datetag->isChecked() && !program->date().isEmpty()) {
		if(!air) descr += "<br>";
		if(!descr.isEmpty()) descr += "<br>";
		descr += "<b>" + i18n("Date") + ":</b> " + program->date();
		air = true;
	}
	if(m_parent->prefs()->cb_aspecttag->isChecked() && !program->aspect().isEmpty()) {
		if(!air) descr += "<br>";
		if(!descr.isEmpty()) descr += "<br>";
		descr += "<b>" + i18n("Aspect") + ":</b> " + program->aspect();
		air = true;
	}
	m_dialog->tb_details->setText(descr);
	if(program->desc().isEmpty())
		m_dialog->pb_details->setEnabled(false);

//	m_dialog->pb_close->setText("&Close (" + (ProgramMaster::duration(program)).toString("h:mm") + ")");
	m_timeLeft = program->duration().hour()*60+program->duration().minute();
	m_minBefore = m_parent->prefs()->sb_minbefore->value()+1;
	QTime now(QTime::currentTime());
	m_timer = new QTimer(this);
	connect(m_timer, SIGNAL(timeout()), this, SLOT(timerDone()));
//	m_timer->changeInterval((60-now.second())*1000);
	timerDone();

	m_dialog->pb_progress->setProgress(0, m_timeLeft);
	WId winid = winId();
	unsigned long wstate = NET::Modal | NET::Sticky | NET::StaysOnTop;
	KWin::setState(winid, wstate);
	KWin::setOnAllDesktops(winid, true);
	connect(m_dialog->pb_close, SIGNAL(clicked()), this, SLOT(closeReminder()));
	connect(m_dialog->pb_details, SIGNAL(clicked()), this, SLOT(toggleDetails()));
	showNormal();
}
//-----------------------------------------------------------------------------------------------------------------------
void RemindWindow::closeReminder()
{
	m_timer->stop();
	delete m_timer;
	m_dialog->close();
	delete m_dialog;
	hide();
}
//-----------------------------------------------------------------------------------------------------------------------
void RemindWindow::toggleDetails()
{
	if(m_dialog->pb_details->isOn()) {
		m_dialog->tb_details->show();
		setMaximumHeight(32767);
	} else {
		m_dialog->tb_details->hide();
		setMaximumHeight(113);
	}
}
//-----------------------------------------------------------------------------------------------------------------------
void RemindWindow::timerDone()
{
	QTime now(QTime::currentTime());

	if(m_minBefore)
		m_minBefore--;
	else
		m_timeLeft--;

	if(m_timeLeft) {
		m_dialog->pb_close->setText(i18n("&Close") + " (" + QString::number(m_timeLeft/60) + ":" + (m_timeLeft%60<10?"0":"") + QString::number(m_timeLeft%60) + (m_minBefore?(" + " + QString::number(m_minBefore)):"") + ")");
		m_dialog->pb_progress->setProgress(m_dialog->pb_progress->totalSteps()-m_timeLeft);
		m_timer->changeInterval((60-now.second())*1000);
	} else
		queryClose();
}
//-----------------------------------------------------------------------------------------------------------------------
bool RemindWindow::queryClose()
{
	closeReminder();
	return(false);
}
//-----------------------------------------------------------------------------------------------------------------------
