#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config /etc/mplayerplug-in.conf.new



( cd usr/lib ; rm -rf libxpcom_core.so )
( cd usr/lib ; ln -sf /usr/lib/seamonkey/libxpcom_core.so libxpcom_core.so )
( cd usr/lib ; rm -rf libxpcom.so )
( cd usr/lib ; ln -sf /usr/lib/seamonkey/libxpcom.so libxpcom.so )