/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifndef GRAPHIC_H
#define GRAPHIC_H

#ifdef ENABLE_SOMALIST
#include <somalist.h>
#endif

#define APPEND 0
#define PREPEND 1

#define INPUT_PLS 0
#define INPUT_MIC 1
#define INPUT_SDS 2

typedef struct
{
  GtkWidget *playlist;
  GtkWidget *buttons;

  GtkWidget *volume;
  GtkWidget *balance;

  GtkWidget *random;
  GtkWidget *repeat;

  GtkWidget *t_playlist;
#ifdef ENABLE_MIC  
  GtkWidget *t_microphone;
#endif  

#ifdef ENABLE_DAEMON
  GtkWidget *t_daemon_input;
#endif  

} gtk_element_input;

extern GtkTargetEntry targetentries[];

extern pthread_mutex_t gmutex;

extern GtkWidget *winmain;
extern GtkWidget *winoutput;
extern GtkWidget *winsearch;
#ifdef ENABLE_SOMALIST
extern GtkWidget *winspls;
#endif
extern GtkWidget *text;
extern GtkWidget *b_random;
extern GtkWidget *b_repeat;
extern GtkWidget *playlist;
extern GtkWidget *statusbar;
extern gint statusbar_id;
extern GtkWidget *output_list;
extern GtkWidget *ledbar_l;
extern GtkWidget *ledbar_r;
extern gtk_element_input *element_input;

extern char *gtkrc;

extern char graphic_dialog_text[SIZE_BUFFER];

/* main.c */
void graphic_save_size (int, int);

/* dialog.c */
int dialog_msg (char *);
int dialog_ask (char *);
int dialog_test_file (char *);

/* interface.c */
GtkWidget *create_winmain (void);

/* timeout.c */
int timeout (gpointer);

/* input.c */
#ifdef ENABLE_MIC
void on_mic_activate (GtkMenuItem *, gtk_element_input *);
#endif
#ifdef ENABLE_DAEMON
void on_daemon_input_activate (GtkMenuItem *, gtk_element_input *);
#endif
void on_playlist_activate (GtkMenuItem *, gtk_element_input *);
void input_update (int);

/* menu.c */
void on_save_playlist_activate (GtkMenuItem *, gpointer);
void on_save_configuration_activate (GtkMenuItem *, gpointer);
void on_quit_activate (GtkMenuItem *, gpointer);

/* tools.c */
void on_trimming_activate (GtkMenuItem *, gpointer);
void on_admin_activate (GtkMenuItem *, gpointer);
void on_realtime_activate (GtkMenuItem *, gpointer);

/* about.c */
void on_about_activate (GtkMenuItem *, gpointer);

/* o_ao_new.c */
void on_ao_new_activate (GtkMenuItem *, gpointer);

/* o_ao_show.c */
void on_ao_show_activate (GtkMenuItem *, gpointer);

/* o_sndfile_new.c */
void on_write_a_file_new_activate (GtkMenuItem *, gpointer);

/* o_sndfile_show.c */
void on_write_a_file_show_activate (GtkMenuItem *, gpointer);

/* o_sds_new.c */
void on_sds_new_activate (GtkMenuItem *, gpointer);

/* o_sds_show.c */
void on_sds_show_activate (GtkMenuItem *, gpointer);

/* o_icecast_new.c */
void on_icecast_new_activate (GtkMenuItem *, gpointer);

/* o_icecast_show.c */
void on_icecast_show_activate (GtkMenuItem *, gpointer);

/* o_icecast2_new.c */
void on_icecast2_new_activate (GtkMenuItem *, gpointer);

/* o_icecast2_show.c */
void on_icecast2_show_activate (GtkMenuItem *, gpointer);

/* o_shoutcast_new.c */
void on_shoutcast_new_activate (GtkMenuItem *, gpointer);

/* o_shoutcast_show.c */
void on_shoutcast_show_activate (GtkMenuItem *, gpointer);

/* o_lame_new.c */
void on_lame_new_activate (GtkMenuItem *, gpointer);

/* o_lame_show.c */
void on_lame_show_activate (GtkMenuItem *, gpointer);

/* o_ogg_new.c */
void on_ogg_new_activate (GtkMenuItem *, gpointer);

/* o_ogg_show.c */
void on_ogg_show_activate (GtkMenuItem *, gpointer);

/* o_monitor_show.c */
void on_monitor_show_activate (GtkMenuItem *, gpointer);

/* playlist.c */
void playlist_select (void);
void playlist_add (char *);
void playlist_refresh (void);
void playlist_append(list *);
void playlist_append_before(list *, list *);
void playlist_remove(int);
void playlist_move(list *, list *);
void on_b_remove_clicked (GtkWidget *, GtkTreeSelection *);
void on_b_queue_clicked (GtkWidget *, GtkTreeSelection *);
GtkWidget *playlist_menu (void);
GtkWidget *add_menu (void);
void popup_position (GtkMenu *, gint *, gint *, gboolean *, gpointer);
gint playlist_key_event(GtkWidget *, GdkEventKey *, GtkTreeSelection *);
gint playlist_menu_popup (GtkWidget *, GdkEventButton *, gpointer);
gint add_menu_popup (GtkWidget *, GdkEventButton *, gpointer);
void playlist_save (char *);
void playlist_dump (void);
void playlist_restore (void);
void playlist_drop(GtkWidget *, GdkDragContext *, int, int, GtkSelectionData *, guint, guint, gpointer);
void playlist_drag_begin(GtkWidget *, GdkDragContext *, GtkSelectionData *, guint, guint, gpointer);
void playlist_drag_get (GtkWidget *, GdkDragContext *, GtkSelectionData *, guint, guint , gpointer);
void playlist_drag_end(GtkWidget *, GdkDragContext *, gpointer);


#ifdef ENABLE_CDAUDIO
/* cdaudio.c */
void add_cdaudio_activate (GtkWidget *, gpointer);
#endif

/* stream.c */
void add_stream_activate (GtkWidget *, gpointer);

/* o_playlist.c */
void add_pl_activate (GtkWidget *, gpointer);

/* fileselection.c */
void add_file_activate (GtkWidget *, gpointer);
void *file_chooser (char *, int, int);
void add_dir_activate (GtkWidget *, gpointer);

/* menu.c */
void on_b_replay_clicked (GtkButton *, gpointer);
void on_b_prev_clicked (GtkButton *, gpointer);
void on_b_play_clicked (GtkButton *, gpointer);
void on_b_stop_clicked (GtkButton *, gpointer);
void on_b_next_clicked (GtkButton *, gpointer);
void on_s_volume_value_changed (GtkWidget *, gpointer);
void on_s_balance_value_changed (GtkWidget *, gpointer);
void on_b_repeat_toggled (GtkWidget *, gpointer);
void on_b_random_toggled (GtkWidget *, gpointer);

/* o_interface.c */
GtkWidget *create_winoutput(void);
GtkWidget *create_output_list (void);
GtkWidget *create_output_list_menu (GtkTreeSelection *);
gboolean output_list_m_show(GtkWidget *, GdkEventButton *, gpointer);
GtkWidget *output_list_menu (void);
int output_window_show (GtkWidget *, gpointer);
void output_list_refresh (void);
void output_list_add (audio *, int);
void output_list_select_show (GtkWidget *, GtkTreeSelection *);
void output_list_select_remove (GtkWidget *, GtkTreeSelection *);
void output_list_select_stop (GtkWidget *, GtkTreeSelection *);

/* ledbar.c */
int ledbar_timeout (gpointer);

/* search.c */
GtkWidget *create_winsearch (void);
int search_window_show (GtkWidget *, gpointer);

#ifdef ENABLE_SOMALIST
GtkWidget *create_winspls(void);
int spls_window_show(GtkWidget *w, gpointer);
#endif

#endif

/* EOF */
