#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/slp.conf.new
( cd usr/lib ; rm -rf libslp.so.1 )
( cd usr/lib ; ln -sf libslp.so.1.0.1 libslp.so.1 )
( cd usr/lib ; rm -rf libslp.so )
( cd usr/lib ; ln -sf libslp.so.1.0.1 libslp.so )
