#!/bin/sh


mkdir -p /var/run/hald/hald-local
mkdir -p /var/run/hald/hald-runner


config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

config etc/rc.d/rc.hald.new



# If the haldaemon user/group don't exist, add them:
if ! grep -q haldaemon /etc/group; then
        groupadd haldaemon
fi
if ! grep -q haldaemon /etc/passwd; then
        useradd -g haldaemon -d / -c "Hal Daemon" -s /bin/false haldaemon
fi    


( cd /etc/udev/rules.d \ 
sed -i "s|#RUN+|RUN+|g" udev.rules )



# If the mounters group don't exist, add them:
if ! grep -q plugdev /etc/group; then
        groupadd plugdev
fi 


###
# Use rc.local to start dbus at boot.
###
PIDFILE=/var/run/dbus/dbus.pid
if [ ! -e etc/rc.d/rc.local ]; then
	echo "#!/bin/sh" > etc/rc.d/rc.local
	chmod 755 etc/rc.d/rc.local
fi
run=`grep "sh /etc/rc.d/rc.messagebus" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then	
	echo "" >> etc/rc.d/rc.local
	echo "if [ -x /etc/rc.d/rc.messagebus ]; then" >> etc/rc.d/rc.local
	echo "	if [ -w $PIDFILE ]; then" >> etc/rc.d/rc.local
	echo "		rm $PIDFILE" >> etc/rc.d/rc.local
	echo "	fi" >> etc/rc.d/rc.local
	echo "	sh /etc/rc.d/rc.messagebus start" >> etc/rc.d/rc.local
	echo "fi" >> etc/rc.d/rc.local
fi



# if rc.hal is executable, run it on startup
run=`grep ". /etc/rc.d/rc.hald" etc/rc.d/rc.local`
if [[ "${run}" == "" ]]; then
cat << EOF >> etc/rc.d/rc.local

#hal
# To disable hal, chmod rc.hal to 644
if [ -x /etc/rc.d/rc.hald ]; then
	sh /etc/rc.d/rc.hald start
fi
EOF
fi

( echo -e "\E[0;32m+----------------------------------------------------------------------+\E[0;0m" )
( echo -e "\E[0;32m|  Done. It's needed to add your user account to < plugdev > group... |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m|  Remember to remove removable media from  /etc/fstab                 |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m|  Save and restart all service  or restart pc                         |\E[0;0m" )
( echo -e "\E[0;32m|                                                                      |\E[0;0m" )
( echo -e "\E[0;32m|  # /etc/rc.d/rc.messagebus start                                     |\E[0;0m" )
( echo -e "\E[0;32m|  # /etc/rc.d/rc.hal start                                            |\E[0;0m" )
( echo -e "\E[0;32m|  # /etc/rc.d/rc.udev reload                                          |\E[0;0m" )
( echo -e "\E[0;32m+--------------------------------------------------------------------- +\E[0;0m" )



( cd usr/lib ; rm -rf libhal.so.1 )
( cd usr/lib ; ln -sf libhal.so.1.0.0 libhal.so.1 )
( cd usr/lib ; rm -rf libhal.so )
( cd usr/lib ; ln -sf libhal.so.1.0.0 libhal.so )
( cd usr/lib ; rm -rf libhal-storage.so.1 )
( cd usr/lib ; ln -sf libhal-storage.so.1.0.0 libhal-storage.so.1 )
( cd usr/lib ; rm -rf libhal-storage.so )
( cd usr/lib ; ln -sf libhal-storage.so.1.0.0 libhal-storage.so )
