/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DragAndDropEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

class TableDragAndDropEffect
extends DragAndDropEffect {
    Table table;
    int scrollIndex = -1;
    long scrollBeginTime;
    static final int SCROLL_HYSTERESIS = 150;

    TableDragAndDropEffect(Table table) {
        this.table = table;
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    Widget getItem(int x, int y) {
        Rectangle area;
        Point coordinates = new Point(x, y);
        TableItem item = this.table.getItem(coordinates = this.table.toControl(coordinates));
        if (item == null && (area = this.table.getClientArea()).contains(coordinates)) {
            int x1 = area.x;
            while (x1 < area.x + area.width) {
                Point pt = new Point(x1, coordinates.y);
                item = this.table.getItem(pt);
                if (item != null) break;
                ++x1;
            }
        }
        return item;
    }

    ImageData getDragSourceImage(int x, int y) {
        int[] model;
        if (OS.GTK_VERSION < OS.VERSION(2, 2, 0)) {
            return null;
        }
        int handle = this.table.handle;
        int selection = OS.gtk_tree_view_get_selection(handle);
        int list = OS.gtk_tree_selection_get_selected_rows(selection, model = OS.GTK_VERSION < OS.VERSION(2, 2, 4) ? new int[1] : null);
        if (list == 0) {
            return null;
        }
        int count = Math.min(10, OS.g_list_length(list));
        Image image = null;
        Display display = this.table.getDisplay();
        if (count == 1) {
            int path = OS.g_list_nth_data(list, 0);
            int pixmap = OS.gtk_tree_view_create_row_drag_icon(handle, path);
            image = Image.gtk_new(display, 1, pixmap, 0);
        } else {
            int width = 0;
            int height = 0;
            int[] w = new int[1];
            int[] h = new int[1];
            int[] yy = new int[count];
            int[] hh = new int[count];
            int[] pixmaps = new int[count];
            GdkRectangle rect = new GdkRectangle();
            int i = 0;
            while (i < count) {
                int path = OS.g_list_nth_data(list, i);
                OS.gtk_tree_view_get_cell_area(handle, path, 0, rect);
                pixmaps[i] = OS.gtk_tree_view_create_row_drag_icon(handle, path);
                OS.gdk_drawable_get_size(pixmaps[i], w, h);
                width = Math.max(width, w[0]);
                height = rect.y + h[0] - yy[0];
                yy[i] = rect.y;
                hh[i] = h[0];
                ++i;
            }
            int source = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, -1);
            int gcSource = OS.gdk_gc_new(source);
            int mask = OS.gdk_pixmap_new(OS.GDK_ROOT_PARENT(), width, height, 1);
            int gcMask = OS.gdk_gc_new(mask);
            GdkColor color = new GdkColor();
            color.pixel = 0;
            OS.gdk_gc_set_foreground(gcMask, color);
            OS.gdk_draw_rectangle(mask, gcMask, 1, 0, 0, width, height);
            color.pixel = 1;
            OS.gdk_gc_set_foreground(gcMask, color);
            int i2 = 0;
            while (i2 < count) {
                OS.gdk_draw_drawable(source, gcSource, pixmaps[i2], 0, 0, 0, yy[i2] - yy[0], -1, -1);
                OS.gdk_draw_rectangle(mask, gcMask, 1, 0, yy[i2] - yy[0], width, hh[i2]);
                OS.g_object_unref(pixmaps[i2]);
                ++i2;
            }
            OS.g_object_unref(gcSource);
            OS.g_object_unref(gcMask);
            image = Image.gtk_new(display, 1, source, mask);
        }
        OS.g_list_free(list);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    void showDropTargetEffect(int effect, int eventType, int x, int y) {
        int indices;
        effect = this.checkEffect(effect);
        int handle = this.table.handle;
        Point coordinates = new Point(x, y);
        coordinates = this.table.toControl(coordinates);
        int[] path = new int[1];
        OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
        int index = -1;
        if (path[0] != 0 && (indices = OS.gtk_tree_path_get_indices(path[0])) != 0) {
            int[] temp = new int[1];
            OS.memmove(temp, indices, 4);
            index = temp[0];
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollIndex = -1;
        } else if (index != -1 && this.scrollIndex == index && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                if (coordinates.y < this.table.getItemHeight()) {
                    OS.gtk_tree_path_prev(path[0]);
                } else {
                    OS.gtk_tree_path_next(path[0]);
                }
                if (path[0] != 0) {
                    OS.gtk_tree_view_scroll_to_cell(handle, path[0], 0, false, 0.0f, 0.0f);
                    OS.gtk_tree_path_free(path[0]);
                    path[0] = 0;
                    OS.gtk_tree_view_get_path_at_pos(handle, coordinates.x, coordinates.y, path, null, null, null);
                }
                this.scrollBeginTime = 0L;
                this.scrollIndex = -1;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollIndex = index;
        }
        if (path[0] != 0) {
            int position = 0;
            if ((effect & 1) != 0) {
                position = 2;
            }
            if (position != 0) {
                OS.gtk_tree_view_set_drag_dest_row(handle, path[0], 2);
            } else {
                OS.gtk_tree_view_unset_rows_drag_dest(handle);
            }
        } else {
            OS.gtk_tree_view_unset_rows_drag_dest(handle);
        }
        if (path[0] != 0) {
            OS.gtk_tree_path_free(path[0]);
        }
    }
}

