/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoAttribute;
import org.eclipse.swt.internal.gtk.PangoItem;
import org.eclipse.swt.internal.gtk.PangoLayoutLine;
import org.eclipse.swt.internal.gtk.PangoLayoutRun;
import org.eclipse.swt.internal.gtk.PangoLogAttr;
import org.eclipse.swt.internal.gtk.PangoRectangle;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int ascent;
    int descent;
    int[] segments;
    int[] tabs;
    StyleItem[] styles;
    int layout;
    int context;
    int attrList;
    int[] invalidOffsets;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final char ZWS = '\u200b';
    static final char ZWNBS = '\ufeff';

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.context = OS.gdk_pango_context_get();
        if (this.context == 0) {
            SWT.error(2);
        }
        OS.pango_context_set_language(this.context, OS.gtk_get_default_language());
        OS.pango_context_set_base_dir(this.context, 0);
        OS.gdk_pango_context_set_colormap(this.context, OS.gdk_colormap_get_system());
        this.layout = OS.pango_layout_new(this.context);
        if (this.layout == 0) {
            SWT.error(2);
        }
        OS.pango_layout_set_wrap(this.layout, 2);
        OS.pango_layout_set_tabs(this.layout, device.emptyTab);
        if (OS.GTK_VERSION >= OS.VERSION(2, 4, 0)) {
            OS.pango_layout_set_auto_dir(this.layout, false);
        }
        this.text = "";
        this.descent = -1;
        this.ascent = -1;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        char c;
        if (this.attrList != 0) {
            return;
        }
        String segmentsText = this.getSegmentsText();
        byte[] buffer = Converter.wcsToMbcs(null, segmentsText, false);
        OS.pango_layout_set_text(this.layout, buffer, buffer.length);
        if (this.styles.length == 2 && this.styles[0].style == null && this.ascent == -1 && this.descent == -1 && this.segments == null) {
            return;
        }
        int ptr = OS.pango_layout_get_text(this.layout);
        this.attrList = OS.pango_attr_list_new();
        PangoAttribute attribute = new PangoAttribute();
        char[] chars = null;
        int segementsLength = segmentsText.length();
        if ((this.ascent != -1 || this.descent != -1) && segementsLength > 0) {
            int iter = OS.pango_layout_get_iter(this.layout);
            if (iter == 0) {
                SWT.error(2);
            }
            PangoRectangle rect = new PangoRectangle();
            if (this.ascent != -1) {
                rect.y = -(this.ascent * 1024);
            }
            rect.height = (Math.max(0, this.ascent) + Math.max(0, this.descent)) * 1024;
            int lineCount = OS.pango_layout_get_line_count(this.layout);
            chars = new char[segementsLength + lineCount * 2];
            int oldPos = 0;
            int count = 0;
            do {
                int bytePos = OS.pango_layout_iter_get_index(iter);
                int offset = count * 6;
                int attr = OS.pango_attr_shape_new(rect, rect);
                OS.memmove(attribute, attr, PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset;
                attribute.end_index = bytePos + offset + 3;
                OS.memmove(attr, attribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                attr = OS.pango_attr_shape_new(rect, rect);
                OS.memmove(attribute, attr, PangoAttribute.sizeof);
                attribute.start_index = bytePos + offset + 3;
                attribute.end_index = bytePos + offset + 6;
                OS.memmove(attr, attribute, PangoAttribute.sizeof);
                OS.pango_attr_list_insert(this.attrList, attr);
                int pos = OS.g_utf8_pointer_to_offset(ptr, ptr + bytePos);
                chars[pos + count * 2] = 8203;
                chars[pos + count * 2 + 1] = 65279;
                segmentsText.getChars(oldPos, pos, chars, oldPos + count * 2);
                oldPos = pos;
                ++count;
            } while (OS.pango_layout_iter_next_line(iter));
            OS.pango_layout_iter_free(iter);
            segmentsText.getChars(oldPos, segementsLength, chars, oldPos + count * 2);
            buffer = Converter.wcsToMbcs(null, chars, false);
            OS.pango_layout_set_text(this.layout, buffer, buffer.length);
            ptr = OS.pango_layout_get_text(this.layout);
        } else {
            chars = new char[segementsLength];
            segmentsText.getChars(0, segementsLength, chars, 0);
        }
        int offsetCount = 0;
        int i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == '\u200e' || c == '\u200f' || c == '\ufeff' || c == '\u200b') {
                ++offsetCount;
            }
            ++i;
        }
        this.invalidOffsets = new int[offsetCount];
        offsetCount = 0;
        i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == '\u200e' || c == '\u200f' || c == '\ufeff' || c == '\u200b') {
                this.invalidOffsets[offsetCount++] = i;
            }
            ++i;
        }
        int strlen = OS.strlen(ptr);
        int i2 = 0;
        while (i2 < this.styles.length - 1) {
            StyleItem styleItem = this.styles[i2];
            TextStyle style = styleItem.style;
            if (style != null) {
                int rise;
                int attr;
                GlyphMetrics metrics;
                Color background;
                Color foreground;
                int attr2;
                int start = this.translateOffset(styleItem.start);
                int end = this.translateOffset(this.styles[i2 + 1].start - 1);
                int byteStart = OS.g_utf8_offset_to_pointer(ptr, start) - ptr;
                int byteEnd = OS.g_utf8_offset_to_pointer(ptr, end + 1) - ptr;
                byteStart = Math.min(byteStart, strlen);
                byteEnd = Math.min(byteEnd, strlen);
                Font font = style.font;
                if (font != null && !font.isDisposed()) {
                    attr2 = OS.pango_attr_font_desc_new(font.handle);
                    OS.memmove(attribute, attr2, PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr2, attribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr2);
                }
                if (style.underline) {
                    attr2 = OS.pango_attr_underline_new(1);
                    OS.memmove(attribute, attr2, PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr2, attribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr2);
                }
                if (style.strikeout) {
                    attr2 = OS.pango_attr_strikethrough_new(true);
                    OS.memmove(attribute, attr2, PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr2, attribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr2);
                }
                if ((foreground = style.foreground) != null && !foreground.isDisposed()) {
                    GdkColor fg = foreground.handle;
                    int attr3 = OS.pango_attr_foreground_new(fg.red, fg.green, fg.blue);
                    OS.memmove(attribute, attr3, PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr3, attribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr3);
                }
                if ((background = style.background) != null && !background.isDisposed()) {
                    GdkColor bg = background.handle;
                    int attr4 = OS.pango_attr_background_new(bg.red, bg.green, bg.blue);
                    OS.memmove(attribute, attr4, PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr4, attribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr4);
                }
                if ((metrics = style.metrics) != null) {
                    PangoRectangle rect = new PangoRectangle();
                    rect.y = -(metrics.ascent * 1024);
                    rect.height = (metrics.ascent + metrics.descent) * 1024;
                    rect.width = metrics.width * 1024;
                    attr = OS.pango_attr_shape_new(rect, rect);
                    OS.memmove(attribute, attr, PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr, attribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr);
                }
                if ((rise = style.rise) != 0) {
                    attr = OS.pango_attr_rise_new(rise * 1024);
                    OS.memmove(attribute, attr, PangoAttribute.sizeof);
                    attribute.start_index = byteStart;
                    attribute.end_index = byteEnd;
                    OS.memmove(attr, attribute, PangoAttribute.sizeof);
                    OS.pango_attr_list_insert(this.attrList, attr);
                }
            }
            ++i2;
        }
        OS.pango_layout_set_attributes(this.layout, this.attrList);
    }

    public void dispose() {
        if (this.layout == 0) {
            return;
        }
        this.font = null;
        this.text = null;
        this.styles = null;
        this.freeRuns();
        if (this.layout != 0) {
            OS.g_object_unref(this.layout);
        }
        this.layout = 0;
        if (this.context != 0) {
            OS.g_object_unref(this.context);
        }
        this.context = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        gc.checkGC(1);
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        GCData data = gc.data;
        int cairo = data.cairo;
        if (!hasSelection) {
            if (cairo != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                Cairo.cairo_move_to(cairo, x, y);
                OS.pango_cairo_show_layout(cairo, this.layout);
            } else {
                OS.gdk_draw_layout(data.drawable, gc.handle, x, y, this.layout);
            }
        } else {
            boolean fullSelection;
            selectionStart = Math.min(Math.max(0, selectionStart), length - 1);
            selectionEnd = Math.min(Math.max(0, selectionEnd), length - 1);
            length = OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1);
            selectionStart = this.translateOffset(selectionStart);
            selectionEnd = this.translateOffset(selectionEnd);
            if (selectionForeground == null) {
                selectionForeground = this.device.getSystemColor(27);
            }
            if (selectionBackground == null) {
                selectionBackground = this.device.getSystemColor(26);
            }
            boolean bl = fullSelection = selectionStart == 0 && selectionEnd == length - 1;
            if (fullSelection) {
                if (cairo != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    int ptr = OS.pango_layout_get_text(this.layout);
                    this.drawWithCairo(cairo, x, y, 0, OS.strlen(ptr), fullSelection, selectionBackground.handle, selectionForeground.handle);
                } else {
                    OS.gdk_draw_layout_with_colors(data.drawable, gc.handle, x, y, this.layout, selectionForeground.handle, selectionBackground.handle);
                }
            } else {
                int ptr = OS.pango_layout_get_text(this.layout);
                int byteSelStart = OS.g_utf8_offset_to_pointer(ptr, selectionStart) - ptr;
                int byteSelEnd = OS.g_utf8_offset_to_pointer(ptr, selectionEnd + 1) - ptr;
                int strlen = OS.strlen(ptr);
                byteSelStart = Math.min(byteSelStart, strlen);
                byteSelEnd = Math.min(byteSelEnd, strlen);
                if (cairo != 0 && OS.GTK_VERSION >= OS.VERSION(2, 8, 0)) {
                    this.drawWithCairo(cairo, x, y, byteSelStart, byteSelEnd, fullSelection, selectionBackground.handle, selectionForeground.handle);
                } else {
                    Region clipping = new Region();
                    gc.getClipping(clipping);
                    OS.gdk_draw_layout(data.drawable, gc.handle, x, y, this.layout);
                    int[] ranges = new int[]{byteSelStart, byteSelEnd};
                    int rgn = OS.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges, ranges.length / 2);
                    if (rgn != 0) {
                        OS.gdk_gc_set_clip_region(gc.handle, rgn);
                        OS.gdk_region_destroy(rgn);
                    }
                    OS.gdk_draw_layout_with_colors(data.drawable, gc.handle, x, y, this.layout, selectionForeground.handle, selectionBackground.handle);
                    gc.setClipping(clipping);
                    clipping.dispose();
                }
            }
        }
    }

    void drawWithCairo(int cairo, int x, int y, int byteSelStart, int byteSelEnd, boolean fullSelection, GdkColor selectionBackground, GdkColor selectionForeground) {
        int[] ranges;
        int rgn;
        Cairo.cairo_save(cairo);
        if (!fullSelection) {
            Cairo.cairo_move_to(cairo, x, y);
            OS.pango_cairo_show_layout(cairo, this.layout);
        }
        if ((rgn = OS.gdk_pango_layout_get_clip_region(this.layout, x, y, ranges = new int[]{byteSelStart, byteSelEnd}, ranges.length / 2)) != 0) {
            OS.gdk_cairo_region(cairo, rgn);
            Cairo.cairo_clip(cairo);
            OS.gdk_cairo_set_source_color(cairo, selectionBackground);
            Cairo.cairo_paint(cairo);
            OS.gdk_region_destroy(rgn);
        }
        OS.gdk_cairo_set_source_color(cairo, selectionForeground);
        Cairo.cairo_move_to(cairo, x, y);
        OS.pango_cairo_show_layout(cairo, this.layout);
        Cairo.cairo_restore(cairo);
    }

    void freeRuns() {
        if (this.attrList == 0) {
            return;
        }
        OS.pango_layout_set_attributes(this.layout, 0);
        OS.pango_attr_list_unref(this.attrList);
        this.attrList = 0;
        this.invalidOffsets = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int align = OS.pango_layout_get_alignment(this.layout);
        switch (align) {
            case 1: {
                return 0x1000000;
            }
            case 2: {
                return 131072;
            }
        }
        return 16384;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int[] w = new int[1];
        int[] h = new int[1];
        OS.pango_layout_get_size(this.layout, w, h);
        int wrapWidth = OS.pango_layout_get_width(this.layout);
        int width = OS.PANGO_PIXELS(wrapWidth != -1 ? wrapWidth : w[0]);
        int height = OS.PANGO_PIXELS(h[0]);
        if (this.ascent != -1 && this.descent != -1) {
            height = Math.max(height, this.ascent + this.descent);
        }
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getBounds(int start, int end) {
        int linesRegion;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        int ptr = OS.pango_layout_get_text(this.layout);
        int byteStart = OS.g_utf8_offset_to_pointer(ptr, start) - ptr;
        int byteEnd = OS.g_utf8_offset_to_pointer(ptr, end + 1) - ptr;
        int strlen = OS.strlen(ptr);
        int[] ranges = new int[]{byteStart = Math.min(byteStart, strlen), byteEnd = Math.min(byteEnd, strlen)};
        int clipRegion = OS.gdk_pango_layout_get_clip_region(this.layout, 0, 0, ranges, 1);
        if (clipRegion == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        GdkRectangle rect = new GdkRectangle();
        PangoRectangle pangoRect = new PangoRectangle();
        int iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        if ((linesRegion = OS.gdk_region_new()) == 0) {
            SWT.error(2);
        }
        int lineEnd = 0;
        do {
            OS.pango_layout_iter_get_line_extents(iter, null, pangoRect);
            lineEnd = OS.pango_layout_iter_next_line(iter) ? OS.pango_layout_iter_get_index(iter) - 1 : strlen;
            if (byteStart > lineEnd) continue;
            rect.x = OS.PANGO_PIXELS(pangoRect.x);
            rect.y = OS.PANGO_PIXELS(pangoRect.y);
            rect.width = OS.PANGO_PIXELS(pangoRect.width);
            rect.height = OS.PANGO_PIXELS(pangoRect.height);
            OS.gdk_region_union_with_rect(linesRegion, rect);
        } while (lineEnd + 1 <= byteEnd);
        OS.gdk_region_intersect(clipRegion, linesRegion);
        OS.gdk_region_destroy(linesRegion);
        OS.pango_layout_iter_free(iter);
        OS.gdk_region_get_clipbox(clipRegion, rect);
        OS.gdk_region_destroy(clipRegion);
        return new Rectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_indent(this.layout));
    }

    public boolean getJustify() {
        this.checkLayout();
        return OS.pango_layout_get_justify(this.layout);
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        int level = 0;
        PangoItem item = new PangoItem();
        PangoLayoutRun run = new PangoLayoutRun();
        int ptr = OS.pango_layout_get_text(this.layout);
        int byteOffset = OS.g_utf8_offset_to_pointer(ptr, offset) - ptr;
        int strlen = OS.strlen(ptr);
        byteOffset = Math.min(byteOffset, strlen);
        do {
            int runPtr;
            if ((runPtr = OS.pango_layout_iter_get_run(iter)) == 0) continue;
            OS.memmove(run, runPtr, PangoLayoutRun.sizeof);
            OS.memmove(item, run.item, PangoItem.sizeof);
            if (item.offset > byteOffset || byteOffset >= item.offset + item.length) continue;
            level = item.analysis_level;
            break;
        } while (OS.pango_layout_iter_next_run(iter));
        OS.pango_layout_iter_free(iter);
        return level;
    }

    public Rectangle getLineBounds(int lineIndex) {
        int iter;
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        if ((iter = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        int i = 0;
        while (i < lineIndex) {
            OS.pango_layout_iter_next_line(iter);
            ++i;
        }
        PangoRectangle rect = new PangoRectangle();
        OS.pango_layout_iter_get_line_extents(iter, null, rect);
        OS.pango_layout_iter_free(iter);
        int x = OS.PANGO_PIXELS(rect.x);
        int y = OS.PANGO_PIXELS(rect.y);
        int width = OS.PANGO_PIXELS(rect.width);
        int height = OS.PANGO_PIXELS(rect.height);
        if (this.ascent != -1 && this.descent != -1) {
            height = Math.max(height, this.ascent + this.descent);
        }
        return new Rectangle(x, y, width, height);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return OS.pango_layout_get_line_count(this.layout);
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(5);
        }
        offset = this.translateOffset(offset);
        int line = 0;
        int ptr = OS.pango_layout_get_text(this.layout);
        int byteOffset = OS.g_utf8_offset_to_pointer(ptr, offset) - ptr;
        int strlen = OS.strlen(ptr);
        byteOffset = Math.min(byteOffset, strlen);
        int iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        while (OS.pango_layout_iter_next_line(iter)) {
            if (OS.pango_layout_iter_get_index(iter) > byteOffset) break;
            ++line;
        }
        OS.pango_layout_iter_free(iter);
        return line;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        int ascent = 0;
        int descent = 0;
        PangoLayoutLine line = new PangoLayoutLine();
        OS.memmove(line, OS.pango_layout_get_line(this.layout, lineIndex), PangoLayoutLine.sizeof);
        if (line.runs == 0) {
            int font = this.font != null ? this.font.handle : this.device.systemFont.handle;
            int lang = OS.pango_context_get_language(this.context);
            int metrics = OS.pango_context_get_metrics(this.context, font, lang);
            ascent = OS.pango_font_metrics_get_ascent(metrics);
            descent = OS.pango_font_metrics_get_descent(metrics);
            OS.pango_font_metrics_unref(metrics);
        } else {
            PangoRectangle rect = new PangoRectangle();
            OS.pango_layout_line_get_extents(OS.pango_layout_get_line(this.layout, lineIndex), null, rect);
            ascent = -rect.y;
            descent = rect.height - ascent;
        }
        ascent = Math.max(this.ascent, OS.PANGO_PIXELS(ascent));
        descent = Math.max(this.descent, OS.PANGO_PIXELS(descent));
        return FontMetrics.gtk_new(ascent, descent, 0, 0, ascent + descent);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int lineCount = OS.pango_layout_get_line_count(this.layout);
        int[] offsets = new int[lineCount + 1];
        int ptr = OS.pango_layout_get_text(this.layout);
        int iter = OS.pango_layout_get_iter(this.layout);
        if (iter == 0) {
            SWT.error(2);
        }
        int i = 0;
        do {
            int bytePos = OS.pango_layout_iter_get_index(iter);
            int pos = OS.g_utf8_pointer_to_offset(ptr, ptr + bytePos);
            offsets[i++] = this.untranslateOffset(pos);
        } while (OS.pango_layout_iter_next_line(iter));
        OS.pango_layout_iter_free(iter);
        offsets[lineCount] = this.text.length();
        return offsets;
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int ptr = OS.pango_layout_get_text(this.layout);
        int byteOffset = OS.g_utf8_offset_to_pointer(ptr, offset) - ptr;
        int strlen = OS.strlen(ptr);
        byteOffset = Math.min(byteOffset, strlen);
        PangoRectangle pos = new PangoRectangle();
        OS.pango_layout_index_to_pos(this.layout, byteOffset, pos);
        int x = trailing ? pos.x + pos.width : pos.x;
        int y = pos.y;
        return new Point(OS.PANGO_PIXELS(x), OS.PANGO_PIXELS(y));
    }

    public int getNextOffset(int offset, int movement) {
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int step;
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (forward) {
            if (offset == length) {
                return length;
            }
        } else if (offset == 0) {
            return 0;
        }
        int n = step = forward ? 1 : -1;
        if ((movement & 1) != 0) {
            return offset + step;
        }
        int[] attrs = new int[1];
        int[] nAttrs = new int[1];
        OS.pango_layout_get_log_attrs(this.layout, attrs, nAttrs);
        if (attrs[0] == 0) {
            return offset + step;
        }
        length = OS.g_utf8_strlen(OS.pango_layout_get_text(this.layout), -1);
        offset = this.translateOffset(offset);
        PangoLogAttr logAttr = new PangoLogAttr();
        offset = this.validateOffset(offset, step);
        while (offset > 0 && offset < length) {
            OS.memmove(logAttr, attrs[0] + offset * PangoLogAttr.sizeof, PangoLogAttr.sizeof);
            if ((movement & 2) != 0 && logAttr.is_cursor_position || (movement & 4) != 0 && (forward ? logAttr.is_word_end : logAttr.is_word_start)) break;
            offset = this.validateOffset(offset, step);
        }
        OS.g_free(attrs[0]);
        return Math.min(Math.max(0, this.untranslateOffset(offset)), this.text.length());
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int iter;
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        if ((iter = OS.pango_layout_get_iter(this.layout)) == 0) {
            SWT.error(2);
        }
        PangoRectangle rect = new PangoRectangle();
        do {
            OS.pango_layout_iter_get_line_extents(iter, null, rect);
            rect.y = OS.PANGO_PIXELS(rect.y);
            rect.height = OS.PANGO_PIXELS(rect.height);
            if (rect.y > y || y >= rect.y + rect.height) continue;
            rect.x = OS.PANGO_PIXELS(rect.x);
            rect.width = OS.PANGO_PIXELS(rect.width);
            if (x >= rect.x + rect.width) {
                x = rect.x + rect.width - 1;
            }
            if (x >= rect.x) break;
            x = rect.x;
            break;
        } while (OS.pango_layout_iter_next_line(iter));
        OS.pango_layout_iter_free(iter);
        int[] index = new int[1];
        int[] piTrailing = new int[1];
        OS.pango_layout_xy_to_index(this.layout, x * 1024, y * 1024, index, piTrailing);
        int ptr = OS.pango_layout_get_text(this.layout);
        int offset = OS.g_utf8_pointer_to_offset(ptr, ptr + index[0]);
        if (trailing != null) {
            trailing[0] = piTrailing[0];
        }
        return this.untranslateOffset(offset);
    }

    public int getOrientation() {
        this.checkLayout();
        int baseDir = OS.pango_context_get_base_dir(this.context);
        return baseDir == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int index, int movement) {
        return this._getOffset(index, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        int i = 0;
        while (i < this.styles.length - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int nSegments = this.segments.length;
        if (nSegments <= 1) {
            return this.text;
        }
        int length = this.text.length();
        if (length == 0) {
            return this.text;
        }
        if (nSegments == 2 && this.segments[0] == 0 && this.segments[1] == length) {
            return this.text;
        }
        char[] oldChars = new char[length];
        this.text.getChars(0, length, oldChars, 0);
        char[] newChars = new char[length + nSegments];
        int charCount = 0;
        int segmentCount = 0;
        int separator = this.getOrientation() == 0x4000000 ? 8207 : 8206;
        while (charCount < length) {
            if (segmentCount < nSegments && charCount == this.segments[segmentCount]) {
                newChars[charCount + segmentCount++] = separator;
                continue;
            }
            newChars[charCount + segmentCount] = oldChars[charCount++];
        }
        if (segmentCount < nSegments) {
            this.segments[segmentCount] = charCount;
            newChars[charCount + segmentCount++] = separator;
        }
        return new String(newChars, 0, Math.min(charCount + segmentCount, newChars.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return OS.PANGO_PIXELS(OS.pango_layout_get_spacing(this.layout));
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            StyleItem item = this.styles[i];
            if (item.start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        int width = OS.pango_layout_get_width(this.layout);
        return width != -1 ? OS.PANGO_PIXELS(width) : -1;
    }

    public boolean isDisposed() {
        return this.layout == 0;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        int align = 0;
        switch (alignment) {
            case 0x1000000: {
                align = 1;
                break;
            }
            case 131072: {
                align = 2;
            }
        }
        OS.pango_layout_set_alignment(this.layout, align);
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.font = font;
        OS.pango_layout_set_font_description(this.layout, font != null ? font.handle : 0);
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        OS.pango_layout_set_indent(this.layout, indent * 1024);
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        OS.pango_layout_set_justify(this.layout, justify);
    }

    public void setOrientation(int orientation) {
        int baseDir;
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        int n = baseDir = orientation == 0x4000000 ? 1 : 0;
        if (OS.pango_context_get_base_dir(this.context) == baseDir) {
            return;
        }
        OS.pango_context_set_base_dir(this.context, baseDir);
        OS.pango_layout_context_changed(this.layout);
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        OS.pango_layout_set_spacing(this.layout, spacing * 1024);
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        if (start > 0 && TextLayout.isAlef(this.text.charAt(start)) && TextLayout.isLam(this.text.charAt(start - 1))) {
            --start;
        }
        if (end < length - 1 && TextLayout.isLam(this.text.charAt(end)) && TextLayout.isAlef(this.text.charAt(end + 1))) {
            ++end;
        }
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.styles.length) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.styles.length) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                newStyles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                newStyles[modifyStart + 2] = item;
                System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                this.styles = newStyles;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
        StyleItem[] newStyles = new StyleItem[newLength];
        System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        newStyles[modifyStart + 1] = item;
        this.styles[modifyEnd].start = end + 1;
        System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
        this.styles = newStyles;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.tabs = tabs;
        if (tabs == null) {
            OS.pango_layout_set_tabs(this.layout, this.device.emptyTab);
        } else {
            int tabArray = OS.pango_tab_array_new(tabs.length, true);
            if (tabArray != 0) {
                int i = 0;
                while (i < tabs.length) {
                    OS.pango_tab_array_set_tab(tabArray, i, 0, tabs[i]);
                    ++i;
                }
                OS.pango_layout_set_tabs(this.layout, tabArray);
                OS.pango_tab_array_free(tabArray);
            }
        }
        OS.pango_layout_context_changed(this.layout);
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[this.styles.length - 1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        this.freeRuns();
        OS.pango_layout_set_width(this.layout, width == -1 ? -1 : width * 1024);
    }

    static final boolean isLam(int ch) {
        return ch == 1604;
    }

    static final boolean isAlef(int ch) {
        switch (ch) {
            case 1570: 
            case 1571: 
            case 1573: 
            case 1575: 
            case 1609: 
            case 1648: 
            case 1649: 
            case 1650: 
            case 1651: 
            case 1653: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length) {
            if (offset < this.invalidOffsets[i]) break;
            ++offset;
            ++i;
        }
        return offset;
    }

    int untranslateOffset(int offset) {
        int length = this.text.length();
        if (length == 0) {
            return offset;
        }
        if (this.invalidOffsets == null) {
            return offset;
        }
        int i = 0;
        while (i < this.invalidOffsets.length) {
            if (offset == this.invalidOffsets[i]) {
                ++offset;
            } else if (offset < this.invalidOffsets[i]) {
                return offset - i;
            }
            ++i;
        }
        return offset - this.invalidOffsets.length;
    }

    int validateOffset(int offset, int step) {
        if (this.invalidOffsets == null) {
            return offset + step;
        }
        int i = step > 0 ? 0 : this.invalidOffsets.length - 1;
        block0: do {
            offset += step;
            while (i >= 0 && i < this.invalidOffsets.length) {
                if (this.invalidOffsets[i] == offset) continue block0;
                i += step;
            }
        } while (i >= 0 && i < this.invalidOffsets.length);
        return offset;
    }

    static class StyleItem {
        TextStyle style;
        int start;

        StyleItem() {
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

