/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.GtkCellRendererClass;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.GtkWidgetClass;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.XButtonEvent;
import org.eclipse.swt.internal.gtk.XEvent;
import org.eclipse.swt.internal.gtk.XExposeEvent;
import org.eclipse.swt.internal.gtk.XVisibilityEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    int gdkEventCount;
    int[] gdkEvents;
    Widget[] gdkEventWidgets;
    int[] dispatchEvents;
    Event[] eventQueue;
    int fds;
    int allocated_nfds;
    boolean wake;
    int[] max_priority = new int[1];
    int[] timeout = new int[1];
    Callback eventCallback;
    Callback filterCallback;
    int eventProc;
    int filterProc;
    int windowProc2;
    int windowProc3;
    int windowProc4;
    int windowProc5;
    Callback windowCallback2;
    Callback windowCallback3;
    Callback windowCallback4;
    Callback windowCallback5;
    EventTable eventTable;
    EventTable filterTable;
    static String APP_NAME = "SWT";
    static final String DISPATCH_EVENT_KEY = "org.eclipse.swt.internal.gtk.dispatchEvent";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    int[] closures;
    int[] signalIds;
    int shellMapProcClosure;
    int freeSlot;
    int[] indexTable;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final int SWT_OBJECT_INDEX1;
    static final int SWT_OBJECT_INDEX2;
    int focusEvent;
    Control focusControl;
    Shell activeShell;
    boolean activePending;
    Control imControl;
    int preeditWindow;
    int preeditLabel;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Tray tray;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    Caret currentCaret;
    Callback caretCallback;
    int caretId;
    int caretProc;
    Control mnemonicControl;
    int mouseHoverId;
    int mouseHoverHandle;
    int mouseHoverProc;
    Callback mouseHoverCallback;
    int menuPositionProc;
    Callback menuPositionCallback;
    int sizeAllocateProc;
    Callback sizeAllocateCallback;
    int shellMapProc;
    Callback shellMapCallback;
    int idleProc;
    Callback idleCallback;
    static final String IDLE_PROC_KEY = "org.eclipse.swt.internal.gtk2.idleProc";
    int[] treeSelection;
    int treeSelectionLength;
    int treeSelectionProc;
    Callback treeSelectionCallback;
    int cellDataProc;
    Callback cellDataCallback;
    int setDirectionProc;
    Callback setDirectionCallback;
    int styleSetProc;
    Callback styleSetCallback;
    int shellHandle;
    boolean settingsChanged;
    boolean runSettings;
    boolean entrySelectOnFocus;
    int checkIfEventProc;
    Callback checkIfEventCallback;
    int flushWindow;
    boolean flushAll;
    GdkRectangle flushRect = new GdkRectangle();
    XExposeEvent exposeEvent = new XExposeEvent();
    XVisibilityEvent visibilityEvent = new XVisibilityEvent();
    int[] flushData = new int[1];
    int dragStartX;
    int dragStartY;
    boolean dragging;
    boolean dragOverride;
    Font systemFont;
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningImage;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    GdkColor COLOR_WIDGET_DARK_SHADOW;
    GdkColor COLOR_WIDGET_NORMAL_SHADOW;
    GdkColor COLOR_WIDGET_LIGHT_SHADOW;
    GdkColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    GdkColor COLOR_WIDGET_BACKGROUND;
    GdkColor COLOR_WIDGET_FOREGROUND;
    GdkColor COLOR_WIDGET_BORDER;
    GdkColor COLOR_LIST_FOREGROUND;
    GdkColor COLOR_LIST_BACKGROUND;
    GdkColor COLOR_LIST_SELECTION;
    GdkColor COLOR_LIST_SELECTION_TEXT;
    GdkColor COLOR_INFO_BACKGROUND;
    GdkColor COLOR_INFO_FOREGROUND;
    GdkColor COLOR_TITLE_FOREGROUND;
    GdkColor COLOR_TITLE_BACKGROUND;
    GdkColor COLOR_TITLE_BACKGROUND_GRADIENT;
    GdkColor COLOR_TITLE_INACTIVE_FOREGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND;
    GdkColor COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
    Menu[] popups;
    int clickCount = 1;
    int lastEventTime;
    int lastUserEventTime;
    static int fixed_type;
    static int fixed_info_ptr;
    static Callback fixedClassInitCallback;
    static Callback fixedMapCallback;
    static int fixedClassInitProc;
    static int fixedMapProc;
    static int text_renderer_type;
    static int pixbuf_renderer_type;
    static int toggle_renderer_type;
    static int text_renderer_info_ptr;
    static int pixbuf_renderer_info_ptr;
    static int toggle_renderer_info_ptr;
    static Callback rendererClassInitCallback;
    static Callback rendererRenderCallback;
    static Callback rendererGetSizeCallback;
    static int rendererClassInitProc;
    static int rendererRenderProc;
    static int rendererGetSizeProc;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    static final Class OS_LOCK;
    static final int MAJOR = 2;
    static final int MINOR = 0;
    static final int MICRO = 6;
    Object data;
    String[] keys;
    Object[] values;
    int borderTrimWidth = 4;
    int borderTrimHeight = 4;
    int resizeTrimWidth = 6;
    int resizeTrimHeight = 6;
    int titleBorderTrimWidth = 5;
    int titleBorderTrimHeight = 28;
    int titleResizeTrimWidth = 6;
    int titleResizeTrimHeight = 29;
    int titleTrimWidth = 0;
    int titleTrimHeight = 23;
    boolean ignoreTrim;
    String windowManager;

    static {
        byte[] buffer = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX", true);
        SWT_OBJECT_INDEX = OS.g_quark_from_string(buffer);
        buffer = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX1", true);
        SWT_OBJECT_INDEX1 = OS.g_quark_from_string(buffer);
        buffer = Converter.wcsToMbcs(null, "SWT_OBJECT_INDEX2", true);
        SWT_OBJECT_INDEX2 = OS.g_quark_from_string(buffer);
        KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
        Displays = new Display[4];
        Class<?> lock = null;
        try {
            lock = Class.forName("org.eclipse.swt.internal.gtk.OS");
        }
        catch (Throwable throwable) {}
        OS_LOCK = lock;
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addGdkEvent(int event) {
        int length;
        if (this.gdkEvents == null) {
            length = 1024;
            this.gdkEvents = new int[length];
            this.gdkEventWidgets = new Widget[length];
            this.gdkEventCount = 0;
        }
        if (this.gdkEventCount == this.gdkEvents.length) {
            length = this.gdkEventCount + 1024;
            int[] newEvents = new int[length];
            System.arraycopy(this.gdkEvents, 0, newEvents, 0, this.gdkEventCount);
            this.gdkEvents = newEvents;
            Widget[] newWidgets = new Widget[length];
            System.arraycopy(this.gdkEventWidgets, 0, newWidgets, 0, this.gdkEventCount);
            this.gdkEventWidgets = newWidgets;
        }
        Widget widget = null;
        int handle = OS.gtk_get_event_widget(event);
        if (handle != 0) {
            while ((widget = this.getWidget(handle)) == null && (handle = OS.gtk_widget_get_parent(handle)) != 0) {
            }
        }
        this.gdkEvents[this.gdkEventCount] = event;
        this.gdkEventWidgets[this.gdkEventCount] = widget;
        ++this.gdkEventCount;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addMouseHoverTimeout(int handle) {
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove(this.mouseHoverId);
        }
        this.mouseHoverId = OS.gtk_timeout_add(400, this.mouseHoverProc, handle);
        this.mouseHoverHandle = handle;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addWidget(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        int index = this.freeSlot + 1;
        OS.g_object_set_qdata(handle, SWT_OBJECT_INDEX, index);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        this.widgetTable[oldSlot] = widget;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        if (!this.isValidThread()) {
            this.error(22);
        }
        OS.gdk_beep();
        if (!OS.GDK_WINDOWING_X11()) {
            OS.gdk_flush();
        } else {
            int xDisplay = OS.GDK_DISPLAY();
            OS.XFlush(xDisplay);
        }
    }

    int cellDataProc(int tree_column, int cell, int tree_model, int iter, int data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.cellDataProc(tree_column, cell, tree_model, iter, data);
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread, boolean multiple) {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] != null) {
                if (!multiple) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[i].thread == thread) {
                    SWT.error(22);
                }
            }
            ++i;
        }
    }

    int checkIfEventProc(int display, int xEvent, int userData) {
        int type = OS.X_EVENT_TYPE(xEvent);
        switch (type) {
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            default: {
                return 0;
            }
        }
        int window = OS.gdk_window_lookup(OS.X_EVENT_WINDOW(xEvent));
        if (window == 0) {
            return 0;
        }
        if (this.flushWindow != 0) {
            if (this.flushAll) {
                int tempWindow = window;
                while (tempWindow != this.flushWindow && (tempWindow = OS.gdk_window_get_parent(tempWindow)) != 0) {
                }
                if (tempWindow != this.flushWindow) {
                    return 0;
                }
            } else if (window != this.flushWindow) {
                return 0;
            }
        }
        OS.memmove(this.exposeEvent, xEvent, XExposeEvent.sizeof);
        switch (type) {
            case 12: 
            case 13: {
                this.flushRect.x = this.exposeEvent.x;
                this.flushRect.y = this.exposeEvent.y;
                this.flushRect.width = this.exposeEvent.width;
                this.flushRect.height = this.exposeEvent.height;
                OS.gdk_window_invalidate_rect(window, this.flushRect, true);
                this.exposeEvent.type = -1;
                OS.memmove(xEvent, this.exposeEvent, XExposeEvent.sizeof);
                break;
            }
            case 15: {
                Control control;
                Widget widget;
                OS.memmove(this.visibilityEvent, xEvent, XVisibilityEvent.sizeof);
                OS.gdk_window_get_user_data(window, this.flushData);
                int handle = this.flushData[0];
                Widget widget2 = widget = handle != 0 ? this.getWidget(handle) : null;
                if (widget == null || !(widget instanceof Control) || window != (control = (Control)widget).paintWindow()) break;
                if (this.visibilityEvent.state == 2) {
                    control.state |= 0x40;
                    break;
                }
                control.state &= 0xFFFFFFBF;
            }
        }
        return 0;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(data);
        this.register();
        if (Default == null) {
            Default = this;
        }
    }

    synchronized void createDisplay(DeviceData data) {
        byte[] type_name;
        int ptr;
        if (!OS.g_thread_supported()) {
            OS.g_thread_init(0);
        }
        OS.gtk_set_locale();
        if (!OS.gtk_init_check(new int[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
        if (OS.GDK_WINDOWING_X11()) {
            this.xDisplay = OS.GDK_DISPLAY();
        }
        if ((ptr = OS.gtk_check_version(2, 0, 6)) != 0) {
            int length = OS.strlen(ptr);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, ptr, length);
            System.out.println("***WARNING: " + new String(Converter.mbcsToWcs(null, buffer)));
            System.out.println("***WARNING: SWT requires GTK 2.0.6");
            int major = OS.gtk_major_version();
            int minor = OS.gtk_minor_version();
            int micro = OS.gtk_micro_version();
            System.out.println("***WARNING: Detected: " + major + "." + minor + "." + micro);
        }
        if (fixed_type == 0) {
            byte[] type_name2 = Converter.wcsToMbcs(null, "SwtFixed", true);
            fixedClassInitCallback = new Callback(this.getClass(), "fixedClassInitProc", 2);
            fixedClassInitProc = fixedClassInitCallback.getAddress();
            if (fixedClassInitProc == 0) {
                SWT.error(3);
            }
            if ((fixedMapProc = (fixedMapCallback = new Callback(this.getClass(), "fixedMapProc", 1)).getAddress()) == 0) {
                SWT.error(3);
            }
            GTypeInfo fixed_info = new GTypeInfo();
            fixed_info.class_size = (short)OS.GtkFixedClass_sizeof();
            fixed_info.class_init = fixedClassInitProc;
            fixed_info.instance_size = (short)OS.GtkFixed_sizeof();
            fixed_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(fixed_info_ptr, fixed_info, GTypeInfo.sizeof);
            fixed_type = OS.g_type_register_static(OS.GTK_TYPE_FIXED(), type_name2, fixed_info_ptr, 0);
        }
        if (rendererClassInitProc == 0 && (rendererClassInitProc = (rendererClassInitCallback = new Callback(this.getClass(), "rendererClassInitProc", 2)).getAddress()) == 0) {
            SWT.error(3);
        }
        if (rendererRenderProc == 0 && (rendererRenderProc = (rendererRenderCallback = new Callback(this.getClass(), "rendererRenderProc", 7)).getAddress()) == 0) {
            SWT.error(3);
        }
        if (rendererGetSizeProc == 0 && (rendererGetSizeProc = (rendererGetSizeCallback = new Callback(this.getClass(), "rendererGetSizeProc", 7)).getAddress()) == 0) {
            SWT.error(3);
        }
        if (text_renderer_type == 0) {
            GTypeInfo renderer_info = new GTypeInfo();
            renderer_info.class_size = (short)OS.GtkCellRendererTextClass_sizeof();
            renderer_info.class_init = rendererClassInitProc;
            renderer_info.instance_size = (short)OS.GtkCellRendererText_sizeof();
            text_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(text_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
            type_name = Converter.wcsToMbcs(null, "SwtTextRenderer", true);
            text_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TEXT(), type_name, text_renderer_info_ptr, 0);
        }
        if (pixbuf_renderer_type == 0) {
            GTypeInfo renderer_info = new GTypeInfo();
            renderer_info.class_size = (short)OS.GtkCellRendererPixbufClass_sizeof();
            renderer_info.class_init = rendererClassInitProc;
            renderer_info.instance_size = (short)OS.GtkCellRendererPixbuf_sizeof();
            pixbuf_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(pixbuf_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
            type_name = Converter.wcsToMbcs(null, "SwtPixbufRenderer", true);
            pixbuf_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_PIXBUF(), type_name, pixbuf_renderer_info_ptr, 0);
        }
        if (toggle_renderer_type == 0) {
            GTypeInfo renderer_info = new GTypeInfo();
            renderer_info.class_size = (short)OS.GtkCellRendererToggleClass_sizeof();
            renderer_info.class_init = rendererClassInitProc;
            renderer_info.instance_size = (short)OS.GtkCellRendererToggle_sizeof();
            toggle_renderer_info_ptr = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(toggle_renderer_info_ptr, renderer_info, GTypeInfo.sizeof);
            type_name = Converter.wcsToMbcs(null, "SwtToggleRenderer", true);
            toggle_renderer_type = OS.g_type_register_static(OS.GTK_TYPE_CELL_RENDERER_TOGGLE(), type_name, toggle_renderer_info_ptr, 0);
        }
        OS.gtk_widget_set_default_direction(1);
        OS.gdk_rgb_init();
        byte[] buffer = Converter.wcsToMbcs(null, APP_NAME, true);
        OS.g_set_prgname(buffer);
        OS.gdk_set_program_class(buffer);
        byte[] flatStyle = Converter.wcsToMbcs(null, "style \"swt-flat\" { GtkToolbar::shadow-type = none } widget \"*.swt-toolbar-flat\" style : highest \"swt-flat\"", true);
        OS.gtk_rc_parse_string(flatStyle);
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0) {
            SWT.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        this.eventCallback = new Callback(this, "eventProc", 2);
        this.eventProc = this.eventCallback.getAddress();
        if (this.eventProc == 0) {
            SWT.error(3);
        }
        OS.gdk_event_handler_set(this.eventProc, 0, 0);
        this.filterCallback = new Callback(this, "filterProc", 3);
        this.filterProc = this.filterCallback.getAddress();
        if (this.filterProc == 0) {
            this.error(3);
        }
        OS.gdk_window_add_filter(0, this.filterProc, 0);
    }

    Image createImage(String name) {
        int style = OS.gtk_widget_get_default_style();
        byte[] buffer = Converter.wcsToMbcs(null, name, true);
        int pixbuf = OS.gtk_icon_set_render_icon(OS.gtk_icon_factory_lookup_default(buffer), style, 0, 0, 6, 0, 0);
        if (pixbuf == 0) {
            return null;
        }
        int width = OS.gdk_pixbuf_get_width(pixbuf);
        int height = OS.gdk_pixbuf_get_height(pixbuf);
        int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
        boolean hasAlpha = OS.gdk_pixbuf_get_has_alpha(pixbuf);
        int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
        byte[] data = new byte[stride * height];
        OS.memmove(data, pixels, data.length);
        OS.g_object_unref(pixbuf);
        ImageData imageData = null;
        if (hasAlpha) {
            PaletteData palette = new PaletteData(-16777216, 0xFF0000, 65280);
            imageData = new ImageData(width, height, 32, palette);
            byte[] alpha = new byte[stride * height];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    alpha[y * width + x] = data[y * stride + x * 4 + 3];
                    data[y * stride + x * 4 + 3] = 0;
                    ++x;
                }
                ++y;
            }
            imageData.setAlphas(0, 0, width * height, alpha, 0);
        } else {
            PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
            imageData = new ImageData(width, height, 24, palette);
        }
        imageData.data = data;
        imageData.bytesPerLine = stride;
        return new Image((Device)this, imageData);
    }

    static int createPixbuf(Image image) {
        int pixbuf;
        boolean hasMask;
        int[] w = new int[1];
        int[] h = new int[1];
        OS.gdk_drawable_get_size(image.pixmap, w, h);
        int colormap = OS.gdk_colormap_get_system();
        boolean bl = hasMask = image.mask != 0 && OS.gdk_drawable_get_depth(image.mask) == 1;
        if (hasMask) {
            pixbuf = OS.gdk_pixbuf_new(0, true, 8, w[0], h[0]);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
            int maskPixbuf = OS.gdk_pixbuf_new(0, false, 8, w[0], h[0]);
            if (maskPixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(maskPixbuf, image.mask, 0, 0, 0, 0, 0, w[0], h[0]);
            int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
            int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
            byte[] line = new byte[stride];
            int maskStride = OS.gdk_pixbuf_get_rowstride(maskPixbuf);
            int maskPixels = OS.gdk_pixbuf_get_pixels(maskPixbuf);
            byte[] maskLine = new byte[maskStride];
            int y = 0;
            while (y < h[0]) {
                int offset = pixels + y * stride;
                OS.memmove(line, offset, stride);
                int maskOffset = maskPixels + y * maskStride;
                OS.memmove(maskLine, maskOffset, maskStride);
                int x = 0;
                while (x < w[0]) {
                    if (maskLine[x * 3] == 0) {
                        line[x * 4 + 3] = 0;
                    }
                    ++x;
                }
                OS.memmove(offset, line, stride);
                ++y;
            }
            OS.g_object_unref(maskPixbuf);
        } else {
            ImageData data = image.getImageData();
            boolean hasAlpha = data.getTransparencyType() == 1;
            pixbuf = OS.gdk_pixbuf_new(0, hasAlpha, 8, w[0], h[0]);
            if (pixbuf == 0) {
                SWT.error(2);
            }
            OS.gdk_pixbuf_get_from_drawable(pixbuf, image.pixmap, colormap, 0, 0, 0, 0, w[0], h[0]);
            if (hasAlpha) {
                byte[] alpha = data.alphaData;
                int stride = OS.gdk_pixbuf_get_rowstride(pixbuf);
                int pixels = OS.gdk_pixbuf_get_pixels(pixbuf);
                byte[] line = new byte[stride];
                int y = 0;
                while (y < h[0]) {
                    int offset = pixels + y * stride;
                    OS.memmove(line, offset, stride);
                    int x = 0;
                    while (x < w[0]) {
                        line[x * 4 + 3] = alpha[y * w[0] + x];
                        ++x;
                    }
                    OS.memmove(offset, line, stride);
                    ++y;
                }
            }
        }
        return pixbuf;
    }

    synchronized void deregister() {
        int i = 0;
        while (i < Displays.length) {
            if (this == Displays[i]) {
                Display.Displays[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        this.deregister();
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public static synchronized Display findDisplay(Thread thread) {
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++i;
        }
        return null;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    int eventProc(int event, int data) {
        int time = OS.gdk_event_get_time(event);
        if (time != 0) {
            this.lastEventTime = time;
        }
        int eventType = OS.GDK_EVENT_TYPE(event);
        switch (eventType) {
            case 4: 
            case 8: {
                this.lastUserEventTime = time;
            }
        }
        boolean dispatch = true;
        if (this.dispatchEvents != null) {
            dispatch = false;
            int i = 0;
            while (i < this.dispatchEvents.length) {
                if (eventType == this.dispatchEvents[i]) {
                    dispatch = true;
                    break;
                }
                ++i;
            }
        }
        if (!dispatch) {
            this.addGdkEvent(OS.gdk_event_copy(event));
            return 0;
        }
        Widget shell = null;
        Control control = null;
        int grabHandle = OS.gtk_grab_get_current();
        if (grabHandle != 0 && OS.GTK_IS_WINDOW(grabHandle) && OS.gtk_window_get_modal(grabHandle)) {
            block3 : switch (eventType) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    int window = OS.GDK_EVENT_WINDOW(event);
                    int[] user_data = new int[1];
                    do {
                        Widget widget;
                        OS.gdk_window_get_user_data(window, user_data);
                        int handle = user_data[0];
                        if (handle == 0 || (widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
                        control = (Control)widget;
                        break block3;
                    } while ((window = OS.gdk_window_get_parent(window)) != 0);
                }
            }
            if (control != null) {
                shell = control.getShell();
                if ((((Shell)shell).style & 0x4000) != 0) {
                    OS.gtk_grab_add(((Shell)shell).shellHandle);
                }
            }
        }
        OS.gtk_main_do_event(event);
        if (this.dispatchEvents == null) {
            this.putGdkEvents();
        }
        if (control != null && shell != null && !shell.isDisposed() && (((Shell)shell).style & 0x4000) != 0) {
            OS.gtk_grab_remove(((Shell)shell).shellHandle);
        }
        return 0;
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(int handle, int id) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int id) {
        this.checkDevice();
        return null;
    }

    static int fixedClassInitProc(int g_class, int class_data) {
        GtkWidgetClass klass = new GtkWidgetClass();
        OS.memmove(klass, g_class);
        klass.map = fixedMapProc;
        OS.memmove(g_class, klass);
        return 0;
    }

    static int fixedMapProc(int handle) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.fixedMapProc(handle);
        }
        return 0;
    }

    static int rendererClassInitProc(int g_class, int class_data) {
        GtkCellRendererClass klass = new GtkCellRendererClass();
        OS.memmove(klass, g_class);
        klass.render = rendererRenderProc;
        klass.get_size = rendererGetSizeProc;
        OS.memmove(g_class, klass);
        return 0;
    }

    static int rendererGetSizeProc(int cell, int handle, int cell_area, int x_offset, int y_offset, int width, int height) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererGetSizeProc(cell, handle, cell_area, x_offset, y_offset, width, height);
        }
        return 0;
    }

    static int rendererRenderProc(int cell, int window, int handle, int background_area, int cell_area, int expose_area, int flags) {
        Display display = Display.getCurrent();
        Widget widget = display.getWidget(handle);
        if (widget != null) {
            return widget.rendererRenderProc(cell, window, handle, background_area, cell_area, expose_area, flags);
        }
        return 0;
    }

    void flushExposes(int window, boolean all) {
        OS.gdk_flush();
        OS.gdk_flush();
        if (OS.GDK_WINDOWING_X11()) {
            this.flushWindow = window;
            this.flushAll = all;
            int xDisplay = OS.GDK_DISPLAY();
            int xEvent = OS.g_malloc(XEvent.sizeof);
            OS.XCheckIfEvent(xDisplay, xEvent, this.checkIfEventProc, 0);
            OS.g_free(xEvent);
            this.flushWindow = 0;
        }
    }

    public Shell getActiveShell() {
        this.checkDevice();
        return this.activeShell;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, OS.gdk_screen_width(), OS.gdk_screen_height());
    }

    public static synchronized Display getCurrent() {
        Thread current = Thread.currentThread();
        int i = 0;
        while (i < Displays.length) {
            Display display = Displays[i];
            if (display != null && display.thread == current) {
                return display;
            }
            ++i;
        }
        return null;
    }

    int getCaretBlinkTime() {
        int settings = OS.gtk_settings_get_default();
        if (settings == 0) {
            return 500;
        }
        int[] buffer = new int[1];
        OS.g_object_get(settings, OS.gtk_cursor_blink, buffer, 0);
        if (buffer[0] == 0) {
            return 0;
        }
        OS.g_object_get(settings, OS.gtk_cursor_blink_time, buffer, 0);
        if (buffer[0] == 0) {
            return 500;
        }
        return buffer[0] / 2;
    }

    public Control getCursorControl() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        int window = OS.gdk_window_at_pointer(x, y);
        if (window == 0) {
            return null;
        }
        int[] user_data = new int[1];
        OS.gdk_window_get_user_data(window, user_data);
        int handle = user_data[0];
        if (handle == 0) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) continue;
            return control;
        } while ((handle = OS.gtk_widget_get_parent(handle)) != 0);
        return null;
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    int filterProc(int xEvent, int gdkEvent, int data) {
        if (data == 0) {
            XButtonEvent mouseEvent = new XButtonEvent();
            OS.memmove(mouseEvent, xEvent, 4);
            if (mouseEvent.type == 5) {
                OS.memmove(mouseEvent, xEvent, XButtonEvent.sizeof);
                switch (mouseEvent.button) {
                    case 6: 
                    case 7: {
                        mouseEvent.button = -mouseEvent.button;
                        OS.memmove(xEvent, mouseEvent, XButtonEvent.sizeof);
                    }
                }
            }
        }
        return 0;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int[] x = new int[1];
        int[] y = new int[1];
        OS.gdk_window_get_pointer(0, x, y, null);
        return new Point(x[0], y[0]);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY)) {
            return this.dispatchEvents;
        }
        if (key.equals(IDLE_PROC_KEY)) {
            return new LONG(this.idleProc);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public Point getDPI() {
        this.checkDevice();
        int widthMM = OS.gdk_screen_width_mm();
        int width = OS.gdk_screen_width();
        int dpi = Compatibility.round(254 * width, widthMM * 10);
        return new Point(dpi, dpi);
    }

    int gtk_fixed_get_type() {
        return fixed_type;
    }

    int gtk_cell_renderer_text_get_type() {
        return text_renderer_type;
    }

    int gtk_cell_renderer_pixbuf_get_type() {
        return pixbuf_renderer_type;
    }

    int gtk_cell_renderer_toggle_get_type() {
        return toggle_renderer_type;
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        int settings = OS.gtk_settings_get_default();
        int[] buffer = new int[1];
        OS.g_object_get(settings, OS.gtk_double_click_time, buffer, 0);
        return buffer[0];
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        if (this.activeShell == null) {
            return null;
        }
        int shellHandle = this.activeShell.shellHandle;
        int handle = OS.gtk_window_get_focus(shellHandle);
        if (handle == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((handle = OS.gtk_widget_get_parent(handle)) != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getDepth() {
        this.checkDevice();
        GdkVisual visual = new GdkVisual();
        OS.memmove(visual, OS.gdk_visual_get_system());
        return visual.depth;
    }

    public int getIconDepth() {
        this.checkDevice();
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    int getLastEventTime() {
        return this.lastEventTime;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Rectangle getWorkArea() {
        byte[] name = Converter.wcsToMbcs(null, "_NET_WORKAREA", true);
        int atom = OS.gdk_atom_intern(name, true);
        if (atom == 0) {
            return null;
        }
        int[] actualType = new int[1];
        int[] actualFormat = new int[1];
        int[] actualLength = new int[1];
        int[] data = new int[1];
        if (!OS.gdk_property_get(OS.GDK_ROOT_PARENT(), atom, 0, 0, 16, 0, actualType, actualFormat, actualLength, data)) {
            return null;
        }
        Rectangle result = null;
        if (data[0] != 0) {
            if (actualLength[0] == 16) {
                int[] values = new int[4];
                OS.memmove(values, data[0], 16);
                result = new Rectangle(values[0], values[1], values[2], values[3]);
            } else if (actualLength[0] == 32) {
                long[] values = new long[4];
                OS.memmove(values, data[0], 32);
                result = new Rectangle((int)values[0], (int)values[1], (int)values[2], (int)values[3]);
            }
            OS.g_free(data[0]);
        }
        return result;
    }

    public Monitor[] getMonitors() {
        int monitorCount;
        this.checkDevice();
        Monitor[] monitors = null;
        Rectangle workArea = this.getWorkArea();
        int screen = OS.gdk_screen_get_default();
        if (screen != 0 && (monitorCount = OS.gdk_screen_get_n_monitors(screen)) > 0) {
            monitors = new Monitor[monitorCount];
            GdkRectangle dest = new GdkRectangle();
            int i = 0;
            while (i < monitorCount) {
                OS.gdk_screen_get_monitor_geometry(screen, i, dest);
                Monitor monitor = new Monitor();
                monitor.handle = i;
                monitor.x = dest.x;
                monitor.y = dest.y;
                monitor.width = dest.width;
                monitor.height = dest.height;
                if (i == 0 && workArea != null) {
                    monitor.clientX = workArea.x;
                    monitor.clientY = workArea.y;
                    monitor.clientWidth = workArea.width;
                    monitor.clientHeight = workArea.height;
                } else {
                    monitor.clientX = monitor.x;
                    monitor.clientY = monitor.y;
                    monitor.clientWidth = monitor.width;
                    monitor.clientHeight = monitor.height;
                }
                monitors[i] = monitor;
                ++i;
            }
        }
        if (monitors == null) {
            Monitor monitor = new Monitor();
            Rectangle bounds = this.getBounds();
            monitor.x = bounds.x;
            monitor.y = bounds.y;
            monitor.width = bounds.width;
            monitor.height = bounds.height;
            if (workArea != null) {
                monitor.clientX = workArea.x;
                monitor.clientY = workArea.y;
                monitor.clientWidth = workArea.width;
                monitor.clientHeight = workArea.height;
            } else {
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            monitors = new Monitor[]{monitor};
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitors = this.getMonitors();
        return monitors[0];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int index = 0;
        Shell[] result = new Shell[16];
        int i = 0;
        while (i < this.widgetTable.length) {
            Widget widget = this.widgetTable[i];
            if (widget != null && widget instanceof Shell) {
                int j = 0;
                while (j < index) {
                    if (result[j] == widget) break;
                    ++j;
                }
                if (j == index) {
                    if (index == result.length) {
                        Shell[] newResult = new Shell[index + 16];
                        System.arraycopy(result, 0, newResult, 0, index);
                        result = newResult;
                    }
                    result[index++] = (Shell)widget;
                }
            }
            ++i;
        }
        if (index == result.length) {
            return result;
        }
        Shell[] newResult = new Shell[index];
        System.arraycopy(result, 0, newResult, 0, index);
        return newResult;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        GdkColor gdkColor = null;
        switch (id) {
            case 28: {
                gdkColor = this.COLOR_INFO_FOREGROUND;
                break;
            }
            case 29: {
                gdkColor = this.COLOR_INFO_BACKGROUND;
                break;
            }
            case 30: {
                gdkColor = this.COLOR_TITLE_FOREGROUND;
                break;
            }
            case 31: {
                gdkColor = this.COLOR_TITLE_BACKGROUND;
                break;
            }
            case 32: {
                gdkColor = this.COLOR_TITLE_BACKGROUND_GRADIENT;
                break;
            }
            case 33: {
                gdkColor = this.COLOR_TITLE_INACTIVE_FOREGROUND;
                break;
            }
            case 34: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND;
                break;
            }
            case 35: {
                gdkColor = this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT;
                break;
            }
            case 17: {
                gdkColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                gdkColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                gdkColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                gdkColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                gdkColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                gdkColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                gdkColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                gdkColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                gdkColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                gdkColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                gdkColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        if (gdkColor == null) {
            return super.getSystemColor(2);
        }
        return Color.gtk_new(this, gdkColor);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        switch (id) {
            case 1: {
                if (this.errorImage == null) {
                    this.errorImage = this.createImage("gtk-dialog-error");
                }
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage == null) {
                    this.infoImage = this.createImage("gtk-dialog-info");
                }
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage == null) {
                    this.questionImage = this.createImage("gtk-dialog-question");
                }
                return this.questionImage;
            }
            case 8: {
                if (this.warningImage == null) {
                    this.warningImage = this.createImage("gtk-dialog-warning");
                }
                return this.warningImage;
            }
        }
        return null;
    }

    void initializeSystemColors() {
        int tooltipShellHandle = OS.gtk_window_new(1);
        if (tooltipShellHandle == 0) {
            SWT.error(2);
        }
        byte[] gtk_tooltips = Converter.wcsToMbcs(null, "gtk-tooltips", true);
        OS.gtk_widget_set_name(tooltipShellHandle, gtk_tooltips);
        OS.gtk_widget_realize(tooltipShellHandle);
        int tooltipStyle = OS.gtk_widget_get_style(tooltipShellHandle);
        GdkColor gdkColor = new GdkColor();
        OS.gtk_style_get_fg(tooltipStyle, 0, gdkColor);
        this.COLOR_INFO_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(tooltipStyle, 0, gdkColor);
        this.COLOR_INFO_BACKGROUND = gdkColor;
        OS.gtk_widget_destroy(tooltipShellHandle);
        int style = OS.gtk_widget_get_style(this.shellHandle);
        gdkColor = new GdkColor();
        OS.gtk_style_get_black(style, gdkColor);
        this.COLOR_WIDGET_DARK_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_dark(style, 0, gdkColor);
        this.COLOR_WIDGET_NORMAL_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(style, 0, gdkColor);
        this.COLOR_WIDGET_LIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(style, 0, gdkColor);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(style, 0, gdkColor);
        this.COLOR_WIDGET_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(style, 0, gdkColor);
        this.COLOR_WIDGET_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(style, 0, gdkColor);
        this.COLOR_LIST_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(style, 0, gdkColor);
        this.COLOR_LIST_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_text(style, 3, gdkColor);
        this.COLOR_LIST_SELECTION_TEXT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_base(style, 3, gdkColor);
        this.COLOR_LIST_SELECTION = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(style, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(style, 3, gdkColor);
        this.COLOR_TITLE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(style, 3, gdkColor);
        this.COLOR_TITLE_BACKGROUND_GRADIENT = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_bg(style, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_fg(style, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_FOREGROUND = gdkColor;
        gdkColor = new GdkColor();
        OS.gtk_style_get_light(style, 4, gdkColor);
        this.COLOR_TITLE_INACTIVE_BACKGROUND_GRADIENT = gdkColor;
    }

    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        int style = OS.gtk_widget_get_style(this.shellHandle);
        int defaultFont = OS.pango_font_description_copy(OS.gtk_style_get_font_desc(style));
        this.systemFont = Font.gtk_new(this, defaultFont);
        return this.systemFont;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        this.tray = new Tray(this, 0);
        return this.tray;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    Widget getWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        int index = OS.g_object_get_qdata(handle, SWT_OBJECT_INDEX) - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            return this.widgetTable[index];
        }
        return null;
    }

    int idleProc(int data) {
        this.runAsyncMessages(false);
        return 1;
    }

    protected void init() {
        super.init();
        this.initializeCallbacks();
        this.initializeSystemColors();
        this.initializeSystemSettings();
        this.initializeWidgetTable();
        this.initializeWindowManager();
    }

    void initializeCallbacks() {
        this.closures = new int[62];
        this.signalIds = new int[62];
        this.signalIds[2] = OS.g_signal_lookup(OS.button_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[4] = OS.g_signal_lookup(OS.button_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[10] = OS.g_signal_lookup(OS.configure_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[11] = OS.g_signal_lookup(OS.delete_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[14] = OS.g_signal_lookup(OS.enter_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[15] = OS.g_signal_lookup(OS.event, OS.GTK_TYPE_WIDGET());
        this.signalIds[16] = OS.g_signal_lookup(OS.event_after, OS.GTK_TYPE_WIDGET());
        this.signalIds[18] = OS.g_signal_lookup(OS.expose_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[20] = OS.g_signal_lookup(OS.focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[21] = OS.g_signal_lookup(OS.focus_in_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[22] = OS.g_signal_lookup(OS.focus_out_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[23] = OS.g_signal_lookup(OS.grab_focus, OS.GTK_TYPE_WIDGET());
        this.signalIds[24] = OS.g_signal_lookup(OS.hide, OS.GTK_TYPE_WIDGET());
        this.signalIds[27] = OS.g_signal_lookup(OS.key_press_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[28] = OS.g_signal_lookup(OS.key_release_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[29] = OS.g_signal_lookup(OS.leave_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[30] = OS.g_signal_lookup(OS.map, OS.GTK_TYPE_WIDGET());
        this.signalIds[31] = OS.g_signal_lookup(OS.map_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[32] = OS.g_signal_lookup(OS.mnemonic_activate, OS.GTK_TYPE_WIDGET());
        this.signalIds[33] = OS.g_signal_lookup(OS.motion_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[37] = OS.g_signal_lookup(OS.popup_menu, OS.GTK_TYPE_WIDGET());
        this.signalIds[39] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[42] = OS.g_signal_lookup(OS.scroll_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[44] = OS.g_signal_lookup(OS.show, OS.GTK_TYPE_WIDGET());
        this.signalIds[45] = OS.g_signal_lookup(OS.show_help, OS.GTK_TYPE_WIDGET());
        this.signalIds[46] = OS.g_signal_lookup(OS.size_allocate, OS.GTK_TYPE_WIDGET());
        this.signalIds[47] = OS.g_signal_lookup(OS.style_set, OS.GTK_TYPE_WIDGET());
        this.signalIds[53] = OS.g_signal_lookup(OS.unmap, OS.GTK_TYPE_WIDGET());
        this.signalIds[54] = OS.g_signal_lookup(OS.unmap_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[55] = OS.g_signal_lookup(OS.realize, OS.GTK_TYPE_WIDGET());
        this.signalIds[57] = OS.g_signal_lookup(OS.visibility_notify_event, OS.GTK_TYPE_WIDGET());
        this.signalIds[58] = OS.g_signal_lookup(OS.window_state_event, OS.GTK_TYPE_WIDGET());
        this.windowCallback2 = new Callback(this, "windowProc", 2);
        this.windowProc2 = this.windowCallback2.getAddress();
        if (this.windowProc2 == 0) {
            SWT.error(3);
        }
        this.closures[1] = OS.g_cclosure_new(this.windowProc2, 1, 0);
        this.closures[59] = OS.g_cclosure_new(this.windowProc2, 59, 0);
        this.closures[6] = OS.g_cclosure_new(this.windowProc2, 6, 0);
        this.closures[8] = OS.g_cclosure_new(this.windowProc2, 8, 0);
        this.closures[60] = OS.g_cclosure_new(this.windowProc2, 60, 0);
        this.closures[24] = OS.g_cclosure_new(this.windowProc2, 24, 0);
        this.closures[23] = OS.g_cclosure_new(this.windowProc2, 23, 0);
        this.closures[30] = OS.g_cclosure_new(this.windowProc2, 30, 0);
        this.closures[61] = OS.g_cclosure_new(this.windowProc2, 61, 0);
        this.closures[36] = OS.g_cclosure_new(this.windowProc2, 36, 0);
        this.closures[37] = OS.g_cclosure_new(this.windowProc2, 37, 0);
        this.closures[38] = OS.g_cclosure_new(this.windowProc2, 38, 0);
        this.closures[39] = OS.g_cclosure_new(this.windowProc2, 39, 0);
        this.closures[43] = OS.g_cclosure_new(this.windowProc2, 43, 0);
        this.closures[44] = OS.g_cclosure_new(this.windowProc2, 44, 0);
        this.closures[56] = OS.g_cclosure_new(this.windowProc2, 56, 0);
        this.closures[53] = OS.g_cclosure_new(this.windowProc2, 53, 0);
        this.closures[55] = OS.g_cclosure_new(this.windowProc2, 55, 0);
        this.windowCallback3 = new Callback(this, "windowProc", 3);
        this.windowProc3 = this.windowCallback3.getAddress();
        if (this.windowProc3 == 0) {
            SWT.error(3);
        }
        this.closures[2] = OS.g_cclosure_new(this.windowProc3, 2, 0);
        this.closures[3] = OS.g_cclosure_new(this.windowProc3, 3, 0);
        this.closures[4] = OS.g_cclosure_new(this.windowProc3, 4, 0);
        this.closures[5] = OS.g_cclosure_new(this.windowProc3, 5, 0);
        this.closures[9] = OS.g_cclosure_new(this.windowProc3, 9, 0);
        this.closures[10] = OS.g_cclosure_new(this.windowProc3, 10, 0);
        this.closures[11] = OS.g_cclosure_new(this.windowProc3, 11, 0);
        this.closures[14] = OS.g_cclosure_new(this.windowProc3, 14, 0);
        this.closures[15] = OS.g_cclosure_new(this.windowProc3, 15, 0);
        this.closures[16] = OS.g_cclosure_new(this.windowProc3, 16, 0);
        this.closures[18] = OS.g_cclosure_new(this.windowProc3, 18, 0);
        this.closures[19] = OS.g_cclosure_new(this.windowProc3, 19, 0);
        this.closures[20] = OS.g_cclosure_new(this.windowProc3, 20, 0);
        this.closures[21] = OS.g_cclosure_new(this.windowProc3, 21, 0);
        this.closures[22] = OS.g_cclosure_new(this.windowProc3, 22, 0);
        this.closures[27] = OS.g_cclosure_new(this.windowProc3, 27, 0);
        this.closures[28] = OS.g_cclosure_new(this.windowProc3, 28, 0);
        this.closures[25] = OS.g_cclosure_new(this.windowProc3, 25, 0);
        this.closures[29] = OS.g_cclosure_new(this.windowProc3, 29, 0);
        this.closures[31] = OS.g_cclosure_new(this.windowProc3, 31, 0);
        this.closures[32] = OS.g_cclosure_new(this.windowProc3, 32, 0);
        this.closures[33] = OS.g_cclosure_new(this.windowProc3, 33, 0);
        this.closures[34] = OS.g_cclosure_new(this.windowProc3, 34, 0);
        this.closures[35] = OS.g_cclosure_new(this.windowProc3, 35, 0);
        this.closures[42] = OS.g_cclosure_new(this.windowProc3, 42, 0);
        this.closures[45] = OS.g_cclosure_new(this.windowProc3, 45, 0);
        this.closures[46] = OS.g_cclosure_new(this.windowProc3, 46, 0);
        this.closures[47] = OS.g_cclosure_new(this.windowProc3, 47, 0);
        this.closures[52] = OS.g_cclosure_new(this.windowProc3, 52, 0);
        this.closures[54] = OS.g_cclosure_new(this.windowProc3, 54, 0);
        this.closures[57] = OS.g_cclosure_new(this.windowProc3, 57, 0);
        this.closures[58] = OS.g_cclosure_new(this.windowProc3, 58, 0);
        this.windowCallback4 = new Callback(this, "windowProc", 4);
        this.windowProc4 = this.windowCallback4.getAddress();
        if (this.windowProc4 == 0) {
            SWT.error(3);
        }
        this.closures[12] = OS.g_cclosure_new(this.windowProc4, 12, 0);
        this.closures[13] = OS.g_cclosure_new(this.windowProc4, 13, 0);
        this.closures[40] = OS.g_cclosure_new(this.windowProc4, 40, 0);
        this.closures[41] = OS.g_cclosure_new(this.windowProc4, 41, 0);
        this.closures[48] = OS.g_cclosure_new(this.windowProc4, 48, 0);
        this.closures[49] = OS.g_cclosure_new(this.windowProc4, 49, 0);
        this.closures[50] = OS.g_cclosure_new(this.windowProc4, 50, 0);
        this.windowCallback5 = new Callback(this, "windowProc", 5);
        this.windowProc5 = this.windowCallback5.getAddress();
        if (this.windowProc5 == 0) {
            SWT.error(3);
        }
        this.closures[7] = OS.g_cclosure_new(this.windowProc5, 7, 0);
        this.closures[17] = OS.g_cclosure_new(this.windowProc5, 17, 0);
        this.closures[26] = OS.g_cclosure_new(this.windowProc5, 26, 0);
        this.closures[51] = OS.g_cclosure_new(this.windowProc5, 51, 0);
        int i = 0;
        while (i < 62) {
            if (this.closures[i] != 0) {
                OS.g_closure_ref(this.closures[i]);
            }
            ++i;
        }
        this.timerCallback = new Callback(this, "timerProc", 1);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 1);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 1);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 1);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.menuPositionCallback = new Callback(this, "menuPositionProc", 5);
        this.menuPositionProc = this.menuPositionCallback.getAddress();
        if (this.menuPositionProc == 0) {
            this.error(3);
        }
        this.sizeAllocateCallback = new Callback(this, "sizeAllocateProc", 3);
        this.sizeAllocateProc = this.sizeAllocateCallback.getAddress();
        if (this.sizeAllocateProc == 0) {
            this.error(3);
        }
        this.shellMapCallback = new Callback(this, "shellMapProc", 3);
        this.shellMapProc = this.shellMapCallback.getAddress();
        if (this.shellMapProc == 0) {
            this.error(3);
        }
        this.shellMapProcClosure = OS.g_cclosure_new(this.shellMapProc, 0, 0);
        OS.g_closure_ref(this.shellMapProcClosure);
        this.treeSelectionCallback = new Callback(this, "treeSelectionProc", 4);
        this.treeSelectionProc = this.treeSelectionCallback.getAddress();
        if (this.treeSelectionProc == 0) {
            this.error(3);
        }
        this.cellDataCallback = new Callback(this, "cellDataProc", 5);
        this.cellDataProc = this.cellDataCallback.getAddress();
        if (this.cellDataProc == 0) {
            this.error(3);
        }
        this.setDirectionCallback = new Callback(this, "setDirectionProc", 2);
        this.setDirectionProc = this.setDirectionCallback.getAddress();
        if (this.setDirectionProc == 0) {
            this.error(3);
        }
        this.checkIfEventCallback = new Callback(this, "checkIfEventProc", 3);
        this.checkIfEventProc = this.checkIfEventCallback.getAddress();
        if (this.checkIfEventProc == 0) {
            this.error(3);
        }
        this.idleCallback = new Callback(this, "idleProc", 1);
        this.idleProc = this.idleCallback.getAddress();
        if (this.idleProc == 0) {
            this.error(3);
        }
    }

    void initializeSystemSettings() {
        this.styleSetCallback = new Callback(this, "styleSetProc", 3);
        this.styleSetProc = this.styleSetCallback.getAddress();
        if (this.styleSetProc == 0) {
            SWT.error(3);
        }
        OS.g_signal_connect(this.shellHandle, OS.style_set, this.styleSetProc, 0);
        int entry = OS.gtk_entry_new();
        OS.gtk_widget_destroy(entry);
        int[] buffer2 = new int[1];
        int settings = OS.gtk_settings_get_default();
        OS.g_object_get(settings, OS.gtk_entry_select_on_focus, buffer2, 0);
        this.entrySelectOnFocus = buffer2[0] != 0;
    }

    void initializeWidgetTable() {
        this.indexTable = new int[1024];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    void initializeWindowManager() {
        int length;
        int ptr2;
        int screen;
        this.windowManager = "";
        if (OS.GTK_VERSION >= OS.VERSION(2, 2, 0) && (screen = OS.gdk_screen_get_default()) != 0 && (ptr2 = OS.gdk_x11_screen_get_window_manager_name(screen)) != 0 && (length = OS.strlen(ptr2)) > 0) {
            byte[] buffer2 = new byte[length];
            OS.memmove(buffer2, ptr2, length);
            this.windowManager = new String(Converter.mbcsToWcs(null, buffer2));
        }
    }

    public void internal_dispose_GC(int gdkGC, GCData data) {
        OS.g_object_unref(gdkGC);
    }

    public int internal_new_GC(GCData data) {
        int root;
        int gdkGC;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((gdkGC = OS.gdk_gc_new(root = OS.GDK_ROOT_PARENT())) == 0) {
            SWT.error(2);
        }
        OS.gdk_gc_set_subwindow(gdkGC, 1);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = root;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont().handle;
        }
        return gdkGC;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        int[] origin_y;
        int[] origin_x;
        int window;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from != null) {
            window = from.eventWindow();
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin(window, origin_x, origin_y);
            point.x += origin_x[0];
            point.y += origin_y[0];
        }
        if (to != null) {
            window = to.eventWindow();
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin(window, origin_x, origin_y);
            point.x -= origin_x[0];
            point.y -= origin_y[0];
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static char mbcsToWcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = key <= 255 ? new byte[]{(byte)key} : new byte[]{(byte)(key >> 8 & 0xFF), (byte)(key & 0xFF)};
        char[] result = Converter.mbcsToWcs(null, buffer);
        if (result.length == 0) {
            return '\u0000';
        }
        return result[0];
    }

    int menuPositionProc(int menu, int x, int y, int push_in, int user_data) {
        Widget widget = this.getWidget(menu);
        if (widget == null) {
            return 0;
        }
        return widget.menuPositionProc(menu, x, y, push_in, user_data);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        int[] origin_y;
        int[] origin_x;
        int window;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from != null) {
            window = from.eventWindow();
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin(window, origin_x, origin_y);
            rect.x += origin_x[0];
            rect.y += origin_y[0];
        }
        if (to != null) {
            window = to.eventWindow();
            origin_x = new int[1];
            origin_y = new int[1];
            OS.gdk_window_get_origin(window, origin_x, origin_y);
            rect.x -= origin_x[0];
            rect.y -= origin_y[0];
        }
        return rect;
    }

    int mouseHoverProc(int handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(handle);
    }

    public boolean post(Event event) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (event == null) {
            this.error(4);
        }
        if (!OS.GDK_WINDOWING_X11()) {
            return false;
        }
        int xDisplay = OS.GDK_DISPLAY();
        int type = event.type;
        switch (type) {
            case 1: 
            case 2: {
                int keyCode = 0;
                int keysym = Display.untranslateKey(event.keyCode);
                if (keysym != 0) {
                    keyCode = OS.XKeysymToKeycode(xDisplay, keysym);
                }
                if (keyCode == 0) {
                    char key = event.character;
                    switch (key) {
                        case '\b': {
                            keysym = 65288;
                            break;
                        }
                        case '\r': {
                            keysym = 65293;
                            break;
                        }
                        case '\u007f': {
                            keysym = 65535;
                            break;
                        }
                        case '\u001b': {
                            keysym = 65307;
                            break;
                        }
                        case '\t': {
                            keysym = 65289;
                            break;
                        }
                        case '\n': {
                            keysym = 65290;
                            break;
                        }
                        default: {
                            keysym = Display.wcsToMbcs(key);
                        }
                    }
                    keyCode = OS.XKeysymToKeycode(xDisplay, keysym);
                    if (keyCode == 0) {
                        return false;
                    }
                }
                OS.XTestFakeKeyEvent(xDisplay, keyCode, type == 1, 0);
                return true;
            }
            case 3: 
            case 4: 
            case 5: {
                if (type == 5) {
                    OS.XTestFakeMotionEvent(xDisplay, -1, event.x, event.y, 0);
                } else {
                    int button = event.button;
                    if (button < 1 || button > 3) {
                        return false;
                    }
                    OS.XTestFakeButtonEvent(xDisplay, button, type == 3, 0);
                }
                return true;
            }
        }
        return false;
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    void putGdkEvents() {
        if (this.gdkEventCount != 0) {
            int i = 0;
            while (i < this.gdkEventCount) {
                int event = this.gdkEvents[i];
                Widget widget = this.gdkEventWidgets[i];
                if (widget == null || !widget.isDisposed()) {
                    OS.gdk_event_put(event);
                }
                OS.gdk_event_free(event);
                this.gdkEvents[i] = 0;
                this.gdkEventWidgets[i] = null;
                ++i;
            }
            this.gdkEventCount = 0;
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        boolean events = false;
        events |= this.runSettings();
        events |= this.runPopups();
        if (events |= OS.g_main_context_iteration(0, false)) {
            this.runDeferredEvents();
            return true;
        }
        return this.runAsyncMessages(false);
    }

    synchronized void register() {
        int i = 0;
        while (i < Displays.length) {
            if (Displays[i] == null) {
                Display.Displays[i] = this;
                return;
            }
            ++i;
        }
        Display[] newDisplays = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
        newDisplays[Display.Displays.length] = this;
        Displays = newDisplays;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        this.windowCallback2.dispose();
        this.windowCallback2 = null;
        this.windowCallback3.dispose();
        this.windowCallback3 = null;
        this.windowCallback4.dispose();
        this.windowCallback4 = null;
        this.windowCallback5.dispose();
        this.windowCallback5 = null;
        this.windowProc5 = 0;
        this.windowProc4 = 0;
        this.windowProc3 = 0;
        this.windowProc2 = 0;
        this.filterCallback.dispose();
        this.filterCallback = null;
        this.filterProc = 0;
        this.checkIfEventCallback.dispose();
        this.checkIfEventCallback = null;
        this.checkIfEventProc = 0;
        if (this.preeditWindow != 0) {
            OS.gtk_widget_destroy(this.preeditWindow);
        }
        this.imControl = null;
        this.menuPositionCallback.dispose();
        this.menuPositionCallback = null;
        this.menuPositionProc = 0;
        this.sizeAllocateCallback.dispose();
        this.sizeAllocateCallback = null;
        this.sizeAllocateProc = 0;
        this.shellMapCallback.dispose();
        this.shellMapCallback = null;
        this.shellMapProc = 0;
        this.idleCallback.dispose();
        this.idleCallback = null;
        this.idleProc = 0;
        this.treeSelectionCallback.dispose();
        this.treeSelectionCallback = null;
        this.treeSelectionProc = 0;
        this.cellDataCallback.dispose();
        this.cellDataCallback = null;
        this.cellDataProc = 0;
        this.setDirectionCallback.dispose();
        this.setDirectionCallback = null;
        this.setDirectionProc = 0;
        if (this.caretId != 0) {
            OS.gtk_timeout_remove(this.caretId);
        }
        this.caretId = 0;
        this.caretProc = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        int i = 0;
        while (i < 62) {
            if (this.closures[i] != 0) {
                OS.g_closure_unref(this.closures[i]);
            }
            ++i;
        }
        if (this.shellMapProcClosure != 0) {
            OS.g_closure_unref(this.shellMapProcClosure);
        }
        if (this.timerIds != null) {
            i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.gtk_timeout_remove(this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverProc = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningImage != null) {
            this.warningImage.dispose();
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        if (this.resources != null) {
            i = 0;
            while (i < this.resources.length) {
                if (this.resources[i] != null) {
                    this.resources[i].dispose();
                }
                ++i;
            }
            this.resources = null;
        }
        this.COLOR_INFO_FOREGROUND = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        OS.gdk_event_handler_set(0, 0, 0);
        this.eventCallback.dispose();
        this.eventCallback = null;
        if (this.shellHandle != 0) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0;
        this.styleSetCallback.dispose();
        this.styleSetCallback = null;
        this.styleSetProc = 0;
        this.timeout = null;
        this.max_priority = null;
        if (this.fds != 0) {
            OS.g_free(this.fds);
        }
        this.fds = 0;
        this.popups = null;
        this.thread = null;
        this.activeShell = null;
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    int removeGdkEvent() {
        if (this.gdkEventCount == 0) {
            return 0;
        }
        int event = this.gdkEvents[0];
        --this.gdkEventCount;
        System.arraycopy(this.gdkEvents, 1, this.gdkEvents, 0, this.gdkEventCount);
        System.arraycopy(this.gdkEventWidgets, 1, this.gdkEventWidgets, 0, this.gdkEventCount);
        this.gdkEvents[this.gdkEventCount] = 0;
        this.gdkEventWidgets[this.gdkEventCount] = null;
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        return event;
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    void removeMouseHoverTimeout(int handle) {
        if (handle != this.mouseHoverHandle) {
            return;
        }
        if (this.mouseHoverId != 0) {
            OS.gtk_timeout_remove(this.mouseHoverId);
        }
        this.mouseHoverId = 0;
        this.mouseHoverHandle = 0;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    Widget removeWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        Widget widget = null;
        int index = OS.g_object_get_qdata(handle, SWT_OBJECT_INDEX) - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            OS.g_object_set_qdata(handle, SWT_OBJECT_INDEX, 0);
        }
        return widget;
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runSettings() {
        if (!this.runSettings) {
            return false;
        }
        this.runSettings = false;
        this.saveResources();
        this.initializeSystemColors();
        this.sendEvent(39, null);
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.redraw(true);
                shell.layout(true, true);
            }
            ++i;
        }
        return true;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        if (OS.GDK_WINDOWING_X11()) {
            int xDisplay = OS.GDK_DISPLAY();
            int xWindow = OS.XDefaultRootWindow(xDisplay);
            OS.XWarpPointer(xDisplay, 0, xWindow, 0, 0, 0, 0, x, y);
        }
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(DISPATCH_EVENT_KEY) && (value == null || value instanceof int[])) {
            this.dispatchEvents = (int[])value;
            if (value == null) {
                this.putGdkEvents();
            }
            return;
        }
        if (key.equals(ADD_WIDGET_KEY)) {
            Object[] data = (Object[])value;
            int handle = ((LONG)data[0]).value;
            Widget widget = (Widget)data[1];
            if (widget != null) {
                this.addWidget(handle, widget);
            } else {
                this.removeWidget(handle);
            }
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    int setDirectionProc(int widget, int direction) {
        OS.gtk_widget_set_direction(widget, direction);
        if (OS.GTK_IS_CONTAINER(widget)) {
            OS.gtk_container_forall(widget, this.setDirectionProc, direction);
        }
        return 0;
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages(true);
        }
        this.synchronizer = synchronizer;
    }

    void showIMWindow(Control control) {
        this.imControl = control;
        if (this.preeditWindow == 0) {
            this.preeditWindow = OS.gtk_window_new(1);
            if (this.preeditWindow == 0) {
                this.error(2);
            }
            this.preeditLabel = OS.gtk_label_new(null);
            if (this.preeditLabel == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.preeditWindow, this.preeditLabel);
            OS.gtk_widget_show(this.preeditLabel);
        }
        int[] preeditString = new int[1];
        int[] pangoAttrs = new int[1];
        int imHandle = control.imHandle();
        OS.gtk_im_context_get_preedit_string(imHandle, preeditString, pangoAttrs, null);
        if (preeditString[0] != 0 && OS.strlen(preeditString[0]) > 0) {
            Control widget = control.findBackgroundControl();
            if (widget == null) {
                widget = control;
            }
            OS.gtk_widget_modify_bg(this.preeditWindow, 0, widget.getBackgroundColor());
            widget.setForegroundColor(this.preeditLabel, control.getForegroundColor());
            OS.gtk_widget_modify_font(this.preeditLabel, control.getFontDescription());
            if (pangoAttrs[0] != 0) {
                OS.gtk_label_set_attributes(this.preeditLabel, pangoAttrs[0]);
            }
            OS.gtk_label_set_text(this.preeditLabel, preeditString[0]);
            Point point = control.toDisplay(control.getIMCaretPos());
            OS.gtk_window_move(this.preeditWindow, point.x, point.y);
            GtkRequisition requisition = new GtkRequisition();
            OS.gtk_widget_size_request(this.preeditLabel, requisition);
            OS.gtk_window_resize(this.preeditWindow, requisition.width, requisition.height);
            OS.gtk_widget_show(this.preeditWindow);
        } else {
            OS.gtk_widget_hide(this.preeditWindow);
        }
        if (preeditString[0] != 0) {
            OS.g_free(preeditString[0]);
        }
        if (pangoAttrs[0] != 0) {
            OS.pango_attr_list_unref(pangoAttrs[0]);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.gdkEventCount == 0) {
            this.gdkEvents = null;
            this.gdkEventWidgets = null;
        }
        if (this.settingsChanged) {
            this.settingsChanged = false;
            this.runSettings = true;
            return false;
        }
        if (this.getMessageCount() != 0) {
            return true;
        }
        if (this.fds == 0) {
            this.allocated_nfds = 2;
            this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
        }
        this.timeout[0] = 0;
        this.max_priority[0] = 0;
        context = OS.g_main_context_default();
        result = false;
        do {
            block17: {
                if (!OS.g_main_context_acquire(context)) continue;
                result = OS.g_main_context_prepare(context, this.max_priority);
                while (true) {
                    if ((nfds = OS.g_main_context_query(context, this.max_priority[0], this.timeout, this.fds, this.allocated_nfds)) <= this.allocated_nfds) {
                        poll = OS.g_main_context_get_poll_func(context);
                        if (poll == 0 || nfds <= 0 && this.timeout[0] == 0) break block17;
                        if (this.timeout[0] < 0) {
                            this.timeout[0] = 50;
                        }
                        break;
                    }
                    OS.g_free(this.fds);
                    this.allocated_nfds = nfds;
                    this.fds = OS.g_malloc(OS.GPollFD_sizeof() * this.allocated_nfds);
                }
                lock = OS.lock;
                count = lock.lock();
                i = 0;
                while (true) {
                    if (i >= count) {
                        ** try [egrp 0[TRYBLOCK] [0 : 247->272)] { 
lbl39:
                        // 1 sources

                        break;
                    }
                    lock.unlock();
                    ++i;
                }
                {
                    this.wake = false;
                    OS.Call(poll, this.fds, nfds, this.timeout[0]);
                    ** GOTO lbl-1000
                }
lbl47:
                // 1 sources

                catch (Throwable var8_11) {
                    var7_9 = null;
                    i = 0;
                }
                while (true) {
                    if (i >= count) {
                        lock.unlock();
                        throw var8_11;
                    }
                    lock.lock();
                    ++i;
                }
lbl-1000:
                // 1 sources

                {
                    var7_7 = null;
                    i = 0;
                }
                while (true) {
                    if (i >= count) {
                        lock.unlock();
                        break;
                    }
                    lock.lock();
                    ++i;
                }
            }
            OS.g_main_context_check(context, this.max_priority[0], this.fds, nfds);
            OS.g_main_context_release(context);
        } while (!result && this.getMessageCount() == 0 && !this.wake);
        this.wake = false;
        return true;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int timerId;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.gtk_timeout_remove(this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((timerId = OS.gtk_timeout_add(milliseconds, this.timerProc, index)) != 0) {
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int i) {
        if (this.timerList == null) {
            return 0;
        }
        int index = i;
        if (index >= 0 && index < this.timerList.length) {
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    int caretProc(int clientData) {
        this.caretId = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            if (blinkRate == 0) {
                return 0;
            }
            this.caretId = OS.gtk_timeout_add(blinkRate, this.caretProc, 0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int sizeAllocateProc(int handle, int arg0, int user_data) {
        Widget widget = this.getWidget(user_data);
        if (widget == null) {
            return 0;
        }
        return widget.sizeAllocateProc(handle, arg0, user_data);
    }

    int treeSelectionProc(int model, int path, int iter, int data) {
        Widget widget = this.getWidget(data);
        if (widget == null) {
            return 0;
        }
        return widget.treeSelectionProc(model, path, iter, this.treeSelection, this.treeSelectionLength++);
    }

    void saveResources() {
        int resourceCount = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            resourceCount = this.resources.length;
            Resource[] newResources = new Resource[resourceCount + 27];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
        if (this.systemFont != null) {
            this.resources[resourceCount++] = this.systemFont;
            this.systemFont = null;
        }
        if (this.errorImage != null) {
            this.resources[resourceCount++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[resourceCount++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[resourceCount++] = this.questionImage;
        }
        if (this.warningImage != null) {
            this.resources[resourceCount++] = this.warningImage;
        }
        this.warningImage = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        int i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.resources[resourceCount++] = this.cursors[i];
            }
            this.cursors[i] = null;
            ++i;
        }
        if (resourceCount < 27) {
            Resource[] newResources = new Resource[resourceCount];
            System.arraycopy(this.resources, 0, newResources, 0, resourceCount);
            this.resources = newResources;
        }
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretId != 0) {
            OS.gtk_timeout_remove(this.caretId);
        }
        this.caretId = 0;
        this.currentCaret = caret;
        if (caret == null) {
            return;
        }
        int blinkRate = this.currentCaret.blinkRate;
        this.caretId = OS.gtk_timeout_add(blinkRate, this.caretProc, 0);
    }

    int shellMapProc(int handle, int arg0, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.shellMapProc(handle, arg0, user_data);
    }

    int styleSetProc(int gobject, int arg1, int user_data) {
        this.settingsChanged = true;
        return 0;
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        this.flushExposes(0, true);
        OS.gdk_window_process_all_updates();
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        this.wakeThread();
    }

    void wakeThread() {
        OS.g_main_context_wakeup(0);
        this.wake = true;
    }

    static char wcsToMbcs(char ch) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = Converter.wcsToMbcs(null, new char[]{ch}, false);
        if (buffer.length == 1) {
            return (char)buffer[0];
        }
        if (buffer.length == 2) {
            return (char)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
        }
        return '\u0000';
    }

    int windowProc(int handle, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, user_data);
    }

    int windowProc(int handle, int arg0, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, arg1, user_data);
    }

    int windowProc(int handle, int arg0, int arg1, int arg2, int user_data) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, arg0, arg1, arg2, user_data);
    }

    int windowTimerProc(int handle) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(handle);
    }
}

