/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientConnection;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessage;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessageHandler;
import com.aelitis.azureus.core.clientmessageservice.impl.NonBlockingReadWriteService;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ProtocolEndpointTCP;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;

public class AEClientService
implements ClientMessageService {
    private final String address;
    private final int port;
    private final String msg_type_id;
    private final int timeout_secs;
    private int max_message_bytes = -1;
    private ClientConnection conn;
    private final AESemaphore read_block = new AESemaphore("AEClientService:R");
    private final AESemaphore write_block = new AESemaphore("AEClientService:W");
    private final ArrayList received_messages = new ArrayList();
    private final NonBlockingReadWriteService rw_service;
    private volatile Throwable error;

    public AEClientService(String server_address, int server_port, String _msg_type_id) {
        this(server_address, server_port, 30, _msg_type_id);
    }

    public AEClientService(String server_address, int server_port, int timeout, String _msg_type_id) {
        this.address = server_address;
        this.port = server_port;
        this.timeout_secs = timeout;
        this.msg_type_id = _msg_type_id;
        try {
            AZMessageFactory.registerGenericMapPayloadMessageType(this.msg_type_id);
        }
        catch (MessageException me) {
            // empty catch block
        }
        this.rw_service = new NonBlockingReadWriteService(this.msg_type_id, timeout, 0, new NonBlockingReadWriteService.ServiceListener(){

            public void messageReceived(ClientMessage message) {
                AEClientService.this.received_messages.add(message.getPayload());
                AEClientService.this.read_block.release();
            }

            public void connectionError(ClientConnection connection, Throwable msg) {
                AEClientService.this.error = msg;
                AEClientService.this.read_block.releaseForever();
                AEClientService.this.write_block.releaseForever();
            }
        });
    }

    private void connect() throws IOException {
        InetSocketAddress tcp_target = new InetSocketAddress(this.address, this.port);
        ConnectionEndpoint ce = new ConnectionEndpoint(tcp_target);
        new ProtocolEndpointTCP(ce, tcp_target);
        final AESemaphore connect_block = new AESemaphore("AEClientService:C");
        ce.connectOutbound(false, false, null, null, new Transport.ConnectListener(){

            public void connectAttemptStarted() {
            }

            public void connectSuccess(Transport transport, ByteBuffer remaining_initial_data) {
                AEClientService.this.conn = new ClientConnection((TCPTransportImpl)transport);
                if (AEClientService.this.max_message_bytes != -1) {
                    AEClientService.this.conn.setMaximumMessageSize(AEClientService.this.max_message_bytes);
                }
                connect_block.release();
            }

            public void connectFailure(Throwable failure_msg) {
                AEClientService.this.error = failure_msg;
                connect_block.release();
            }
        });
        if (!connect_block.reserve(this.timeout_secs * 1000)) {
            throw new IOException("connect op failed: timeout");
        }
        if (this.error != null) {
            this.close();
            throw new IOException("connect op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
        this.rw_service.addClientConnection(this.conn);
    }

    public void sendMessage(Map message) throws IOException {
        if (this.conn == null) {
            this.connect();
        }
        if (this.error != null) {
            this.close();
            throw new IOException("send op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
        ClientMessage client_msg = new ClientMessage(this.msg_type_id, this.conn, message, new ClientMessageHandler(){

            public String getMessageTypeID() {
                return AEClientService.this.msg_type_id;
            }

            public void processMessage(ClientMessage message) {
                Debug.out("ERROR: should never be called");
            }

            public void sendAttemptCompleted(ClientMessage message) {
                AEClientService.this.write_block.release();
            }

            public void sendAttemptFailed(ClientMessage message, Throwable cause) {
                AEClientService.this.error = cause;
                AEClientService.this.write_block.release();
            }
        });
        this.rw_service.sendMessage(client_msg);
        this.write_block.reserve();
        if (this.error != null) {
            this.close();
            throw new IOException("send op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
        }
    }

    public Map receiveMessage() throws IOException {
        if (this.conn == null) {
            this.connect();
        }
        this.read_block.reserve();
        if (!this.received_messages.isEmpty()) {
            Map recv_msg = (Map)this.received_messages.remove(0);
            return recv_msg;
        }
        if (this.error == null) {
            this.error = new IOException("receive op inconsistent");
        }
        this.close();
        throw new IOException("receive op failed: " + this.error.getMessage() == null ? "[]" : this.error.getMessage());
    }

    public void close() {
        if (this.conn != null) {
            this.rw_service.removeClientConnection(this.conn);
            this.conn.close(new Exception("Connection closed"));
        }
        this.rw_service.destroy();
    }

    public void setMaximumMessageSize(int max_bytes) {
        this.max_message_bytes = max_bytes;
    }
}

