/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.secure.impl;

import com.aelitis.azureus.core.clientmessageservice.ClientMessageService;
import com.aelitis.azureus.core.clientmessageservice.ClientMessageServiceClient;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSAEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.jce.provider.RSAUtil;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.StaticUtilities;

public class SecureMessageServiceClientHelper
implements ClientMessageService {
    private ClientMessageService delegate;
    private SecretKey session_key;
    private byte[] encryped_session_key;

    public static ClientMessageService getServerService(String server_address, int server_port, int timeout_secs, String msg_type_id, RSAPublicKey public_key) throws IOException {
        return new SecureMessageServiceClientHelper(server_address, server_port, timeout_secs, msg_type_id, public_key);
    }

    protected SecureMessageServiceClientHelper(String server_address, int server_port, int timeout_secs, String msg_type_id, RSAPublicKey public_key) throws IOException {
        try {
            KeyGenerator secret_key_gen = KeyGenerator.getInstance("DESede");
            this.session_key = secret_key_gen.generateKey();
            byte[] secret_bytes = this.session_key.getEncoded();
            try {
                Cipher rsa_cipher = Cipher.getInstance("RSA");
                rsa_cipher.init(1, public_key);
                this.encryped_session_key = rsa_cipher.doFinal(secret_bytes);
            }
            catch (Throwable e) {
                RSAEngine eng = new RSAEngine();
                PKCS1Encoding padded_eng = new PKCS1Encoding(eng);
                CipherParameters param = RSAUtil.generatePublicKeyParameter(public_key);
                param = new ParametersWithRandom(param, new SecureRandom());
                padded_eng.init(true, param);
                this.encryped_session_key = padded_eng.processBlock(secret_bytes, 0, secret_bytes.length);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException("Secure client message service initialisation fails - " + Debug.getNestedExceptionMessage(e));
        }
        this.delegate = ClientMessageServiceClient.getServerService(server_address, server_port, msg_type_id);
    }

    public void sendMessage(Map plain_payload) throws IOException {
        HashMap<String, Object> secure_payload = new HashMap<String, Object>();
        try {
            byte[] message_bytes = StaticUtilities.getFormatters().bEncode(plain_payload);
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(1, this.session_key);
            byte[] encrypted_message = cipher.doFinal(message_bytes);
            secure_payload.put("ver", "1");
            secure_payload.put("alg", "DESede");
            secure_payload.put("key", this.encryped_session_key);
            secure_payload.put("content", encrypted_message);
        }
        catch (Throwable e) {
            throw new IOException("send message failed - " + Debug.getNestedExceptionMessage(e));
        }
        this.delegate.sendMessage(secure_payload);
    }

    public Map receiveMessage() throws IOException {
        Map secure_payload = this.delegate.receiveMessage();
        byte[] encrypted_message = (byte[])secure_payload.get("content");
        try {
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            cipher.init(2, this.session_key);
            byte[] message_bytes = cipher.doFinal(encrypted_message);
            Map plain_payload = StaticUtilities.getFormatters().bDecode(message_bytes);
            return plain_payload;
        }
        catch (Throwable e) {
            throw new IOException("send message failed - " + Debug.getNestedExceptionMessage(e));
        }
    }

    public void close() {
        this.delegate.close();
    }

    public void setMaximumMessageSize(int max_bytes) {
        this.delegate.setMaximumMessageSize(max_bytes);
    }
}

