/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.control.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTOperationListener;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlListener;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.control.impl.DHTControlContactImpl;
import com.aelitis.azureus.core.dht.control.impl.DHTControlStatsImpl;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.db.DHTDBFactory;
import com.aelitis.azureus.core.dht.db.DHTDBLookupResult;
import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.router.DHTRouterAdapter;
import com.aelitis.azureus.core.dht.router.DHTRouterContact;
import com.aelitis.azureus.core.dht.router.DHTRouterContactAttachment;
import com.aelitis.azureus.core.dht.router.DHTRouterFactory;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportException;
import com.aelitis.azureus.core.dht.transport.DHTTransportFindValueReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportRequestHandler;
import com.aelitis.azureus.core.dht.transport.DHTTransportStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.ThreadPoolTask;

public class DHTControlImpl
implements DHTControl,
DHTTransportRequestHandler {
    private static final int EXTERNAL_LOOKUP_CONCURRENCY = 16;
    private static final int EXTERNAL_PUT_CONCURRENCY = 8;
    private static final int RANDOM_QUERY_PERIOD = 300000;
    private static final int INTEGRATION_TIME_MAX = 15000;
    private DHTControlAdapter adapter;
    private DHTTransport transport;
    private DHTTransportContact local_contact;
    private DHTRouter router;
    private DHTDB database;
    private DHTControlStatsImpl stats;
    private DHTLogger logger;
    private int node_id_byte_count;
    private int search_concurrency;
    private int lookup_concurrency;
    private int cache_at_closest_n;
    private int K;
    private int B;
    private int max_rep_per_node;
    private long router_start_time;
    private int router_count;
    private ThreadPool internal_lookup_pool;
    private ThreadPool external_lookup_pool;
    private ThreadPool internal_put_pool;
    private ThreadPool external_put_pool;
    private Map imported_state = new HashMap();
    private long last_lookup;
    private ListenerManager listeners = ListenerManager.createAsyncManager("DHTControl:listenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            DHTControlListener target = (DHTControlListener)_listener;
            target.activityChanged((DHTControlActivity)value, type);
        }
    });
    private List activities = new ArrayList();
    private AEMonitor activity_mon = new AEMonitor("DHTControl:activities");
    protected AEMonitor estimate_mon = new AEMonitor("DHTControl:estimate");
    private long last_dht_estimate_time;
    private long local_dht_estimate;
    private long combined_dht_estimate;
    private static final int LOCAL_ESTIMATE_HISTORY = 32;
    private Map local_estimate_values = new LinkedHashMap(32, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 32;
        }
    };
    private static final int REMOTE_ESTIMATE_HISTORY = 128;
    private List remote_estimate_values = new LinkedList();
    protected AEMonitor spoof_mon = new AEMonitor("DHTControl:spoof");
    private Cipher spoof_cipher;
    private SecretKey spoof_key;

    public DHTControlImpl(DHTControlAdapter _adapter, DHTTransport _transport, int _K, int _B, int _max_rep_per_node, int _search_concurrency, int _lookup_concurrency, int _original_republish_interval, int _cache_republish_interval, int _cache_at_closest_n, DHTLogger _logger) {
        this.adapter = _adapter;
        this.transport = _transport;
        this.logger = _logger;
        this.K = _K;
        this.B = _B;
        this.max_rep_per_node = _max_rep_per_node;
        this.search_concurrency = _search_concurrency;
        this.lookup_concurrency = _lookup_concurrency;
        this.cache_at_closest_n = _cache_at_closest_n;
        this.last_dht_estimate_time = SystemTime.getCurrentTime();
        this.database = DHTDBFactory.create(this.adapter.getStorageAdapter(), _original_republish_interval, _cache_republish_interval, this.logger);
        this.internal_lookup_pool = new ThreadPool("DHTControl:internallookups", this.lookup_concurrency);
        this.internal_put_pool = new ThreadPool("DHTControl:internalputs", this.lookup_concurrency);
        this.external_lookup_pool = new ThreadPool("DHTControl:externallookups", 16, true);
        this.external_put_pool = new ThreadPool("DHTControl:puts", 8, true);
        this.createRouter(this.transport.getLocalContact());
        this.node_id_byte_count = this.router.getID().length;
        this.stats = new DHTControlStatsImpl(this);
        if (this.transport.supportsStorage()) {
            try {
                this.spoof_cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
                KeyGenerator keyGen = KeyGenerator.getInstance("DESede");
                this.spoof_key = keyGen.generateKey();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                this.logger.log(e);
            }
        }
        this.transport.setRequestHandler(this);
        this.transport.addListener(new DHTTransportListener(){

            public void localContactChanged(DHTTransportContact new_local_contact) {
                DHTTransportContact t_contact;
                DHTRouterContact contact;
                int i;
                DHTControlImpl.this.logger.log("Transport ID changed, recreating router");
                List old_contacts = DHTControlImpl.this.router.findBestContacts(0);
                byte[] old_router_id = DHTControlImpl.this.router.getID();
                DHTControlImpl.this.createRouter(new_local_contact);
                Set sorted_contacts = new sortedTransportContactSet(DHTControlImpl.this.router.getID(), true).getSet();
                for (i = 0; i < old_contacts.size(); ++i) {
                    contact = (DHTRouterContact)old_contacts.get(i);
                    if (Arrays.equals(old_router_id, contact.getID()) || !contact.isAlive()) continue;
                    t_contact = ((DHTControlContactImpl)contact.getAttachment()).getTransportContact();
                    sorted_contacts.add(t_contact);
                }
                for (i = 0; sorted_contacts.size() < 32 && i < old_contacts.size(); ++i) {
                    contact = (DHTRouterContact)old_contacts.get(i);
                    if (Arrays.equals(old_router_id, contact.getID()) || contact.isAlive()) continue;
                    t_contact = ((DHTControlContactImpl)contact.getAttachment()).getTransportContact();
                    sorted_contacts.add(t_contact);
                }
                Iterator it = sorted_contacts.iterator();
                for (int added = 0; it.hasNext() && added < 128; ++added) {
                    DHTTransportContact contact2 = (DHTTransportContact)it.next();
                    DHTControlImpl.this.router.contactAlive(contact2.getID(), new DHTControlContactImpl(contact2));
                }
                DHTControlImpl.this.seed(false);
            }

            public void currentAddress(String address) {
            }

            public void reachabilityChanged(boolean reacheable) {
            }
        });
    }

    protected void createRouter(DHTTransportContact _local_contact) {
        this.router_start_time = SystemTime.getCurrentTime();
        ++this.router_count;
        this.local_contact = _local_contact;
        if (this.router != null) {
            this.router.destroy();
        }
        this.router = DHTRouterFactory.create(this.K, this.B, this.max_rep_per_node, this.local_contact.getID(), new DHTControlContactImpl(this.local_contact), this.logger);
        this.router.setAdapter(new DHTRouterAdapter(){

            public void requestPing(DHTRouterContact contact) {
                DHTControlImpl.this.requestPing(contact);
            }

            public void requestLookup(byte[] id, String description) {
                DHTControlImpl.this.lookup(DHTControlImpl.this.internal_lookup_pool, false, id, description, (byte)0, false, 0L, DHTControlImpl.this.search_concurrency, 1, DHTControlImpl.this.router.getK(), new lookupResultHandler(new DHTOperationAdapter()){

                    public void diversify(DHTTransportContact cause, byte diversification_type) {
                    }

                    public void closest(List res) {
                    }
                });
            }

            public void requestAdd(DHTRouterContact contact) {
                DHTControlImpl.this.nodeAddedToRouter(contact);
            }
        });
        this.database.setControl(this);
    }

    public long getRouterUptime() {
        long now = SystemTime.getCurrentTime();
        if (now < this.router_start_time) {
            this.router_start_time = now;
        }
        return now - this.router_start_time;
    }

    public int getRouterCount() {
        return this.router_count;
    }

    public DHTControlStats getStats() {
        return this.stats;
    }

    public DHTTransport getTransport() {
        return this.transport;
    }

    public DHTRouter getRouter() {
        return this.router;
    }

    public DHTDB getDataBase() {
        return this.database;
    }

    public void contactImported(DHTTransportContact contact) {
        this.router.contactKnown(contact.getID(), new DHTControlContactImpl(contact));
    }

    public void contactRemoved(DHTTransportContact contact) {
        if (!this.router.isID(contact.getID())) {
            this.router.contactDead(contact.getID(), true);
        }
    }

    public void exportState(DataOutputStream daos, int max) throws IOException {
        DHTRouterContact contact;
        int i;
        List contacts = this.router.findBestContacts(0);
        ArrayList<DHTRouterContact> to_save = new ArrayList<DHTRouterContact>();
        ArrayList<DHTRouterContact> reserves = new ArrayList<DHTRouterContact>();
        for (i = 0; i < contacts.size(); ++i) {
            contact = (DHTRouterContact)contacts.get(i);
            Object[] imported = (Object[])this.imported_state.get(new HashWrapper(contact.getID()));
            if (imported == null) continue;
            if (contact.isAlive()) {
                to_save.add(contact);
                continue;
            }
            if (contact.isFailing()) continue;
            reserves.add(contact);
        }
        for (i = 0; i < contacts.size(); ++i) {
            contact = (DHTRouterContact)contacts.get(i);
            if (!contact.isAlive() || to_save.contains(contact)) continue;
            to_save.add(contact);
        }
        for (i = 0; i < reserves.size(); ++i) {
            contact = (DHTRouterContact)reserves.get(i);
            if (to_save.contains(contact)) continue;
            to_save.add(contact);
        }
        for (i = 0; i < contacts.size(); ++i) {
            contact = (DHTRouterContact)contacts.get(i);
            if (to_save.contains(contact)) continue;
            to_save.add(contact);
        }
        Iterator it = to_save.iterator();
        while (it.hasNext()) {
            contact = (DHTRouterContact)it.next();
            DHTTransportContact t_contact = ((DHTControlContactImpl)contact.getAttachment()).getTransportContact();
            if (t_contact.isValid()) continue;
            it.remove();
        }
        int num_to_write = Math.min(max, to_save.size());
        daos.writeInt(num_to_write);
        for (int i2 = 0; i2 < num_to_write; ++i2) {
            DHTRouterContact contact2 = (DHTRouterContact)to_save.get(i2);
            daos.writeLong(contact2.getTimeAlive());
            DHTTransportContact t_contact = ((DHTControlContactImpl)contact2.getAttachment()).getTransportContact();
            try {
                t_contact.exportContact(daos);
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
                throw new IOException(e.getMessage());
            }
        }
        daos.flush();
    }

    public void importState(DataInputStream dais) throws IOException {
        int num = dais.readInt();
        for (int i = 0; i < num; ++i) {
            try {
                long time_alive = dais.readLong();
                DHTTransportContact contact = this.transport.importContact(dais);
                this.imported_state.put(new HashWrapper(contact.getID()), new Object[]{new Long(time_alive), contact});
                continue;
            }
            catch (DHTTransportException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void seed(final boolean full_wait) {
        long remaining;
        final AESemaphore sem = new AESemaphore("DHTControl:seed");
        this.lookup(this.internal_lookup_pool, false, this.router.getID(), "Seeding DHT", (byte)0, false, 0L, this.search_concurrency * 4, 1, this.router.getK(), new lookupResultHandler(new DHTOperationAdapter()){

            public void diversify(DHTTransportContact cause, byte diversification_type) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void closest(List res) {
                if (!full_wait) {
                    sem.release();
                }
                try {
                    DHTControlImpl.this.router.seed();
                }
                finally {
                    if (full_wait) {
                        sem.release();
                    }
                }
            }
        });
        long start = SystemTime.getCurrentTime();
        sem.reserve(15000L);
        long now = SystemTime.getCurrentTime();
        if (now < start) {
            start = now;
        }
        if ((remaining = 15000L - (now - start)) > 500L && !full_wait) {
            this.logger.log("Initial integration completed, waiting " + remaining + " ms for second phase to start");
            try {
                Thread.sleep(remaining);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void poke() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_lookup || now - this.last_lookup > 300000L) {
            this.last_lookup = now;
            this.external_lookup_pool.run(new task(this.external_lookup_pool){
                private byte[] target;
                {
                    this.target = new byte[0];
                }

                public void runSupport() {
                    this.target = DHTControlImpl.this.router.refreshRandom();
                }

                public byte[] getTarget() {
                    return this.target;
                }

                public String getDescription() {
                    return "Random Query";
                }
            });
        }
    }

    public void put(byte[] _unencoded_key, String _description, byte[] _value, byte _flags, DHTOperationListener _listener) {
        if (_value.length == 0) {
            throw new RuntimeException("zero length values not supported");
        }
        byte[] encoded_key = this.encodeKey(_unencoded_key);
        DHTLog.log("put for " + DHTLog.getString(encoded_key));
        DHTDBValue value = this.database.store(new HashWrapper(encoded_key), _value, _flags);
        this.put(this.external_put_pool, encoded_key, _description, value, 0L, true, new HashSet(), _listener instanceof DHTOperationListenerDemuxer ? (DHTOperationListenerDemuxer)_listener : new DHTOperationListenerDemuxer(_listener));
    }

    public void putEncodedKey(byte[] encoded_key, String description, DHTTransportValue value, long timeout, boolean original_mappings) {
        this.put(this.internal_put_pool, encoded_key, description, value, timeout, original_mappings, new HashSet(), new DHTOperationListenerDemuxer(new DHTOperationAdapter()));
    }

    protected void put(ThreadPool thread_pool, byte[] initial_encoded_key, String description, DHTTransportValue value, long timeout, boolean original_mappings, Set keys_written, DHTOperationListenerDemuxer listener) {
        this.put(thread_pool, initial_encoded_key, description, new DHTTransportValue[]{value}, timeout, original_mappings, keys_written, listener);
    }

    protected void put(final ThreadPool thread_pool, byte[] initial_encoded_key, String description, final DHTTransportValue[] values, final long timeout, boolean original_mappings, final Set keys_written, final DHTOperationListenerDemuxer listener) {
        byte[][] encoded_keys = this.adapter.diversify(null, true, true, initial_encoded_key, (byte)1, original_mappings);
        for (int i = 0; i < encoded_keys.length; ++i) {
            final byte[] encoded_key = encoded_keys[i];
            HashWrapper hw = new HashWrapper(encoded_key);
            if (keys_written.contains(hw)) continue;
            keys_written.add(hw);
            final String this_description = Arrays.equals(encoded_key, initial_encoded_key) ? description : "Diversification of [" + description + "]";
            this.lookup(thread_pool, false, encoded_key, this_description, (byte)0, false, timeout, this.search_concurrency, 1, this.router.getK(), new lookupResultHandler(listener){

                public void diversify(DHTTransportContact cause, byte diversification_type) {
                    Debug.out("Shouldn't get a diversify on a lookup-node");
                }

                public void closest(List _closest) {
                    DHTControlImpl.this.put(thread_pool, new byte[][]{encoded_key}, "Store of [" + this_description + "]", new DHTTransportValue[][]{values}, _closest, timeout, listener, true, keys_written);
                }
            });
        }
    }

    public void putDirectEncodedKeys(byte[][] encoded_keys, String description, DHTTransportValue[][] value_sets, List contacts) {
        this.put(this.internal_put_pool, encoded_keys, description, value_sets, contacts, 0L, new DHTOperationListenerDemuxer(new DHTOperationAdapter()), false, new HashSet());
    }

    protected void put(final ThreadPool thread_pool, byte[][] initial_encoded_keys, final String description, DHTTransportValue[][] initial_value_sets, List contacts, final long timeout, final DHTOperationListenerDemuxer listener, final boolean consider_diversification, final Set keys_written) {
        int i;
        DHTTransportValue[][] value_sets;
        boolean[] ok = new boolean[initial_encoded_keys.length];
        int failed = 0;
        for (int i2 = 0; i2 < initial_encoded_keys.length; ++i2) {
            ok[i2] = !this.database.isKeyBlocked(initial_encoded_keys[i2]);
            if (ok[i2]) continue;
            ++failed;
        }
        if (failed == ok.length) {
            listener.incrementCompletes();
            listener.complete(false);
            return;
        }
        final byte[][] encoded_keys = failed == 0 ? initial_encoded_keys : (byte[][])new byte[ok.length - failed][];
        Object object = value_sets = failed == 0 ? initial_value_sets : new DHTTransportValue[ok.length - failed][];
        if (failed > 0) {
            int pos = 0;
            for (i = 0; i < ok.length; ++i) {
                if (!ok[i]) continue;
                encoded_keys[pos] = initial_encoded_keys[i];
                value_sets[pos] = initial_value_sets[i];
                ++pos;
            }
        }
        final boolean[] diversified = new boolean[encoded_keys.length];
        for (i = 0; i < contacts.size(); ++i) {
            DHTTransportContact contact = (DHTTransportContact)contacts.get(i);
            if (this.router.isID(contact.getID())) continue;
            try {
                for (int j = 0; j < value_sets.length; ++j) {
                    for (int k = 0; k < value_sets[j].length; ++k) {
                        listener.wrote(contact, value_sets[j][k]);
                    }
                }
                listener.incrementCompletes();
                contact.sendStore(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void storeReply(DHTTransportContact _contact, byte[] _diversifications) {
                        try {
                            DHTLog.log("Store OK " + DHTLog.getString(_contact));
                            DHTControlImpl.this.router.contactAlive(_contact.getID(), new DHTControlContactImpl(_contact));
                            if (consider_diversification && _diversifications != null) {
                                for (int j = 0; j < _diversifications.length; ++j) {
                                    if (_diversifications[j] == 1 || diversified[j]) continue;
                                    diversified[j] = true;
                                    byte[][] diversified_keys = DHTControlImpl.this.adapter.diversify(_contact, true, false, encoded_keys[j], _diversifications[j], false);
                                    for (int k = 0; k < diversified_keys.length; ++k) {
                                        DHTControlImpl.this.put(thread_pool, diversified_keys[k], "Diversification of [" + description + "]", value_sets[j], timeout, false, keys_written, listener);
                                    }
                                }
                            }
                        }
                        finally {
                            listener.complete(false);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact _contact, Throwable _error) {
                        try {
                            DHTLog.log("Store failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            DHTControlImpl.this.router.contactDead(_contact.getID(), false);
                        }
                        finally {
                            listener.complete(true);
                        }
                    }

                    public void keyBlockRequest(DHTTransportContact contact, byte[] request2, byte[] key_signature) {
                        DHTStorageBlock key_block = DHTControlImpl.this.database.keyBlockRequest(null, request2, key_signature);
                        if (key_block != null) {
                            for (int i = 0; i < encoded_keys.length; ++i) {
                                if (!Arrays.equals(encoded_keys[i], key_block.getKey())) continue;
                                byte[] dummy = new byte[encoded_keys[i].length];
                                new Random().nextBytes(dummy);
                                encoded_keys[i] = dummy;
                            }
                        }
                    }
                }, encoded_keys, value_sets);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public DHTTransportValue getLocalValue(byte[] unencoded_key) {
        byte[] encoded_key = this.encodeKey(unencoded_key);
        DHTLog.log("getLocalValue for " + DHTLog.getString(encoded_key));
        DHTDBValue res = this.database.get(new HashWrapper(encoded_key));
        if (res == null) {
            return null;
        }
        return res;
    }

    public void get(byte[] unencoded_key, String description, byte flags, int max_values, long timeout, boolean exhaustive, boolean high_priority, DHTOperationListener get_listener) {
        byte[] encoded_key = this.encodeKey(unencoded_key);
        DHTLog.log("get for " + DHTLog.getString(encoded_key));
        this.getSupport(encoded_key, description, flags, max_values, timeout, exhaustive, high_priority, new DHTOperationListenerDemuxer(get_listener));
    }

    public boolean isDiversified(byte[] unencoded_key) {
        byte[] encoded_key = this.encodeKey(unencoded_key);
        return this.adapter.isDiversified(encoded_key);
    }

    public boolean lookup(byte[] unencoded_key, long timeout, final DHTOperationListener lookup_listener) {
        byte[] encoded_key = this.encodeKey(unencoded_key);
        DHTLog.log("lookup for " + DHTLog.getString(encoded_key));
        final AESemaphore sem = new AESemaphore("DHTControl:lookup");
        final boolean[] diversified = new boolean[]{false};
        DHTOperationListener delegate = new DHTOperationListener(){

            public void searching(DHTTransportContact contact, int level, int active_searches) {
                lookup_listener.searching(contact, level, active_searches);
            }

            public void found(DHTTransportContact contact) {
            }

            public void diversified() {
                lookup_listener.diversified();
            }

            public void read(DHTTransportContact contact, DHTTransportValue value) {
            }

            public void wrote(DHTTransportContact contact, DHTTransportValue value) {
            }

            public void complete(boolean timeout) {
                lookup_listener.complete(timeout);
                sem.release();
            }
        };
        this.lookup(this.external_lookup_pool, false, encoded_key, "lookup", (byte)0, false, timeout, this.search_concurrency, 1, this.router.getK(), new lookupResultHandler(delegate){

            public void diversify(DHTTransportContact cause, byte diversification_type) {
                this.diversified();
                diversified[0] = true;
            }

            public void closest(List closest) {
                for (int i = 0; i < closest.size(); ++i) {
                    lookup_listener.found((DHTTransportContact)closest.get(i));
                }
            }
        });
        sem.reserve();
        return diversified[0];
    }

    protected void getSupport(byte[] initial_encoded_key, String description, final byte flags, final int max_values, final long timeout, final boolean exhaustive, final boolean high_priority, final DHTOperationListenerDemuxer get_listener) {
        byte[][] encoded_keys = this.adapter.diversify(null, false, true, initial_encoded_key, (byte)1, exhaustive);
        for (int i = 0; i < encoded_keys.length; ++i) {
            boolean div;
            final boolean[] diversified = new boolean[]{false};
            final byte[] encoded_key = encoded_keys[i];
            boolean bl = div = !Arrays.equals(encoded_key, initial_encoded_key);
            if (div) {
                get_listener.diversified();
            }
            final String this_description = div ? "Diversification of [" + description + "]" : description;
            this.lookup(this.external_lookup_pool, high_priority, encoded_key, this_description, flags, true, timeout, this.search_concurrency, max_values, this.router.getK(), new lookupResultHandler(get_listener){
                private List found_values;
                {
                    super(x0);
                    this.found_values = new ArrayList();
                }

                public void diversify(DHTTransportContact cause, byte diversification_type) {
                    this.diversified();
                    if (!diversified[0]) {
                        int rem;
                        diversified[0] = true;
                        int n = rem = max_values == 0 ? 0 : max_values - this.found_values.size();
                        if (max_values == 0 || rem > 0) {
                            byte[][] diversified_keys = DHTControlImpl.this.adapter.diversify(cause, false, false, encoded_key, diversification_type, exhaustive);
                            for (int j = 0; j < diversified_keys.length; ++j) {
                                DHTControlImpl.this.getSupport(diversified_keys[j], "Diversification of [" + this_description + "]", flags, rem, timeout, exhaustive, high_priority, get_listener);
                            }
                        }
                    }
                }

                public void read(DHTTransportContact contact, DHTTransportValue value) {
                    this.found_values.add(value);
                    super.read(contact, value);
                }

                public void closest(List closest) {
                }
            });
        }
    }

    public byte[] remove(byte[] unencoded_key, String description, DHTOperationListener listener) {
        byte[] encoded_key = this.encodeKey(unencoded_key);
        DHTLog.log("remove for " + DHTLog.getString(encoded_key));
        DHTDBValue res = this.database.remove(this.local_contact, new HashWrapper(encoded_key));
        if (res == null) {
            return null;
        }
        this.put(this.external_put_pool, encoded_key, description, res, 0L, true, new HashSet(), new DHTOperationListenerDemuxer(listener));
        return res.getValue();
    }

    protected void lookup(ThreadPool thread_pool, boolean high_priority, final byte[] lookup_id, final String description, final byte flags, final boolean value_search, final long timeout, final int concurrency, final int max_values, final int search_accuracy, final lookupResultHandler handler) {
        thread_pool.run(new task(thread_pool){

            public void runSupport() {
                try {
                    DHTControlImpl.this.lookupSupportSync(lookup_id, flags, value_search, timeout, concurrency, max_values, search_accuracy, handler);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }

            public byte[] getTarget() {
                return lookup_id;
            }

            public String getDescription() {
                return description;
            }
        }, high_priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupSupportSync(byte[] lookup_id, byte flags, boolean value_search, long timeout, int concurrency, int max_values, final int search_accuracy, final lookupResultHandler result_handler) {
        boolean timeout_occurred = false;
        this.last_lookup = SystemTime.getCurrentTime();
        result_handler.incrementCompletes();
        try {
            DHTLog.log("lookup for " + DHTLog.getString(lookup_id));
            if (value_search && this.database.isKeyBlocked(lookup_id)) {
                DHTLog.log("lookup: terminates - key blocked");
                return;
            }
            final Set contacts_to_query = this.getClosestContactsSet(lookup_id, false);
            final AEMonitor contacts_to_query_mon = new AEMonitor("DHTControl:ctq");
            final HashMap<DHTTransportContact, Integer> level_map = new HashMap<DHTTransportContact, Integer>();
            Iterator it = contacts_to_query.iterator();
            while (it.hasNext()) {
                DHTTransportContact contact = (DHTTransportContact)it.next();
                result_handler.found(contact);
                level_map.put(contact, new Integer(0));
            }
            final HashMap<HashWrapper, DHTTransportContact> contacts_queried = new HashMap<HashWrapper, DHTTransportContact>();
            final Set ok_contacts = new sortedTransportContactSet(lookup_id, false).getSet();
            final AESemaphore search_sem = new AESemaphore("DHTControl:search", concurrency);
            final int[] idle_searches = new int[]{0};
            final int[] active_searches = new int[]{0};
            final int[] values_found = new int[]{0};
            final int[] value_replies = new int[]{0};
            final HashSet values_found_set = new HashSet();
            final boolean[] key_blocked = new boolean[]{false};
            long start = SystemTime.getCurrentTime();
            while (true) {
                if (timeout > 0L) {
                    long remaining;
                    long now = SystemTime.getCurrentTime();
                    if (now < start) {
                        start = now;
                    }
                    if ((remaining = timeout - (now - start)) <= 0L) {
                        DHTLog.log("lookup: terminates - timeout");
                        timeout_occurred = true;
                        break;
                    }
                    if (!search_sem.reserve(remaining)) {
                        DHTLog.log("lookup: terminates - timeout");
                        timeout_occurred = true;
                        break;
                    }
                } else {
                    search_sem.reserve();
                }
                try {
                    DHTTransportContact furthest_ok;
                    int distance;
                    contacts_to_query_mon.enter();
                    if (values_found[0] >= max_values || value_replies[0] >= 2) break;
                    if (key_blocked[0]) {
                        contacts_to_query.clear();
                    }
                    if (contacts_to_query.size() == 0) {
                        if (active_searches[0] == 0) {
                            DHTLog.log("lookup: terminates - no contacts left to query");
                            break;
                        }
                        idle_searches[0] = idle_searches[0] + 1;
                        continue;
                    }
                    DHTTransportContact closest = (DHTTransportContact)contacts_to_query.iterator().next();
                    if (ok_contacts.size() == search_accuracy && (distance = this.computeAndCompareDistances((furthest_ok = (DHTTransportContact)ok_contacts.iterator().next()).getID(), closest.getID(), lookup_id)) <= 0) {
                        DHTLog.log("lookup: terminates - we've searched the closest " + search_accuracy + " contacts");
                        break;
                    }
                    if (contacts_queried.size() < concurrency) {
                        DHTNetworkPosition[] loc_nps = this.local_contact.getNetworkPositions();
                        DHTTransportContact vp_closest = null;
                        Iterator vp_it = contacts_to_query.iterator();
                        int vp_count_limit = concurrency * 2 - contacts_queried.size();
                        int vp_count = 0;
                        float best_dist = Float.MAX_VALUE;
                        while (vp_it.hasNext() && vp_count < vp_count_limit) {
                            ++vp_count;
                            DHTTransportContact entry = (DHTTransportContact)vp_it.next();
                            DHTNetworkPosition[] rem_nps = entry.getNetworkPositions();
                            float dist = DHTNetworkPositionManager.estimateRTT(loc_nps, rem_nps);
                            if (!Float.isNaN(dist) && dist < best_dist) {
                                best_dist = dist;
                                vp_closest = entry;
                            }
                            if (vp_closest == null) continue;
                            closest = vp_closest;
                        }
                    }
                    contacts_to_query.remove(closest);
                    contacts_queried.put(new HashWrapper(closest.getID()), closest);
                    if (this.router.isID(closest.getID())) {
                        search_sem.release();
                        continue;
                    }
                    final int search_level = (Integer)level_map.get(closest);
                    active_searches[0] = active_searches[0] + 1;
                    result_handler.searching(closest, search_level, active_searches[0]);
                    DHTTransportReplyHandlerAdapter handler = new DHTTransportReplyHandlerAdapter(){
                        private boolean value_reply_received = false;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void findNodeReply(DHTTransportContact target_contact, DHTTransportContact[] reply_contacts) {
                            try {
                                DHTTransportContact contact;
                                DHTLog.log("findNodeReply: " + DHTLog.getString(reply_contacts));
                                DHTControlImpl.this.router.contactAlive(target_contact.getID(), new DHTControlContactImpl(target_contact));
                                for (int i = 0; i < reply_contacts.length; ++i) {
                                    contact = reply_contacts[i];
                                    if (DHTControlImpl.this.compareDistances(DHTControlImpl.this.router.getID(), contact.getID()) == 0) continue;
                                    DHTControlImpl.this.router.contactKnown(contact.getID(), new DHTControlContactImpl(contact));
                                }
                                try {
                                    contacts_to_query_mon.enter();
                                    ok_contacts.add(target_contact);
                                    if (ok_contacts.size() > search_accuracy) {
                                        Iterator ok_it = ok_contacts.iterator();
                                        ok_it.next();
                                        ok_it.remove();
                                    }
                                    for (int i = 0; i < reply_contacts.length; ++i) {
                                        contact = reply_contacts[i];
                                        if (DHTControlImpl.this.compareDistances(DHTControlImpl.this.router.getID(), contact.getID()) == 0 || contacts_queried.get(new HashWrapper(contact.getID())) != null || contacts_to_query.contains(contact)) continue;
                                        DHTLog.log("    new contact for query: " + DHTLog.getString(contact));
                                        contacts_to_query.add(contact);
                                        result_handler.found(contact);
                                        level_map.put(contact, new Integer(search_level + 1));
                                        if (idle_searches[0] <= 0) continue;
                                        idle_searches[0] = idle_searches[0] - 1;
                                        search_sem.release();
                                    }
                                }
                                finally {
                                    contacts_to_query_mon.exit();
                                }
                            }
                            finally {
                                try {
                                    contacts_to_query_mon.enter();
                                    active_searches[0] = active_searches[0] - 1;
                                }
                                finally {
                                    contacts_to_query_mon.exit();
                                }
                                search_sem.release();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void findValueReply(DHTTransportContact contact, DHTTransportValue[] values, byte diversification_type, boolean more_to_come) {
                            DHTLog.log("findValueReply: " + DHTLog.getString(values) + ",mtc=" + more_to_come + ", dt=" + diversification_type);
                            try {
                                if (!key_blocked[0] && diversification_type != 1) {
                                    result_handler.diversify(contact, diversification_type);
                                }
                                this.value_reply_received = true;
                                DHTControlImpl.this.router.contactAlive(contact.getID(), new DHTControlContactImpl(contact));
                                int new_values = 0;
                                if (!key_blocked[0]) {
                                    for (int i = 0; i < values.length; ++i) {
                                        DHTTransportValue value = values[i];
                                        DHTTransportContact originator = value.getOriginator();
                                        byte[] originator_id = originator.getID();
                                        byte[] value_bytes = value.getValue();
                                        byte[] value_id = new byte[originator_id.length + value_bytes.length];
                                        System.arraycopy(originator_id, 0, value_id, 0, originator_id.length);
                                        System.arraycopy(value_bytes, 0, value_id, originator_id.length, value_bytes.length);
                                        HashWrapper x = new HashWrapper(value_id);
                                        if (values_found_set.contains(x)) continue;
                                        ++new_values;
                                        values_found_set.add(x);
                                        result_handler.read(contact, values[i]);
                                    }
                                }
                                try {
                                    contacts_to_query_mon.enter();
                                    if (!more_to_come) {
                                        value_replies[0] = value_replies[0] + 1;
                                    }
                                    values_found[0] = values_found[0] + new_values;
                                }
                                finally {
                                    contacts_to_query_mon.exit();
                                }
                            }
                            finally {
                                if (!more_to_come) {
                                    try {
                                        contacts_to_query_mon.enter();
                                        active_searches[0] = active_searches[0] - 1;
                                    }
                                    finally {
                                        contacts_to_query_mon.exit();
                                    }
                                    search_sem.release();
                                }
                            }
                        }

                        public void findValueReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                            this.findNodeReply(contact, contacts);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void failed(DHTTransportContact target_contact, Throwable error) {
                            try {
                                if (!this.value_reply_received) {
                                    DHTLog.log("findNode/findValue " + DHTLog.getString(target_contact) + " -> failed: " + error.getMessage());
                                    DHTControlImpl.this.router.contactDead(target_contact.getID(), false);
                                }
                            }
                            finally {
                                try {
                                    contacts_to_query_mon.enter();
                                    active_searches[0] = active_searches[0] - 1;
                                }
                                finally {
                                    contacts_to_query_mon.exit();
                                }
                                search_sem.release();
                            }
                        }

                        public void keyBlockRequest(DHTTransportContact contact, byte[] request2, byte[] key_signature) {
                            if (DHTControlImpl.this.database.keyBlockRequest(null, request2, key_signature) != null) {
                                key_blocked[0] = true;
                            }
                        }
                    };
                    this.router.recordLookup(lookup_id);
                    if (value_search) {
                        int rem = max_values - values_found[0];
                        if (rem <= 0) {
                            Debug.out("eh?");
                            rem = 1;
                        }
                        closest.sendFindValue(handler, lookup_id, rem, flags);
                        continue;
                    }
                    closest.sendFindNode(handler, lookup_id);
                    continue;
                }
                finally {
                    contacts_to_query_mon.exit();
                    continue;
                }
                break;
            }
            ArrayList closest_res = null;
            try {
                contacts_to_query_mon.enter();
                if (DHTLog.isOn()) {
                    DHTLog.log("lookup complete for " + DHTLog.getString(lookup_id));
                    DHTLog.log("    queried = " + DHTLog.getString(contacts_queried));
                    DHTLog.log("    to query = " + DHTLog.getString(contacts_to_query));
                    DHTLog.log("    ok = " + DHTLog.getString(ok_contacts));
                }
                closest_res = new ArrayList(ok_contacts);
                Collections.reverse(closest_res);
                if (timeout <= 0L && !value_search) {
                    this.estimateDHTSize(lookup_id, contacts_queried, search_accuracy);
                }
            }
            finally {
                contacts_to_query_mon.exit();
            }
            result_handler.closest(closest_res);
        }
        finally {
            result_handler.complete(timeout_occurred);
        }
    }

    public void pingRequest(DHTTransportContact originating_contact) {
        DHTLog.log("pingRequest from " + DHTLog.getString(originating_contact.getID()));
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
    }

    public void keyBlockRequest(DHTTransportContact originating_contact, byte[] request2, byte[] sig) {
        DHTLog.log("keyBlockRequest from " + DHTLog.getString(originating_contact.getID()));
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
        this.database.keyBlockRequest(originating_contact, request2, sig);
    }

    public DHTTransportStoreReply storeRequest(DHTTransportContact originating_contact, byte[][] keys, DHTTransportValue[][] value_sets) {
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
        DHTLog.log("storeRequest from " + DHTLog.getString(originating_contact) + ", keys = " + keys.length);
        byte[] diverse_res = new byte[keys.length];
        Arrays.fill(diverse_res, (byte)1);
        if (keys.length != value_sets.length) {
            Debug.out("DHTControl:storeRequest - invalid request received from " + originating_contact.getString() + ", keys and values length mismatch");
            return new DHTTransportStoreReplyImpl(diverse_res);
        }
        DHTStorageBlock blocked_details = null;
        for (int i = 0; i < keys.length; ++i) {
            HashWrapper key = new HashWrapper(keys[i]);
            DHTTransportValue[] values = value_sets[i];
            DHTLog.log("    key=" + DHTLog.getString(key) + ", value=" + DHTLog.getString(values));
            diverse_res[i] = this.database.store(originating_contact, key, values);
            if (blocked_details != null) continue;
            blocked_details = this.database.getKeyBlockDetails(keys[i]);
        }
        if (blocked_details == null) {
            return new DHTTransportStoreReplyImpl(diverse_res);
        }
        return new DHTTransportStoreReplyImpl(blocked_details.getRequest(), blocked_details.getCertificate());
    }

    public DHTTransportContact[] findNodeRequest(DHTTransportContact originating_contact, byte[] id) {
        DHTLog.log("findNodeRequest from " + DHTLog.getString(originating_contact.getID()));
        this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
        List l = id.length == this.router.getID().length ? this.getClosestKContactsList(id, false) : new ArrayList();
        DHTTransportContact[] res = new DHTTransportContact[l.size()];
        l.toArray(res);
        int rand = this.generateSpoofID(originating_contact);
        originating_contact.setRandomID(rand);
        return res;
    }

    public DHTTransportFindValueReply findValueRequest(DHTTransportContact originating_contact, byte[] key, int max_values, byte flags) {
        DHTLog.log("findValueRequest from " + DHTLog.getString(originating_contact.getID()));
        DHTDBLookupResult result = this.database.get(originating_contact, new HashWrapper(key), max_values, flags, true);
        if (result != null) {
            this.router.contactAlive(originating_contact.getID(), new DHTControlContactImpl(originating_contact));
            DHTStorageBlock block_details = this.database.getKeyBlockDetails(key);
            if (block_details == null) {
                return new DHTTransportFindValueReplyImpl(result.getDiversificationType(), result.getValues());
            }
            return new DHTTransportFindValueReplyImpl(block_details.getRequest(), block_details.getCertificate());
        }
        return new DHTTransportFindValueReplyImpl(this.findNodeRequest(originating_contact, key));
    }

    public DHTTransportFullStats statsRequest(DHTTransportContact contact) {
        return this.stats;
    }

    protected void requestPing(DHTRouterContact contact) {
        ((DHTControlContactImpl)contact.getAttachment()).getTransportContact().sendPing(new DHTTransportReplyHandlerAdapter(){

            public void pingReply(DHTTransportContact _contact) {
                DHTLog.log("ping OK " + DHTLog.getString(_contact));
                DHTControlImpl.this.router.contactAlive(_contact.getID(), new DHTControlContactImpl(_contact));
            }

            public void failed(DHTTransportContact _contact, Throwable _error) {
                DHTLog.log("ping " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                DHTControlImpl.this.router.contactDead(_contact.getID(), false);
            }
        });
    }

    protected void nodeAddedToRouter(DHTRouterContact new_contact) {
        if (this.router.isID(new_contact.getID())) {
            return;
        }
        HashMap keys_to_store = new HashMap();
        DHTStorageBlock[] direct_key_blocks = this.database.getDirectKeyBlocks();
        if (this.database.isEmpty() && direct_key_blocks.length == 0) {
            if (!new_contact.hasBeenAlive()) {
                this.requestPing(new_contact);
            }
            return;
        }
        List closest_contacts = this.getClosestKContactsList(new_contact.getID(), false);
        boolean close = false;
        for (int i = 0; i < closest_contacts.size(); ++i) {
            if (!this.router.isID(((DHTTransportContact)closest_contacts.get(i)).getID())) continue;
            close = true;
            break;
        }
        if (!close) {
            if (!new_contact.hasBeenAlive()) {
                this.requestPing(new_contact);
            }
            return;
        }
        Iterator it = this.database.getKeys();
        while (it.hasNext()) {
            DHTDBLookupResult result;
            HashWrapper key = (HashWrapper)it.next();
            byte[] encoded_key = key.getHash();
            if (this.database.isKeyBlocked(encoded_key) || (result = this.database.get(null, key, 0, (byte)0, false)) == null) continue;
            DHTDBValue[] values = result.getValues();
            ArrayList<DHTDBValue> values_to_store = new ArrayList<DHTDBValue>();
            for (int i = 0; i < values.length; ++i) {
                DHTDBValue value = values[i];
                List sorted_contacts = this.getClosestKContactsList(encoded_key, false);
                boolean store_it = false;
                if (sorted_contacts.size() > 0) {
                    DHTTransportContact first = (DHTTransportContact)sorted_contacts.get(0);
                    if (this.router.isID(first.getID())) {
                        store_it = true;
                    } else if (Arrays.equals(first.getID(), new_contact.getID()) && sorted_contacts.size() > 1) {
                        store_it = this.router.isID(((DHTTransportContact)sorted_contacts.get(1)).getID());
                    }
                }
                if (!store_it) continue;
                values_to_store.add(value);
            }
            if (values_to_store.size() <= 0) continue;
            keys_to_store.put(key, values_to_store);
        }
        final DHTTransportContact t_contact = ((DHTControlContactImpl)new_contact.getAttachment()).getTransportContact();
        final boolean[] anti_spoof_done = new boolean[]{false};
        if (keys_to_store.size() > 0) {
            it = keys_to_store.entrySet().iterator();
            final byte[][] keys = new byte[keys_to_store.size()][];
            final DHTTransportValue[][] value_sets = new DHTTransportValue[keys.length][];
            int index = 0;
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                HashWrapper key = (HashWrapper)entry.getKey();
                List values = (List)entry.getValue();
                keys[index] = key.getHash();
                value_sets[index] = new DHTTransportValue[values.size()];
                for (int i = 0; i < values.size(); ++i) {
                    value_sets[index][i] = ((DHTDBValue)values.get(i)).getValueForRelay(this.local_contact);
                }
                ++index;
            }
            t_contact.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                public void findNodeReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                    anti_spoof_done[0] = true;
                    t_contact.sendStore(new DHTTransportReplyHandlerAdapter(){

                        public void storeReply(DHTTransportContact _contact, byte[] _diversifications) {
                            DHTLog.log("add store ok");
                            DHTControlImpl.this.router.contactAlive(_contact.getID(), new DHTControlContactImpl(_contact));
                        }

                        public void failed(DHTTransportContact _contact, Throwable _error) {
                            DHTLog.log("add store failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            DHTControlImpl.this.router.contactDead(_contact.getID(), false);
                        }

                        public void keyBlockRequest(DHTTransportContact contact, byte[] request2, byte[] signature) {
                            DHTControlImpl.this.database.keyBlockRequest(null, request2, signature);
                        }
                    }, keys, value_sets);
                }

                public void failed(DHTTransportContact _contact, Throwable _error) {
                    DHTLog.log("pre-store findNode failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                    DHTControlImpl.this.router.contactDead(_contact.getID(), false);
                }
            }, t_contact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20]);
        } else if (!new_contact.hasBeenAlive()) {
            this.requestPing(new_contact);
        }
        if (t_contact.getProtocolVersion() >= 14) {
            for (int i = 0; i < direct_key_blocks.length; ++i) {
                final DHTStorageBlock key_block = direct_key_blocks[i];
                List contacts = this.getClosestKContactsList(key_block.getKey(), false);
                boolean forward_it = false;
                for (int j = 0; j < contacts.size(); ++j) {
                    DHTTransportContact contact = (DHTTransportContact)contacts.get(j);
                    if (!this.router.isID(contact.getID())) continue;
                    forward_it = true;
                    break;
                }
                if (!forward_it || key_block.hasBeenSentTo(t_contact)) continue;
                final Runnable task2 = new Runnable(){

                    public void run() {
                        t_contact.sendKeyBlock(new DHTTransportReplyHandlerAdapter(){

                            public void keyBlockReply(DHTTransportContact _contact) {
                                DHTLog.log("key block forward ok " + DHTLog.getString(_contact));
                                key_block.sentTo(_contact);
                            }

                            public void failed(DHTTransportContact _contact, Throwable _error) {
                                DHTLog.log("key block forward failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            }
                        }, key_block.getRequest(), key_block.getCertificate());
                    }
                };
                if (anti_spoof_done[0]) {
                    task2.run();
                    continue;
                }
                t_contact.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                    public void findNodeReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                        task2.run();
                    }

                    public void failed(DHTTransportContact _contact, Throwable _error) {
                        DHTLog.log("pre-kb findNode failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                        DHTControlImpl.this.router.contactDead(_contact.getID(), false);
                    }
                }, t_contact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20]);
            }
        }
    }

    protected Set getClosestContactsSet(byte[] id, boolean live_only) {
        List l = this.router.findClosestContacts(id, live_only);
        Set sorted_set = new sortedTransportContactSet(id, true).getSet();
        for (int i = 0; i < l.size(); ++i) {
            sorted_set.add(((DHTControlContactImpl)((DHTRouterContact)l.get(i)).getAttachment()).getTransportContact());
        }
        return sorted_set;
    }

    public List getClosestKContactsList(byte[] id, boolean live_only) {
        Set sorted_set = this.getClosestContactsSet(id, live_only);
        ArrayList res = new ArrayList(this.K);
        Iterator it = sorted_set.iterator();
        while (it.hasNext() && res.size() < this.K) {
            res.add(it.next());
        }
        return res;
    }

    protected byte[] encodeKey(byte[] key) {
        byte[] temp = new SHA1Simple().calculateHash(key);
        byte[] result = new byte[this.node_id_byte_count];
        System.arraycopy(temp, 0, result, 0, this.node_id_byte_count);
        return result;
    }

    public int computeAndCompareDistances(byte[] t1, byte[] t2, byte[] pivot) {
        return DHTControlImpl.computeAndCompareDistances2(t1, t2, pivot);
    }

    protected static int computeAndCompareDistances2(byte[] t1, byte[] t2, byte[] pivot) {
        for (int i = 0; i < t1.length; ++i) {
            byte d1 = (byte)(t1[i] ^ pivot[i]);
            byte d2 = (byte)(t2[i] ^ pivot[i]);
            int diff = (d1 & 0xFF) - (d2 & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public byte[] computeDistance(byte[] n1, byte[] n2) {
        return DHTControlImpl.computeDistance2(n1, n2);
    }

    protected static byte[] computeDistance2(byte[] n1, byte[] n2) {
        byte[] res = new byte[n1.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (byte)(n1[i] ^ n2[i]);
        }
        return res;
    }

    public int compareDistances(byte[] n1, byte[] n2) {
        return DHTControlImpl.compareDistances2(n1, n2);
    }

    protected static int compareDistances2(byte[] n1, byte[] n2) {
        for (int i = 0; i < n1.length; ++i) {
            int diff = (n1[i] & 0xFF) - (n2[i] & 0xFF);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DHTControlListener l) {
        try {
            this.activity_mon.enter();
            this.listeners.addListener(l);
            for (int i = 0; i < this.activities.size(); ++i) {
                this.listeners.dispatch(1, this.activities.get(i));
            }
        }
        finally {
            this.activity_mon.exit();
        }
    }

    public void removeListener(DHTControlListener l) {
        this.listeners.removeListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DHTControlActivity[] getActivities() {
        ArrayList res;
        try {
            this.activity_mon.enter();
            res = new ArrayList(this.activities);
        }
        finally {
            this.activity_mon.exit();
        }
        DHTControlActivity[] x = new DHTControlActivity[res.size()];
        res.toArray(x);
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportEstimatedDHTSize(int size) {
        if (size > 0) {
            try {
                this.estimate_mon.enter();
                this.remote_estimate_values.add(new Integer(size));
                if (this.remote_estimate_values.size() > 128) {
                    this.remote_estimate_values.remove(0);
                }
            }
            finally {
                this.estimate_mon.exit();
            }
        }
    }

    public int getTransportEstimatedDHTSize() {
        return (int)this.local_dht_estimate;
    }

    public int getEstimatedDHTSize() {
        long now = SystemTime.getCurrentTime();
        long diff = now - this.last_dht_estimate_time;
        if (diff < 0L || diff > 60000L) {
            this.estimateDHTSize(this.router.getID(), null, this.router.getK());
        }
        return (int)this.combined_dht_estimate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void estimateDHTSize(byte[] id, Map contacts, int contacts_to_use) {
        long now = SystemTime.getCurrentTime();
        long diff = now - this.last_dht_estimate_time;
        if (diff < 0L || diff > 5000L) {
            try {
                ArrayList l;
                this.estimate_mon.enter();
                this.last_dht_estimate_time = now;
                if (contacts == null) {
                    l = this.getClosestKContactsList(id, false);
                } else {
                    Set sorted_set = new sortedTransportContactSet(id, true).getSet();
                    sorted_set.addAll(contacts.values());
                    l = new ArrayList(sorted_set);
                    if (l.size() > 0) {
                        id = ((DHTTransportContact)l.get(0)).getID();
                    }
                }
                if (l.size() > 2) {
                    BigInteger sum1 = new BigInteger("0");
                    BigInteger sum2 = new BigInteger("0");
                    for (int i = 1; i < Math.min(l.size(), contacts_to_use); ++i) {
                        DHTTransportContact node = (DHTTransportContact)l.get(i);
                        byte[] dist = this.computeDistance(id, node.getID());
                        BigInteger b_dist = this.IDToBigInteger(dist);
                        BigInteger b_i = new BigInteger("" + i);
                        sum1 = sum1.add(b_i.multiply(b_dist));
                        sum2 = sum2.add(b_i.multiply(b_i));
                    }
                    byte[] max = new byte[id.length + 1];
                    max[0] = 1;
                    long this_estimate = sum1.compareTo(new BigInteger("0")) == 0 ? 0L : this.IDToBigInteger(max).multiply(sum2).divide(sum1).longValue();
                    if (this_estimate < 1L) {
                        this_estimate = 1L;
                    }
                    this.local_estimate_values.put(new HashWrapper(id), new Long(this_estimate));
                    long new_estimate = 0L;
                    Iterator it = this.local_estimate_values.values().iterator();
                    String sizes = "";
                    while (it.hasNext()) {
                        long estimate = (Long)it.next();
                        sizes = sizes + (sizes.length() == 0 ? "" : ",") + estimate;
                        new_estimate += estimate;
                    }
                    this.local_dht_estimate = new_estimate / (long)this.local_estimate_values.size();
                }
                ArrayList rems = new ArrayList(new TreeSet(this.remote_estimate_values));
                long rem_average = this.local_dht_estimate;
                int rem_vals = 1;
                for (int i = 3; i < rems.size() - 3; ++i) {
                    rem_average += (long)((Integer)rems.get(i)).intValue();
                    ++rem_vals;
                }
                this.combined_dht_estimate = rem_average / (long)rem_vals;
            }
            finally {
                this.estimate_mon.exit();
            }
        }
    }

    protected BigInteger IDToBigInteger(byte[] data) {
        String str_key = "";
        for (int i = 0; i < data.length; ++i) {
            String hex = Integer.toHexString(data[i] & 0xFF);
            while (hex.length() < 2) {
                hex = "0" + hex;
            }
            str_key = str_key + hex;
        }
        BigInteger res = new BigInteger(str_key, 16);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int generateSpoofID(DHTTransportContact contact) {
        if (this.spoof_cipher == null) {
            return 0;
        }
        try {
            int res;
            this.spoof_mon.enter();
            this.spoof_cipher.init(1, this.spoof_key);
            byte[] address = contact.getAddress().getAddress().getAddress();
            byte[] data_out = this.spoof_cipher.doFinal(address);
            int n = res = data_out[0] << 24 & 0xFF000000 | data_out[1] << 16 & 0xFF0000 | data_out[2] << 8 & 0xFF00 | data_out[3] & 0xFF;
            return n;
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        finally {
            this.spoof_mon.exit();
        }
        return 0;
    }

    public boolean verifyContact(DHTTransportContact c, boolean direct) {
        boolean ok = c.getRandomID() == this.generateSpoofID(c);
        return ok;
    }

    public List getContacts() {
        List contacts = this.router.getAllContacts();
        ArrayList<DHTRouterContactAttachment> res = new ArrayList<DHTRouterContactAttachment>(contacts.size());
        for (int i = 0; i < contacts.size(); ++i) {
            DHTRouterContact rc = (DHTRouterContact)contacts.get(i);
            res.add(rc.getAttachment());
        }
        return res;
    }

    public void print() {
        DHTNetworkPosition[] nps = this.transport.getLocalContact().getNetworkPositions();
        String np_str = "";
        for (int j = 0; j < nps.length; ++j) {
            np_str = np_str + (j == 0 ? "" : ",") + nps[j];
        }
        this.logger.log("DHT Details: external IP = " + this.transport.getLocalContact().getAddress() + ", network = " + this.transport.getNetwork() + ", protocol = V" + this.transport.getProtocolVersion() + ", nps = " + np_str);
        this.router.print();
        this.database.print();
    }

    public List sortContactsByDistance(List contacts) {
        Set sorted_contacts = new sortedTransportContactSet(this.router.getID(), true).getSet();
        sorted_contacts.addAll(contacts);
        return new ArrayList(sorted_contacts);
    }

    protected class controlActivity
    implements DHTControlActivity {
        protected ThreadPool tp;
        protected task task;
        protected int type;

        protected controlActivity(ThreadPool _tp, task _task) {
            this.tp = _tp;
            this.task = _task;
            this.type = _tp == DHTControlImpl.this.internal_lookup_pool ? 1 : (_tp == DHTControlImpl.this.external_lookup_pool ? 2 : (_tp == DHTControlImpl.this.internal_put_pool ? 3 : 4));
        }

        public byte[] getTarget() {
            return this.task.getTarget();
        }

        public String getDescription() {
            return this.task.getDescription();
        }

        public int getType() {
            return this.type;
        }

        public boolean isQueued() {
            return this.tp.isQueued(this.task);
        }

        public String getString() {
            return this.type + ":" + DHTLog.getString(this.getTarget()) + "/" + this.getDescription() + ", q = " + this.isQueued();
        }
    }

    protected abstract class task
    extends ThreadPoolTask {
        private controlActivity activity;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected task(ThreadPool thread_pool) {
            this.activity = new controlActivity(thread_pool, this);
            try {
                DHTControlImpl.this.activity_mon.enter();
                DHTControlImpl.this.activities.add(this.activity);
                DHTControlImpl.this.listeners.dispatch(1, this.activity);
            }
            finally {
                DHTControlImpl.this.activity_mon.exit();
            }
        }

        public void taskStarted() {
            DHTControlImpl.this.listeners.dispatch(2, this.activity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskCompleted() {
            try {
                DHTControlImpl.this.activity_mon.enter();
                DHTControlImpl.this.activities.remove(this.activity);
                DHTControlImpl.this.listeners.dispatch(3, this.activity);
            }
            finally {
                DHTControlImpl.this.activity_mon.exit();
            }
        }

        public void interruptTask() {
        }

        public abstract byte[] getTarget();

        public abstract String getDescription();
    }

    protected static class DHTTransportStoreReplyImpl
    implements DHTTransportStoreReply {
        private byte[] divs;
        private byte[] block_request;
        private byte[] block_sig;

        protected DHTTransportStoreReplyImpl(byte[] _divs) {
            this.divs = _divs;
        }

        protected DHTTransportStoreReplyImpl(byte[] _bk, byte[] _bs) {
            this.block_request = _bk;
            this.block_sig = _bs;
        }

        public byte[] getDiversificationTypes() {
            return this.divs;
        }

        public boolean blocked() {
            return this.block_request != null;
        }

        public byte[] getBlockRequest() {
            return this.block_request;
        }

        public byte[] getBlockSignature() {
            return this.block_sig;
        }
    }

    protected static class DHTTransportFindValueReplyImpl
    implements DHTTransportFindValueReply {
        private byte dt = 1;
        private DHTTransportValue[] values;
        private DHTTransportContact[] contacts;
        private byte[] blocked_key;
        private byte[] blocked_sig;

        protected DHTTransportFindValueReplyImpl(byte _dt, DHTTransportValue[] _values) {
            this.dt = _dt;
            this.values = _values;
        }

        protected DHTTransportFindValueReplyImpl(DHTTransportContact[] _contacts) {
            this.contacts = _contacts;
        }

        protected DHTTransportFindValueReplyImpl(byte[] _blocked_key, byte[] _blocked_sig) {
            this.blocked_key = _blocked_key;
            this.blocked_sig = _blocked_sig;
        }

        public byte getDiversificationType() {
            return this.dt;
        }

        public boolean hit() {
            return this.values != null;
        }

        public boolean blocked() {
            return this.blocked_key != null;
        }

        public DHTTransportValue[] getValues() {
            return this.values;
        }

        public DHTTransportContact[] getContacts() {
            return this.contacts;
        }

        public byte[] getBlockedKey() {
            return this.blocked_key;
        }

        public byte[] getBlockedSignature() {
            return this.blocked_sig;
        }
    }

    static abstract class lookupResultHandler
    extends DHTOperationListenerDemuxer {
        protected lookupResultHandler(DHTOperationListener delegate) {
            super(delegate);
        }

        public abstract void closest(List var1);

        public abstract void diversify(DHTTransportContact var1, byte var2);
    }

    protected static class DHTOperationListenerDemuxer
    implements DHTOperationListener {
        private AEMonitor this_mon = new AEMonitor("DHTOperationListenerDemuxer");
        private DHTOperationListener delegate;
        private boolean complete_fired;
        private boolean complete_included_ok;
        private int complete_count = 0;

        protected DHTOperationListenerDemuxer(DHTOperationListener _delegate) {
            this.delegate = _delegate;
            if (this.delegate == null) {
                Debug.out("invalid: null delegate");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void incrementCompletes() {
            try {
                this.this_mon.enter();
                ++this.complete_count;
            }
            finally {
                this.this_mon.exit();
            }
        }

        public void searching(DHTTransportContact contact, int level, int active_searches) {
            this.delegate.searching(contact, level, active_searches);
        }

        public void diversified() {
            this.delegate.diversified();
        }

        public void found(DHTTransportContact contact) {
            this.delegate.found(contact);
        }

        public void read(DHTTransportContact contact, DHTTransportValue value) {
            this.delegate.read(contact, value);
        }

        public void wrote(DHTTransportContact contact, DHTTransportValue value) {
            this.delegate.wrote(contact, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void complete(boolean timeout) {
            boolean fire = false;
            try {
                this.this_mon.enter();
                if (!timeout) {
                    this.complete_included_ok = true;
                }
                --this.complete_count;
                if (this.complete_count <= 0 && !this.complete_fired) {
                    this.complete_fired = true;
                    fire = true;
                }
            }
            finally {
                this.this_mon.exit();
            }
            if (fire) {
                this.delegate.complete(!this.complete_included_ok);
            }
        }
    }

    protected static class sortedTransportContactSet {
        private TreeSet tree_set;
        private byte[] pivot;
        private boolean ascending;

        protected sortedTransportContactSet(byte[] _pivot, boolean _ascending) {
            this.pivot = _pivot;
            this.ascending = _ascending;
            this.tree_set = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    DHTTransportContact t1 = (DHTTransportContact)o1;
                    DHTTransportContact t2 = (DHTTransportContact)o2;
                    int distance = DHTControlImpl.computeAndCompareDistances2(t1.getID(), t2.getID(), sortedTransportContactSet.this.pivot);
                    if (sortedTransportContactSet.this.ascending) {
                        return distance;
                    }
                    return -distance;
                }
            });
        }

        public Set getSet() {
            return this.tree_set;
        }
    }
}

