/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.speed.impl;

import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTester;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContact;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterContactListener;
import com.aelitis.azureus.core.dht.speed.DHTSpeedTesterListener;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class DHTSpeedTesterImpl
implements DHTSpeedTester {
    private static final long PING_TIMEOUT = 5000L;
    private PluginInterface plugin_interface;
    private DHT dht;
    private int contact_num;
    private BloomFilter tried_bloom;
    private LinkedList pending_contacts = new LinkedList();
    private List active_pings = new ArrayList();
    private List new_listeners = new ArrayList();
    private CopyOnWriteList listeners = new CopyOnWriteList();

    public DHTSpeedTesterImpl(DHT _dht) {
        this.dht = _dht;
        this.plugin_interface = this.dht.getLogger().getPluginInterface();
        UTTimer timer = this.plugin_interface.getUtilities().createTimer("DHTSpeedTester:finder", true);
        timer.addPeriodicEvent(5000L, new UTTimerEventPerformer(){

            public void perform(UTTimerEvent event2) {
                DHTSpeedTesterImpl.this.findContacts();
            }
        });
        timer.addPeriodicEvent(1000L, new UTTimerEventPerformer(){
            int tick_count;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(UTTimerEvent event2) {
                try {
                    DHTSpeedTesterImpl.this.pingContacts(this.tick_count);
                }
                finally {
                    ++this.tick_count;
                }
            }
        });
    }

    public int getContactNumber() {
        return this.contact_num;
    }

    public void setContactNumber(int number) {
        this.contact_num = number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findContacts() {
        DHTTransportContact[] reachables = this.dht.getTransport().getReachableContacts();
        for (int i = 0; i < reachables.length; ++i) {
            DHTTransportContact contact = reachables[i];
            byte[] address = contact.getAddress().getAddress().getAddress();
            if (this.tried_bloom == null || this.tried_bloom.getEntryCount() > 500) {
                this.tried_bloom = BloomFilterFactory.createAddOnly(4096);
            }
            if (this.tried_bloom.contains(address)) continue;
            this.tried_bloom.add(address);
            LinkedList linkedList = this.pending_contacts;
            synchronized (linkedList) {
                potentialPing ping = new potentialPing(contact, DHTNetworkPositionManager.estimateRTT(contact.getNetworkPositions(), this.dht.getTransport().getLocalContact().getNetworkPositions()));
                this.pending_contacts.add(0, ping);
                if (this.pending_contacts.size() > 60) {
                    this.pending_contacts.removeLast();
                }
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pingContacts(int tick_count) {
        ArrayList copy = null;
        List list = this.new_listeners;
        synchronized (list) {
            if (this.new_listeners.size() > 0) {
                copy = new ArrayList(this.new_listeners);
                this.new_listeners.clear();
            }
        }
        if (copy != null) {
            for (int i = 0; i < copy.size(); ++i) {
                DHTSpeedTesterListener listener = (DHTSpeedTesterListener)copy.get(i);
                this.listeners.add(listener);
                for (int j = 0; j < this.active_pings.size(); ++j) {
                    activePing ping = (activePing)this.active_pings.get(j);
                    if (!ping.isInformedAlive()) continue;
                    try {
                        listener.contactAdded(ping);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        Iterator pit = this.active_pings.iterator();
        pingInstanceSet ping_set = new pingInstanceSet(true);
        while (pit.hasNext()) {
            activePing ping = (activePing)pit.next();
            if (ping.update(ping_set, tick_count) && !ping.isInformedAlive()) {
                ping.setInformedAlive();
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    try {
                        ((DHTSpeedTesterListener)it.next()).contactAdded(ping);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
            if (!ping.isDead()) continue;
            pit.remove();
            ping.informDead();
        }
        ping_set.setFull();
        int num_active = this.active_pings.size();
        if (num_active < this.contact_num) {
            TreeSet pc = new TreeSet(new Comparator(){

                public int compare(Object o1, Object o2) {
                    potentialPing p1 = (potentialPing)o1;
                    potentialPing p2 = (potentialPing)o2;
                    return p1.getRTT() - p2.getRTT();
                }
            });
            LinkedList e = this.pending_contacts;
            synchronized (e) {
                pc.addAll(this.pending_contacts);
            }
            Iterator it = pc.iterator();
            if (pc.size() >= 3) {
                ArrayList<potentialPing> pps = new ArrayList<potentialPing>();
                for (int i = 0; i < 3; ++i) {
                    potentialPing pp = (potentialPing)it.next();
                    pps.add(pp);
                    it.remove();
                    LinkedList linkedList = this.pending_contacts;
                    synchronized (linkedList) {
                        this.pending_contacts.remove(pp);
                        continue;
                    }
                }
                this.active_pings.add(new activePing(pps));
            }
        } else if (num_active > this.contact_num) {
            for (int i = 0; i < num_active - this.contact_num; ++i) {
                ((activePing)this.active_pings.get(i)).destroy();
            }
        }
    }

    protected void informResults(DHTSpeedTesterContact[] contacts, int[] rtts) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((DHTSpeedTesterListener)it.next()).resultGroup(contacts, rtts);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(DHTSpeedTesterListener listener) {
        List list = this.new_listeners;
        synchronized (list) {
            this.new_listeners.add(listener);
        }
    }

    public void removeListener(DHTSpeedTesterListener listener) {
        this.listeners.remove(listener);
    }

    protected class pingInstanceSet {
        private boolean active;
        private int instances;
        private boolean full;
        List results = new ArrayList();

        protected pingInstanceSet(boolean _active) {
            this.active = _active;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void add(pingInstance instance) {
            pingInstanceSet pingInstanceSet2 = this;
            synchronized (pingInstanceSet2) {
                ++this.instances;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setFull() {
            pingInstanceSet pingInstanceSet2 = this;
            synchronized (pingInstanceSet2) {
                this.full = true;
                if (this.results.size() == this.instances) {
                    this.sendResult();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void complete(pingInstance instance) {
            pingInstanceSet pingInstanceSet2 = this;
            synchronized (pingInstanceSet2) {
                this.results.add(instance);
                if (this.results.size() == this.instances && this.full) {
                    this.sendResult();
                }
            }
        }

        protected void sendResult() {
            if (this.active && this.results.size() > 0) {
                DHTSpeedTesterContact[] contacts = new DHTSpeedTesterContact[this.results.size()];
                int[] rtts = new int[contacts.length];
                for (int i = 0; i < contacts.length; ++i) {
                    pingInstance pi = (pingInstance)this.results.get(i);
                    contacts[i] = pi.getContact();
                    rtts[i] = pi.getResult();
                }
                DHTSpeedTesterImpl.this.informResults(contacts, rtts);
            }
        }
    }

    protected class pingInstance {
        private activePing contact;
        private pingInstanceSet set;
        private int result;

        protected pingInstance(pingInstanceSet _set) {
            this.set = _set;
            this.set.add(this);
        }

        protected activePing getContact() {
            return this.contact;
        }

        protected int getResult() {
            return this.result;
        }

        protected void setResult(activePing _contact, int _result) {
            this.contact = _contact;
            this.result = _result;
            this.set.complete(this);
        }
    }

    protected class activePing
    implements DHTSpeedTesterContact {
        private boolean running;
        private boolean dead;
        private boolean informed_alive;
        private int outstanding;
        private int best_ping = Integer.MAX_VALUE;
        private DHTTransportContact best_pingee;
        private int consec_fails;
        private int total_ok;
        private int total_fails;
        private int period = 5;
        private CopyOnWriteList listeners = new CopyOnWriteList();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected activePing(List candidates) {
            String str = "";
            pingInstanceSet ping_set = new pingInstanceSet(false);
            activePing activePing2 = this;
            synchronized (activePing2) {
                for (int i = 0; i < candidates.size(); ++i) {
                    potentialPing pp = (potentialPing)candidates.get(i);
                    str = str + (i == 0 ? "" : ",") + pp.getContact().getString() + "/" + pp.getRTT();
                    this.ping(ping_set, pp.getContact());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean update(pingInstanceSet ping_set, int tick_count) {
            activePing activePing2 = this;
            synchronized (activePing2) {
                if (this.dead || !this.running || this.outstanding > 0) {
                    return false;
                }
                if (this.best_pingee == null) {
                    this.dead = true;
                    return false;
                }
            }
            if (tick_count % this.period == 0) {
                this.ping(ping_set, this.best_pingee);
            }
            return true;
        }

        protected void ping(pingInstanceSet ping_set, DHTTransportContact contact) {
            final pingInstance pi = new pingInstance(ping_set);
            ++this.outstanding;
            try {
                contact.sendImmediatePing(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void pingReply(DHTTransportContact contact) {
                        int rtt = this.getElapsed();
                        try {
                            activePing activePing2 = activePing.this;
                            synchronized (activePing2) {
                                activePing.this.outstanding--;
                                if (!activePing.this.running) {
                                    if (rtt < activePing.this.best_ping) {
                                        activePing.this.best_pingee = contact;
                                        activePing.this.best_ping = rtt;
                                    }
                                    if (activePing.this.outstanding == 0) {
                                        activePing.this.running = true;
                                    }
                                } else {
                                    activePing.this.total_ok++;
                                    activePing.this.consec_fails = 0;
                                }
                            }
                            Iterator it = activePing.this.listeners.iterator();
                            while (it.hasNext()) {
                                try {
                                    ((DHTSpeedTesterContactListener)it.next()).ping(activePing.this, this.getElapsed());
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                        finally {
                            pi.setResult(activePing.this, rtt);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact contact, Throwable error) {
                        try {
                            activePing activePing2 = activePing.this;
                            synchronized (activePing2) {
                                activePing.this.outstanding--;
                                if (!activePing.this.running) {
                                    if (activePing.this.outstanding == 0) {
                                        activePing.this.running = true;
                                    }
                                } else {
                                    activePing.this.consec_fails++;
                                    activePing.this.total_fails++;
                                    if (activePing.this.consec_fails == 3) {
                                        activePing.this.dead = true;
                                    } else if (activePing.this.total_ok > 10 && activePing.this.total_fails > 0 && activePing.this.total_ok / activePing.this.total_fails < 1) {
                                        activePing.this.dead = true;
                                    } else if (activePing.this.total_ok > 100) {
                                        activePing.this.total_ok = 0;
                                        activePing.this.total_fails = 0;
                                    }
                                }
                            }
                            if (!activePing.this.dead) {
                                Iterator it = activePing.this.listeners.iterator();
                                while (it.hasNext()) {
                                    try {
                                        ((DHTSpeedTesterContactListener)it.next()).pingFailed(activePing.this);
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                            }
                        }
                        finally {
                            pi.setResult(activePing.this, -1);
                        }
                    }
                }, 5000L);
            }
            catch (Throwable e) {
                pi.setResult(this, -1);
                this.dead = true;
                --this.outstanding;
                Debug.printStackTrace(e);
            }
        }

        public void destroy() {
            this.dead = true;
        }

        protected boolean isDead() {
            return this.dead;
        }

        protected boolean isInformedAlive() {
            return this.informed_alive;
        }

        protected void setInformedAlive() {
            this.informed_alive = true;
        }

        protected void informDead() {
            if (this.informed_alive) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    try {
                        ((DHTSpeedTesterContactListener)it.next()).contactDied(this);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }

        public DHTTransportContact getContact() {
            return this.best_pingee;
        }

        public int getPingPeriod() {
            return this.period;
        }

        public void setPingPeriod(int _period) {
            this.period = _period;
        }

        public void addListener(DHTSpeedTesterContactListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(DHTSpeedTesterContactListener listener) {
            this.listeners.remove(listener);
        }
    }

    protected class potentialPing {
        private DHTTransportContact contact;
        private int rtt;

        protected potentialPing(DHTTransportContact _contact, float _rtt) {
            this.contact = _contact;
            this.rtt = (int)(Float.isNaN(_rtt) ? 1000.0 : (double)_rtt);
        }

        protected DHTTransportContact getContact() {
            return this.contact;
        }

        protected int getRTT() {
            return this.rtt;
        }
    }
}

