/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DHTUDPPacketReplyFindNode
extends DHTUDPPacketReply {
    private DHTTransportContact[] contacts;
    private int random_id;
    private int node_status = -1;
    private int estimated_dht_size;

    public DHTUDPPacketReplyFindNode(DHTTransportUDPImpl transport, int trans_id, long conn_id, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1029, trans_id, conn_id, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyFindNode(DHTUDPPacketNetworkHandler network_handler, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, is, 1029, trans_id);
        if (this.getProtocolVersion() >= 7) {
            this.random_id = is.readInt();
        }
        if (this.getProtocolVersion() >= 12) {
            this.node_status = is.readInt();
        }
        if (this.getProtocolVersion() >= 13) {
            this.estimated_dht_size = is.readInt();
        }
        if (this.getProtocolVersion() >= 10) {
            DHTUDPUtils.deserialiseVivaldi(this, is);
        }
        this.contacts = DHTUDPUtils.deserialiseContacts(this.getTransport(), is);
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.getProtocolVersion() >= 7) {
            os.writeInt(this.random_id);
        }
        if (this.getProtocolVersion() >= 12) {
            os.writeInt(this.node_status);
        }
        if (this.getProtocolVersion() >= 13) {
            os.writeInt(this.estimated_dht_size);
        }
        if (this.getProtocolVersion() >= 10) {
            DHTUDPUtils.serialiseVivaldi(this, os);
        }
        DHTUDPUtils.serialiseContacts(os, this.contacts);
    }

    protected void setContacts(DHTTransportContact[] _contacts) {
        this.contacts = _contacts;
    }

    protected void setRandomID(int _random_id) {
        this.random_id = _random_id;
    }

    protected int getRandomID() {
        return this.random_id;
    }

    protected void setNodeStatus(int ns) {
        this.node_status = ns;
    }

    protected int getNodeStatus() {
        return this.node_status;
    }

    protected void setEstimatedDHTSize(int s) {
        this.estimated_dht_size = s;
    }

    protected int getEstimatedDHTSize() {
        return this.estimated_dht_size;
    }

    protected DHTTransportContact[] getContacts() {
        return this.contacts;
    }

    public String getString() {
        return super.getString() + ",contacts=" + (this.contacts == null ? "null" : "" + this.contacts.length);
    }
}

