/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessCompact;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccessLinear;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.File;
import java.io.RandomAccessFile;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class FMFileAccessController
implements FMFileAccess {
    private FMFileImpl owner;
    private int type = 1;
    private File control_file;
    private FMFileAccess file_access;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected FMFileAccessController(FMFileImpl _file, int _target_type) throws FMFileManagerException {
        this.owner = _file;
        this.control_file = this.getControlFile();
        if (this.control_file == null) {
            if (_target_type != 1) throw new FMFileManagerException("Compact storage not supported: no control file available");
            this.file_access = new FMFileAccessLinear(this.owner);
            return;
        } else {
            boolean control_file_existed = this.control_file.exists();
            this.type = control_file_existed ? 2 : 1;
            this.file_access = this.type == 1 ? new FMFileAccessLinear(this.owner) : new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_file, new FMFileAccessLinear(this.owner));
            if (this.type == _target_type) return;
            this.convert(_target_type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void convert(int target_type) throws FMFileManagerException {
        File file = this.owner.getLinkedFile();
        RandomAccessFile raf = null;
        boolean ok = false;
        FMFileAccess target_access = target_type == 1 ? new FMFileAccessLinear(this.owner) : new FMFileAccessCompact(this.owner.getOwner().getTorrentFile(), this.control_file, new FMFileAccessLinear(this.owner));
        if (file.exists()) {
            raf = new RandomAccessFile(file, "rwd");
            FMFileAccessCompact compact_access = target_type == 1 ? (FMFileAccessCompact)this.file_access : (FMFileAccessCompact)target_access;
            long length = this.file_access.getLength(raf);
            long last_piece_start = compact_access.getLastPieceStart();
            long last_piece_length = compact_access.getLastPieceLength();
            if (last_piece_length > 0L && length > last_piece_start) {
                long data_length = length - last_piece_start;
                if (data_length > last_piece_length) {
                    Debug.out("data length inconsistent: len=" + data_length + ",limit=" + last_piece_length);
                    data_length = last_piece_length;
                }
                DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)25, (int)data_length);
                try {
                    this.file_access.read(raf, new DirectByteBuffer[]{buffer}, last_piece_start);
                    if (target_type == 2) {
                        long first_piece_length = compact_access.getFirstPieceLength();
                        long physical_length = raf.length();
                        if (physical_length > first_piece_length) {
                            raf.setLength(first_piece_length);
                        }
                    }
                    buffer.flip((byte)25);
                    target_access.write(raf, new DirectByteBuffer[]{buffer}, last_piece_start);
                }
                finally {
                    buffer.returnToPool();
                }
            } else if (target_type == 2) {
                long first_piece_length = compact_access.getFirstPieceLength();
                long physical_length = raf.length();
                if (physical_length > first_piece_length) {
                    raf.setLength(first_piece_length);
                }
            }
            target_access.setLength(raf, length);
            target_access.flush();
        }
        this.type = target_type;
        this.file_access = target_access;
        ok = true;
        Object var22_18 = null;
        try {
            if (raf == null) return;
            try {
                raf.close();
                return;
            }
            catch (Throwable e) {
                if (!ok) return;
                ok = false;
                throw new FMFileManagerException("convert fails", e);
            }
        }
        finally {
            if (!ok) {
                this.type = 1;
                this.file_access = new FMFileAccessLinear(this.owner);
            }
            if (this.type == 1) {
                this.control_file.delete();
            }
        }
        {
            catch (Throwable e) {
                Debug.printStackTrace(e);
                throw new FMFileManagerException("convert fails", e);
            }
        }
        catch (Throwable throwable) {
            Object var22_19 = null;
            try {
                if (raf == null) throw throwable;
                try {
                    raf.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    if (!ok) throw throwable;
                    ok = false;
                    throw new FMFileManagerException("convert fails", e);
                }
            }
            finally {
                if (!ok) {
                    this.type = 1;
                    this.file_access = new FMFileAccessLinear(this.owner);
                }
                if (this.type == 1) {
                    this.control_file.delete();
                }
            }
        }
    }

    protected File getControlFile() {
        TOTorrentFile tf = this.owner.getOwner().getTorrentFile();
        if (tf == null) {
            return null;
        }
        TOTorrent torrent = tf.getTorrent();
        TOTorrentFile[] files = torrent.getFiles();
        int file_index = -1;
        for (int i = 0; i < files.length; ++i) {
            if (files[i] != tf) continue;
            file_index = i;
            break;
        }
        if (file_index == -1) {
            Debug.out("File '" + this.owner.getName() + "' not found in torrent!");
            return null;
        }
        File control = this.owner.getOwner().getControlFile("fmfile" + file_index + ".dat");
        return control;
    }

    public void setStorageType(int new_type) throws FMFileManagerException {
        if (new_type == this.type) {
            return;
        }
        this.convert(new_type);
    }

    public int getStorageType() {
        return this.type;
    }

    public long getLength(RandomAccessFile raf) throws FMFileManagerException {
        return this.file_access.getLength(raf);
    }

    public void setLength(RandomAccessFile raf, long length) throws FMFileManagerException {
        this.file_access.setLength(raf, length);
    }

    public void read(RandomAccessFile raf, DirectByteBuffer[] buffers, long offset) throws FMFileManagerException {
        this.file_access.read(raf, buffers, offset);
    }

    public void write(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        this.file_access.write(raf, buffers, position);
    }

    public void flush() throws FMFileManagerException {
        this.file_access.flush();
    }

    public String getString() {
        return "type=" + this.type + ",acc=" + this.file_access.getString();
    }
}

