/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;

public class DownloadManagerEnhancer {
    private static DownloadManagerEnhancer singleton;
    private AzureusCore core;
    private Map download_map = new HashMap();
    private boolean progressive_enabled;

    public static synchronized void initialise(AzureusCore core) {
        singleton = new DownloadManagerEnhancer(core);
    }

    public static synchronized DownloadManagerEnhancer getSingleton() {
        return singleton;
    }

    protected DownloadManagerEnhancer(AzureusCore _core) {
        this.core = _core;
        this.core.getGlobalManager().addListener(new GlobalManagerListener(){

            public void downloadManagerAdded(DownloadManager dm) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void downloadManagerRemoved(DownloadManager dm) {
                Map map = DownloadManagerEnhancer.this.download_map;
                synchronized (map) {
                    DownloadManagerEnhancer.this.download_map.remove(dm);
                }
            }

            public void destroyInitiated() {
            }

            public void destroyed() {
            }

            public void seedingStatusChanged(boolean seeding_only_mode) {
            }
        });
        final PluginInterface plugin_interface = this.core.getPluginManager().getDefaultPluginInterface();
        plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                PluginInterface ms_pi = plugin_interface.getPluginManager().getPluginInterfaceByID("aeupnpmediaserver");
                if (ms_pi != null) {
                    DownloadManagerEnhancer.this.progressive_enabled = true;
                } else {
                    System.out.println("No MediaServer plugin found");
                }
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EnhancedDownloadManager getEnhancedDownload(DownloadManager manager) {
        Map map = this.download_map;
        synchronized (map) {
            EnhancedDownloadManager res = (EnhancedDownloadManager)this.download_map.get(manager);
            if (res == null) {
                res = new EnhancedDownloadManager(this, manager);
                this.download_map.put(manager, res);
            }
            return res;
        }
    }

    protected boolean isProgressiveAvailable() {
        return this.progressive_enabled;
    }
}

