/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.download;

import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePriorityProvider;
import com.aelitis.azureus.core.peermanager.piecepicker.PieceRTAProvider;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import java.util.List;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPiece;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.SystemTime;

public class EnhancedDownloadManager {
    public static final int MINIMUM_INITIAL_BUFFER_SECS = 30;
    private DownloadManagerEnhancer enhancer;
    private DownloadManager download_manager;
    private transient PiecePicker current_piece_pickler;
    private long last_eta_result = Long.MAX_VALUE;
    private long last_eta_time;
    private boolean progressive_active = false;
    private long content_bps;
    private int initial_buffer_pieces;
    private bufferETAProvider buffer_provider = new bufferETAProvider();
    private boostETAProvider boost_provider = new boostETAProvider();

    protected EnhancedDownloadManager(DownloadManagerEnhancer _enhancer, DownloadManager _download_manager) {
        this.enhancer = _enhancer;
        this.download_manager = _download_manager;
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent != null) {
            this.content_bps = PlatformTorrentUtils.getContentSpeedBps(torrent);
            if (this.content_bps == 0L) {
                long size = torrent.getSize();
                this.content_bps = size < 0xC800000L ? 30720L : (size < 1048576000L ? 204800L : 409600L);
            }
            long initial_bytes = 30L * this.content_bps;
            this.initial_buffer_pieces = (int)(initial_bytes / torrent.getPieceLength());
            this.initial_buffer_pieces = Math.min(this.initial_buffer_pieces, torrent.getNumberOfPieces());
        }
        this.download_manager.addPeerListener(new DownloadManagerPeerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerAdded(PEPeerManager manager) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    EnhancedDownloadManager.this.current_piece_pickler = manager.getPiecePicker();
                    if (EnhancedDownloadManager.this.progressive_active && EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.boost_provider.activate(EnhancedDownloadManager.this.current_piece_pickler);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void peerManagerRemoved(PEPeerManager manager) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (EnhancedDownloadManager.this.current_piece_pickler != null) {
                        EnhancedDownloadManager.this.buffer_provider.deactivate(EnhancedDownloadManager.this.current_piece_pickler);
                        EnhancedDownloadManager.this.current_piece_pickler = null;
                    }
                }
            }

            public void peerAdded(PEPeer peer) {
            }

            public void peerRemoved(PEPeer peer) {
            }

            public void pieceAdded(PEPiece piece) {
            }

            public void pieceRemoved(PEPiece piece) {
            }
        });
    }

    public boolean supportsProgressiveMode() {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return false;
        }
        return this.content_bps > 0L && this.enhancer.isProgressiveAvailable() && PlatformTorrentUtils.isContentProgressive(torrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProgressiveMode(boolean active) {
        TOTorrent torrent = this.download_manager.getTorrent();
        if (torrent == null) {
            return;
        }
        EnhancedDownloadManager enhancedDownloadManager = this;
        synchronized (enhancedDownloadManager) {
            if (this.progressive_active == active) {
                return;
            }
            if (this.current_piece_pickler != null) {
                this.progressive_active = active;
                if (this.progressive_active) {
                    this.buffer_provider.activate(this.current_piece_pickler);
                    this.boost_provider.activate(this.current_piece_pickler);
                } else {
                    this.buffer_provider.deactivate(this.current_piece_pickler);
                    this.boost_provider.deactivate(this.current_piece_pickler);
                }
            }
        }
    }

    public boolean getProgressiveMode() {
        return this.progressive_active;
    }

    public long getProgressivePlayETA() {
        PiecePicker picker;
        long now = SystemTime.getCurrentTime();
        if (now > this.last_eta_time && now - this.last_eta_time < 1000L) {
            return this.last_eta_result;
        }
        long dl_rate = this.download_manager.getStats().getDataReceiveRate();
        long result = Long.MAX_VALUE;
        DiskManager disk_manager = this.download_manager.getDiskManager();
        if (dl_rate > 0L && this.content_bps > 0L && disk_manager != null && (picker = this.current_piece_pickler) != null) {
            List providers = picker.getRTAProviders();
            long max_cp = 0L;
            long max_bp = 0L;
            for (int i = 0; i < providers.size(); ++i) {
                PieceRTAProvider provider = (PieceRTAProvider)providers.get(i);
                long cp = provider.getCurrentPosition();
                if (cp < max_cp) continue;
                max_cp = cp;
                max_bp = provider.getBlockingPosition();
            }
            long secs_pos = max_cp / this.content_bps;
            long secs_to_watch = (disk_manager.getTotalLength() - max_cp) / this.content_bps;
            long secs_to_download = disk_manager.getRemainingExcludingDND() / dl_rate;
            result = secs_to_download - secs_to_watch;
        }
        this.last_eta_result = result;
        this.last_eta_time = now;
        return result;
    }

    protected class boostETAProvider
    implements PiecePriorityProvider {
        private long[] piece_priorities;
        private long last_recalc;

        protected boostETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                picker.addPriorityProvider(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                picker.removePriorityProvider(this);
                this.piece_priorities = null;
            }
        }

        public long[] updatePriorities(PiecePicker picker) {
            long now = SystemTime.getCurrentTime();
            if (now < this.last_recalc || now - this.last_recalc > 5000L) {
                this.last_recalc = now;
                long stream_delay = EnhancedDownloadManager.this.getProgressivePlayETA();
                DiskManager disk_manager = EnhancedDownloadManager.this.download_manager.getDiskManager();
                if (stream_delay <= 0L || disk_manager == null) {
                    this.piece_priorities = null;
                } else {
                    long dl_rate = EnhancedDownloadManager.this.download_manager.getStats().getDataReceiveRate();
                    if (dl_rate > 0L && EnhancedDownloadManager.this.content_bps > 0L) {
                        long secs_to_watch = disk_manager.getTotalLength() / EnhancedDownloadManager.this.content_bps;
                        long secs_to_download = disk_manager.getRemainingExcludingDND() / dl_rate;
                        long delay = secs_to_download - secs_to_watch;
                        if (delay <= 0L) {
                            this.piece_priorities = null;
                        } else {
                            int num_pieces;
                            long bytes_to_boost = delay * EnhancedDownloadManager.this.content_bps;
                            long pieces_to_boost = (bytes_to_boost + (long)disk_manager.getPieceLength() - 1L) / (long)disk_manager.getPieceLength();
                            if (pieces_to_boost >= (long)(num_pieces = picker.getNumberOfPieces())) {
                                this.piece_priorities = null;
                            } else {
                                this.piece_priorities = new long[num_pieces];
                                int i = 0;
                                while ((long)i < pieces_to_boost) {
                                    this.piece_priorities[i] = 20000L;
                                    ++i;
                                }
                            }
                        }
                    } else {
                        this.piece_priorities = null;
                    }
                }
            }
            return this.piece_priorities;
        }
    }

    protected class bufferETAProvider
    implements PieceRTAProvider {
        private long[] piece_rtas;

        protected bufferETAProvider() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void activate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                this.piece_rtas = new long[picker.getNumberOfPieces()];
                long now = SystemTime.getCurrentTime();
                for (int i = 0; i < EnhancedDownloadManager.this.initial_buffer_pieces; ++i) {
                    this.piece_rtas[i] = now + (long)i;
                }
                picker.addRTAProvider(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deactivate(PiecePicker picker) {
            EnhancedDownloadManager enhancedDownloadManager = EnhancedDownloadManager.this;
            synchronized (enhancedDownloadManager) {
                picker.removeRTAProvider(this);
                this.piece_rtas = null;
            }
        }

        public long[] updateRTAs(PiecePicker picker) {
            DiskManager dm = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (dm != null) {
                DiskManagerPiece[] pieces = dm.getPieces();
                boolean all_done = true;
                for (int i = 0; i < EnhancedDownloadManager.this.initial_buffer_pieces; ++i) {
                    if (pieces[i].isDone()) continue;
                    all_done = false;
                    break;
                }
                if (all_done) {
                    this.deactivate(picker);
                }
            }
            return this.piece_rtas;
        }

        public long getCurrentPosition() {
            return 0L;
        }

        public long getBlockingPosition() {
            DiskManager dm = EnhancedDownloadManager.this.download_manager.getDiskManager();
            if (dm == null) {
                return 0L;
            }
            DiskManagerPiece[] pieces = dm.getPieces();
            for (int i = 0; i < pieces.length; ++i) {
                DiskManagerPiece piece = pieces[i];
                if (piece.isDone()) continue;
                long complete = i * dm.getPieceLength();
                boolean[] written = piece.getWritten();
                if (written == null) {
                    complete += (long)piece.getLength();
                } else {
                    int j = 0;
                    if (j < written.length && written[j]) {
                        complete += (long)piece.getBlockSize(j);
                    }
                }
                return complete;
            }
            return dm.getTotalLength();
        }
    }
}

