/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.ui.swt.browser.msg.MessageDispatcher;
import com.aelitis.azureus.ui.swt.browser.msg.MessageListener;
import com.aelitis.azureus.ui.swt.browser.txn.Transaction;
import com.aelitis.azureus.ui.swt.browser.txn.TransactionManager;
import com.aelitis.azureus.util.Constants;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;

public abstract class ClientMessageContextImpl
implements ClientMessageContext {
    private String id;
    private MessageDispatcher dispatcher;
    private TransactionManager txnManager;

    public ClientMessageContextImpl(String id) {
        this.id = id;
        this.dispatcher = new MessageDispatcher(this);
        this.txnManager = new TransactionManager(this);
    }

    public void addMessageListener(MessageListener listener) {
        this.dispatcher.addListener(listener);
    }

    public Transaction cancelTransaction(String type) {
        return this.txnManager.cancelTransaction(type);
    }

    public void debug(String message) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.CMsgr");
        diag_logger.log("[" + this.id + "] " + message);
        if (Constants.DIAG_TO_STDOUT) {
            System.out.println("[" + this.id + "] " + message);
        }
    }

    public void debug(String message, Throwable t) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.CMsgr");
        diag_logger.log("[" + this.id + "] " + message);
        diag_logger.log(t);
        if (Constants.DIAG_TO_STDOUT) {
            System.err.println("[" + this.id + "] " + message);
            t.printStackTrace();
        }
    }

    public Transaction getTransaction(String type) {
        return this.txnManager.getTransaction(type);
    }

    public TransactionManager getTransactionManager() {
        return this.txnManager;
    }

    public void registerTransactionType(String type, Class clazz) {
        this.txnManager.registerTransactionType(type, clazz);
    }

    public void removeMessageListener(String listenerId) {
        this.dispatcher.removeListener(listenerId);
    }

    public void removeMessageListener(MessageListener listener) {
        this.dispatcher.removeListener(listener);
    }

    public Transaction startTransaction(String type) {
        return this.txnManager.startTransaction(type);
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.dispatcher;
    }

    public String getID() {
        return this.id;
    }
}

