/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.SystemTime;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlatformMessage {
    private final String messageID;
    private final String listenerID;
    private final String operationID;
    private final JSONObject parameters;
    private final long fireBeforeDate;
    private final long messageCreatedOn;
    private long lSequenceNo = -1L;

    public PlatformMessage(String messageID, String listenerID, String operationID, JSONObject parameters, long maxDelayMS) {
        this.messageID = messageID;
        this.listenerID = listenerID;
        this.operationID = operationID;
        this.parameters = parameters;
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + maxDelayMS;
    }

    public PlatformMessage(String messageID, String listenerID, String operationID, Map parameters, long maxDelayMS) {
        this.messageID = messageID;
        this.listenerID = listenerID;
        this.operationID = operationID;
        this.parameters = new JSONObject(parameters);
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + maxDelayMS;
    }

    public PlatformMessage(String messageID, String listenerID, String operationID, Object[] parameters, long maxDelayMS) {
        this.messageID = messageID;
        this.listenerID = listenerID;
        this.operationID = operationID;
        this.parameters = PlatformMessage.parseParams(parameters);
        this.messageCreatedOn = SystemTime.getCurrentTime();
        this.fireBeforeDate = this.messageCreatedOn + maxDelayMS;
    }

    public static JSONObject parseParams(Object[] parameters) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < parameters.length - 1; i += 2) {
            if (!(parameters[i] instanceof String)) continue;
            if (parameters[i + 1] instanceof String[]) {
                List<String> list = Arrays.asList((String[])parameters[i + 1]);
                result.put((String)parameters[i], new JSONArray(list));
                continue;
            }
            if (parameters[i + 1] instanceof Object[]) {
                result.put((String)parameters[i], PlatformMessage.parseParams((Object[])parameters[i + 1]));
                continue;
            }
            if (parameters[i + 1] instanceof Map) {
                result.put((String)parameters[i], (Map)parameters[i + 1]);
                continue;
            }
            result.put((String)parameters[i], parameters[i + 1]);
        }
        return result;
    }

    public long getFireBefore() {
        return this.fireBeforeDate;
    }

    public long getMessageCreated() {
        return this.messageCreatedOn;
    }

    public JSONObject getParameters() {
        return this.parameters;
    }

    public String getListenerID() {
        return this.listenerID;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public String getOperationID() {
        return this.operationID;
    }

    protected long getSequenceNo() {
        return this.lSequenceNo;
    }

    protected void setSequenceNo(long sequenceNo) {
        this.lSequenceNo = sequenceNo;
    }

    public String toString() {
        return "PlaformMessage {" + this.lSequenceNo + ", " + this.messageID + ", " + this.listenerID + ", " + this.operationID + "," + this.parameters + "}";
    }
}

