/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContextImpl;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.msg.BrowserMessage;
import com.aelitis.azureus.ui.swt.browser.msg.MessageCompletionListener;
import com.aelitis.azureus.util.Constants;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONString;
import org.json.JSONTokener;

public class PlatformMessenger {
    private static boolean USE_HTTP_POST = true;
    public static String REPLY_EXCEPTION = "exception";
    public static String REPLY_ACTION = "action";
    public static String REPLY_RESULT = "response";
    private static Map mapQueue = new HashMap();
    private static AEMonitor queue_mon = new AEMonitor("v3.PlatformMessenger.queue");
    private static Timer timerProcess = new Timer("v3.PlatformMessenger.queue");
    private static TimerEvent timerEvent = null;
    private static boolean initialized;
    private static fakeContext context;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        context = new fakeContext();
        context.addMessageListener(new TorrentListener());
        context.addMessageListener(new DisplayListener(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueMessage(PlatformMessage message, PlatformMessengerListener listener) {
        if (!initialized) {
            PlatformMessenger.init();
        }
        PlatformMessenger.debug("q msg " + message + " for " + new Date(message.getFireBefore()));
        queue_mon.enter();
        try {
            mapQueue.put(message, listener);
            if (timerEvent == null || timerEvent.hasRun()) {
                timerEvent = timerProcess.addEvent(message.getFireBefore(), new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        timerEvent = null;
                        PlatformMessenger.processQueue();
                    }
                });
            } else if (message.getFireBefore() < timerEvent.getWhen()) {
                timerProcess.adjustAllBy(message.getFireBefore() - timerEvent.getWhen());
            }
        }
        finally {
            queue_mon.exit();
        }
    }

    private static void debug(String string) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.PMsgr");
        diag_logger.log(string);
        if (Constants.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processQueue() {
        String sURL;
        if (!initialized) {
            PlatformMessenger.init();
        }
        final HashMap mapProcessing = new HashMap();
        queue_mon.enter();
        try {
            mapProcessing.putAll(mapQueue);
            mapQueue.clear();
        }
        finally {
            queue_mon.exit();
        }
        PlatformMessenger.debug("about to process " + mapProcessing.size());
        String urlStem = "";
        long sequenceNo = 0L;
        Iterator iter = mapProcessing.keySet().iterator();
        while (iter.hasNext()) {
            PlatformMessage message = (PlatformMessage)iter.next();
            message.setSequenceNo(sequenceNo);
            if (sequenceNo > 0L) {
                urlStem = urlStem + "&";
            }
            try {
                urlStem = urlStem + "cmd=" + URLEncoder.encode("AZMSG;" + sequenceNo + ";" + message.getListenerID() + ";" + message.getOperationID() + ";" + message.getParameters().toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            PlatformMessengerListener listener = (PlatformMessengerListener)mapProcessing.get(message);
            if (listener != null) {
                listener.messageSent(message);
            }
            ++sequenceNo;
        }
        String sPostData = null;
        if (USE_HTTP_POST) {
            sURL = Constants.URL_PREFIX + "app";
            sPostData = "service=rpc&" + urlStem + "&" + Constants.URL_SUFFIX + "\n";
            PlatformMessenger.debug("POST: " + sURL + "?" + sPostData);
        } else {
            sURL = Constants.URL_PREFIX + "app?service=rpc" + "&" + urlStem + "&" + Constants.URL_SUFFIX;
            PlatformMessenger.debug("GET: " + sURL);
        }
        final String fURL = sURL;
        final String fPostData = sPostData;
        AEThread thread = new AEThread("v3.PlatformMessenger", true){

            public void runSupport() {
                try {
                    PlatformMessenger.processQueueAsync(fURL, fPostData, mapProcessing);
                }
                catch (Exception e) {
                    Debug.out("Error while sending message(s) to Platform", e);
                    Iterator iter = mapProcessing.keySet().iterator();
                    while (iter.hasNext()) {
                        PlatformMessage message = (PlatformMessage)iter.next();
                        PlatformMessengerListener l = (PlatformMessengerListener)mapProcessing.get(message);
                        if (l == null) continue;
                        try {
                            l.replyReceived(message, REPLY_EXCEPTION, e.toString());
                        }
                        catch (Exception e2) {
                            Debug.out("Error while sending replyReceived", e2);
                        }
                    }
                }
            }
        };
        thread.start();
    }

    protected static void processQueueAsync(String sURL, String sData, Map mapProcessing) throws Exception {
        URL url = new URL(sURL);
        AzureusCore core = AzureusCoreFactory.getSingleton();
        PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
        byte[] bytes = PlatformMessenger.downloadURL(pi, url, sData);
        String s = new String(bytes, "UTF8");
        if (s == null || s.length() == 0 || !Character.isDigit(s.charAt(0))) {
            Debug.out("Error while sending message(s) to Platform: reply = " + s);
            Iterator iter = mapProcessing.keySet().iterator();
            while (iter.hasNext()) {
                PlatformMessage message = (PlatformMessage)iter.next();
                PlatformMessengerListener l = (PlatformMessengerListener)mapProcessing.get(message);
                if (l == null) continue;
                try {
                    l.replyReceived(message, REPLY_EXCEPTION, s);
                }
                catch (Exception e2) {
                    Debug.out("Error while sending replyReceived", e2);
                }
            }
            return;
        }
        HashMap<Long, BrowserMessage> mapSeqToBrowserMsg = new HashMap<Long, BrowserMessage>();
        String[] replies = s.split("\\n");
        for (int i = 0; i < replies.length; ++i) {
            String reply = replies[i];
            final String[] replySections = reply.split(";", 3);
            if (replySections.length < 2) continue;
            long sequenceNo = NumberFormat.getInstance().parse(replySections[0]).longValue();
            Object jsonReply = null;
            if (replySections.length == 3) {
                JSONTokener tokener = new JSONTokener(replySections[2]);
                jsonReply = tokener.nextValue();
            }
            PlatformMessage message = null;
            PlatformMessengerListener listener = null;
            Iterator iter = mapProcessing.keySet().iterator();
            while (iter.hasNext()) {
                PlatformMessage potentialMessage = (PlatformMessage)iter.next();
                if (potentialMessage.getSequenceNo() != sequenceNo) continue;
                message = potentialMessage;
                listener = (PlatformMessengerListener)mapProcessing.get(message);
            }
            if (message == null) {
                Debug.out("No message with sequence number " + sequenceNo);
                continue;
            }
            PlatformMessenger.debug("Got a reply! " + reply + "\n\t for " + message.toString());
            final PlatformMessage fMessage = message;
            final PlatformMessengerListener fListener = listener;
            final Object fJSONReply = jsonReply;
            if (i == 0) {
                // empty if block
            }
            if (replySections[1].equals("action") && jsonReply instanceof JSONObject) {
                boolean bRetry;
                JSONObject actionResults = (JSONObject)jsonReply;
                boolean bl = bRetry = actionResults.has("retry-client-message") && actionResults.getBoolean("retry-client-message");
                if (actionResults.has("messages")) {
                    JSONArray array = actionResults.getJSONArray("messages");
                    for (int j = 0; j < array.size(); ++j) {
                        final String sMsg = array.getString(j);
                        PlatformMessenger.debug("handling (" + (bRetry ? " with retry" : " no retry") + "): " + sMsg);
                        final BrowserMessage browserMsg = new BrowserMessage(sMsg);
                        int seq = browserMsg.getSequence();
                        BrowserMessage existingBrowserMsg = (BrowserMessage)mapSeqToBrowserMsg.get(new Long(seq));
                        if (existingBrowserMsg != null) {
                            existingBrowserMsg.addCompletionListener(new MessageCompletionListener(){

                                public void completed(boolean success, Object data) {
                                    PlatformMessenger.debug("got complete for " + sMsg);
                                    if (success) {
                                        PlatformMessenger.queueMessage(fMessage, fListener);
                                    } else if (fListener != null) {
                                        try {
                                            fListener.replyReceived(fMessage, replySections[1], fJSONReply);
                                        }
                                        catch (Exception e2) {
                                            Debug.out("Error while sending replyReceived", e2);
                                        }
                                    }
                                }
                            });
                            continue;
                        }
                        if (bRetry) {
                            mapSeqToBrowserMsg.put(new Long(seq), browserMsg);
                            browserMsg.addCompletionListener(new MessageCompletionListener(){

                                public void completed(boolean success, Object data) {
                                    PlatformMessenger.debug("got complete for " + sMsg + ";" + success);
                                    if (success) {
                                        PlatformMessenger.queueMessage(fMessage, fListener);
                                    } else if (fListener != null) {
                                        try {
                                            fListener.replyReceived(fMessage, replySections[1], fJSONReply);
                                        }
                                        catch (Exception e2) {
                                            Debug.out("Error while sending replyReceived", e2);
                                        }
                                    }
                                }
                            });
                        }
                        new AEThread("v3.Msg.Dispatch"){

                            public void runSupport() {
                                context.getMessageDispatcher().dispatch(browserMsg);
                            }
                        }.start();
                    }
                }
                if (bRetry) continue;
            }
            if (listener == null) continue;
            try {
                listener.replyReceived(message, replySections[1], jsonReply);
                continue;
            }
            catch (Exception e2) {
                Debug.out("Error while sending replyReceived", e2);
            }
        }
        context.getMessageDispatcher().resetSequence();
    }

    private static byte[] downloadURL(PluginInterface pi, URL url, String postData) throws Exception {
        ResourceDownloaderFactory rdf = pi.getUtilities().getResourceDownloaderFactory();
        ResourceDownloader rd = rdf.create(url, postData);
        rd = rdf.getRetryDownloader(rd, 3);
        InputStream is = rd.download();
        int length = is.available();
        byte[] data = new byte[length];
        is.read(data);
        return data;
    }

    private static class fakeContext
    extends ClientMessageContextImpl {
        public fakeContext() {
            super("fakeContext");
        }

        public void deregisterBrowser() {
            this.debug("deregisterBrowser");
        }

        public void displayBrowserMessage(String message) {
            this.debug("displayBrowserMessage");
        }

        public boolean executeInBrowser(String javascript) {
            this.debug("executeInBrowser");
            return false;
        }

        public Object getBrowserData(String key) {
            this.debug("getBrowserData");
            return null;
        }

        public void handleMessage(BrowserMessage message) {
            this.debug("handleMessage");
        }

        public void registerBrowser(Browser browser, Control widgetWaitingIndicator) {
            this.debug("registerBrowser");
        }

        public boolean sendBrowserMessage(String key, String op) {
            this.debug("sendBrowserMessage");
            return false;
        }

        public boolean sendBrowserMessage(String key, String op, JSONString params) {
            this.debug("sendBrowserMessage");
            return false;
        }

        public void setBrowserData(String key, Object value) {
            this.debug("setBrowserData");
        }

        public void widgetDisposed(DisposeEvent event2) {
            this.debug("widgetDisposed");
        }
    }
}

