/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.messenger.config.PlatformRatingMessenger;
import com.aelitis.azureus.util.Constants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.json.JSONObject;

public class Test {
    public void initialize(PluginInterface pi) throws PluginException {
        Constants.initialize(AzureusCoreFactory.getSingleton());
        System.out.println(Constants.URL_SUFFIX);
        PlatformMessenger.init();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("section-type", "browse");
        parameters.put("locale", Locale.getDefault().toString());
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage 0");
        PlatformMessenger.queueMessage(new PlatformMessage("AZMSG", "config", "get-browse-sections", new JSONObject(parameters), 150L), new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Object JSONReply) {
                System.out.println(SystemTime.getCurrentTime() + ": replyRecieved " + message + ";" + replyType + ";" + JSONReply);
            }

            public void messageSent(PlatformMessage message) {
                System.out.println(SystemTime.getCurrentTime() + ": messageSent" + message);
            }
        });
        parameters = new HashMap();
        parameters.put("section-type", "minibrowse");
        parameters.put("locale", Locale.getDefault().toString());
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage 1");
        PlatformMessenger.queueMessage(new PlatformMessage("AZMSG", "config", "get-browse-sections", new JSONObject(parameters), 550L), new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Object JSONReply) {
                System.out.println(SystemTime.getCurrentTime() + ": replyRecieved " + message + ";" + replyType + ";" + JSONReply);
            }

            public void messageSent(PlatformMessage message) {
                System.out.println(SystemTime.getCurrentTime() + ": messageSent" + message);
            }
        });
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage gr");
        PlatformRatingMessenger.getUserRating(new String[]{"content"}, new String[]{"11"}, 500L, new PlatformRatingMessenger.GetRatingReplyListener(){

            public void messageSent() {
                System.out.println(SystemTime.getCurrentTime() + ": r messageSent");
            }

            public void replyReceived(String replyType, PlatformRatingMessenger.GetRatingReply reply) {
                System.out.println(SystemTime.getCurrentTime() + ": replyRecieved " + ";" + replyType + ";" + reply.getMap().size());
                Test.dumpMap(reply.getMap(), "");
            }
        });
        System.out.println(SystemTime.getCurrentTime() + ": queueMessage 3");
        PlatformRatingMessenger.setUserRating("11", 1, 500L, null);
    }

    public static void dumpMap(Map map, String indent) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = map.get(key);
            if (value instanceof Map) {
                System.out.println(key + " - " + ((Map)value).size());
                Test.dumpMap((Map)value, indent + "  ");
            }
            System.out.println(indent + key + ": " + value);
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display, 2144);
        shell.open();
        boolean count = false;
        try {
            AzureusCore core = AzureusCoreFactory.create();
            Test test = new Test();
            test.initialize(core.getPluginManager().getDefaultPluginInterface());
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }
}

