/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.util.Constants;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlatformConfigMessenger {
    public static final String LISTENER_ID = "config";
    public static final String SECTION_TYPE_BIGBROWSE = "browse";
    public static final String SECTION_TYPE_MINIBROWSE = "minibrowse";
    private static String DEFAULT_WHITELIST = "https?://" + Constants.URL_ADDRESS.replaceAll("\\.", "\\\\.") + ":?[0-9]*/" + Constants.URL_NAMESPACE.replaceAll("\\.", "\\\\.") + ".*";
    private static String[] sURLWhiteList = new String[]{DEFAULT_WHITELIST};

    public static void getBrowseSections(String sectionType, long maxDelayMS, final GetBrowseSectionsReplyListener replyListener) {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "get-browse-sections", new Object[]{"section-type", sectionType, "locale", Locale.getDefault().toString()}, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                replyListener.messageSent();
            }

            public void replyReceived(PlatformMessage message, String replyType, Object JSONReply) {
                if (JSONReply instanceof JSONArray) {
                    JSONArray array = (JSONArray)JSONReply;
                    Map[] reply = new HashMap[array.size()];
                    for (int i = 0; i < reply.length; ++i) {
                        reply[i] = array.getJSONObject(i).toMap();
                        String url = (String)reply[i].get("url");
                        if (url == null || url.startsWith("http://")) continue;
                        url = Constants.URL_PREFIX + url;
                        url = url.indexOf(63) < 0 ? url + "?" : url + "&";
                        url = url + Constants.URL_SUFFIX;
                        reply[i].put("url", url);
                    }
                    replyListener.replyReceived(reply);
                } else {
                    replyListener.replyReceived(new Map[0]);
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void login(long maxDelayMS) {
        Object[] params = new Object[]{"version", "2.5.0.4", "locale", Locale.getDefault().toString()};
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "login", params, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void replyReceived(PlatformMessage message, String replyType, Object jsonReply) {
                JSONObject jsonObject;
                if (jsonReply instanceof JSONObject && (jsonObject = (JSONObject)jsonReply).has("url-whitelist")) {
                    JSONArray array = jsonObject.getJSONArray("url-whitelist");
                    String[] sNewWhiteList = new String[array.length() + 1];
                    sNewWhiteList[0] = DEFAULT_WHITELIST;
                    for (int i = 0; i < array.length(); ++i) {
                        String string = array.getString(i);
                        PlatformTorrentUtils.log("v3.login: got whitelist of " + string);
                        sNewWhiteList[i + 1] = string;
                    }
                    PlatformConfigMessenger.access$102(sNewWhiteList);
                }
            }

            public void messageSent(PlatformMessage message) {
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void sendUsageStats(Map stats, long timestamp, PlatformMessengerListener l) {
        try {
            PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "send-usage-stats", new Object[]{"stats", stats, "version", "2.5.0.4", "timestamp", new Long(timestamp)}, 5000L);
            PlatformMessenger.queueMessage(message, l);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static String[] getURLWhitelist() {
        return sURLWhiteList;
    }

    static /* synthetic */ String[] access$102(String[] x0) {
        sURLWhiteList = x0;
        return x0;
    }

    public static interface GetBrowseSectionsReplyListener {
        public void messageSent();

        public void replyReceived(Map[] var1);
    }
}

