/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.json.JSONArray;
import org.json.JSONObject;

public class PlatformRatingMessenger {
    public static final String LISTENER_ID = "rating";
    public static final String OP_GET = "get";
    public static final String OP_SET = "set";
    public static final String RATE_TYPE_CONTENT = "content";

    public static void getUserRating(String[] rateTypes, String[] torrentHashes, long maxDelayMS, final GetRatingReplyListener replyListener) {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "get-user", new Object[]{"rating-type", rateTypes, "torrent-hash", torrentHashes}, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                replyListener.messageSent();
            }

            public void replyReceived(PlatformMessage message, String replyType, Object JSONReply) {
                if (JSONReply instanceof JSONObject) {
                    Map reply = ((JSONObject)JSONReply).toMap();
                    GetRatingReply ratingReply = new GetRatingReply(reply);
                    replyListener.replyReceived(replyType, ratingReply);
                } else {
                    replyListener.replyReceived(replyType, new GetRatingReply(null));
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void getGlobalRating(String[] rateTypes, String[] torrentHashes, long maxDelayMS, final GetRatingReplyListener replyListener) {
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, "get-global", new Object[]{"rating-type", rateTypes, "torrent-hash", torrentHashes}, maxDelayMS);
        PlatformMessengerListener listener = new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                replyListener.messageSent();
            }

            public void replyReceived(PlatformMessage message, String replyType, Object JSONReply) {
                if (JSONReply instanceof JSONObject) {
                    Map reply = ((JSONObject)JSONReply).toMap();
                    GetRatingReply ratingReply = new GetRatingReply(reply);
                    replyListener.replyReceived(replyType, ratingReply);
                } else {
                    replyListener.replyReceived(replyType, new GetRatingReply(null));
                }
            }
        };
        PlatformMessenger.queueMessage(message, listener);
    }

    public static void setUserRating(String torrentHash, int rating, long maxDelayMS, final PlatformMessengerListener l) {
        JSONArray array = new JSONArray();
        array.put(PlatformMessage.parseParams(new Object[]{"rating-type", RATE_TYPE_CONTENT, "rating-value", new Integer(rating)}));
        PlatformMessage message = new PlatformMessage("AZMSG", LISTENER_ID, OP_SET, new Object[]{"torrent-hash", torrentHash, "ratings", array}, maxDelayMS);
        PlatformMessenger.queueMessage(message, new PlatformMessengerListener(){

            public void messageSent(PlatformMessage message) {
                System.out.println(SystemTime.getCurrentTime() + ": messageSent" + message);
                if (l != null) {
                    l.messageSent(message);
                }
            }

            public void replyReceived(PlatformMessage message, String replyType, Object jsonReply) {
                System.out.println(SystemTime.getCurrentTime() + ": replyRecieved " + message + ";" + replyType + ";" + jsonReply);
                if (l != null) {
                    l.replyReceived(message, replyType, jsonReply);
                }
            }
        });
    }

    public static boolean ratingSucceeded(Object jsonReply) {
        if (jsonReply instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)jsonReply;
            if (jsonObject.has("message")) {
                return jsonObject.getString("message").equals("Ok");
            }
            if (jsonObject.has("success")) {
                return jsonObject.getBoolean("success");
            }
        }
        return false;
    }

    public static class GetRatingReply {
        private final Map reply;

        public GetRatingReply(Map message) {
            this.reply = message == null ? new HashMap() : message;
        }

        public long getRatingValue(String hash, String type) {
            Object val;
            JSONObject mapValues;
            int rating = -1;
            JSONObject mapRating = (JSONObject)this.reply.get(hash);
            if (mapRating != null && (mapValues = (JSONObject)mapRating.get(PlatformRatingMessenger.RATE_TYPE_CONTENT)) != null && mapValues.has("value") && (val = mapValues.get("value")) instanceof Double) {
                rating = ((Double)val).intValue();
            }
            return rating;
        }

        public long getRatingCount(String hash, String type) {
            long rating = -1L;
            try {
                Object val;
                JSONObject mapValues;
                JSONObject mapRating = (JSONObject)this.reply.get(hash);
                if (mapRating != null && (mapValues = (JSONObject)mapRating.get(PlatformRatingMessenger.RATE_TYPE_CONTENT)) != null && mapValues.has("count") && (val = mapValues.get("count")) instanceof Number) {
                    rating = ((Number)val).longValue();
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            return rating;
        }

        public String getRatingString(String hash, String type) {
            String rating = "--";
            try {
                JSONObject mapValues;
                JSONObject mapRating = (JSONObject)this.reply.get(hash);
                if (mapRating != null && (mapValues = (JSONObject)mapRating.get(PlatformRatingMessenger.RATE_TYPE_CONTENT)) != null && mapValues.has("value")) {
                    Object val = mapValues.get("value");
                    if (val instanceof String) {
                        rating = (String)val;
                    } else if (val instanceof Double) {
                        rating = ((Double)val).toString();
                    }
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            return rating;
        }

        public String getRatingColor(String hash, String type) {
            String color = null;
            try {
                JSONObject map;
                JSONObject mapValues;
                JSONObject mapRating = (JSONObject)this.reply.get(hash);
                if (mapRating != null && (mapValues = (JSONObject)mapRating.get(PlatformRatingMessenger.RATE_TYPE_CONTENT)) != null && mapValues.has("display-settings") && (map = mapValues.getJSONObject("display-settings")).has("color")) {
                    color = map.getString("color");
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            return color;
        }

        public long getRatingExpireyMins(String hash, String type) {
            long expiryMins = -1L;
            try {
                Object val;
                JSONObject mapValues;
                JSONObject mapRating = (JSONObject)this.reply.get(hash);
                if (mapRating != null && (mapValues = (JSONObject)mapRating.get(PlatformRatingMessenger.RATE_TYPE_CONTENT)) != null && mapValues.has("expires-in-mins") && (val = mapValues.get("expires-in-mins")) instanceof Long) {
                    expiryMins = (Long)val;
                }
            }
            catch (Exception e) {
                Debug.out(e);
            }
            return expiryMins;
        }

        public Map getMap() {
            return this.reply;
        }
    }

    public static abstract class GetRatingReplyListener {
        public abstract void messageSent();

        public abstract void replyReceived(String var1, GetRatingReply var2);
    }
}

