/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNLookup;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminImpl;
import java.net.InetAddress;
import org.gudy.azureus2.core3.util.IndentWriter;

public abstract class NetworkAdmin {
    private static NetworkAdmin singleton;
    public static final String PR_NETWORK_INTERFACES = "Network Interfaces";
    public static final String PR_DEFAULT_BIND_ADDRESS = "Default Bind IP";

    public static synchronized NetworkAdmin getSingleton() {
        if (singleton == null) {
            singleton = new NetworkAdminImpl();
        }
        return singleton;
    }

    public abstract InetAddress getDefaultBindAddress();

    public abstract String getNetworkInterfacesAsString();

    public abstract NetworkAdminNetworkInterface[] getInterfaces();

    public abstract NetworkAdminProtocol[] getOutboundProtocols();

    public abstract NetworkAdminProtocol[] getInboundProtocols();

    public abstract InetAddress testProtocol(NetworkAdminProtocol var1) throws NetworkAdminException;

    public abstract NetworkAdminSocksProxy[] getSocksProxies();

    public abstract NetworkAdminHTTPProxy getHTTPProxy();

    public abstract NetworkAdminNATDevice[] getNATDevices();

    public abstract NetworkAdminASNLookup lookupASN(InetAddress var1) throws NetworkAdminException;

    public abstract boolean matchesCIDR(String var1, InetAddress var2) throws NetworkAdminException;

    public abstract void addPropertyChangeListener(NetworkAdminPropertyChangeListener var1);

    public abstract void removePropertyChangeListener(NetworkAdminPropertyChangeListener var1);

    public abstract void runInitialChecks();

    public abstract void logNATStatus(IndentWriter var1);

    public abstract void generateDiagnostics(IndentWriter var1);
}

