/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNLookup;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminASNLookupImpl
implements NetworkAdminASNLookup {
    private static final String WHOIS_ADDRESS = "whois.cymru.com";
    private static final int WHOIS_PORT = 43;
    private static final int TIMEOUT = 30000;
    private String as;
    private String asn;
    private String bgp_prefix;

    protected NetworkAdminASNLookupImpl(InetAddress address) throws NetworkAdminException {
        this.lookupDNS(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lookupTCP(InetAddress address) throws NetworkAdminException {
        try {
            Socket socket = new Socket();
            int timeout = 30000;
            long start = SystemTime.getCurrentTime();
            socket.connect(new InetSocketAddress(WHOIS_ADDRESS, 43), timeout);
            long end = SystemTime.getCurrentTime();
            timeout = (int)((long)timeout - (end - start));
            if (timeout <= 0) {
                throw new NetworkAdminException("Timeout on connect");
            }
            if (timeout > 30000) {
                timeout = 30000;
            }
            socket.setSoTimeout(timeout);
            try {
                int len;
                OutputStream os = socket.getOutputStream();
                String command = "-u -p " + address.getHostAddress() + "\r\n";
                os.write(command.getBytes());
                os.flush();
                InputStream is = socket.getInputStream();
                byte[] buffer = new byte[1024];
                String result = "";
                while ((len = is.read(buffer)) > 0) {
                    result = result + new String(buffer, 0, len);
                }
                this.processResult(result);
            }
            finally {
                socket.close();
            }
        }
        catch (Throwable e) {
            throw new NetworkAdminException("whois connection failed", e);
        }
    }

    protected void lookupDNS(InetAddress address) throws NetworkAdminException {
        byte[] bytes = address.getAddress();
        String ip_query = "origin.asn.cymru.com";
        for (int i = 0; i < 4; ++i) {
            ip_query = (bytes[i] & 0xFF) + "." + ip_query;
        }
        String ip_result = this.lookupDNS(ip_query);
        this.processResult("AS | BGP Prefix | CC | Reg | Date | AS Name\n" + ip_result + " | n/a");
        String as = this.getAS();
        if (as.length() > 0) {
            String asn_query = "AS" + as + ".asn.cymru.com";
            try {
                int pos;
                String asn_result = this.lookupDNS(asn_query);
                if (asn_result != null && (pos = asn_result.lastIndexOf(124)) != -1) {
                    this.asn = asn_result.substring(pos + 1).trim();
                }
            }
            catch (Throwable e) {
                Debug.outNoStack("ASN lookup for '" + asn_query + "' failed: " + e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String lookupDNS(String query) throws NetworkAdminException {
        Context context = null;
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            context = new InitialDirContext(env);
            Attributes attrs = context.getAttributes(query, new String[]{"TXT"});
            NamingEnumeration<? extends Attribute> n_enum = attrs.getAll();
            block10: while (true) {
                if (!n_enum.hasMoreElements()) throw new NetworkAdminException("DNS query returned no results");
                Attribute attr = n_enum.next();
                NamingEnumeration<?> n_enum2 = attr.getAll();
                while (true) {
                    if (!n_enum2.hasMoreElements()) continue block10;
                    String attribute = (String)n_enum2.nextElement();
                    if (attribute != null) {
                        if ((attribute = attribute.trim()).startsWith("\"")) {
                            attribute = attribute.substring(1);
                        }
                        if (attribute.endsWith("\"")) {
                            attribute = attribute.substring(0, attribute.length() - 1);
                        }
                        if (attribute.length() > 0) {
                            String string = attribute;
                            return string;
                        }
                    }
                    continue;
                    break;
                }
                break;
            }
        }
        catch (Throwable e) {
            throw new NetworkAdminException("DNS query failed", e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    protected void processResult(String result) {
        StringTokenizer lines = new StringTokenizer(result, "\n");
        int line_number = 0;
        ArrayList<String> keywords = new ArrayList<String>();
        HashMap<String, String> map = new HashMap<String, String>();
        block0: while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (++line_number > 2) break;
            StringTokenizer tok = new StringTokenizer(line, "|");
            int token_number = 0;
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken().trim();
                if (line_number == 1) {
                    keywords.add(token.toLowerCase());
                } else {
                    if (token_number >= keywords.size()) continue block0;
                    String kw = (String)keywords.get(token_number);
                    map.put(kw, token);
                }
                ++token_number;
            }
        }
        this.as = (String)map.get("as");
        this.asn = (String)map.get("as name");
        this.bgp_prefix = (String)map.get("bgp prefix");
        if (this.bgp_prefix != null) {
            int pos = this.bgp_prefix.indexOf(32);
            if (pos != -1) {
                this.bgp_prefix = this.bgp_prefix.substring(pos + 1).trim();
            }
            if (this.bgp_prefix.indexOf(47) == -1) {
                this.bgp_prefix = null;
            }
        }
    }

    public String getAS() {
        return this.as == null ? "" : this.as;
    }

    public String getASName() {
        return this.asn == null ? "" : this.asn;
    }

    public String getBGPPrefix() {
        return this.bgp_prefix == null ? "" : this.bgp_prefix;
    }

    public InetAddress getBGPStartAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return NetworkAdminASNLookupImpl.getCIDRStartAddress(this.bgp_prefix);
        }
        catch (NetworkAdminException e) {
            Debug.out(e);
            return null;
        }
    }

    protected static InetAddress getCIDRStartAddress(String cidr) throws NetworkAdminException {
        int pos = cidr.indexOf(47);
        try {
            return InetAddress.getByName(cidr.substring(0, pos));
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Parse failure for '" + cidr + "'", e);
        }
    }

    public InetAddress getBGPEndAddress() {
        if (this.bgp_prefix == null) {
            return null;
        }
        try {
            return NetworkAdminASNLookupImpl.getCIDREndAddress(this.bgp_prefix);
        }
        catch (NetworkAdminException e) {
            Debug.out(e);
            return null;
        }
    }

    public static InetAddress getCIDREndAddress(String cidr) throws NetworkAdminException {
        int pos = cidr.indexOf(47);
        try {
            InetAddress start = InetAddress.getByName(cidr.substring(0, pos));
            int cidr_mask = Integer.parseInt(cidr.substring(pos + 1));
            int rev_mask = 0;
            for (int i = 0; i < 32 - cidr_mask; ++i) {
                rev_mask = rev_mask << 1 | 1;
            }
            byte[] bytes = start.getAddress();
            bytes[0] = (byte)(bytes[0] | rev_mask >> 24 & 0xFF);
            bytes[1] = (byte)(bytes[1] | rev_mask >> 16 & 0xFF);
            bytes[2] = (byte)(bytes[2] | rev_mask >> 8 & 0xFF);
            bytes[3] = (byte)(bytes[3] | rev_mask & 0xFF);
            return InetAddress.getByAddress(bytes);
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Parse failure for '" + cidr + "'", e);
        }
    }

    protected static boolean matchesCIDR(String cidr, InetAddress address) throws NetworkAdminException {
        InetAddress start = NetworkAdminASNLookupImpl.getCIDRStartAddress(cidr);
        InetAddress end = NetworkAdminASNLookupImpl.getCIDREndAddress(cidr);
        long l_start = PRHelpers.addressToLong(start);
        long l_end = PRHelpers.addressToLong(end);
        long test = PRHelpers.addressToLong(address);
        return test >= l_start && test <= l_end;
    }

    public String getString() {
        return "as=" + this.getAS() + ",asn=" + this.getASName() + ", bgp_prefx=" + this.getBGPPrefix() + "[" + this.getBGPStartAddress() + "-" + this.getBGPEndAddress() + "]";
    }

    public static void main(String[] args) {
        try {
            NetworkAdminASNLookupImpl lookup = new NetworkAdminASNLookupImpl(InetAddress.getByName("64.71.8.82"));
            System.out.println(lookup.getString());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

