/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNLookup;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNode;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRouteListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminASNLookupImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminHTTPProxyImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminNATDeviceImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolImpl;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminSocksProxyImpl;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;

public class NetworkAdminImpl
extends NetworkAdmin {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private Set old_network_interfaces;
    private InetAddress old_bind_ip;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private NetworkAdminRouteListener trace_route_listener = new NetworkAdminRouteListener(){
        private int node_count = 0;

        public boolean foundNode(NetworkAdminNode node, int distance, int rtt) {
            ++this.node_count;
            return true;
        }

        public boolean timeout(int distance) {
            return distance != 3 || this.node_count != 0;
        }
    };

    public NetworkAdminImpl() {
        COConfigurationManager.addParameterListener("Bind IP", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                NetworkAdminImpl.this.checkDefaultBindAddress(false);
            }
        });
        SimpleTimer.addPeriodicEvent("NetworkAdmin:checker", 15000L, new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                NetworkAdminImpl.this.checkNetworkInterfaces(false);
            }
        });
        this.checkNetworkInterfaces(true);
        this.checkDefaultBindAddress(true);
    }

    protected void checkNetworkInterfaces(boolean first_time) {
        try {
            Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
            boolean changed = false;
            if (nis != null || this.old_network_interfaces != null) {
                if (nis == null) {
                    this.old_network_interfaces = null;
                    changed = true;
                } else if (this.old_network_interfaces == null) {
                    HashSet<NetworkInterface> new_network_interfaces = new HashSet<NetworkInterface>();
                    while (nis.hasMoreElements()) {
                        new_network_interfaces.add(nis.nextElement());
                    }
                    this.old_network_interfaces = new_network_interfaces;
                    changed = true;
                } else {
                    HashSet<NetworkInterface> new_network_interfaces = new HashSet<NetworkInterface>();
                    while (nis.hasMoreElements()) {
                        NetworkInterface ni = nis.nextElement();
                        if (!this.old_network_interfaces.contains(ni)) {
                            changed = true;
                        }
                        new_network_interfaces.add(ni);
                    }
                    if (this.old_network_interfaces.size() != new_network_interfaces.size()) {
                        changed = true;
                    }
                    this.old_network_interfaces = new_network_interfaces;
                }
            }
            if (changed) {
                if (!first_time) {
                    Logger.log(new LogEvent(LOGID, "NetworkAdmin: network interfaces have changed"));
                }
                this.firePropertyChange("Network Interfaces");
                this.checkDefaultBindAddress(first_time);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public InetAddress getDefaultBindAddress() {
        return this.old_bind_ip;
    }

    protected void checkDefaultBindAddress(boolean first_time) {
        boolean changed = false;
        String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "").trim();
        try {
            if (bind_ip.length() != 0 || this.old_bind_ip != null) {
                if (bind_ip.length() == 0) {
                    this.old_bind_ip = null;
                    changed = true;
                } else {
                    InetAddress new_bind_ip = null;
                    if (bind_ip.indexOf(46) == -1) {
                        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
                        while (nis.hasMoreElements()) {
                            Enumeration<InetAddress> addresses;
                            NetworkInterface ni = nis.nextElement();
                            if (!bind_ip.equalsIgnoreCase(ni.getName()) || !(addresses = ni.getInetAddresses()).hasMoreElements()) continue;
                            new_bind_ip = addresses.nextElement();
                        }
                        if (new_bind_ip == null) {
                            Logger.log(new LogAlert(false, 3, "Bind IP '" + bind_ip + "' is invalid - no matching network interfaces"));
                            return;
                        }
                    } else {
                        new_bind_ip = InetAddress.getByName(bind_ip);
                    }
                    if (this.old_bind_ip == null || !this.old_bind_ip.equals(new_bind_ip)) {
                        this.old_bind_ip = new_bind_ip;
                        changed = true;
                    }
                }
            }
            if (changed) {
                if (!first_time) {
                    Logger.log(new LogEvent(LOGID, "NetworkAdmin: default bind ip has changed to '" + (this.old_bind_ip == null ? "none" : this.old_bind_ip.getHostAddress()) + "'"));
                }
                this.firePropertyChange("Default Bind IP");
            }
        }
        catch (Throwable e) {
            Logger.log(new LogAlert(false, 3, "Bind IP '" + bind_ip + "' is invalid"));
        }
    }

    public String getNetworkInterfacesAsString() {
        Set interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return "";
        }
        Iterator it = interfaces.iterator();
        String str = "";
        while (it.hasNext()) {
            NetworkInterface ni = (NetworkInterface)it.next();
            Enumeration<InetAddress> addresses = ni.getInetAddresses();
            if (addresses.hasMoreElements()) {
                str = str + (str.length() == 0 ? "" : ",") + ni.getName() + "=";
            }
            int add_num = 0;
            while (addresses.hasMoreElements()) {
                InetAddress ia = addresses.nextElement();
                str = str + (++add_num == 1 ? "" : ";") + ia.getHostAddress();
            }
        }
        return str;
    }

    protected void firePropertyChange(String property) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((NetworkAdminPropertyChangeListener)it.next()).propertyChanged(property);
        }
    }

    public NetworkAdminNetworkInterface[] getInterfaces() {
        Set interfaces = this.old_network_interfaces;
        if (interfaces == null) {
            return new NetworkAdminNetworkInterface[0];
        }
        NetworkAdminNetworkInterface[] res = new NetworkAdminNetworkInterface[interfaces.size()];
        Iterator it = interfaces.iterator();
        int pos = 0;
        while (it.hasNext()) {
            NetworkInterface ni = (NetworkInterface)it.next();
            res[pos++] = new networkInterface(ni);
        }
        return res;
    }

    public NetworkAdminProtocol[] getOutboundProtocols() {
        AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
        NetworkAdminProtocol[] res = new NetworkAdminProtocol[]{new NetworkAdminProtocolImpl(azureus_core, 1), new NetworkAdminProtocolImpl(azureus_core, 2), new NetworkAdminProtocolImpl(azureus_core, 3)};
        return res;
    }

    public NetworkAdminProtocol[] getInboundProtocols() {
        HTTPNetworkManager http_manager;
        int port;
        AzureusCore azureus_core = AzureusCoreFactory.getSingleton();
        ArrayList<NetworkAdminProtocolImpl> protocols = new ArrayList<NetworkAdminProtocolImpl>();
        TCPNetworkManager tcp_manager = TCPNetworkManager.getSingleton();
        if (tcp_manager.isTCPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 2, tcp_manager.getTCPListeningPortNumber()));
        }
        UDPNetworkManager udp_manager = UDPNetworkManager.getSingleton();
        int done_udp = -1;
        if (udp_manager.isUDPListenerEnabled()) {
            done_udp = udp_manager.getUDPListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 3, done_udp));
        }
        if (udp_manager.isUDPNonDataListenerEnabled() && (port = udp_manager.getUDPNonDataListeningPortNumber()) != done_udp) {
            done_udp = udp_manager.getUDPNonDataListeningPortNumber();
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 3, done_udp));
        }
        if ((http_manager = HTTPNetworkManager.getSingleton()).isHTTPListenerEnabled()) {
            protocols.add(new NetworkAdminProtocolImpl(azureus_core, 1, http_manager.getHTTPListeningPortNumber()));
        }
        return protocols.toArray(new NetworkAdminProtocol[protocols.size()]);
    }

    public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
        return protocol.test(null);
    }

    public NetworkAdminSocksProxy[] getSocksProxies() {
        String host = System.getProperty("socksProxyHost", "").trim();
        String port = System.getProperty("socksProxyPort", "").trim();
        String user = System.getProperty("java.net.socks.username", "").trim();
        String password = System.getProperty("java.net.socks.password", "").trim();
        ArrayList<NetworkAdminSocksProxyImpl> res = new ArrayList<NetworkAdminSocksProxyImpl>();
        NetworkAdminSocksProxyImpl p1 = new NetworkAdminSocksProxyImpl(host, port, user, password);
        if (p1.isConfigured()) {
            res.add(p1);
        }
        if (COConfigurationManager.getBooleanParameter("Proxy.Data.Enable") && !COConfigurationManager.getBooleanParameter("Proxy.Data.Same")) {
            NetworkAdminSocksProxyImpl p2;
            host = COConfigurationManager.getStringParameter("Proxy.Data.Host");
            port = COConfigurationManager.getStringParameter("Proxy.Data.Port");
            user = COConfigurationManager.getStringParameter("Proxy.Data.Username");
            if (user.trim().equalsIgnoreCase("<none>")) {
                user = "";
            }
            if ((p2 = new NetworkAdminSocksProxyImpl(host, port, user, password = COConfigurationManager.getStringParameter("Proxy.Data.Password"))).isConfigured()) {
                res.add(p2);
            }
        }
        return res.toArray(new NetworkAdminSocksProxy[res.size()]);
    }

    public NetworkAdminHTTPProxy getHTTPProxy() {
        NetworkAdminHTTPProxyImpl res = new NetworkAdminHTTPProxyImpl();
        if (!res.isConfigured()) {
            res = null;
        }
        return res;
    }

    public NetworkAdminNATDevice[] getNATDevices() {
        ArrayList<NetworkAdminNATDeviceImpl> devices = new ArrayList<NetworkAdminNATDeviceImpl>();
        try {
            PluginInterface upnp_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
            if (upnp_pi != null) {
                UPnPPlugin upnp = (UPnPPlugin)upnp_pi.getPlugin();
                UPnPPluginService[] services = upnp.getServices();
                for (int i = 0; i < services.length; ++i) {
                    devices.add(new NetworkAdminNATDeviceImpl(services[i]));
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return devices.toArray(new NetworkAdminNATDevice[devices.size()]);
    }

    public NetworkAdminASNLookup lookupASN(InetAddress address) throws NetworkAdminException {
        return new NetworkAdminASNLookupImpl(address);
    }

    public boolean matchesCIDR(String cidr, InetAddress address) throws NetworkAdminException {
        return NetworkAdminASNLookupImpl.matchesCIDR(cidr, address);
    }

    public void runInitialChecks() {
        if (COConfigurationManager.getBooleanParameter("Proxy.Check.On.Start")) {
            NetworkAdminSocksProxy[] socks = this.getSocksProxies();
            for (int i = 0; i < socks.length; ++i) {
                NetworkAdminSocksProxy sock = socks[i];
                try {
                    sock.getVersionsSupported();
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "Socks proxy " + sock.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
            }
            NetworkAdminHTTPProxy http_proxy = this.getHTTPProxy();
            if (http_proxy != null) {
                try {
                    http_proxy.getDetails();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    Logger.log(new LogAlert(true, 1, "HTTP proxy " + http_proxy.getName() + " check failed: " + Debug.getNestedExceptionMessage(e)));
                }
            }
        }
    }

    public void addPropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(NetworkAdminPropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void generateDiagnostics(IndentWriter iw) {
        NetworkAdminProtocol protocol;
        int i;
        HashSet<InetAddress> public_addresses = new HashSet<InetAddress>();
        NetworkAdminHTTPProxy proxy = this.getHTTPProxy();
        if (proxy == null) {
            iw.println("HTTP proxy: none");
        } else {
            iw.println("HTTP proxy: " + proxy.getName());
            try {
                NetworkAdminHTTPProxy.Details details = proxy.getDetails();
                iw.println("    name: " + details.getServerName());
                iw.println("    resp: " + details.getResponse());
                iw.println("    auth: " + details.getAuthenticationType());
            }
            catch (NetworkAdminException e) {
                iw.println("    failed: " + e.getLocalizedMessage());
            }
        }
        NetworkAdminSocksProxy[] socks = this.getSocksProxies();
        if (socks.length == 0) {
            iw.println("Socks proxy: none");
        } else {
            for (int i2 = 0; i2 < socks.length; ++i2) {
                NetworkAdminSocksProxy sock = socks[i2];
                iw.println("Socks proxy: " + sock.getName());
                try {
                    String[] versions = sock.getVersionsSupported();
                    String str = "";
                    for (int j = 0; j < versions.length; ++j) {
                        str = str + (j == 0 ? "" : ",") + versions[j];
                    }
                    iw.println("   version: " + str);
                    continue;
                }
                catch (NetworkAdminException e) {
                    iw.println("    failed: " + e.getLocalizedMessage());
                }
            }
        }
        NetworkAdminNATDevice[] nat_devices = this.getNATDevices();
        iw.println("NAT Devices: " + nat_devices.length);
        for (int i3 = 0; i3 < nat_devices.length; ++i3) {
            NetworkAdminNATDevice device = nat_devices[i3];
            iw.println("    " + device.getName() + ",address=" + device.getAddress().getHostAddress() + ":" + device.getPort() + ",ext=" + device.getExternalAddress());
            public_addresses.add(device.getExternalAddress());
        }
        iw.println("Interfaces");
        iw.println("Inbound protocols: default routing");
        NetworkAdminProtocol[] protocols = this.getInboundProtocols();
        for (i = 0; i < protocols.length; ++i) {
            protocol = protocols[i];
            try {
                InetAddress ext_addr = this.testProtocol(protocol);
                if (ext_addr != null) {
                    public_addresses.add(ext_addr);
                }
                iw.println("    " + protocol.getName() + " - " + ext_addr);
                continue;
            }
            catch (NetworkAdminException e) {
                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
            }
        }
        iw.println("Outbound protocols: default routing");
        protocols = this.getOutboundProtocols();
        for (i = 0; i < protocols.length; ++i) {
            protocol = protocols[i];
            try {
                InetAddress ext_addr = this.testProtocol(protocol);
                if (ext_addr != null) {
                    public_addresses.add(ext_addr);
                }
                iw.println("    " + protocol.getName() + " - " + ext_addr);
                continue;
            }
            catch (NetworkAdminException e) {
                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
            }
        }
        Iterator it = public_addresses.iterator();
        iw.println("Public Addresses");
        while (it.hasNext()) {
            InetAddress pub_address = (InetAddress)it.next();
            try {
                NetworkAdminASNLookup res = this.lookupASN(pub_address);
                iw.println("    " + pub_address.getHostAddress() + " -> " + res.getAS() + "/" + res.getASName());
            }
            catch (Throwable e) {
                iw.println("    " + pub_address.getHostAddress() + " -> " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    protected void generateDiagnostics(IndentWriter iw, NetworkAdminProtocol[] protocols) {
        for (int i = 0; i < protocols.length; ++i) {
            NetworkAdminProtocol protocol = protocols[i];
            iw.println("Testing " + protocol.getName());
            try {
                InetAddress ext_addr = this.testProtocol(protocol);
                iw.println("    -> OK, public address=" + ext_addr);
                continue;
            }
            catch (NetworkAdminException e) {
                iw.println("    -> Failed: " + Debug.getNestedExceptionMessage(e));
            }
        }
    }

    public void logNATStatus(IndentWriter iw) {
        this.generateDiagnostics(iw, this.getInboundProtocols());
    }

    public static void main(String[] args) {
        boolean TEST_SOCKS_PROXY = false;
        boolean TEST_HTTP_PROXY = false;
        try {
            if (TEST_SOCKS_PROXY) {
                AESocksProxy proxy = AESocksProxyFactory.create(4567, 10000L, 10000L);
                proxy.setAllowExternalConnections(true);
                System.setProperty("socksProxyHost", "localhost");
                System.setProperty("socksProxyPort", "4567");
            }
            if (TEST_HTTP_PROXY) {
                System.setProperty("http.proxyHost", "localhost");
                System.setProperty("http.proxyPort", "3128");
                System.setProperty("https.proxyHost", "localhost");
                System.setProperty("https.proxyPort", "3128");
                Authenticator.setDefault(new Authenticator(){
                    protected AEMonitor auth_mon = new AEMonitor("SESecurityManager:auth");

                    protected PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication("fred", "bill".toCharArray());
                    }
                });
            }
            IndentWriter iw = new IndentWriter(new PrintWriter(System.out));
            iw.setForce(true);
            COConfigurationManager.initialise();
            AzureusCoreFactory.create();
            NetworkAdminImpl.getSingleton().logNATStatus(iw);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected class networkInterface
    implements NetworkAdminNetworkInterface {
        private NetworkInterface ni;

        protected networkInterface(NetworkInterface _ni) {
            this.ni = _ni;
        }

        public String getDisplayName() {
            return this.ni.getDisplayName();
        }

        public String getName() {
            return this.ni.getName();
        }

        public NetworkAdminNetworkInterfaceAddress[] getAddresses() {
            Enumeration<InetAddress> e = this.ni.getInetAddresses();
            ArrayList<networkAddress> addresses = new ArrayList<networkAddress>();
            while (e.hasMoreElements()) {
                addresses.add(new networkAddress(e.nextElement()));
            }
            return addresses.toArray(new NetworkAdminNetworkInterfaceAddress[addresses.size()]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
            iw.println(this.getDisplayName() + "/" + this.getName());
            NetworkAdminNetworkInterfaceAddress[] addresses = this.getAddresses();
            for (int i = 0; i < addresses.length; ++i) {
                networkAddress addr = (networkAddress)addresses[i];
                iw.indent();
                try {
                    addr.generateDiagnostics(iw, public_addresses);
                    continue;
                }
                finally {
                    iw.exdent();
                }
            }
        }

        protected class networkAddress
        implements NetworkAdminNetworkInterfaceAddress {
            private InetAddress address;

            protected networkAddress(InetAddress _address) {
                this.address = _address;
            }

            public InetAddress getAddress() {
                return this.address;
            }

            public boolean isLoopback() {
                return this.address.isLoopbackAddress();
            }

            public NetworkAdminNode[] getRoute(InetAddress target, final int max_millis, final NetworkAdminRouteListener listener) throws NetworkAdminException {
                PlatformManager pm = PlatformManagerFactory.getPlatformManager();
                if (!pm.hasCapability(PlatformManagerCapabilities.TraceRouteAvailability)) {
                    throw new NetworkAdminException("No trace-route capability on platform");
                }
                final ArrayList nodes = new ArrayList();
                try {
                    pm.traceRoute(this.address, target, new PlatformManagerPingCallback(){
                        private long start_time = SystemTime.getCurrentTime();

                        public boolean reportNode(int distance, InetAddress address, int millis) {
                            boolean timeout = false;
                            if (max_millis >= 0) {
                                long now = SystemTime.getCurrentTime();
                                if (now < this.start_time) {
                                    this.start_time = now;
                                }
                                if (now - this.start_time >= (long)max_millis) {
                                    timeout = true;
                                }
                            }
                            networkNode node = null;
                            if (address != null) {
                                node = new networkNode(address, distance, millis);
                                nodes.add(node);
                            }
                            boolean result = listener == null ? true : (node == null ? listener.timeout(distance) : listener.foundNode(node, distance, millis));
                            return result && !timeout;
                        }
                    });
                }
                catch (PlatformManagerException e) {
                    throw new NetworkAdminException("trace-route failed", e);
                }
                return nodes.toArray(new NetworkAdminNode[nodes.size()]);
            }

            public InetAddress testProtocol(NetworkAdminProtocol protocol) throws NetworkAdminException {
                return protocol.test(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generateDiagnostics(IndentWriter iw, Set public_addresses) {
                block15: {
                    iw.println("" + this.getAddress());
                    try {
                        InetAddress res;
                        NetworkAdminProtocol protocol;
                        int i;
                        iw.println("  Trace route");
                        iw.indent();
                        if (this.isLoopback()) {
                            iw.println("Loopback - ignoring");
                            break block15;
                        }
                        try {
                            NetworkAdminNode[] nodes = this.getRoute(InetAddress.getByName("www.google.com"), 30000, NetworkAdminImpl.this.trace_route_listener);
                            for (i = 0; i < nodes.length; ++i) {
                                networkNode node = (networkNode)nodes[i];
                                iw.println(node.getString());
                            }
                        }
                        catch (Throwable e) {
                            iw.println("Can't resolve host for route trace - " + e.getMessage());
                        }
                        iw.println("Outbound protocols: bound");
                        NetworkAdminProtocol[] protocols = NetworkAdminImpl.this.getOutboundProtocols();
                        for (i = 0; i < protocols.length; ++i) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                                continue;
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                        iw.println("Inbound protocols: bound");
                        protocols = NetworkAdminImpl.this.getInboundProtocols();
                        for (i = 0; i < protocols.length; ++i) {
                            protocol = protocols[i];
                            try {
                                res = this.testProtocol(protocol);
                                if (res != null) {
                                    public_addresses.add(res);
                                }
                                iw.println("    " + protocol.getName() + " - " + res);
                                continue;
                            }
                            catch (NetworkAdminException e) {
                                iw.println("    " + protocol.getName() + " - " + Debug.getNestedExceptionMessage(e));
                            }
                        }
                    }
                    finally {
                        iw.exdent();
                    }
                }
            }

            protected class networkNode
            implements NetworkAdminNode {
                private InetAddress address;
                private int distance;
                private int rtt;

                protected networkNode(InetAddress _address, int _distance, int _millis) {
                    this.address = _address;
                    this.distance = _distance;
                    this.rtt = _millis;
                }

                public InetAddress getAddress() {
                    return this.address;
                }

                public boolean isLocalAddress() {
                    return this.address.isLinkLocalAddress() || this.address.isSiteLocalAddress();
                }

                public int getDistance() {
                    return this.distance;
                }

                public int getRTT() {
                    return this.rtt;
                }

                protected String getString() {
                    if (this.address == null) {
                        return "" + this.distance;
                    }
                    return this.distance + "," + this.address + "[local=" + this.isLocalAddress() + "]," + this.rtt;
                }
            }
        }
    }
}

