/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminHTTPTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminTCPTester;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminUDPTester;
import java.net.InetAddress;

public class NetworkAdminProtocolImpl
implements NetworkAdminProtocol {
    private AzureusCore core;
    private int type;
    private int port;

    protected NetworkAdminProtocolImpl(AzureusCore _core, int _type) {
        this.core = _core;
        this.type = _type;
        this.port = -1;
    }

    protected NetworkAdminProtocolImpl(AzureusCore _core, int _type, int _port) {
        this.core = _core;
        this.type = _type;
        this.port = _port;
    }

    public int getType() {
        return this.type;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress test(NetworkAdminNetworkInterfaceAddress address) throws NetworkAdminException {
        InetAddress bind_ip;
        InetAddress inetAddress = bind_ip = address == null ? null : address.getAddress();
        NetworkAdminProtocolTester tester2 = this.type == 1 ? new NetworkAdminHTTPTester(this.core) : (this.type == 2 ? new NetworkAdminTCPTester(this.core) : new NetworkAdminUDPTester(this.core));
        InetAddress res = this.port <= 0 ? tester2.testOutbound(bind_ip, 0) : tester2.testInbound(bind_ip, this.port);
        return res;
    }

    public String getName() {
        String res = this.type == 1 ? "HTTP" : (this.type == 2 ? "TCP" : "UDP");
        if (this.port == -1) {
            return res + " outbound";
        }
        return res + " port " + this.port + " inbound";
    }
}

