/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminProtocolTester;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.net.InetAddress;
import org.gudy.azureus2.core3.ipchecker.natchecker.NatChecker;

public class NetworkAdminTCPTester
implements NetworkAdminProtocolTester {
    private AzureusCore core;

    protected NetworkAdminTCPTester(AzureusCore _core) {
        this.core = _core;
    }

    public InetAddress testOutbound(InetAddress bind_ip, int bind_port) throws NetworkAdminException {
        try {
            return VersionCheckClient.getSingleton().getExternalIpAddressTCP(bind_ip, bind_port);
        }
        catch (Throwable e) {
            throw new NetworkAdminException("Outbound check failed", e);
        }
    }

    public InetAddress testInbound(InetAddress bind_ip, int local_port) throws NetworkAdminException {
        NatChecker checker = new NatChecker(this.core, bind_ip, local_port, false);
        if (checker.getResult() == 1) {
            return checker.getExternalAddress();
        }
        throw new NetworkAdminException("NAT check failed: " + checker.getAdditionalInfo());
    }
}

