/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.networkmanager.impl.RateHandler;
import java.util.ArrayList;
import java.util.Iterator;
import org.gudy.azureus2.core3.util.AEMonitor;

public class MultiPeerDownloader
implements RateControlledEntity {
    private volatile ArrayList connections_cow = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("MultiPeerDownloader");
    private final RateHandler main_handler;
    private int next_position = 0;

    public MultiPeerDownloader(RateHandler main_handler) {
        this.main_handler = main_handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeerConnection(NetworkConnectionBase connection) {
        try {
            this.connections_mon.enter();
            ArrayList<NetworkConnectionBase> conn_new = new ArrayList<NetworkConnectionBase>(this.connections_cow.size() + 1);
            conn_new.addAll(this.connections_cow);
            conn_new.add(connection);
            this.connections_cow = conn_new;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePeerConnection(NetworkConnectionBase connection) {
        try {
            this.connections_mon.enter();
            ArrayList conn_new = new ArrayList(this.connections_cow);
            boolean removed = conn_new.remove(connection);
            if (!removed) {
                boolean bl = false;
                return bl;
            }
            this.connections_cow = conn_new;
            boolean bl = true;
            return bl;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public boolean canProcess(EventWaiter waiter) {
        return this.main_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public long getBytesReadyToWrite() {
        return 0L;
    }

    public int getConnectionCount() {
        return this.connections_cow.size();
    }

    public int getReadyConnectionCount(EventWaiter waiter) {
        int res = 0;
        Iterator it = this.connections_cow.iterator();
        while (it.hasNext()) {
            NetworkConnectionBase connection = (NetworkConnectionBase)it.next();
            if (!connection.getTransportBase().isReadyForRead(waiter)) continue;
            ++res;
        }
        return res;
    }

    public boolean doProcessing(EventWaiter waiter) {
        int num_bytes_allowed = this.main_handler.getCurrentNumBytesAllowed();
        if (num_bytes_allowed < 1) {
            return false;
        }
        ArrayList connections = this.connections_cow;
        int num_checked = 0;
        int num_bytes_remaining = num_bytes_allowed;
        while (num_bytes_remaining > 0 && num_checked < connections.size()) {
            this.next_position = this.next_position >= connections.size() ? 0 : this.next_position;
            NetworkConnectionBase connection = (NetworkConnectionBase)connections.get(this.next_position);
            ++this.next_position;
            ++num_checked;
            if (!connection.getTransportBase().isReadyForRead(waiter)) continue;
            int mss = connection.getMssSize();
            int allowed = num_bytes_remaining > mss ? mss : num_bytes_remaining;
            int bytes_read = 0;
            try {
                bytes_read = connection.getIncomingMessageQueue().receiveFromTransport(allowed);
            }
            catch (Throwable e) {
                connection.notifyOfException(e);
            }
            num_bytes_remaining -= bytes_read;
        }
        int total_bytes_read = num_bytes_allowed - num_bytes_remaining;
        if (total_bytes_read > 0) {
            this.main_handler.bytesProcessed(total_bytes_read);
            return true;
        }
        return false;
    }

    public int getPriority() {
        return 1;
    }

    public String getString() {
        String str = "";
        Iterator it = this.connections_cow.iterator();
        while (it.hasNext()) {
            NetworkConnectionBase connection = (NetworkConnectionBase)it.next();
            str = str + (str.length() == 0 ? "" : ",") + connection.getString();
        }
        return "MPD: " + str;
    }
}

