/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;

public class ReadController
implements AzureusCoreStatsProvider {
    private static int IDLE_SLEEP_TIME = 50;
    private volatile ArrayList normal_priority_entities = new ArrayList();
    private volatile ArrayList high_priority_entities = new ArrayList();
    private final AEMonitor entities_mon = new AEMonitor("ReadController:EM");
    private int next_normal_position = 0;
    private int next_high_position = 0;
    private long wait_count;
    private EventWaiter read_waiter = new EventWaiter();

    public ReadController() {
        AEThread read_processor_thread = new AEThread("ReadController:ReadProcessor"){

            public void runSupport() {
                ReadController.this.readProcessorLoop();
            }
        };
        read_processor_thread.setDaemon(true);
        read_processor_thread.setPriority(9);
        read_processor_thread.start();
        HashSet<String> types = new HashSet<String>();
        types.add("net.read.control.wait.count");
        types.add("net.read.control.entity.count");
        types.add("net.read.control.con.count");
        types.add("net.read.control.ready.con.count");
        AzureusCoreStats.registerProvider(types, this);
        AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void generate(IndentWriter writer) {
                writer.println("Read Controller");
                try {
                    RateControlledEntity entity;
                    int i;
                    writer.indent();
                    ArrayList ref = ReadController.this.normal_priority_entities;
                    writer.println("normal - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                    ref = ReadController.this.high_priority_entities;
                    writer.println("priority - " + ref.size());
                    for (i = 0; i < ref.size(); ++i) {
                        entity = (RateControlledEntity)ref.get(i);
                        writer.println(entity.getString());
                    }
                }
                finally {
                    writer.exdent();
                }
            }
        });
    }

    public void updateStats(Set types, Map values) {
        if (types.contains("net.read.control.wait.count")) {
            values.put("net.read.control.wait.count", new Long(this.wait_count));
        }
        if (types.contains("net.read.control.entity.count")) {
            values.put("net.read.control.entity.count", new Long(this.high_priority_entities.size() + this.normal_priority_entities.size()));
        }
        if (types.contains("net.read.control.con.count") || types.contains("net.read.control.ready.con.count")) {
            int ready_connections = 0;
            int connections = 0;
            ArrayList[] refs = new ArrayList[]{this.normal_priority_entities, this.high_priority_entities};
            for (int i = 0; i < refs.length; ++i) {
                ArrayList ref = refs[i];
                for (int j = 0; j < ref.size(); ++j) {
                    RateControlledEntity entity = (RateControlledEntity)ref.get(j);
                    connections += entity.getConnectionCount();
                    ready_connections += entity.getReadyConnectionCount(this.read_waiter);
                }
            }
            values.put("net.read.control.con.count", new Long(connections));
            values.put("net.read.control.ready.con.count", new Long(ready_connections));
        }
    }

    private void readProcessorLoop() {
        boolean check_high_first = true;
        while (true) {
            try {
                while (true) {
                    if (check_high_first) {
                        check_high_first = false;
                        if (this.doHighPriorityRead() || this.doNormalPriorityRead() || !this.read_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                        ++this.wait_count;
                        continue;
                    }
                    check_high_first = true;
                    if (this.doNormalPriorityRead() || this.doHighPriorityRead() || !this.read_waiter.waitForEvent(IDLE_SLEEP_TIME)) continue;
                    ++this.wait_count;
                }
            }
            catch (Throwable t) {
                Debug.out("readProcessorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private boolean doNormalPriorityRead() {
        RateControlledEntity ready_entity = this.getNextReadyNormalPriorityEntity();
        return ready_entity != null && ready_entity.doProcessing(this.read_waiter);
    }

    private boolean doHighPriorityRead() {
        RateControlledEntity ready_entity = this.getNextReadyHighPriorityEntity();
        return ready_entity != null && ready_entity.doProcessing(this.read_waiter);
    }

    private RateControlledEntity getNextReadyNormalPriorityEntity() {
        ArrayList ref = this.normal_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_normal_position = this.next_normal_position >= size ? 0 : this.next_normal_position;
            RateControlledEntity entity = (RateControlledEntity)ref.get(this.next_normal_position);
            ++this.next_normal_position;
            if (!entity.canProcess(this.read_waiter)) continue;
            return entity;
        }
        return null;
    }

    private RateControlledEntity getNextReadyHighPriorityEntity() {
        ArrayList ref = this.high_priority_entities;
        int size = ref.size();
        for (int num_checked = 0; num_checked < size; ++num_checked) {
            this.next_high_position = this.next_high_position >= size ? 0 : this.next_high_position;
            RateControlledEntity entity = (RateControlledEntity)ref.get(this.next_high_position);
            ++this.next_high_position;
            if (!entity.canProcess(this.read_waiter)) continue;
            return entity;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReadEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList<RateControlledEntity> high_new = new ArrayList<RateControlledEntity>(this.high_priority_entities.size() + 1);
                high_new.addAll(this.high_priority_entities);
                high_new.add(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList<RateControlledEntity> norm_new = new ArrayList<RateControlledEntity>(this.normal_priority_entities.size() + 1);
                norm_new.addAll(this.normal_priority_entities);
                norm_new.add(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReadEntity(RateControlledEntity entity) {
        try {
            this.entities_mon.enter();
            if (entity.getPriority() == 1) {
                ArrayList high_new = new ArrayList(this.high_priority_entities);
                high_new.remove(entity);
                this.high_priority_entities = high_new;
            } else {
                ArrayList norm_new = new ArrayList(this.normal_priority_entities);
                norm_new.remove(entity);
                this.normal_priority_entities = norm_new;
            }
        }
        finally {
            this.entities_mon.exit();
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("network.control.read.idle.time", new ParameterListener(){

            public void parameterChanged(String name) {
                IDLE_SLEEP_TIME = COConfigurationManager.getIntParameter(name);
            }
        });
    }
}

