/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;

public class HTTPMessageDecoder
implements MessageStreamDecoder {
    private static final int MAX_HEADER = 1024;
    private static final String NL = "\r\n";
    private HTTPNetworkConnection http_connection;
    private volatile boolean paused;
    private volatile boolean destroyed;
    private StringBuffer header_so_far = new StringBuffer();
    private List messages = new ArrayList();
    private int protocol_bytes_read;

    public void setConnection(HTTPNetworkConnection _http_connection) {
        this.http_connection = _http_connection;
        if (this.destroyed) {
            this.http_connection.destroy();
        }
    }

    public int performStreamDecode(Transport transport, int max_bytes) throws IOException {
        if (this.http_connection == null) {
            Debug.out("connection not yet assigned");
            throw new IOException("Internal error - connection not yet assigned");
        }
        this.protocol_bytes_read = 0;
        int rem = max_bytes;
        byte[] bytes = new byte[1];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        ByteBuffer[] bbs = new ByteBuffer[]{bb};
        while (rem > 0 && !this.paused && transport.read(bbs, 0, 1) != 0L) {
            String header_str;
            --rem;
            ++this.protocol_bytes_read;
            bb.flip();
            char c = (char)(bytes[0] & 0xFF);
            this.header_so_far.append(c);
            if (this.header_so_far.length() > 1024) {
                throw new IOException("HTTP header exceeded maximum of 1024");
            }
            if (c != '\n' || !(header_str = this.header_so_far.toString()).endsWith("\r\n\r\n")) continue;
            this.http_connection.decodeHeader(header_str);
            this.header_so_far.setLength(0);
        }
        return max_bytes - rem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMessage(Message message) {
        List list = this.messages;
        synchronized (list) {
            this.messages.add(message);
        }
        this.http_connection.readWakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] removeDecodedMessages() {
        List list = this.messages;
        synchronized (list) {
            if (this.messages.isEmpty()) {
                return null;
            }
            Message[] msgs = this.messages.toArray(new Message[this.messages.size()]);
            this.messages.clear();
            return msgs;
        }
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_read;
    }

    public int getDataBytesDecoded() {
        return 0;
    }

    public int getPercentDoneOfCurrentMessage() {
        return 0;
    }

    public void pauseDecoding() {
        this.paused = true;
    }

    public void resumeDecoding() {
        if (!this.destroyed) {
            this.paused = false;
        }
    }

    public ByteBuffer destroy() {
        this.paused = true;
        this.destroyed = true;
        if (this.http_connection != null) {
            this.http_connection.destroy();
        }
        try {
            for (int i = 0; i < this.messages.size(); ++i) {
                Message msg = (Message)this.messages.get(i);
                msg.destroy();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.messages.clear();
        return null;
    }
}

