/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessage;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageEncoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class HTTPNetworkConnection {
    protected static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int MAX_OUTSTANDING_BT_REQUESTS = 16;
    protected static final String NL = "\r\n";
    private static int max_read_block_size;
    private static final int TIMEOUT_CHECK_PERIOD = 15000;
    private static final int DEAD_CONNECTION_TIMEOUT_PERIOD = 30000;
    private static final int MAX_CON_PER_ENDPOINT = 5000;
    private static Map http_connection_map;
    private HTTPNetworkManager manager;
    private NetworkConnection connection;
    private PEPeerTransport peer;
    private String url;
    private HTTPMessageDecoder decoder;
    private HTTPMessageEncoder encoder;
    private boolean sent_handshake = false;
    private byte[] peer_id = PeerUtils.createPeerID();
    private boolean choked = true;
    private List http_requests = new ArrayList();
    private List choked_requests = new ArrayList();
    private List outstanding_requests = new ArrayList();
    private BitSet piece_map = new BitSet();
    private long last_http_activity_time;
    private networkConnectionKey network_connection_key;
    private boolean closing;
    private boolean destroyed;

    protected static boolean checkConnections(List connections) {
        boolean some_closed = false;
        HTTPNetworkConnection oldest = null;
        long oldest_time = -1L;
        Iterator it = connections.iterator();
        ArrayList<HTTPNetworkConnection> timed_out = new ArrayList<HTTPNetworkConnection>();
        while (it.hasNext()) {
            HTTPNetworkConnection connection = (HTTPNetworkConnection)it.next();
            long time = connection.getTimeSinceLastActivity();
            if (time > 30000L && connection.getRequestCount() == 0) {
                timed_out.add(connection);
                continue;
            }
            if (time <= oldest_time || connection.isClosing()) continue;
            oldest_time = time;
            oldest = connection;
        }
        for (int i = 0; i < timed_out.size(); ++i) {
            ((HTTPNetworkConnection)timed_out.get(i)).close("Timeout");
            some_closed = true;
        }
        if (connections.size() - timed_out.size() > 5000) {
            oldest.close("Too many connections from initiator");
            some_closed = true;
        }
        return some_closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPNetworkConnection(HTTPNetworkManager _manager, NetworkConnection _connection, PEPeerTransport _peer, String _url) {
        this.manager = _manager;
        this.connection = _connection;
        this.peer = _peer;
        this.url = _url;
        this.network_connection_key = new networkConnectionKey();
        this.last_http_activity_time = SystemTime.getCurrentTime();
        this.decoder = (HTTPMessageDecoder)this.connection.getIncomingMessageQueue().getDecoder();
        this.encoder = (HTTPMessageEncoder)this.connection.getOutgoingMessageQueue().getEncoder();
        Map map = http_connection_map;
        synchronized (map) {
            ArrayList<HTTPNetworkConnection> connections = (ArrayList<HTTPNetworkConnection>)http_connection_map.get(this.network_connection_key);
            if (connections == null) {
                connections = new ArrayList<HTTPNetworkConnection>();
                http_connection_map.put(this.network_connection_key, connections);
            }
            connections.add(this);
            if (connections.size() > 5000) {
                HTTPNetworkConnection.checkConnections(connections);
            }
        }
        this.decoder.setConnection(this);
        this.encoder.setConnection(this);
    }

    protected boolean isSeed() {
        if (!this.peer.getControl().isSeeding()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.peer, LOGID, "Download is not seeding"));
            }
            this.sendAndClose(this.manager.getNotFound());
            return false;
        }
        return true;
    }

    protected HTTPNetworkManager getManager() {
        return this.manager;
    }

    protected NetworkConnection getConnection() {
        return this.connection;
    }

    protected PEPeerTransport getPeer() {
        return this.peer;
    }

    protected PEPeerControl getPeerControl() {
        return this.peer.getControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage encodeChoke() {
        List list = this.outstanding_requests;
        synchronized (list) {
            this.choked = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage encodeUnchoke() {
        List list = this.outstanding_requests;
        synchronized (list) {
            this.choked = false;
            for (int i = 0; i < this.choked_requests.size(); ++i) {
                this.decoder.addMessage((BTRequest)this.choked_requests.get(i));
            }
            this.choked_requests.clear();
        }
        return null;
    }

    protected RawMessage encodeBitField() {
        this.decoder.addMessage(new BTInterested());
        return null;
    }

    protected void readWakeup() {
        this.connection.getTransport().setReadyForRead();
    }

    protected RawMessage encodeHandShake(Message message) {
        return null;
    }

    protected abstract void decodeHeader(String var1) throws IOException;

    protected String encodeHeader(httpRequest request2) {
        String res = "HTTP/1.1 " + (request2.isPartialContent() ? "206 Partial Content" : "200 OK") + NL + "Content-Type: application/octet-stream" + NL + "Server: " + "Azureus" + " " + "2.5.0.4" + NL + "Connection: " + (request2.keepAlive() ? "Keep-Alive" : "Close") + NL + (request2.keepAlive() ? "Keep-Alive: timeout=30\r\n" : "") + "Content-Length: " + request2.getTotalLength() + NL + NL;
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequest(httpRequest request2) throws IOException {
        this.last_http_activity_time = SystemTime.getCurrentTime();
        PEPeerControl control = this.getPeerControl();
        if (!this.sent_handshake) {
            this.sent_handshake = true;
            this.decoder.addMessage(new BTHandshake(control.getHash(), this.peer_id, false));
            byte[] bits = new byte[(control.getPieces().length + 7) / 8];
            DirectByteBuffer buffer = new DirectByteBuffer(ByteBuffer.wrap(bits));
            this.decoder.addMessage(new BTBitfield(buffer));
        }
        List list = this.outstanding_requests;
        synchronized (list) {
            this.http_requests.add(request2);
        }
        this.submitBTRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitBTRequests() throws IOException {
        PEPeerControl control = this.getPeerControl();
        long piece_size = control.getPieceLength(0);
        List list = this.outstanding_requests;
        synchronized (list) {
            while (this.outstanding_requests.size() < 16 && this.http_requests.size() > 0) {
                httpRequest http_request = (httpRequest)this.http_requests.get(0);
                long[] offsets = http_request.getOffsets();
                long[] lengths = http_request.getLengths();
                int index = http_request.getIndex();
                long offset = offsets[index];
                long length = lengths[index];
                int this_piece_number = (int)(offset / piece_size);
                int this_piece_size = control.getPieceLength(this_piece_number);
                int offset_in_piece = (int)(offset - (long)this_piece_number * piece_size);
                int space_this_piece = this_piece_size - offset_in_piece;
                int request_size = (int)Math.min(length, (long)space_this_piece);
                request_size = Math.min(request_size, max_read_block_size);
                this.addBTRequest(new BTRequest(this_piece_number, offset_in_piece, request_size), http_request);
                if ((long)request_size == length) {
                    if (index == offsets.length - 1) {
                        this.http_requests.remove(0);
                        continue;
                    }
                    http_request.setIndex(index + 1);
                    continue;
                }
                int n = index;
                offsets[n] = offsets[n] + (long)request_size;
                int n2 = index;
                lengths[n2] = lengths[n2] - (long)request_size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBTRequest(BTRequest request2, httpRequest http_request) throws IOException {
        List list = this.outstanding_requests;
        synchronized (list) {
            if (this.destroyed) {
                throw new IOException("HTTP connection destroyed");
            }
            this.outstanding_requests.add(new pendingRequest(request2, http_request));
            if (this.choked) {
                if (this.choked_requests.size() > 1024) {
                    Debug.out("pending request limit exceeded");
                } else {
                    this.choked_requests.add(request2);
                }
            } else {
                this.decoder.addMessage(request2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage encodePiece(Message message) {
        this.last_http_activity_time = SystemTime.getCurrentTime();
        BTPiece piece = (BTPiece)message;
        ArrayList<pendingRequest> ready_requests = new ArrayList<pendingRequest>();
        boolean found = false;
        List list = this.outstanding_requests;
        synchronized (list) {
            if (this.destroyed) {
                return this.getEmptyRawMessage(message);
            }
            for (int i = 0; i < this.outstanding_requests.size(); ++i) {
                pendingRequest r;
                BTPiece btp;
                pendingRequest req = (pendingRequest)this.outstanding_requests.get(i);
                if (req.getPieceNumber() != piece.getPieceNumber() || req.getStart() != piece.getPieceOffset() || req.getLength() != piece.getPieceData().remaining((byte)5) || req.getBTPiece() != null) continue;
                req.setBTPiece(piece);
                found = true;
                if (i != 0) break;
                Iterator it = this.outstanding_requests.iterator();
                while (it.hasNext() && (btp = (r = (pendingRequest)it.next()).getBTPiece()) != null) {
                    it.remove();
                    ready_requests.add(r);
                }
                break;
            }
        }
        if (!found) {
            Debug.out("request not matched");
            return this.getEmptyRawMessage(message);
        }
        if (ready_requests.size() == 0) {
            return this.getEmptyRawMessage(message);
        }
        try {
            this.submitBTRequests();
        }
        catch (IOException e) {
            // empty catch block
        }
        pendingRequest req = (pendingRequest)ready_requests.get(0);
        int buffer_index = 0;
        httpRequest http_request = req.getHTTPRequest();
        DirectByteBuffer[] buffers = new DirectByteBuffer[ready_requests.size() + 1];
        if (!http_request.hasSentFirstReply()) {
            http_request.setSentFirstReply();
            String header = this.encodeHeader(http_request);
            buffers[buffer_index++] = new DirectByteBuffer(ByteBuffer.wrap(header.getBytes()));
        } else {
            buffers[buffer_index++] = new DirectByteBuffer(ByteBuffer.allocate(0));
        }
        for (int i = 0; i < ready_requests.size(); ++i) {
            req = (pendingRequest)ready_requests.get(i);
            BTPiece this_piece = req.getBTPiece();
            int piece_number = this_piece.getPieceNumber();
            if (!this.piece_map.get(piece_number)) {
                this.piece_map.set(piece_number);
                this.decoder.addMessage(new BTHave(piece_number));
            }
            buffers[buffer_index++] = this_piece.getPieceData();
        }
        return new RawMessageImpl(message, buffers, 2, true, new Message[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRequestCount() {
        List list = this.outstanding_requests;
        synchronized (list) {
            return this.http_requests.size();
        }
    }

    protected boolean isClosing() {
        return this.closing;
    }

    protected void close(String reason) {
        this.closing = true;
        this.peer.getControl().removePeer(this.peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = http_connection_map;
        synchronized (object) {
            List connections = (List)http_connection_map.get(this.network_connection_key);
            if (connections != null) {
                connections.remove(this);
                if (connections.size() == 0) {
                    http_connection_map.remove(this.network_connection_key);
                }
            }
        }
        object = this.outstanding_requests;
        synchronized (object) {
            Object req;
            int i;
            this.destroyed = true;
            for (i = 0; i < this.outstanding_requests.size(); ++i) {
                req = (pendingRequest)this.outstanding_requests.get(i);
                BTPiece piece = ((pendingRequest)req).getBTPiece();
                if (piece == null) continue;
                piece.destroy();
            }
            this.outstanding_requests.clear();
            for (i = 0; i < this.choked_requests.size(); ++i) {
                req = (BTRequest)this.choked_requests.get(i);
                ((BTRequest)req).destroy();
            }
            this.choked_requests.clear();
        }
    }

    protected long getTimeSinceLastActivity() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_http_activity_time) {
            this.last_http_activity_time = now;
        }
        return now - this.last_http_activity_time;
    }

    protected void log(String str) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getPeer(), LOGID, str));
        }
    }

    protected RawMessage getEmptyRawMessage(Message message) {
        return new RawMessageImpl(message, new DirectByteBuffer[]{new DirectByteBuffer(ByteBuffer.allocate(0))}, 2, true, new Message[0]);
    }

    protected void sendAndClose(String data) {
        final HTTPMessage http_message = new HTTPMessage(data);
        this.getConnection().getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageQueued(Message message) {
            }

            public void messageRemoved(Message message) {
            }

            public void messageSent(Message message) {
                if (message == http_message) {
                    HTTPNetworkConnection.this.close("Close after message send complete");
                }
            }

            public void protocolBytesSent(int byte_count) {
            }

            public void dataBytesSent(int byte_count) {
            }
        });
        this.getConnection().getOutgoingMessageQueue().addMessage(http_message, false);
    }

    static {
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
        http_connection_map = new HashMap();
        SimpleTimer.addPeriodicEvent("HTTPNetworkConnection:timer", 15000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                Map map = http_connection_map;
                synchronized (map) {
                    boolean check = true;
                    block3: while (check) {
                        check = false;
                        Iterator it = http_connection_map.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            networkConnectionKey key = (networkConnectionKey)entry.getKey();
                            List connections = (List)entry.getValue();
                            if (!HTTPNetworkConnection.checkConnections(connections) || http_connection_map.containsKey(key)) continue;
                            check = true;
                            continue block3;
                        }
                    }
                }
            }
        });
    }

    protected class networkConnectionKey {
        protected networkConnectionKey() {
        }

        public boolean equals(Object obj) {
            networkConnectionKey other = (networkConnectionKey)obj;
            return Arrays.equals(this.getAddress(), other.getAddress()) && Arrays.equals(this.getHash(), other.getHash());
        }

        protected String getName() {
            return HTTPNetworkConnection.this.peer.getControl().getDisplayName() + ": " + HTTPNetworkConnection.this.connection.getEndpoint().getNotionalAddress().getAddress().getHostAddress();
        }

        protected byte[] getAddress() {
            return HTTPNetworkConnection.this.connection.getEndpoint().getNotionalAddress().getAddress().getAddress();
        }

        protected byte[] getHash() {
            return HTTPNetworkConnection.this.peer.getControl().getHash();
        }

        public int hashCode() {
            return HTTPNetworkConnection.this.peer.getControl().hashCode();
        }
    }

    protected class pendingRequest {
        private int piece;
        private int start;
        private int length;
        private httpRequest http_request;
        private BTPiece bt_piece;

        protected pendingRequest(BTRequest _request, httpRequest _http_request) {
            this.piece = _request.getPieceNumber();
            this.start = _request.getPieceOffset();
            this.length = _request.getLength();
            this.http_request = _http_request;
        }

        protected int getPieceNumber() {
            return this.piece;
        }

        protected int getStart() {
            return this.start;
        }

        protected int getLength() {
            return this.length;
        }

        protected httpRequest getHTTPRequest() {
            return this.http_request;
        }

        protected BTPiece getBTPiece() {
            return this.bt_piece;
        }

        protected void setBTPiece(BTPiece _bt_piece) {
            this.bt_piece = _bt_piece;
        }
    }

    protected class httpRequest {
        private long[] offsets;
        private long[] lengths;
        private boolean partial_content;
        private int index;
        private long total_length;
        private boolean sent_first_reply;
        private boolean keep_alive;

        protected httpRequest(long[] _offsets, long[] _lengths, boolean _partial_content, boolean _keep_alive) {
            this.offsets = _offsets;
            this.lengths = _lengths;
            this.partial_content = _partial_content;
            this.keep_alive = _keep_alive;
            for (int i = 0; i < this.lengths.length; ++i) {
                this.total_length += this.lengths[i];
            }
        }

        protected boolean isPartialContent() {
            return this.partial_content;
        }

        protected boolean hasSentFirstReply() {
            return this.sent_first_reply;
        }

        protected void setSentFirstReply() {
            this.sent_first_reply = true;
        }

        protected long[] getOffsets() {
            return this.offsets;
        }

        protected long[] getLengths() {
            return this.lengths;
        }

        protected int getIndex() {
            return this.index;
        }

        protected void setIndex(int _index) {
            this.index = _index;
        }

        protected long getTotalLength() {
            return this.total_length;
        }

        protected boolean keepAlive() {
            return this.keep_alive;
        }
    }
}

