/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnection;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;

public class HTTPNetworkConnectionWebSeed
extends HTTPNetworkConnection {
    protected HTTPNetworkConnectionWebSeed(HTTPNetworkManager _manager, NetworkConnection _connection, PEPeerTransport _peer, String _url) {
        super(_manager, _connection, _peer, _url);
    }

    protected void decodeHeader(String header) throws IOException {
        if (!this.isSeed()) {
            return;
        }
        int pos = header.indexOf("\r\n");
        String line = header.substring(4, pos);
        pos = line.lastIndexOf(32);
        String url = line.substring(0, pos).trim();
        StringTokenizer tok = new StringTokenizer(url, "&");
        int piece = -1;
        ArrayList<int[]> ranges = new ArrayList<int[]>();
        while (tok.hasMoreElements()) {
            String token = tok.nextToken();
            pos = token.indexOf(61);
            if (pos == -1) continue;
            String lhs = token.substring(0, pos).toLowerCase();
            String rhs = token.substring(pos + 1);
            if (lhs.equals("piece")) {
                try {
                    piece = Integer.parseInt(rhs);
                    continue;
                }
                catch (Throwable e) {
                    throw new IOException("Invalid piece number '" + rhs + "'");
                }
            }
            if (!lhs.equals("ranges")) continue;
            StringTokenizer range_tok = new StringTokenizer(rhs, ",");
            while (range_tok.hasMoreTokens()) {
                String range = range_tok.nextToken();
                int sep = range.indexOf(45);
                if (sep == -1) {
                    throw new IOException("Invalid range specification '" + rhs + "'");
                }
                try {
                    ranges.add(new int[]{Integer.parseInt(range.substring(0, sep)), Integer.parseInt(range.substring(sep + 1))});
                }
                catch (Throwable e) {
                    throw new IOException("Invalid range specification '" + rhs + "'");
                }
            }
        }
        if (piece == -1) {
            throw new IOException("Piece number not specified");
        }
        boolean keep_alive = header.toLowerCase().indexOf("keep-alive") != -1;
        PEPeerControl control = this.getPeerControl();
        int this_piece_size = control.getPieceLength(piece);
        if (ranges.size() == 0) {
            ranges.add(new int[]{0, this_piece_size - 1});
        }
        long[] offsets = new long[ranges.size()];
        long[] lengths = new long[ranges.size()];
        long piece_offset = piece * control.getPieceLength(0);
        for (int i = 0; i < ranges.size(); ++i) {
            int[] range = (int[])ranges.get(i);
            int start = range[0];
            int end = range[1];
            if (start < 0 || start >= this_piece_size || end < 0 || end >= this_piece_size || start > end) {
                throw new IOException("Invalid range specification '" + start + "-" + end + "'");
            }
            offsets[i] = piece_offset + (long)start;
            lengths[i] = end - start + 1;
        }
        this.addRequest(new HTTPNetworkConnection.httpRequest(offsets, lengths, false, keep_alive));
    }
}

