/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageEncoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionFile;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkConnectionWebSeed;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import com.aelitis.azureus.core.peermanager.PeerManager;
import com.aelitis.azureus.core.peermanager.PeerManagerRegistration;
import com.aelitis.azureus.core.peermanager.PeerManagerRoutingListener;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamFactory;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.BEncoder;

public class HTTPNetworkManager {
    private static final String NL = "\r\n";
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final HTTPNetworkManager instance = new HTTPNetworkManager();
    private final IncomingSocketChannelManager http_incoming_manager = new IncomingSocketChannelManager("HTTP.Data.Listen.Port", "HTTP.Data.Listen.Port.Enable");

    public static HTTPNetworkManager getSingleton() {
        return instance;
    }

    private HTTPNetworkManager() {
        NetworkManager.ByteMatcher matcher = new NetworkManager.ByteMatcher(){

            public int matchThisSizeOrBigger() {
                return 16;
            }

            public int maxSize() {
                return 256;
            }

            public int minSize() {
                return 3;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object matches(TransportHelper transport, ByteBuffer to_compare, int port) {
                InetSocketAddress address = transport.getAddress();
                int old_limit = to_compare.limit();
                int old_position = to_compare.position();
                try {
                    int hash_end;
                    int hash_start;
                    String url;
                    block27: {
                        byte[] head = new byte[3];
                        to_compare.get(head);
                        if (head[0] != 71 || head[1] != 69 || head[2] != 84) {
                            Object var8_8 = null;
                            return var8_8;
                        }
                        byte[] line_bytes = new byte[to_compare.remaining()];
                        to_compare.get(line_bytes);
                        try {
                            url = new String(line_bytes, "ISO-8859-1");
                            int space = url.indexOf(32);
                            if (space == -1) {
                                Object var11_14 = null;
                                return var11_14;
                            }
                            if ((url = url.substring(space + 1).trim()).indexOf("/index.html") == -1) break block27;
                        }
                        catch (Throwable e) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "HTTP decode from " + address + " failed, " + e.getMessage()));
                            }
                            Object var10_13 = null;
                            return var10_13;
                        }
                        Object[] objectArray = new Object[]{transport, HTTPNetworkManager.this.getIndexPage()};
                        return objectArray;
                    }
                    if (url.indexOf("/ping.html") != -1) {
                        Object[] objectArray = new Object[]{transport, HTTPNetworkManager.this.getPingPage(url)};
                        return objectArray;
                    }
                    if (url.indexOf("/test503.html") != -1) {
                        Object[] objectArray = new Object[]{transport, HTTPNetworkManager.this.getTest503()};
                        return objectArray;
                    }
                    String hash_str = null;
                    int hash_pos = url.indexOf("?info_hash=");
                    if (hash_pos != -1) {
                        hash_start = hash_pos + 11;
                        hash_end = url.indexOf(38, hash_pos);
                        if (hash_end == -1) {
                            Object var15_25 = null;
                            return var15_25;
                        }
                        hash_str = url.substring(hash_start, hash_end);
                    } else {
                        hash_pos = url.indexOf("/files/");
                        if (hash_pos != -1) {
                            hash_start = hash_pos + 7;
                            hash_end = url.indexOf(47, hash_start);
                            if (hash_end == -1) {
                                Object var15_26 = null;
                                return var15_26;
                            }
                            hash_str = url.substring(hash_start, hash_end);
                        }
                    }
                    if (hash_str != null) {
                        byte[] hash = URLDecoder.decode(hash_str, "ISO-8859-1").getBytes("ISO-8859-1");
                        PeerManagerRegistration reg_data = PeerManager.getSingleton().manualMatchHash(address, hash);
                        if (reg_data != null) {
                            int pos = url.indexOf(32);
                            String trimmed = pos == -1 ? url : url.substring(0, pos);
                            Object[] objectArray = new Object[]{trimmed, reg_data};
                            return objectArray;
                        }
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "HTTP decode from " + address + " failed: no match for " + url));
                    }
                    Object[] objectArray = new Object[]{transport, HTTPNetworkManager.this.getNotFound()};
                    return objectArray;
                }
                finally {
                    to_compare.limit(old_limit);
                    to_compare.position(old_position);
                }
            }

            public Object minMatches(TransportHelper transport, ByteBuffer to_compare, int port) {
                byte[] head = new byte[3];
                to_compare.get(head);
                if (head[0] != 71 || head[1] != 69 || head[2] != 84) {
                    return null;
                }
                return "";
            }

            public byte[][] getSharedSecrets() {
                return null;
            }

            public int getSpecificPort() {
                return HTTPNetworkManager.this.http_incoming_manager.getTCPListeningPortNumber();
            }
        };
        NetworkManager.getSingleton().requestIncomingConnectionRouting(matcher, new NetworkManager.RoutingListener(){

            public void connectionRouted(final NetworkConnection connection, Object _routing_data) {
                Object[] x = (Object[])_routing_data;
                if (x[0] instanceof TransportHelper) {
                    HTTPNetworkManager.this.writeReply(connection, (TransportHelper)x[0], (String)x[1]);
                    return;
                }
                final String url = (String)x[0];
                PeerManagerRegistration routing_data = (PeerManagerRegistration)x[1];
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " routed successfully on '" + url + "'"));
                }
                PeerManager.getSingleton().manualRoute(routing_data, connection, new PeerManagerRoutingListener(){

                    public boolean routed(PEPeerTransport peer) {
                        if (url.indexOf("/webseed") != -1) {
                            new HTTPNetworkConnectionWebSeed(HTTPNetworkManager.this, connection, peer, url);
                            return true;
                        }
                        if (url.indexOf("/files/") != -1) {
                            new HTTPNetworkConnectionFile(HTTPNetworkManager.this, connection, peer, url);
                            return true;
                        }
                        return false;
                    }
                });
            }

            public boolean autoCryptoFallback() {
                return false;
            }
        }, new MessageStreamFactory(){

            public MessageStreamEncoder createEncoder() {
                return new HTTPMessageEncoder();
            }

            public MessageStreamDecoder createDecoder() {
                return new HTTPMessageDecoder();
            }
        });
    }

    public boolean isHTTPListenerEnabled() {
        return this.http_incoming_manager.isEnabled();
    }

    public int getHTTPListeningPortNumber() {
        return this.http_incoming_manager.getTCPListeningPortNumber();
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.http_incoming_manager.setExplicitBindAddress(address);
    }

    public void clearExplicitBindAddress() {
        this.http_incoming_manager.clearExplicitBindAddress();
    }

    public boolean isEffectiveBindAddress(InetAddress address) {
        return this.http_incoming_manager.isEffectiveBindAddress(address);
    }

    protected String getIndexPage() {
        return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getPingPage(String url) {
        int pos = url.indexOf(32);
        if (pos != -1) {
            url = url.substring(0, pos);
        }
        pos = url.indexOf(63);
        HashMap<String, String> response = new HashMap<String, String>();
        boolean ok = false;
        if (pos != -1) {
            StringTokenizer tok = new StringTokenizer(url.substring(pos + 1), "&");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                pos = token.indexOf(61);
                if (pos == -1) continue;
                String lhs = token.substring(0, pos);
                String rhs = token.substring(pos + 1);
                if (!lhs.equals("check")) continue;
                response.put("check", rhs);
                ok = true;
            }
        }
        if (ok) {
            try {
                byte[] bytes = BEncoder.encode(response);
                byte[] length = new byte[4];
                ByteBuffer.wrap(length).putInt(bytes.length);
                return "HTTP/1.1 200 OK\r\nConnection: Close\r\nContent-Length: " + (bytes.length + 4) + NL + NL + new String(length, "ISO-8859-1") + new String(bytes, "ISO-8859-1");
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return this.getNotFound();
    }

    protected String getTest503() {
        return "HTTP/1.1 503 Service Unavailable\r\nConnection: Close\r\nContent-Length: 4\r\n\r\n1234";
    }

    protected String getNotFound() {
        return "HTTP/1.1 404 Not Found\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected String getRangeNotSatisfiable() {
        return "HTTP/1.1 416 Not Satisfiable\r\nConnection: Close\r\nContent-Length: 0\r\n\r\n";
    }

    protected void writeReply(final NetworkConnection connection, TransportHelper transport, final String data) {
        byte[] bytes;
        try {
            bytes = data.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            bytes = data.getBytes();
        }
        final ByteBuffer bb = ByteBuffer.wrap(bytes);
        try {
            transport.write(bb, false);
            if (bb.remaining() > 0) {
                transport.registerForWriteSelects(new TransportHelper.selectListener(){

                    public boolean selectSuccess(TransportHelper helper, Object attachment) {
                        try {
                            int written = helper.write(bb, false);
                            if (bb.remaining() > 0) {
                                helper.registerForWriteSelects(this, null);
                            } else {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " closed"));
                                }
                                connection.close();
                            }
                            return written > 0;
                        }
                        catch (Throwable e) {
                            helper.cancelWriteSelects();
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " failed to write error '" + data + "'"));
                            }
                            connection.close();
                            return false;
                        }
                    }

                    public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                        helper.cancelWriteSelects();
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " failed to write error '" + data + "'"));
                        }
                        connection.close();
                    }
                }, null);
            } else {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " closed"));
                }
                connection.close();
            }
        }
        catch (Throwable e) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "HTTP connection from " + connection.getEndpoint().getNotionalAddress() + " failed to write error '" + data + "'"));
            }
            connection.close();
        }
    }
}

