/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.ConnectDisconnectManager;
import com.aelitis.azureus.core.networkmanager.impl.tcp.IncomingSocketChannelManager;
import java.net.InetAddress;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;

public class TCPNetworkManager {
    private static int WRITE_SELECT_LOOP_TIME = 25;
    private static int READ_SELECT_LOOP_TIME = 25;
    protected static int tcp_mss_size;
    private static final TCPNetworkManager instance;
    public static boolean TCP_INCOMING_ENABLED;
    public static boolean TCP_OUTGOING_ENABLED;
    private final VirtualChannelSelector read_selector = new VirtualChannelSelector("TCP network manager", 1, true);
    private final VirtualChannelSelector write_selector = new VirtualChannelSelector("TCP network manager", 4, true);
    private final ConnectDisconnectManager connect_disconnect_manager = new ConnectDisconnectManager();
    private final IncomingSocketChannelManager incoming_socketchannel_manager = new IncomingSocketChannelManager("TCP.Listen.Port", "TCP.Listen.Port.Enable");

    public static TCPNetworkManager getSingleton() {
        return instance;
    }

    public static int getTcpMssSize() {
        return tcp_mss_size;
    }

    public static void refreshRates(int min_rate) {
        tcp_mss_size = COConfigurationManager.getIntParameter("network.tcp.mtu.size") - 40;
        if (tcp_mss_size > min_rate) {
            tcp_mss_size = min_rate - 1;
        }
        if (tcp_mss_size < 512) {
            tcp_mss_size = 512;
        }
    }

    protected TCPNetworkManager() {
        AEThread read_selector_thread = new AEThread("ReadController:ReadSelector"){

            public void runSupport() {
                TCPNetworkManager.this.readSelectorLoop();
            }
        };
        read_selector_thread.setDaemon(true);
        read_selector_thread.setPriority(8);
        read_selector_thread.start();
        AEThread write_selector_thread = new AEThread("WriteController:WriteSelector"){

            public void runSupport() {
                TCPNetworkManager.this.writeSelectorLoop();
            }
        };
        write_selector_thread.setDaemon(true);
        write_selector_thread.setPriority(8);
        write_selector_thread.start();
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.incoming_socketchannel_manager.setExplicitBindAddress(address);
    }

    public void clearExplicitBindAddress() {
        this.incoming_socketchannel_manager.clearExplicitBindAddress();
    }

    public boolean isEffectiveBindAddress(InetAddress address) {
        return this.incoming_socketchannel_manager.isEffectiveBindAddress(address);
    }

    public ConnectDisconnectManager getConnectDisconnectManager() {
        return this.connect_disconnect_manager;
    }

    public VirtualChannelSelector getReadSelector() {
        return this.read_selector;
    }

    public VirtualChannelSelector getWriteSelector() {
        return this.write_selector;
    }

    public boolean isTCPListenerEnabled() {
        return this.incoming_socketchannel_manager.isEnabled();
    }

    public int getTCPListeningPortNumber() {
        return this.incoming_socketchannel_manager.getTCPListeningPortNumber();
    }

    private void readSelectorLoop() {
        while (true) {
            try {
                while (true) {
                    this.read_selector.select(READ_SELECT_LOOP_TIME);
                }
            }
            catch (Throwable t) {
                Debug.out("readSelectorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    private void writeSelectorLoop() {
        while (true) {
            try {
                while (true) {
                    this.write_selector.select(WRITE_SELECT_LOOP_TIME);
                }
            }
            catch (Throwable t) {
                Debug.out("writeSelectorLoop() EXCEPTION: ", t);
                continue;
            }
            break;
        }
    }

    static {
        instance = new TCPNetworkManager();
        COConfigurationManager.addAndFireParameterListener("TCP.Listen.Port.Enable", new ParameterListener(){

            public void parameterChanged(String name) {
                TCP_INCOMING_ENABLED = TCP_OUTGOING_ENABLED = COConfigurationManager.getBooleanParameter(name);
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.read.select.time", "network.tcp.write.select.time"}, new ParameterListener(){

            public void parameterChanged(String name) {
                WRITE_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.write.select.time");
                READ_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.read.select.time");
            }
        });
    }
}

