/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.SelectorGuard;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class VirtualChannelSelectorImpl {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    protected Selector selector;
    private final SelectorGuard selector_guard;
    private final LinkedList register_cancel_list = new LinkedList();
    private final AEMonitor register_cancel_list_mon = new AEMonitor("VirtualChannelSelector:RCL");
    private final HashMap paused_states = new HashMap();
    private final int INTEREST_OP;
    private final boolean pause_after_select;
    protected final VirtualChannelSelector parent;
    private volatile boolean destroyed;
    private static final int WRITE_SELECTOR_DEBUG_CHECK_PERIOD = 10000;
    private static final int WRITE_SELECTOR_DEBUG_MAX_TIME = 20000;
    private long last_write_select_debug;

    public VirtualChannelSelectorImpl(VirtualChannelSelector _parent, int _interest_op, boolean _pause_after_select) {
        String type;
        this.parent = _parent;
        this.INTEREST_OP = _interest_op;
        this.pause_after_select = _pause_after_select;
        switch (this.INTEREST_OP) {
            case 8: {
                type = "OP_CONNECT";
                break;
            }
            case 1: {
                type = "OP_READ";
                break;
            }
            default: {
                type = "OP_WRITE";
            }
        }
        this.selector_guard = new SelectorGuard(type, new SelectorGuard.GuardListener(){

            public boolean safeModeSelectEnabled() {
                return VirtualChannelSelectorImpl.this.parent.isSafeSelectionModeEnabled();
            }

            public void spinDetected() {
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.parent.enableSafeSelectionMode();
            }

            public void failureDetected() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.closeExistingSelector();
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                }
                VirtualChannelSelectorImpl.this.selector = VirtualChannelSelectorImpl.this.openNewSelector();
            }
        });
        this.selector = this.openNewSelector();
    }

    protected Selector openNewSelector() {
        Selector sel = null;
        try {
            sel = Selector.open();
            AEDiagnostics.logWithStack("seltrace", "Selector created for '" + this.parent.getName() + "'," + this.selector_guard.getType());
        }
        catch (Throwable t) {
            Debug.out("ERROR: caught exception on Selector.open()", t);
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            int fail_count = 1;
            while (fail_count < 10) {
                try {
                    sel = Selector.open();
                    AEDiagnostics.logWithStack("seltrace", "Selector created for '" + this.parent.getName() + "'," + this.selector_guard.getType());
                    break;
                }
                catch (Throwable f) {
                    Debug.out(f);
                    ++fail_count;
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable x) {
                        x.printStackTrace();
                    }
                }
            }
            if (fail_count < 10) {
                Debug.out("NOTICE: socket Selector successfully opened after " + fail_count + " failures.");
            }
            Logger.log(new LogAlert(true, 3, "ERROR: socket Selector.open() failed 10 times in a row, aborting.\nAzureus / Java is likely being firewalled!"));
        }
        return sel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseSelects(AbstractSelectableChannel channel) {
        if (channel == null) {
            return;
        }
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null && key.isValid()) {
            key.interestOps(key.interestOps() & ~this.INTEREST_OP);
        } else if (channel.isOpen()) {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.put(channel, new Boolean(true));
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeSelects(AbstractSelectableChannel channel) {
        if (channel == null) {
            Debug.printStackTrace(new Exception("resumeSelects():: channel == null"));
            return;
        }
        SelectionKey key = channel.keyFor(this.selector);
        if (key != null && key.isValid()) {
            if ((key.interestOps() & this.INTEREST_OP) == 0) {
                RegistrationData data = (RegistrationData)key.attachment();
                data.last_select_success_time = SystemTime.getCurrentTime();
                data.non_progress_count = 0;
            }
            key.interestOps(key.interestOps() | this.INTEREST_OP);
        } else {
            try {
                this.register_cancel_list_mon.enter();
                this.paused_states.remove(channel);
            }
            finally {
                this.register_cancel_list_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(AbstractSelectableChannel channel) {
        if (this.destroyed) {
            // empty if block
        }
        if (channel == null) {
            Debug.out("Attempt to cancel selects for null channel");
            return;
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator it = this.register_cancel_list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (channel != obj && (!(obj instanceof RegistrationData) || ((RegistrationData)obj).channel != channel)) continue;
                it.remove();
                break;
            }
            this.pauseSelects(channel);
            this.register_cancel_list.add(channel);
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractSelectableChannel channel, VirtualChannelSelector.VirtualAbstractSelectorListener listener, Object attachment) {
        if (this.destroyed) {
            Debug.out("register called after selector destroyed");
        }
        if (channel == null) {
            Debug.out("Attempt to register selects for null channel");
            return;
        }
        try {
            this.register_cancel_list_mon.enter();
            Iterator it = this.register_cancel_list.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (channel != obj && (!(obj instanceof RegistrationData) || ((RegistrationData)obj).channel != channel)) continue;
                it.remove();
                break;
            }
            this.paused_states.remove(channel);
            this.register_cancel_list.add(new RegistrationData(channel, listener, attachment));
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(long timeout) {
        long time_diff;
        RegistrationData data;
        SelectionKey key;
        long select_start_time = SystemTime.getCurrentTime();
        if (this.selector == null) {
            Debug.out("VirtualChannelSelector.select() op called with null selector");
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            return 0;
        }
        if (!this.selector.isOpen()) {
            Debug.out("VirtualChannelSelector.select() op called with closed selector");
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            return 0;
        }
        RegistrationData select_fail_data = null;
        Throwable select_fail_excep = null;
        try {
            this.register_cancel_list_mon.enter();
            while (this.register_cancel_list.size() > 0) {
                SelectionKey key2;
                Object obj = this.register_cancel_list.remove(0);
                if (obj instanceof AbstractSelectableChannel) {
                    AbstractSelectableChannel canceled_channel = (AbstractSelectableChannel)obj;
                    try {
                        key2 = canceled_channel.keyFor(this.selector);
                        if (key2 == null) continue;
                        key2.cancel();
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    continue;
                }
                RegistrationData data2 = (RegistrationData)obj;
                if (data2 == null) {
                    Debug.out("data == null");
                }
                if (data2.channel == null) {
                    Debug.out("data.channel == null");
                }
                try {
                    if (data2.channel.isOpen()) {
                        Object paused;
                        key2 = data2.channel.keyFor(this.selector);
                        if (key2 != null && key2.isValid()) {
                            key2.attach(data2);
                            key2.interestOps(key2.interestOps() | this.INTEREST_OP);
                        } else {
                            data2.channel.register(this.selector, this.INTEREST_OP, data2);
                        }
                        if ((paused = this.paused_states.get(data2.channel)) == null) continue;
                        this.pauseSelects(data2.channel);
                        continue;
                    }
                    select_fail_data = data2;
                    select_fail_excep = new Throwable("select registration: channel is closed");
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                    select_fail_data = data2;
                    select_fail_excep = t;
                }
            }
            this.paused_states.clear();
        }
        finally {
            this.register_cancel_list_mon.exit();
        }
        if (select_fail_data != null) {
            try {
                this.parent.selectFailure(select_fail_data.listener, select_fail_data.channel, select_fail_data.attachment, select_fail_excep);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        int count = 0;
        this.selector_guard.markPreSelectTime();
        try {
            count = this.selector.select(timeout);
        }
        catch (Throwable t) {
            Debug.out("Caught exception on selector.select() op: " + t.getMessage(), t);
            try {
                Thread.sleep(timeout);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (this.destroyed) {
            this.closeExistingSelector();
            return 0;
        }
        this.selector_guard.verifySelectorIntegrity(count, 12L);
        if (!this.selector.isOpen()) {
            return count;
        }
        int progress_made_key_count = 0;
        int total_key_count = 0;
        long now = SystemTime.getCurrentTime();
        HashSet<SelectionKey> non_selected_keys = null;
        if (this.INTEREST_OP == 4 && (now < this.last_write_select_debug || now - this.last_write_select_debug > 10000L)) {
            this.last_write_select_debug = now;
            non_selected_keys = new HashSet<SelectionKey>(this.selector.keys());
        }
        Iterator<SelectionKey> i = this.selector.selectedKeys().iterator();
        while (i.hasNext()) {
            ++total_key_count;
            key = i.next();
            i.remove();
            data = (RegistrationData)key.attachment();
            if (non_selected_keys != null) {
                non_selected_keys.remove(key);
            }
            data.last_select_success_time = now;
            if (key.isValid()) {
                boolean progress_indicator;
                if ((key.interestOps() & this.INTEREST_OP) == 0) continue;
                if (this.pause_after_select) {
                    key.interestOps(key.interestOps() & ~this.INTEREST_OP);
                }
                if (progress_indicator = this.parent.selectSuccess(data.listener, data.channel, data.attachment)) {
                    ++progress_made_key_count;
                    data.non_progress_count = 0;
                    continue;
                }
                ++data.non_progress_count;
                if (data.non_progress_count != 10 && (data.non_progress_count % 100 != 0 || data.non_progress_count <= 0)) continue;
                Debug.out("VirtualChannelSelector: No progress for op " + this.INTEREST_OP + ": listener = " + data.listener.getClass() + ", count = " + data.non_progress_count + ", socket: open = " + data.channel.isOpen() + (this.INTEREST_OP == 16 ? "" : ", connected = " + ((SocketChannel)data.channel).isConnected()));
                if (data.non_progress_count != 1000) continue;
                Debug.out("No progress for " + data.non_progress_count + ", closing connection");
                try {
                    data.channel.close();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                continue;
            }
            key.cancel();
            this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("key is invalid"));
        }
        if (non_selected_keys != null) {
            i = non_selected_keys.iterator();
            while (i.hasNext()) {
                key = i.next();
                data = (RegistrationData)key.attachment();
                if ((key.interestOps() & this.INTEREST_OP) == 0) continue;
                long stall_time = now - data.last_select_success_time;
                if (stall_time < 0L) {
                    data.last_select_success_time = now;
                    continue;
                }
                if (stall_time <= 20000L) continue;
                Logger.log(new LogEvent(LOGID, 1, "Write select for " + key.channel() + " stalled for " + stall_time));
                if (key.isValid()) {
                    if (this.pause_after_select) {
                        key.interestOps(key.interestOps() & ~this.INTEREST_OP);
                    }
                    if (!this.parent.selectSuccess(data.listener, data.channel, data.attachment)) continue;
                    data.non_progress_count = 0;
                    continue;
                }
                key.cancel();
                this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("key is invalid"));
            }
        }
        if ((total_key_count == 0 || progress_made_key_count != total_key_count) && (time_diff = SystemTime.getCurrentTime() - select_start_time) < timeout && time_diff >= 0L) {
            try {
                Thread.sleep(timeout - time_diff);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return count;
    }

    public void destroy() {
        this.destroyed = true;
    }

    protected void closeExistingSelector() {
        Iterator<SelectionKey> i = this.selector.keys().iterator();
        while (i.hasNext()) {
            SelectionKey key = i.next();
            RegistrationData data = (RegistrationData)key.attachment();
            this.parent.selectFailure(data.listener, data.channel, data.attachment, new Throwable("selector destroyed"));
        }
        try {
            this.selector.close();
            AEDiagnostics.log("seltrace", "Selector destroyed for '" + this.parent.getName() + "'," + this.selector_guard.getType());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static class RegistrationData {
        protected final AbstractSelectableChannel channel;
        protected final VirtualChannelSelector.VirtualAbstractSelectorListener listener;
        protected final Object attachment;
        protected int non_progress_count;
        protected long last_select_success_time;

        private RegistrationData(AbstractSelectableChannel _channel, VirtualChannelSelector.VirtualAbstractSelectorListener _listener, Object _attachment) {
            this.channel = _channel;
            this.listener = _listener;
            this.attachment = _attachment;
            this.last_select_success_time = SystemTime.getCurrentTime();
        }
    }
}

