/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.TransportEndpoint;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.TransportCryptoManager;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportImpl;
import com.aelitis.azureus.core.networkmanager.impl.udp.ProtocolEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.TransportEndpointUDP;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransportHelper;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;

public class UDPTransport
extends TransportImpl {
    private static final LogIDs LOGID = LogIDs.NET;
    private ProtocolEndpointUDP endpoint;
    private byte[][] shared_secrets;
    private int transport_mode = 0;
    private volatile boolean closed;

    protected UDPTransport(ProtocolEndpointUDP _endpoint, byte[][] _shared_secrets) {
        this.endpoint = _endpoint;
        this.shared_secrets = _shared_secrets;
    }

    protected UDPTransport(ProtocolEndpointUDP _endpoint, TransportHelperFilter _filter) {
        this.endpoint = _endpoint;
        this.setFilter(_filter);
    }

    public TransportEndpoint getTransportEndpoint() {
        return new TransportEndpointUDP(this.endpoint);
    }

    public int getMssSize() {
        return UDPNetworkManager.getUdpMssSize();
    }

    public String getDescription() {
        return this.endpoint.getAddress().toString();
    }

    public void setTransportMode(int mode) {
        this.transport_mode = mode;
    }

    public int getTransportMode() {
        return this.transport_mode;
    }

    public void connectOutbound(ByteBuffer initial_data, final Transport.ConnectListener listener) {
        if (!UDPNetworkManager.UDP_OUTGOING_ENABLED) {
            listener.connectFailure(new Throwable("Outbound UDP connections disabled"));
            return;
        }
        if (this.closed) {
            listener.connectFailure(new Throwable("Connection already closed"));
            return;
        }
        if (this.getFilter() != null) {
            listener.connectFailure(new Throwable("Already connected"));
            return;
        }
        UDPTransportHelper helper = null;
        try {
            listener.connectAttemptStarted();
            final UDPTransportHelper f_helper = helper = new UDPTransportHelper(UDPNetworkManager.getSingleton().getConnectionManager(), this.endpoint.getAddress(), this);
            TransportCryptoManager.getSingleton().manageCrypto(helper, this.shared_secrets, false, initial_data, new TransportCryptoManager.HandshakeListener(){

                public void handshakeSuccess(ProtocolDecoder decoder, ByteBuffer remaining_initial_data) {
                    TransportHelperFilter filter = decoder.getFilter();
                    try {
                        UDPTransport.this.setFilter(filter);
                        if (UDPTransport.this.closed) {
                            UDPTransport.this.close("Already closed");
                            listener.connectFailure(new Exception("Connection already closed"));
                        } else {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Outgoing UDP stream to " + UDPTransport.this.endpoint.getAddress() + " established, type = " + filter.getName()));
                            }
                            UDPTransport.this.connectedOutbound();
                            listener.connectSuccess(UDPTransport.this, remaining_initial_data);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        UDPTransport.this.close(Debug.getNestedExceptionMessageAndStack(e));
                        listener.connectFailure(e);
                    }
                }

                public void handshakeFailure(Throwable failure_msg) {
                    f_helper.close(Debug.getNestedExceptionMessageAndStack(failure_msg));
                    listener.connectFailure(failure_msg);
                }

                public void gotSecret(byte[] session_secret) {
                    f_helper.getConnection().setSecret(session_secret);
                }

                public int getMaximumPlainHeaderLength() {
                    throw new RuntimeException();
                }

                public int matchPlainHeader(ByteBuffer buffer) {
                    throw new RuntimeException();
                }
            });
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            if (helper != null) {
                helper.close(Debug.getNestedExceptionMessage(e));
            }
            listener.connectFailure(e);
        }
    }

    public void close(String reason) {
        this.closed = true;
        this.readyForRead(false);
        this.readyForWrite(false);
        TransportHelperFilter filter = this.getFilter();
        if (filter != null) {
            filter.getHelper().close(reason);
            this.setFilter(null);
        }
    }
}

