/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.udp;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnection;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPConnectionManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPSelector;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPTransport;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;

public class UDPTransportHelper
implements TransportHelper {
    public static final int READ_TIMEOUT = 30000;
    public static final int CONNECT_TIMEOUT = 60000;
    private UDPConnectionManager manager;
    private UDPSelector selector;
    private InetSocketAddress address;
    private UDPTransport transport;
    private boolean incoming;
    private UDPConnection connection;
    private TransportHelper.selectListener read_listener;
    private Object read_attachment;
    private boolean read_selects_paused;
    private TransportHelper.selectListener write_listener;
    private Object write_attachment;
    private boolean write_selects_paused = true;
    private boolean closed;
    private IOException failed;
    private ByteBuffer pending_partial_write;
    private Map user_data;

    protected UDPTransportHelper(UDPConnectionManager _manager, InetSocketAddress _address, UDPTransport _transport) throws IOException {
        this.manager = _manager;
        this.address = _address;
        this.transport = _transport;
        this.incoming = false;
        this.connection = this.manager.registerOutgoing(this);
        this.selector = this.connection.getSelector();
    }

    protected UDPTransportHelper(UDPConnectionManager _manager, InetSocketAddress _address, UDPConnection _connection) {
        this.manager = _manager;
        this.address = _address;
        this.connection = _connection;
        this.incoming = true;
        this.selector = this.connection.getSelector();
    }

    protected void setTransport(UDPTransport _transport) {
        this.transport = _transport;
    }

    protected UDPTransport getTransport() {
        return this.transport;
    }

    protected int getMss() {
        if (this.transport == null) {
            return UDPNetworkManager.getUdpMssSize();
        }
        return this.transport.getMssSize();
    }

    public boolean minimiseOverheads() {
        return true;
    }

    public int getConnectTimeout() {
        return 60000;
    }

    public int getReadTimeout() {
        return 30000;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public String getName() {
        return " (UDP)";
    }

    public boolean isIncoming() {
        return this.incoming;
    }

    protected UDPConnection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer buffer, boolean partial_write) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        if (partial_write && this.pending_partial_write == null && buffer.remaining() < 128) {
            ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
            copy.put(buffer);
            copy.position(0);
            this.pending_partial_write = copy;
            return copy.remaining();
        }
        if (this.pending_partial_write != null) {
            int pw_len = this.pending_partial_write.remaining();
            try {
                int written = this.connection.write(new ByteBuffer[]{this.pending_partial_write, buffer}, 0, 2);
                if (written >= pw_len) {
                    int n = written - pw_len;
                    return n;
                }
                int n = 0;
                return n;
            }
            finally {
                if (this.pending_partial_write.remaining() == 0) {
                    this.pending_partial_write = null;
                }
            }
        }
        return this.connection.write(new ByteBuffer[]{buffer}, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        return this.connection.write(buffers, array_offset, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer buffer) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        return this.connection.read(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.failed != null) {
                throw this.failed;
            }
            if (this.closed) {
                throw new IOException("Transport closed");
            }
        }
        long total = 0L;
        for (int i = array_offset; i < array_offset + length; ++i) {
            ByteBuffer buffer = buffers[i];
            int max = buffer.remaining();
            int read = this.connection.read(buffer);
            total += (long)read;
            if (read < max) break;
        }
        return total;
    }

    protected void canRead() {
        this.fireReadSelect();
    }

    protected void canWrite() {
        this.fireWriteSelect();
    }

    public synchronized void pauseReadSelects() {
        if (this.read_listener != null) {
            this.selector.cancel(this, this.read_listener);
        }
        this.read_selects_paused = true;
    }

    public synchronized void pauseWriteSelects() {
        if (this.write_listener != null) {
            this.selector.cancel(this, this.write_listener);
        }
        this.write_selects_paused = true;
    }

    public synchronized void resumeReadSelects() {
        this.read_selects_paused = false;
        this.fireReadSelect();
    }

    public synchronized void resumeWriteSelects() {
        this.write_selects_paused = false;
        this.fireWriteSelect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForReadSelects(TransportHelper.selectListener listener, Object attachment) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.read_listener = listener;
            this.read_attachment = attachment;
        }
        this.resumeReadSelects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForWriteSelects(TransportHelper.selectListener listener, Object attachment) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.write_listener = listener;
            this.write_attachment = attachment;
        }
        this.resumeWriteSelects();
    }

    public synchronized void cancelReadSelects() {
        this.selector.cancel(this, this.read_listener);
        this.read_selects_paused = true;
        this.read_listener = null;
        this.read_attachment = null;
    }

    public synchronized void cancelWriteSelects() {
        this.selector.cancel(this, this.write_listener);
        this.write_selects_paused = true;
        this.write_listener = null;
        this.write_attachment = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireReadSelect() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.read_listener != null && !this.read_selects_paused) {
                if (this.failed != null) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, this.failed);
                } else if (this.closed) {
                    this.selector.ready(this, this.read_listener, this.read_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canRead()) {
                    this.selector.ready(this, this.read_listener, this.read_attachment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireWriteSelect() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            if (this.write_listener != null && !this.write_selects_paused) {
                if (this.failed != null) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, this.failed);
                } else if (this.closed) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment, new Throwable("Transport closed"));
                } else if (this.connection.canWrite()) {
                    this.write_selects_paused = true;
                    this.selector.ready(this, this.write_listener, this.write_attachment);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Throwable reason) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.failed = reason instanceof IOException ? (IOException)reason : new IOException(Debug.getNestedExceptionMessageAndStack(reason));
            this.fireReadSelect();
            this.fireWriteSelect();
        }
        this.connection.failedSupport(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(String reason) {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.closed = true;
            this.fireReadSelect();
            this.fireWriteSelect();
        }
        this.connection.closeSupport(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poll() {
        UDPTransportHelper uDPTransportHelper = this;
        synchronized (uDPTransportHelper) {
            this.fireReadSelect();
            this.fireWriteSelect();
        }
    }

    public synchronized void setUserData(Object key, Object data) {
        if (this.user_data == null) {
            this.user_data = new HashMap();
        }
        this.user_data.put(key, data);
    }

    public synchronized Object getUserData(Object key) {
        if (this.user_data == null) {
            return null;
        }
        return this.user_data.get(key);
    }
}

