/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZPeerExchange
implements AZMessage {
    private static final LogIDs LOGID = LogIDs.NET;
    private static final byte bss = 11;
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final byte[] infohash;
    private final PeerItem[] peers_added;
    private final PeerItem[] peers_dropped;

    public AZPeerExchange(byte[] _infohash, PeerItem[] _peers_added, PeerItem[] _peers_dropped) {
        this.infohash = _infohash;
        this.peers_added = _peers_added;
        this.peers_dropped = _peers_dropped;
    }

    private void insertPeers(String key_name, Map root_map, PeerItem[] peers) {
        if (peers != null && peers.length > 0) {
            ArrayList<byte[]> raw_peers = new ArrayList<byte[]>();
            byte[] handshake_types = new byte[peers.length];
            byte[] udp_ports = new byte[peers.length * 2];
            int num_valid_udp = 0;
            for (int i = 0; i < peers.length; ++i) {
                raw_peers.add(peers[i].getSerialization());
                handshake_types[i] = peers[i].getHandshakeType();
                int udp_port = peers[i].getUDPPort();
                if (udp_port <= 0) continue;
                ++num_valid_udp;
                udp_ports[i * 2] = (byte)(udp_port >> 8);
                udp_ports[i * 2 + 1] = (byte)udp_port;
            }
            root_map.put(key_name, raw_peers);
            root_map.put(key_name + "_HST", handshake_types);
            if (num_valid_udp > 0) {
                root_map.put(key_name + "_UDP", udp_ports);
            }
        }
    }

    private PeerItem[] extractPeers(String key_name, Map root_map) {
        PeerItem[] return_peers = null;
        ArrayList<PeerItem> peers = new ArrayList<PeerItem>();
        List raw_peers = (List)root_map.get(key_name);
        if (raw_peers != null) {
            int peer_num = raw_peers.size();
            byte[] handshake_types = (byte[])root_map.get(key_name + "_HST");
            byte[] udp_ports = (byte[])root_map.get(key_name + "_UDP");
            int pos = 0;
            if (handshake_types != null && handshake_types.length != peer_num) {
                Logger.log(new LogEvent(LOGID, 1, "PEX: invalid handshake types received: peers=" + peer_num + ",handshakes=" + handshake_types.length));
                handshake_types = null;
            }
            if (udp_ports != null && udp_ports.length != peer_num * 2) {
                Logger.log(new LogEvent(LOGID, 1, "PEX: invalid udp ports received: peers=" + peer_num + ",udp_ports=" + udp_ports.length));
                udp_ports = null;
            }
            Iterator it = raw_peers.iterator();
            while (it.hasNext()) {
                byte[] full_address = (byte[])it.next();
                byte type = 0;
                if (handshake_types != null) {
                    type = handshake_types[pos];
                }
                int udp_port = 0;
                if (udp_ports != null) {
                    udp_port = (udp_ports[pos * 2] << 8 & 0xFF00) + (udp_ports[pos * 2 + 1] & 0xFF);
                }
                try {
                    PeerItem peer = PeerItemFactory.createPeerItem(full_address, (byte)2, type, udp_port);
                    peers.add(peer);
                }
                catch (Exception t) {
                    Logger.log(new LogEvent(LOGID, 1, "PEX: invalid peer received"));
                }
                ++pos;
            }
        }
        if (!peers.isEmpty()) {
            return_peers = new PeerItem[peers.size()];
            peers.toArray(return_peers);
        }
        return return_peers;
    }

    public byte[] getInfoHash() {
        return this.infohash;
    }

    public PeerItem[] getAddedPeers() {
        return this.peers_added;
    }

    public PeerItem[] getDroppedPeers() {
        return this.peers_dropped;
    }

    public String getID() {
        return "AZ_PEER_EXCHANGE";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_PEER_EXCHANGE_BYTES;
    }

    public String getFeatureID() {
        return "AZ1";
    }

    public int getFeatureSubID() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            int add_count = this.peers_added == null ? 0 : this.peers_added.length;
            int drop_count = this.peers_dropped == null ? 0 : this.peers_dropped.length;
            this.description = this.getID() + " for infohash " + ByteFormatter.nicePrint(this.infohash, true) + " with " + add_count + " added and " + drop_count + " dropped peers";
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, byte[]> payload_map = new HashMap<String, byte[]>();
            payload_map.put("infohash", this.infohash);
            this.insertPeers("added", payload_map, this.peers_added);
            this.insertPeers("dropped", payload_map, this.peers_dropped);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)14);
            if (this.buffer.remaining((byte)11) > 2000) {
                System.out.println("Generated AZPeerExchange size = " + this.buffer.remaining((byte)11) + " bytes");
            }
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        Map root;
        byte[] hash;
        if (data.remaining((byte)11) > 2000) {
            System.out.println("Received PEX msg byte size = " + data.remaining((byte)11));
        }
        if ((hash = (byte[])(root = MessagingUtil.convertBencodedByteStreamToPayload(data, 10, this.getID())).get("infohash")) == null) {
            throw new MessageException("hash == null");
        }
        if (hash.length != 20) {
            throw new MessageException("hash.length != 20: " + hash.length);
        }
        PeerItem[] added = this.extractPeers("added", root);
        PeerItem[] dropped = this.extractPeers("dropped", root);
        if (added == null && dropped == null) {
            throw new MessageException("[" + this.getID() + "] received exchange message without any adds or drops");
        }
        return new AZPeerExchange(hash, added, dropped);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

