/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.azureus.session;

import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessagingUtil;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessage;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.DirectByteBuffer;

public class AZSessionAck
implements AZMessage {
    private DirectByteBuffer buffer = null;
    private String description = null;
    private final int session_id;
    private final byte[] infohash;
    private final Map session_info;

    public AZSessionAck(byte[] infohash, int local_session_id, Map session_info) {
        this.session_id = local_session_id;
        this.infohash = infohash;
        this.session_info = session_info;
    }

    public int getSessionID() {
        return this.session_id;
    }

    public byte[] getInfoHash() {
        return this.infohash;
    }

    public Map getSessionInfo() {
        return this.session_info;
    }

    public String getID() {
        return "AZ_SESSION_ACK";
    }

    public byte[] getIDBytes() {
        return AZMessage.ID_AZ_SESSION_ACK_BYTES;
    }

    public String getFeatureID() {
        throw new RuntimeException("not implemented");
    }

    public int getFeatureSubID() {
        throw new RuntimeException("not implemented");
    }

    public int getType() {
        return 0;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getID() + " session id " + this.session_id + " for infohash " + ByteFormatter.nicePrint(this.infohash, true);
        }
        return this.description;
    }

    public DirectByteBuffer[] getData() {
        if (this.buffer == null) {
            HashMap<String, Object> payload_map = new HashMap<String, Object>();
            payload_map.put("session_id", new Long(this.session_id));
            payload_map.put("infohash", this.infohash);
            payload_map.put("info", this.session_info);
            this.buffer = MessagingUtil.convertPayloadToBencodedByteStream(payload_map, (byte)12);
        }
        return new DirectByteBuffer[]{this.buffer};
    }

    public Message deserialize(DirectByteBuffer data) throws MessageException {
        Map root = MessagingUtil.convertBencodedByteStreamToPayload(data, 20, this.getID());
        Long id = (Long)root.get("session_id");
        if (id == null) {
            throw new MessageException("id == null");
        }
        int sid = id.intValue();
        byte[] hash = (byte[])root.get("infohash");
        if (hash == null) {
            throw new MessageException("hash == null");
        }
        if (hash.length != 20) {
            throw new MessageException("hash.length != 20: " + hash.length);
        }
        Map info = (Map)root.get("info");
        return new AZSessionAck(hash, sid, info);
    }

    public void destroy() {
        if (this.buffer != null) {
            this.buffer.returnToPool();
        }
    }
}

