/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.messaging.bittorrent;

import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageException;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class BTMessageDecoder
implements MessageStreamDecoder {
    private static final int MIN_MESSAGE_LENGTH = 1;
    private static final int MAX_MESSAGE_LENGTH = 16393;
    private static final int HANDSHAKE_FAKE_LENGTH = 323119476;
    private static final byte SS = 11;
    private DirectByteBuffer payload_buffer = null;
    private final DirectByteBuffer length_buffer = DirectByteBufferPool.getBuffer((byte)12, 4);
    private final ByteBuffer[] decode_array = new ByteBuffer[]{null, this.length_buffer.getBuffer((byte)11)};
    private boolean reading_length_mode = true;
    private boolean reading_handshake_message = false;
    private int message_length;
    private int pre_read_start_buffer;
    private int pre_read_start_position;
    private boolean last_received_was_keepalive = false;
    private volatile boolean destroyed = false;
    private volatile boolean is_paused = false;
    private ArrayList messages_last_read = new ArrayList();
    private int protocol_bytes_last_read = 0;
    private int data_bytes_last_read = 0;
    private int percent_complete = -1;

    public int performStreamDecode(Transport transport, int max_bytes) throws IOException {
        int bytes_remaining;
        int bytes_read;
        this.protocol_bytes_last_read = 0;
        this.data_bytes_last_read = 0;
        for (bytes_remaining = max_bytes; bytes_remaining > 0 && !this.destroyed && !this.is_paused; bytes_remaining -= bytes_read) {
            int bytes_possible = this.preReadProcess(bytes_remaining);
            if (bytes_possible < 1) {
                Debug.out("ERROR BT: bytes_possible < 1");
                break;
            }
            if (this.reading_length_mode) {
                transport.read(this.decode_array, 1, 1);
            } else {
                transport.read(this.decode_array, 0, 2);
            }
            bytes_read = this.postReadProcess();
            if (bytes_read < bytes_possible) break;
            if (!this.reading_length_mode || !this.last_received_was_keepalive) continue;
            this.last_received_was_keepalive = false;
            break;
        }
        return max_bytes - bytes_remaining;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    public Message[] removeDecodedMessages() {
        if (this.messages_last_read.isEmpty()) {
            return null;
        }
        Message[] msgs = this.messages_last_read.toArray(new Message[this.messages_last_read.size()]);
        this.messages_last_read.clear();
        return msgs;
    }

    public int getProtocolBytesDecoded() {
        return this.protocol_bytes_last_read;
    }

    public int getDataBytesDecoded() {
        return this.data_bytes_last_read;
    }

    public ByteBuffer destroy() {
        this.is_paused = true;
        this.destroyed = true;
        int lbuff_read = 0;
        int pbuff_read = 0;
        this.length_buffer.limit((byte)11, 4);
        if (this.reading_length_mode) {
            lbuff_read = this.length_buffer.position((byte)11);
        } else {
            this.length_buffer.position((byte)11, 4);
            lbuff_read = 4;
            pbuff_read = this.payload_buffer == null ? 0 : this.payload_buffer.position((byte)11);
        }
        ByteBuffer unused = ByteBuffer.allocate(lbuff_read + pbuff_read);
        this.length_buffer.flip((byte)11);
        unused.put(this.length_buffer.getBuffer((byte)11));
        if (this.payload_buffer != null) {
            this.payload_buffer.flip((byte)11);
            unused.put(this.payload_buffer.getBuffer((byte)11));
        }
        unused.flip();
        this.length_buffer.returnToPool();
        if (this.payload_buffer != null) {
            this.payload_buffer.returnToPool();
            this.payload_buffer = null;
        }
        for (int i = 0; i < this.messages_last_read.size(); ++i) {
            Message msg = (Message)this.messages_last_read.get(i);
            msg.destroy();
        }
        this.messages_last_read.clear();
        return unused;
    }

    private int preReadProcess(int allowed) {
        if (allowed < 1) {
            Debug.out("allowed < 1");
        }
        this.decode_array[0] = this.payload_buffer == null ? null : this.payload_buffer.getBuffer((byte)11);
        int bytes_available = 0;
        boolean shrink_remaining_buffers = false;
        int start_buff = this.reading_length_mode ? 1 : 0;
        boolean marked = false;
        for (int i = start_buff; i < 2; ++i) {
            ByteBuffer bb = this.decode_array[i];
            if (bb == null) {
                Debug.out("preReadProcess:: bb[" + i + "] == null, decoder destroyed=" + this.destroyed);
            }
            if (shrink_remaining_buffers) {
                bb.limit(0);
                continue;
            }
            int remaining = bb.remaining();
            if (remaining < 1) continue;
            if (!marked) {
                this.pre_read_start_buffer = i;
                this.pre_read_start_position = bb.position();
                marked = true;
            }
            if (remaining > allowed) {
                bb.limit(bb.position() + allowed);
                bytes_available += bb.remaining();
                shrink_remaining_buffers = true;
                continue;
            }
            bytes_available += remaining;
            allowed -= remaining;
        }
        return bytes_available;
    }

    private int postReadProcess() throws IOException {
        int prot_bytes_read = 0;
        int data_bytes_read = 0;
        if (!this.reading_length_mode && !this.destroyed) {
            this.payload_buffer.limit((byte)11, this.message_length);
            this.length_buffer.limit((byte)11, 4);
            int read = this.payload_buffer.position((byte)11) - this.pre_read_start_position;
            if (this.payload_buffer.position((byte)11) > 0) {
                if (BTMessageFactory.getMessageType(this.payload_buffer) == 1) {
                    data_bytes_read += read;
                } else {
                    prot_bytes_read += read;
                }
            }
            if (!this.payload_buffer.hasRemaining((byte)11) && !this.is_paused) {
                this.payload_buffer.position((byte)11, 0);
                DirectByteBuffer ref_buff = this.payload_buffer;
                this.payload_buffer = null;
                if (this.reading_handshake_message) {
                    this.reading_handshake_message = false;
                    DirectByteBuffer handshake_data = DirectByteBufferPool.getBuffer((byte)16, 68);
                    handshake_data.putInt((byte)11, 323119476);
                    handshake_data.put((byte)11, ref_buff);
                    handshake_data.flip((byte)11);
                    ref_buff.returnToPool();
                    try {
                        Message handshake = MessageManager.getSingleton().createMessage(BTMessage.ID_BT_HANDSHAKE_BYTES, handshake_data);
                        this.messages_last_read.add(handshake);
                    }
                    catch (MessageException me) {
                        handshake_data.returnToPool();
                        throw new IOException("BT message decode failed: " + me.getMessage());
                    }
                    this.pauseDecoding();
                } else {
                    try {
                        Message msg = BTMessageFactory.createBTMessage(ref_buff);
                        this.messages_last_read.add(msg);
                    }
                    catch (MessageException me) {
                        ref_buff.returnToPool();
                        throw new IOException("BT message decode failed: " + me.getMessage());
                    }
                }
                this.reading_length_mode = true;
                this.percent_complete = -1;
            } else {
                this.percent_complete = this.payload_buffer.position((byte)11) * 100 / this.message_length;
            }
        }
        if (this.reading_length_mode && !this.destroyed) {
            this.length_buffer.limit((byte)11, 4);
            prot_bytes_read += this.pre_read_start_buffer == 1 ? this.length_buffer.position((byte)11) - this.pre_read_start_position : this.length_buffer.position((byte)11);
            if (!this.length_buffer.hasRemaining((byte)11)) {
                this.reading_length_mode = false;
                this.length_buffer.position((byte)11, 0);
                this.message_length = this.length_buffer.getInt((byte)11);
                this.length_buffer.position((byte)11, 0);
                if (this.message_length == 323119476) {
                    this.reading_handshake_message = true;
                    this.message_length = 64;
                    this.payload_buffer = DirectByteBufferPool.getBuffer((byte)16, this.message_length);
                } else if (this.message_length == 0) {
                    this.reading_length_mode = true;
                    this.last_received_was_keepalive = true;
                    try {
                        Message keep_alive = MessageManager.getSingleton().createMessage(BTMessage.ID_BT_KEEP_ALIVE_BYTES, null);
                        this.messages_last_read.add(keep_alive);
                    }
                    catch (MessageException me) {
                        throw new IOException("BT message decode failed: " + me.getMessage());
                    }
                } else {
                    if (this.message_length < 1 || this.message_length > 16393) {
                        throw new IOException("Invalid message length given for BT message decode: " + this.message_length);
                    }
                    this.payload_buffer = DirectByteBufferPool.getBuffer((byte)23, this.message_length);
                }
            }
        }
        this.protocol_bytes_last_read += prot_bytes_read;
        this.data_bytes_last_read += data_bytes_read;
        return prot_bytes_read + data_bytes_read;
    }

    public void pauseDecoding() {
        this.is_paused = true;
    }

    public void resumeDecoding() {
        this.is_paused = false;
    }
}

