/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerDatabase {
    private static final int MIN_REBUILD_WAIT_TIME = 60000;
    private static final int MAX_DISCOVERED_PEERS = 500;
    private static final int BLOOM_ROTATION_PERIOD = 420000;
    private static final int BLOOM_FILTER_SIZE = 10000;
    private final HashMap peer_connections = new HashMap();
    private final LinkedList discovered_peers = new LinkedList();
    private final AEMonitor map_mon = new AEMonitor("PeerDatabase");
    private PeerItem[] cached_peer_popularities = null;
    private int popularity_pos = 0;
    private long last_rebuild_time = 0L;
    private long last_rotation_time = 0L;
    private PeerItem self_peer;
    private BloomFilter filter_one = null;
    private BloomFilter filter_two = BloomFilterFactory.createAddOnly(10000);

    protected PeerDatabase() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerExchangerItem registerPeerConnection(PeerItem base_peer_item, PeerExchangerItem.Helper helper) {
        try {
            this.map_mon.enter();
            PeerExchangerItem new_connection = new PeerExchangerItem(this, base_peer_item, helper);
            Iterator it = this.peer_connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                PeerItem old_key = (PeerItem)entry.getKey();
                PeerExchangerItem old_connection = (PeerExchangerItem)entry.getValue();
                if (old_connection.getHelper().isSeed() && new_connection.getHelper().isSeed()) continue;
                old_connection.notifyAdded(base_peer_item);
                new_connection.notifyAdded(old_key);
            }
            this.peer_connections.put(base_peer_item, new_connection);
            PeerExchangerItem peerExchangerItem = new_connection;
            return peerExchangerItem;
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterPeerConnection(PeerItem base_peer_key) {
        try {
            this.map_mon.enter();
            this.peer_connections.remove(base_peer_key);
            Iterator it = this.peer_connections.values().iterator();
            while (it.hasNext()) {
                PeerExchangerItem old_connection = (PeerExchangerItem)it.next();
                old_connection.notifyDropped(base_peer_key);
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seedStatusChanged(PeerExchangerItem item) {
        if (item.getHelper().isSeed()) {
            try {
                this.map_mon.enter();
                Iterator it = this.peer_connections.values().iterator();
                while (it.hasNext()) {
                    PeerExchangerItem connection = (PeerExchangerItem)it.next();
                    if (connection == item || !connection.getHelper().isSeed()) continue;
                    connection.notifyDropped(item.getBasePeer());
                    item.notifyDropped(connection.getBasePeer());
                }
            }
            finally {
                this.map_mon.exit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDiscoveredPeer(PeerItem peer) {
        try {
            this.map_mon.enter();
            Iterator it = this.peer_connections.values().iterator();
            while (it.hasNext()) {
                PeerExchangerItem connection = (PeerExchangerItem)it.next();
                if (!connection.isConnectedToPeer(peer)) continue;
                return;
            }
            if (!this.discovered_peers.contains(peer)) {
                this.discovered_peers.addLast(peer);
                int max_cache_size = PeerUtils.MAX_CONNECTIONS_PER_TORRENT;
                if (max_cache_size < 1 || max_cache_size > 500) {
                    max_cache_size = 500;
                }
                if (this.discovered_peers.size() > max_cache_size) {
                    this.discovered_peers.removeFirst();
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
    }

    public void setSelfPeer(PeerItem self) {
        this.self_peer = self;
    }

    public PeerItem getSelfPeer() {
        return this.self_peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeerItem[] getDiscoveredPeers() {
        try {
            this.map_mon.enter();
            PeerItem[] peerItemArray = this.discovered_peers.toArray(new PeerItem[this.discovered_peers.size()]);
            return peerItemArray;
        }
        finally {
            this.map_mon.exit();
        }
    }

    public PeerItem getNextOptimisticConnectPeer() {
        return this.getNextOptimisticConnectPeer(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PeerItem getNextOptimisticConnectPeer(int recursion_count) {
        PeerItem peer = null;
        boolean discovered_peer = false;
        try {
            this.map_mon.enter();
            if (!this.discovered_peers.isEmpty()) {
                peer = (PeerItem)this.discovered_peers.removeFirst();
                discovered_peer = true;
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (peer == null) {
            if (this.cached_peer_popularities == null || this.popularity_pos == this.cached_peer_popularities.length) {
                this.cached_peer_popularities = null;
                long time_since_rebuild = SystemTime.getCurrentTime() - this.last_rebuild_time;
                if (time_since_rebuild > 60000L || time_since_rebuild < 0L) {
                    this.cached_peer_popularities = this.getExchangedPeersSortedByLeastPopularFirst();
                    this.popularity_pos = 0;
                    this.last_rebuild_time = SystemTime.getCurrentTime();
                }
            }
            if (this.cached_peer_popularities != null && this.cached_peer_popularities.length > 0) {
                peer = this.cached_peer_popularities[this.popularity_pos];
                ++this.popularity_pos;
                this.last_rebuild_time = SystemTime.getCurrentTime();
            }
        }
        if (peer != null) {
            PeerItem next_peer;
            long diff = SystemTime.getCurrentTime() - this.last_rotation_time;
            if (diff < 0L || diff > 420000L) {
                this.filter_one = this.filter_two;
                this.filter_two = BloomFilterFactory.createAddOnly(10000);
                this.last_rotation_time = SystemTime.getCurrentTime();
            }
            boolean already_recorded = false;
            byte[] peer_serialisation = peer.getSerialization();
            if (this.filter_one.contains(peer_serialisation) && recursion_count < 100 && (next_peer = this.getNextOptimisticConnectPeer(recursion_count + 1)) != null) {
                if (discovered_peer) {
                    try {
                        this.map_mon.enter();
                        this.discovered_peers.addLast(peer);
                    }
                    finally {
                        this.map_mon.exit();
                    }
                }
                peer = next_peer;
                already_recorded = true;
            }
            if (!already_recorded) {
                this.filter_one.add(peer_serialisation);
                this.filter_two.add(peer_serialisation);
            }
        }
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PeerItem[] getExchangedPeersSortedByLeastPopularFirst() {
        HashMap<PeerItem, Integer> popularity_counts = new HashMap<PeerItem, Integer>();
        try {
            this.map_mon.enter();
            Iterator it = this.peer_connections.values().iterator();
            while (it.hasNext()) {
                PeerExchangerItem connection = (PeerExchangerItem)it.next();
                PeerItem[] peers = connection.getConnectedPeers();
                for (int i = 0; i < peers.length; ++i) {
                    PeerItem peer = peers[i];
                    Integer count = (Integer)popularity_counts.get(peer);
                    count = count == null ? new Integer(1) : new Integer(count + 1);
                    popularity_counts.put(peer, count);
                }
            }
        }
        finally {
            this.map_mon.exit();
        }
        if (popularity_counts.isEmpty()) {
            return null;
        }
        Map.Entry[] sorted_entries = new Map.Entry[popularity_counts.size()];
        popularity_counts.entrySet().toArray(sorted_entries);
        Arrays.sort(sorted_entries, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Map.Entry en1 = (Map.Entry)obj1;
                Map.Entry en2 = (Map.Entry)obj2;
                return ((Integer)en1.getValue()).compareTo((Integer)en2.getValue());
            }
        });
        PeerItem[] sorted_peers = new PeerItem[sorted_entries.length];
        for (int i = 0; i < sorted_entries.length; ++i) {
            Map.Entry entry = sorted_entries[i];
            sorted_peers[i] = (PeerItem)entry.getKey();
        }
        return sorted_peers;
    }
}

