/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.peerdb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import org.gudy.azureus2.plugins.peers.PeerDescriptor;

public class PeerItem
implements PeerDescriptor {
    private final byte[] address;
    private final short udp_port;
    private final short tcp_port;
    private final byte source;
    private final int hashcode;
    private final byte handshake;
    private final byte crypto_level;
    private final short up_speed;

    protected PeerItem(String _address, int _tcp_port, byte _source, byte _handshake, int _udp_port, byte _crypto_level, int _up_speed) {
        byte[] raw;
        try {
            InetAddress ip = InetAddress.getByName(_address);
            raw = ip.getAddress();
        }
        catch (UnknownHostException e) {
            raw = _address.getBytes();
        }
        this.address = raw;
        this.tcp_port = (short)_tcp_port;
        this.udp_port = (short)_udp_port;
        this.source = _source;
        this.hashcode = new String(this.address).hashCode() + this.tcp_port;
        this.handshake = _handshake;
        this.crypto_level = _crypto_level;
        this.up_speed = (short)_up_speed;
        if (this.address.length != 4) {
            System.out.println("PeerItem OUT: address byte size=" + this.address.length);
        }
    }

    protected PeerItem(byte[] _serialization, byte _source, byte _handshake, int _udp_port) throws Exception {
        if (_serialization.length < 6 || _serialization.length > 32) {
            throw new Exception("PeerItem: invalid serialisation length - " + _serialization.length);
        }
        this.address = new byte[_serialization.length - 2];
        System.arraycopy(_serialization, 0, this.address, 0, _serialization.length - 2);
        byte p0 = _serialization[_serialization.length - 2];
        byte p1 = _serialization[_serialization.length - 1];
        this.tcp_port = (short)((p1 & 0xFF) + ((p0 & 0xFF) << 8));
        this.source = _source;
        this.hashcode = new String(this.address).hashCode() + this.tcp_port;
        this.handshake = _handshake;
        this.udp_port = (short)_udp_port;
        this.crypto_level = 1;
        this.up_speed = 0;
        if (this.address.length > 15) {
            System.out.println("PeerItem IN: address byte size=" + this.address.length);
        }
    }

    public byte[] getSerialization() {
        byte[] full_address = new byte[this.address.length + 2];
        System.arraycopy(this.address, 0, full_address, 0, this.address.length);
        full_address[this.address.length] = (byte)(this.tcp_port >> 8);
        full_address[this.address.length + 1] = (byte)(this.tcp_port & 0xFF);
        return full_address;
    }

    public String getAddressString() {
        try {
            return InetAddress.getByAddress(this.address).getHostAddress();
        }
        catch (UnknownHostException e) {
            return new String(this.address);
        }
    }

    public String getIP() {
        return this.getAddressString();
    }

    public int getTCPPort() {
        return this.tcp_port & 0xFFFF;
    }

    public int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    public byte getSource() {
        return this.source;
    }

    public byte getHandshakeType() {
        return this.handshake;
    }

    public byte getCryptoLevel() {
        return this.crypto_level;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && obj instanceof PeerItem) {
            PeerItem other = (PeerItem)obj;
            if (this.tcp_port == other.tcp_port && this.udp_port == other.udp_port && this.handshake == other.handshake && Arrays.equals(this.address, other.address)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public static String convertSourceString(byte source_id) {
        switch (source_id) {
            case 0: {
                return "Tracker";
            }
            case 1: {
                return "DHT";
            }
            case 2: {
                return "PeerExchange";
            }
            case 3: {
                return "Plugin";
            }
            case 4: {
                return "Incoming";
            }
        }
        return "<unknown>";
    }

    public static byte convertSourceID(String source) {
        if (source.equals("Tracker")) {
            return 0;
        }
        if (source.equals("DHT")) {
            return 1;
        }
        if (source.equals("PeerExchange")) {
            return 2;
        }
        if (source.equals("Plugin")) {
            return 3;
        }
        if (source.equals("Incoming")) {
            return 4;
        }
        return -1;
    }
}

